/*
  Copyright 1999-2019 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.
  
  You may not use this file except in compliance with the License.  You may
  obtain a copy of the License at
  
    https://imagemagick.org/script/license.php
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  MagickCore API methods prefix.

  nm -p MagickCore/.libs/libMagickCore-7.Q16HDRI.a | grep ' T ' | egrep -vi '(Magick)|(lt_)' | \
     egrep -v '(MagickError)|(MagickFatalError)|(MagickWarning)|(ThrowException)' | \
    awk '{ printf("#define %s  PrependMagickMethod(%s)\n", $3, $3); }' | sort
*/
#ifndef MAGICKCORE_METHOD_H
#define MAGICKCORE_METHOD_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#if defined(MAGICKCORE_NAMESPACE_PREFIX)

#if defined(__STDC__)
#define PrescanMagickPrefix(prefix,method)  prefix ## method
#else
#define PrescanMagickPrefix(prefix,method)  prefix(method)
#endif
#define EvaluateMagickPrefix(prefix,method)  PrescanMagickPrefix(prefix,method)
#define PrependMagickMethod(method) \
  EvaluateMagickPrefix(MAGICKCORE_NAMESPACE_PREFIX,method)

#define AcquireAlignedMemory  PrependMagickMethod(AcquireAlignedMemory)
#define AcquireAuthenticCacheView  PrependMagickMethod(AcquireAuthenticCacheView)
#define AcquireCustomStreamInfo  PrependMagickMethod(AcquireCustomStreamInfo)
#define AcquireDistributeCacheInfo  PrependMagickMethod(AcquireDistributeCacheInfo)
#define AcquireDrawInfo  PrependMagickMethod(AcquireDrawInfo)
#define AcquireExceptionInfo  PrependMagickMethod(AcquireExceptionInfo)
#define AcquireFxInfo  PrependMagickMethod(AcquireFxInfo)
#define AcquireImageColormap  PrependMagickMethod(AcquireImageColormap)
#define AcquireImageInfo  PrependMagickMethod(AcquireImageInfo)
#define AcquireImage  PrependMagickMethod(AcquireImage)
#define AcquireKernelBuiltIn  PrependMagickMethod(AcquireKernelBuiltIn)
#define AcquireKernelInfo  PrependMagickMethod(AcquireKernelInfo)
#define AcquireMatrixInfo  PrependMagickMethod(AcquireMatrixInfo)
#define AcquireMimeCache  PrependMagickMethod(AcquireMimeCache)
#define AcquireNextImage  PrependMagickMethod(AcquireNextImage)
#define AcquirePixelCacheNexus  PrependMagickMethod(AcquirePixelCacheNexus)
#define AcquirePixelCachePixels  PrependMagickMethod(AcquirePixelCachePixels)
#define AcquirePixelCache  PrependMagickMethod(AcquirePixelCache)
#define AcquirePixelChannelMap  PrependMagickMethod(AcquirePixelChannelMap)
#define AcquireQuantizeInfo  PrependMagickMethod(AcquireQuantizeInfo)
#define AcquireQuantumInfo  PrependMagickMethod(AcquireQuantumInfo)
#define AcquireQuantumMemory  PrependMagickMethod(AcquireQuantumMemory)
#define AcquireRandomInfo  PrependMagickMethod(AcquireRandomInfo)
#define AcquireResampleFilter  PrependMagickMethod(AcquireResampleFilter)
#define AcquireResizeFilter  PrependMagickMethod(AcquireResizeFilter)
#define AcquireSemaphoreInfo  PrependMagickMethod(AcquireSemaphoreInfo)
#define AcquireSignatureInfo  PrependMagickMethod(AcquireSignatureInfo)
#define AcquireStreamInfo  PrependMagickMethod(AcquireStreamInfo)
#define AcquireStringInfo  PrependMagickMethod(AcquireStringInfo)
#define AcquireString  PrependMagickMethod(AcquireString)
#define AcquireTimerInfo  PrependMagickMethod(AcquireTimerInfo)
#define AcquireTokenInfo  PrependMagickMethod(AcquireTokenInfo)
#define AcquireUniqueFilename  PrependMagickMethod(AcquireUniqueFilename)
#define AcquireUniqueFileResource  PrependMagickMethod(AcquireUniqueFileResource)
#define AcquireUniqueSymbolicLink  PrependMagickMethod(AcquireUniqueSymbolicLink)
#define AcquireVirtualCacheView  PrependMagickMethod(AcquireVirtualCacheView)
#define AcquireVirtualMemory  PrependMagickMethod(AcquireVirtualMemory)
#define ActivateSemaphoreInfo  PrependMagickMethod(ActivateSemaphoreInfo)
#define AdaptiveBlurImage  PrependMagickMethod(AdaptiveBlurImage)
#define AdaptiveResizeImage  PrependMagickMethod(AdaptiveResizeImage)
#define AdaptiveSharpenImage  PrependMagickMethod(AdaptiveSharpenImage)
#define AdaptiveThresholdImage  PrependMagickMethod(AdaptiveThresholdImage)
#define AddChildToXMLTree  PrependMagickMethod(AddChildToXMLTree)
#define AddNoiseImage  PrependMagickMethod(AddNoiseImage)
#define AddPathToXMLTree  PrependMagickMethod(AddPathToXMLTree)
#define AddValueToSplayTree  PrependMagickMethod(AddValueToSplayTree)
#define AffineTransformImage  PrependMagickMethod(AffineTransformImage)
#define analyzeImage  PrependMagickMethod(analyzeImage)
#define AnimateImages  PrependMagickMethod(AnimateImages)
#define AnnotateComponentGenesis  PrependMagickMethod(AnnotateComponentGenesis)
#define AnnotateComponentTerminus  PrependMagickMethod(AnnotateComponentTerminus)
#define AnnotateImage  PrependMagickMethod(AnnotateImage)
#define AppendImageFormat  PrependMagickMethod(AppendImageFormat)
#define AppendImages  PrependMagickMethod(AppendImages)
#define AppendImageToList  PrependMagickMethod(AppendImageToList)
#define AppendValueToLinkedList  PrependMagickMethod(AppendValueToLinkedList)
#define Ascii85Encode  PrependMagickMethod(Ascii85Encode)
#define Ascii85Flush  PrependMagickMethod(Ascii85Flush)
#define Ascii85Initialize  PrependMagickMethod(Ascii85Initialize)
#define AsynchronousResourceComponentTerminus  PrependMagickMethod(AsynchronousResourceComponentTerminus)
#define AttachBlob  PrependMagickMethod(AttachBlob)
#define AttachCustomStream  PrependMagickMethod(AttachCustomStream)
#define AutoGammaImage  PrependMagickMethod(AutoGammaImage)
#define AutoLevelImage  PrependMagickMethod(AutoLevelImage)
#define AutoOrientImage  PrependMagickMethod(AutoOrientImage)
#define AutoThresholdImage  PrependMagickMethod(AutoThresholdImage)
#define Base64Decode  PrependMagickMethod(Base64Decode)
#define Base64Encode  PrependMagickMethod(Base64Encode)
#define BilevelImage  PrependMagickMethod(BilevelImage)
#define BlackThresholdImage  PrependMagickMethod(BlackThresholdImage)
#define BlobToFile  PrependMagickMethod(BlobToFile)
#define BlobToImage  PrependMagickMethod(BlobToImage)
#define BlobToStringInfo  PrependMagickMethod(BlobToStringInfo)
#define BlueShiftImage  PrependMagickMethod(BlueShiftImage)
#define BlurImage  PrependMagickMethod(BlurImage)
#define BorderImage  PrependMagickMethod(BorderImage)
#define BrightnessContrastImage  PrependMagickMethod(BrightnessContrastImage)
#define CacheComponentGenesis  PrependMagickMethod(CacheComponentGenesis)
#define CacheComponentTerminus  PrependMagickMethod(CacheComponentTerminus)
#define CannyEdgeImage  PrependMagickMethod(CannyEdgeImage)
#define CanonicalXMLContent  PrependMagickMethod(CanonicalXMLContent)
#define CatchException  PrependMagickMethod(CatchException)
#define CatchImageException  PrependMagickMethod(CatchImageException)
#define ChannelFxImage  PrependMagickMethod(ChannelFxImage)
#define CharcoalImage  PrependMagickMethod(CharcoalImage)
#define ChopImage  PrependMagickMethod(ChopImage)
#define ChopPathComponents  PrependMagickMethod(ChopPathComponents)
#define CLAHEImage  PrependMagickMethod(CLAHEImage)
#define ClampImage  PrependMagickMethod(ClampImage)
#define ClearLinkedList  PrependMagickMethod(ClearLinkedList)
#define ClipImagePath  PrependMagickMethod(ClipImagePath)
#define ClipImage  PrependMagickMethod(ClipImage)
#define CloneBlobInfo  PrependMagickMethod(CloneBlobInfo)
#define CloneCacheView  PrependMagickMethod(CloneCacheView)
#define CloneDrawInfo  PrependMagickMethod(CloneDrawInfo)
#define CloneExceptionInfo  PrependMagickMethod(CloneExceptionInfo)
#define CloneImageArtifacts  PrependMagickMethod(CloneImageArtifacts)
#define CloneImageInfo  PrependMagickMethod(CloneImageInfo)
#define CloneImageList  PrependMagickMethod(CloneImageList)
#define CloneImageOptions  PrependMagickMethod(CloneImageOptions)
#define CloneImage  PrependMagickMethod(CloneImage)
#define CloneImageProfiles  PrependMagickMethod(CloneImageProfiles)
#define CloneImageProperties  PrependMagickMethod(CloneImageProperties)
#define CloneImages  PrependMagickMethod(CloneImages)
#define CloneImageView  PrependMagickMethod(CloneImageView)
#define CloneKernelInfo  PrependMagickMethod(CloneKernelInfo)
#define CloneMontageInfo  PrependMagickMethod(CloneMontageInfo)
#define ClonePixelCacheMethods  PrependMagickMethod(ClonePixelCacheMethods)
#define ClonePixelCache  PrependMagickMethod(ClonePixelCache)
#define ClonePixelChannelMap  PrependMagickMethod(ClonePixelChannelMap)
#define ClonePixelInfo  PrependMagickMethod(ClonePixelInfo)
#define CloneQuantizeInfo  PrependMagickMethod(CloneQuantizeInfo)
#define CloneSplayTree  PrependMagickMethod(CloneSplayTree)
#define CloneStringInfo  PrependMagickMethod(CloneStringInfo)
#define CloneString  PrependMagickMethod(CloneString)
#define CloseBlob  PrependMagickMethod(CloseBlob)
#define ClutImage  PrependMagickMethod(ClutImage)
#define CoalesceImages  PrependMagickMethod(CoalesceImages)
#define CoderComponentGenesis  PrependMagickMethod(CoderComponentGenesis)
#define CoderComponentTerminus  PrependMagickMethod(CoderComponentTerminus)
#define ColorComponentGenesis  PrependMagickMethod(ColorComponentGenesis)
#define ColorComponentTerminus  PrependMagickMethod(ColorComponentTerminus)
#define ColorDecisionListImage  PrependMagickMethod(ColorDecisionListImage)
#define ColorizeImage  PrependMagickMethod(ColorizeImage)
#define ColorMatrixImage  PrependMagickMethod(ColorMatrixImage)
#define CombineImages  PrependMagickMethod(CombineImages)
#define CommandOptionToMnemonic  PrependMagickMethod(CommandOptionToMnemonic)
#define CompareImagesLayers  PrependMagickMethod(CompareImagesLayers)
#define CompareImages  PrependMagickMethod(CompareImages)
#define CompareSplayTreeStringInfo  PrependMagickMethod(CompareSplayTreeStringInfo)
#define CompareSplayTreeString  PrependMagickMethod(CompareSplayTreeString)
#define CompareStringInfo  PrependMagickMethod(CompareStringInfo)
#define ComplexImages  PrependMagickMethod(ComplexImages)
#define CompositeImage  PrependMagickMethod(CompositeImage)
#define CompositeLayers  PrependMagickMethod(CompositeLayers)
#define CompressImageColormap  PrependMagickMethod(CompressImageColormap)
#define ConcatenateColorComponent  PrependMagickMethod(ConcatenateColorComponent)
#define ConcatenateStringInfo  PrependMagickMethod(ConcatenateStringInfo)
#define ConcatenateString  PrependMagickMethod(ConcatenateString)
#define ConfigureComponentGenesis  PrependMagickMethod(ConfigureComponentGenesis)
#define ConfigureComponentTerminus  PrependMagickMethod(ConfigureComponentTerminus)
#define ConfigureFileToStringInfo  PrependMagickMethod(ConfigureFileToStringInfo)
#define ConformPixelInfo  PrependMagickMethod(ConformPixelInfo)
#define ConnectedComponentsImage  PrependMagickMethod(ConnectedComponentsImage)
#define ConsolidateCMYKImages  PrependMagickMethod(ConsolidateCMYKImages)
#define ConstantString  PrependMagickMethod(ConstantString)
#define ConstituteImage  PrependMagickMethod(ConstituteImage)
#define ContinueTimer  PrependMagickMethod(ContinueTimer)
#define ContrastImage  PrependMagickMethod(ContrastImage)
#define ContrastStretchImage  PrependMagickMethod(ContrastStretchImage)
#define ConvertHCLpToRGB  PrependMagickMethod(ConvertHCLpToRGB)
#define ConvertHCLToRGB  PrependMagickMethod(ConvertHCLToRGB)
#define ConvertHSBToRGB  PrependMagickMethod(ConvertHSBToRGB)
#define ConvertHSIToRGB  PrependMagickMethod(ConvertHSIToRGB)
#define ConvertHSLToRGB  PrependMagickMethod(ConvertHSLToRGB)
#define ConvertHSVToRGB  PrependMagickMethod(ConvertHSVToRGB)
#define ConvertHWBToRGB  PrependMagickMethod(ConvertHWBToRGB)
#define ConvertLCHabToRGB  PrependMagickMethod(ConvertLCHabToRGB)
#define ConvertLCHuvToRGB  PrependMagickMethod(ConvertLCHuvToRGB)
#define ConvertRGBToHCLp  PrependMagickMethod(ConvertRGBToHCLp)
#define ConvertRGBToHCL  PrependMagickMethod(ConvertRGBToHCL)
#define ConvertRGBToHSB  PrependMagickMethod(ConvertRGBToHSB)
#define ConvertRGBToHSI  PrependMagickMethod(ConvertRGBToHSI)
#define ConvertRGBToHSL  PrependMagickMethod(ConvertRGBToHSL)
#define ConvertRGBToHSV  PrependMagickMethod(ConvertRGBToHSV)
#define ConvertRGBToHWB  PrependMagickMethod(ConvertRGBToHWB)
#define ConvertRGBToLCHab  PrependMagickMethod(ConvertRGBToLCHab)
#define ConvertRGBToLCHuv  PrependMagickMethod(ConvertRGBToLCHuv)
#define ConvolveImage  PrependMagickMethod(ConvolveImage)
#define CopyImagePixels  PrependMagickMethod(CopyImagePixels)
#define CropImage  PrependMagickMethod(CropImage)
#define CropImageToTiles  PrependMagickMethod(CropImageToTiles)
#define CustomStreamToImage  PrependMagickMethod(CustomStreamToImage)
#define CycleColormapImage  PrependMagickMethod(CycleColormapImage)
#define DecipherImage  PrependMagickMethod(DecipherImage)
#define DecodePixelGamma  PrependMagickMethod(DecodePixelGamma)
#define DefineImageArtifact  PrependMagickMethod(DefineImageArtifact)
#define DefineImageOption  PrependMagickMethod(DefineImageOption)
#define DefineImageProperty  PrependMagickMethod(DefineImageProperty)
#define DefineImageRegistry  PrependMagickMethod(DefineImageRegistry)
#define DelegateComponentGenesis  PrependMagickMethod(DelegateComponentGenesis)
#define DelegateComponentTerminus  PrependMagickMethod(DelegateComponentTerminus)
#define DeleteImageArtifact  PrependMagickMethod(DeleteImageArtifact)
#define DeleteImageFromList  PrependMagickMethod(DeleteImageFromList)
#define DeleteImageOption  PrependMagickMethod(DeleteImageOption)
#define DeleteImageProfile  PrependMagickMethod(DeleteImageProfile)
#define DeleteImageProperty  PrependMagickMethod(DeleteImageProperty)
#define DeleteImageRegistry  PrependMagickMethod(DeleteImageRegistry)
#define DeleteImages  PrependMagickMethod(DeleteImages)
#define DeleteNodeByValueFromSplayTree  PrependMagickMethod(DeleteNodeByValueFromSplayTree)
#define DeleteNodeFromSplayTree  PrependMagickMethod(DeleteNodeFromSplayTree)
#define DeskewImage  PrependMagickMethod(DeskewImage)
#define DespeckleImage  PrependMagickMethod(DespeckleImage)
#define DestroyBlob  PrependMagickMethod(DestroyBlob)
#define DestroyCacheView  PrependMagickMethod(DestroyCacheView)
#define DestroyConfigureOptions  PrependMagickMethod(DestroyConfigureOptions)
#define DestroyCustomStreamInfo  PrependMagickMethod(DestroyCustomStreamInfo)
#define DestroyDistributeCacheInfo  PrependMagickMethod(DestroyDistributeCacheInfo)
#define DestroyDrawInfo  PrependMagickMethod(DestroyDrawInfo)
#define DestroyExceptionInfo  PrependMagickMethod(DestroyExceptionInfo)
#define DestroyFxInfo  PrependMagickMethod(DestroyFxInfo)
#define DestroyImageArtifacts  PrependMagickMethod(DestroyImageArtifacts)
#define DestroyImageInfo  PrependMagickMethod(DestroyImageInfo)
#define DestroyImageList  PrependMagickMethod(DestroyImageList)
#define DestroyImageOptions  PrependMagickMethod(DestroyImageOptions)
#define DestroyImagePixels  PrependMagickMethod(DestroyImagePixels)
#define DestroyImage  PrependMagickMethod(DestroyImage)
#define DestroyImageProfiles  PrependMagickMethod(DestroyImageProfiles)
#define DestroyImageProperties  PrependMagickMethod(DestroyImageProperties)
#define DestroyImageView  PrependMagickMethod(DestroyImageView)
#define DestroyKernelInfo  PrependMagickMethod(DestroyKernelInfo)
#define DestroyLinkedList  PrependMagickMethod(DestroyLinkedList)
#define DestroyLocaleOptions  PrependMagickMethod(DestroyLocaleOptions)
#define DestroyMatrixInfo  PrependMagickMethod(DestroyMatrixInfo)
#define DestroyMontageInfo  PrependMagickMethod(DestroyMontageInfo)
#define DestroyPixelCacheNexus  PrependMagickMethod(DestroyPixelCacheNexus)
#define DestroyPixelCache  PrependMagickMethod(DestroyPixelCache)
#define DestroyPixelChannelMap  PrependMagickMethod(DestroyPixelChannelMap)
#define DestroyQuantizeInfo  PrependMagickMethod(DestroyQuantizeInfo)
#define DestroyQuantumInfo  PrependMagickMethod(DestroyQuantumInfo)
#define DestroyRandomInfo  PrependMagickMethod(DestroyRandomInfo)
#define DestroyResampleFilter  PrependMagickMethod(DestroyResampleFilter)
#define DestroyResizeFilter  PrependMagickMethod(DestroyResizeFilter)
#define DestroySignatureInfo  PrependMagickMethod(DestroySignatureInfo)
#define DestroySplayTree  PrependMagickMethod(DestroySplayTree)
#define DestroyStreamInfo  PrependMagickMethod(DestroyStreamInfo)
#define DestroyStringInfo  PrependMagickMethod(DestroyStringInfo)
#define DestroyStringList  PrependMagickMethod(DestroyStringList)
#define DestroyString  PrependMagickMethod(DestroyString)
#define DestroyThresholdMap  PrependMagickMethod(DestroyThresholdMap)
#define DestroyTimerInfo  PrependMagickMethod(DestroyTimerInfo)
#define DestroyTokenInfo  PrependMagickMethod(DestroyTokenInfo)
#define DestroyXMLTree  PrependMagickMethod(DestroyXMLTree)
#define DestroyXResources  PrependMagickMethod(DestroyXResources)
#define DestroyXWidget  PrependMagickMethod(DestroyXWidget)
#define DetachBlob  PrependMagickMethod(DetachBlob)
#define DisassociateBlob  PrependMagickMethod(DisassociateBlob)
#define DisassociateImageStream  PrependMagickMethod(DisassociateImageStream)
#define DiscardBlobBytes  PrependMagickMethod(DiscardBlobBytes)
#define DisplayImages  PrependMagickMethod(DisplayImages)
#define DisposeImages  PrependMagickMethod(DisposeImages)
#define DistortImage  PrependMagickMethod(DistortImage)
#define DistortResizeImage  PrependMagickMethod(DistortResizeImage)
#define DistributePixelCacheServer  PrependMagickMethod(DistributePixelCacheServer)
#define DrawAffineImage  PrependMagickMethod(DrawAffineImage)
#define DrawClipPath  PrependMagickMethod(DrawClipPath)
#define DrawGradientImage  PrependMagickMethod(DrawGradientImage)
#define DrawImage  PrependMagickMethod(DrawImage)
#define DrawPatternPath  PrependMagickMethod(DrawPatternPath)
#define DrawPrimitive  PrependMagickMethod(DrawPrimitive)
#define DuplexTransferImageViewIterator  PrependMagickMethod(DuplexTransferImageViewIterator)
#define DuplicateBlob  PrependMagickMethod(DuplicateBlob)
#define DuplicateImages  PrependMagickMethod(DuplicateImages)
#define EdgeImage  PrependMagickMethod(EdgeImage)
#define EmbossImage  PrependMagickMethod(EmbossImage)
#define EncipherImage  PrependMagickMethod(EncipherImage)
#define EncodePixelGamma  PrependMagickMethod(EncodePixelGamma)
#define EnhanceImage  PrependMagickMethod(EnhanceImage)
#define EOFBlob  PrependMagickMethod(EOFBlob)
#define EqualizeImage  PrependMagickMethod(EqualizeImage)
#define ErrorBlob  PrependMagickMethod(ErrorBlob)
#define EscapeString  PrependMagickMethod(EscapeString)
#define EvaluateImage  PrependMagickMethod(EvaluateImage)
#define EvaluateImages  PrependMagickMethod(EvaluateImages)
#define ExceptionComponentGenesis  PrependMagickMethod(ExceptionComponentGenesis)
#define ExceptionComponentTerminus  PrependMagickMethod(ExceptionComponentTerminus)
#define ExcerptImage  PrependMagickMethod(ExcerptImage)
#define ExpandAffine  PrependMagickMethod(ExpandAffine)
#define ExpandFilename  PrependMagickMethod(ExpandFilename)
#define ExpandFilenames  PrependMagickMethod(ExpandFilenames)
#define ExportImagePixels  PrependMagickMethod(ExportImagePixels)
#define ExportQuantumPixels  PrependMagickMethod(ExportQuantumPixels)
#define ExtentImage  PrependMagickMethod(ExtentImage)
#define ExternalDelegateCommand  PrependMagickMethod(ExternalDelegateCommand)
#define FileToBlob  PrependMagickMethod(FileToBlob)
#define FileToImage  PrependMagickMethod(FileToImage)
#define FileToStringInfo  PrependMagickMethod(FileToStringInfo)
#define FileToString  PrependMagickMethod(FileToString)
#define FileToXML  PrependMagickMethod(FileToXML)
#define FinalizeSignature  PrependMagickMethod(FinalizeSignature)
#define FlipImage  PrependMagickMethod(FlipImage)
#define FloodfillPaintImage  PrependMagickMethod(FloodfillPaintImage)
#define FlopImage  PrependMagickMethod(FlopImage)
#define FormatImageProperty  PrependMagickMethod(FormatImageProperty)
#define FormatLocaleFileList  PrependMagickMethod(FormatLocaleFileList)
#define FormatLocaleFile  PrependMagickMethod(FormatLocaleFile)
#define FormatLocaleStringList  PrependMagickMethod(FormatLocaleStringList)
#define FormatLocaleString  PrependMagickMethod(FormatLocaleString)
#define ForwardFourierTransformImage  PrependMagickMethod(ForwardFourierTransformImage)
#define FrameImage  PrependMagickMethod(FrameImage)
#define FunctionImage  PrependMagickMethod(FunctionImage)
#define FxEvaluateChannelExpression  PrependMagickMethod(FxEvaluateChannelExpression)
#define FxEvaluateExpression  PrependMagickMethod(FxEvaluateExpression)
#define FxImage  PrependMagickMethod(FxImage)
#define FxPreprocessExpression  PrependMagickMethod(FxPreprocessExpression)
#define GammaImage  PrependMagickMethod(GammaImage)
#define GaussianBlurImage  PrependMagickMethod(GaussianBlurImage)
#define GaussJordanElimination  PrependMagickMethod(GaussJordanElimination)
#define GenerateDifferentialNoise  PrependMagickMethod(GenerateDifferentialNoise)
#define GetAffineMatrix  PrependMagickMethod(GetAffineMatrix)
#define GetAuthenticMetacontent  PrependMagickMethod(GetAuthenticMetacontent)
#define GetAuthenticPixelCacheNexus  PrependMagickMethod(GetAuthenticPixelCacheNexus)
#define GetAuthenticPixelQueue  PrependMagickMethod(GetAuthenticPixelQueue)
#define GetAuthenticPixels  PrependMagickMethod(GetAuthenticPixels)
#define GetBlobError  PrependMagickMethod(GetBlobError)
#define GetBlobFileHandle  PrependMagickMethod(GetBlobFileHandle)
#define GetBlobInfo  PrependMagickMethod(GetBlobInfo)
#define GetBlobProperties  PrependMagickMethod(GetBlobProperties)
#define GetBlobSize  PrependMagickMethod(GetBlobSize)
#define GetBlobStreamData  PrependMagickMethod(GetBlobStreamData)
#define GetBlobStreamHandler  PrependMagickMethod(GetBlobStreamHandler)
#define GetCacheViewAuthenticMetacontent  PrependMagickMethod(GetCacheViewAuthenticMetacontent)
#define GetCacheViewAuthenticPixelQueue  PrependMagickMethod(GetCacheViewAuthenticPixelQueue)
#define GetCacheViewAuthenticPixels  PrependMagickMethod(GetCacheViewAuthenticPixels)
#define GetCacheViewColorspace  PrependMagickMethod(GetCacheViewColorspace)
#define GetCacheViewExtent  PrependMagickMethod(GetCacheViewExtent)
#define GetCacheViewImage  PrependMagickMethod(GetCacheViewImage)
#define GetCacheViewStorageClass  PrependMagickMethod(GetCacheViewStorageClass)
#define GetCacheViewVirtualMetacontent  PrependMagickMethod(GetCacheViewVirtualMetacontent)
#define GetCacheViewVirtualPixelQueue  PrependMagickMethod(GetCacheViewVirtualPixelQueue)
#define GetCacheViewVirtualPixels  PrependMagickMethod(GetCacheViewVirtualPixels)
#define GetClientName  PrependMagickMethod(GetClientName)
#define GetClientPath  PrependMagickMethod(GetClientPath)
#define GetCoderInfoList  PrependMagickMethod(GetCoderInfoList)
#define GetCoderInfo  PrependMagickMethod(GetCoderInfo)
#define GetCoderList  PrependMagickMethod(GetCoderList)
#define GetColorCompliance  PrependMagickMethod(GetColorCompliance)
#define GetColorInfoList  PrependMagickMethod(GetColorInfoList)
#define GetColorInfo  PrependMagickMethod(GetColorInfo)
#define GetColorList  PrependMagickMethod(GetColorList)
#define GetColorTuple  PrependMagickMethod(GetColorTuple)
#define GetCommandOptionFlags  PrependMagickMethod(GetCommandOptionFlags)
#define GetCommandOptionInfo  PrependMagickMethod(GetCommandOptionInfo)
#define GetCommandOptions  PrependMagickMethod(GetCommandOptions)
#define GetConfigureInfoList  PrependMagickMethod(GetConfigureInfoList)
#define GetConfigureInfo  PrependMagickMethod(GetConfigureInfo)
#define GetConfigureList  PrependMagickMethod(GetConfigureList)
#define GetConfigureOption  PrependMagickMethod(GetConfigureOption)
#define GetConfigureOptions  PrependMagickMethod(GetConfigureOptions)
#define GetConfigurePaths  PrependMagickMethod(GetConfigurePaths)
#define GetConfigureValue  PrependMagickMethod(GetConfigureValue)
#define GetDelegateCommand  PrependMagickMethod(GetDelegateCommand)
#define GetDelegateCommands  PrependMagickMethod(GetDelegateCommands)
#define GetDelegateInfoList  PrependMagickMethod(GetDelegateInfoList)
#define GetDelegateInfo  PrependMagickMethod(GetDelegateInfo)
#define GetDelegateList  PrependMagickMethod(GetDelegateList)
#define GetDelegateMode  PrependMagickMethod(GetDelegateMode)
#define GetDelegateThreadSupport  PrependMagickMethod(GetDelegateThreadSupport)
#define GetDistributeCacheFile  PrependMagickMethod(GetDistributeCacheFile)
#define GetDistributeCacheHostname  PrependMagickMethod(GetDistributeCacheHostname)
#define GetDistributeCachePort  PrependMagickMethod(GetDistributeCachePort)
#define GetDrawInfo  PrependMagickMethod(GetDrawInfo)
#define GetElapsedTime  PrependMagickMethod(GetElapsedTime)
#define GetEnvironmentValue  PrependMagickMethod(GetEnvironmentValue)
#define GetExceptionMessage  PrependMagickMethod(GetExceptionMessage)
#define GetExecutionPath  PrependMagickMethod(GetExecutionPath)
#define GetFirstImageInList  PrependMagickMethod(GetFirstImageInList)
#define GetGeometry  PrependMagickMethod(GetGeometry)
#define GetImageAlphaChannel  PrependMagickMethod(GetImageAlphaChannel)
#define GetImageArtifact  PrependMagickMethod(GetImageArtifact)
#define GetImageBoundingBox  PrependMagickMethod(GetImageBoundingBox)
#define GetImageColorspaceType  PrependMagickMethod(GetImageColorspaceType)
#define GetImageDecoder  PrependMagickMethod(GetImageDecoder)
#define GetImageDepth  PrependMagickMethod(GetImageDepth)
#define GetImageDistortion  PrependMagickMethod(GetImageDistortion)
#define GetImageDistortions  PrependMagickMethod(GetImageDistortions)
#define GetImageDynamicThreshold  PrependMagickMethod(GetImageDynamicThreshold)
#define GetImageEncoder  PrependMagickMethod(GetImageEncoder)
#define GetImageEntropy  PrependMagickMethod(GetImageEntropy)
#define GetImageExtent  PrependMagickMethod(GetImageExtent)
#define GetImageExtrema  PrependMagickMethod(GetImageExtrema)
#define GetImageFeatures  PrependMagickMethod(GetImageFeatures)
#define GetImageFromList  PrependMagickMethod(GetImageFromList)
#define GetImageHistogram  PrependMagickMethod(GetImageHistogram)
#define GetImageIndexInList  PrependMagickMethod(GetImageIndexInList)
#define GetImageInfoFile  PrependMagickMethod(GetImageInfoFile)
#define GetImageInfo  PrependMagickMethod(GetImageInfo)
#define GetImageKurtosis  PrependMagickMethod(GetImageKurtosis)
#define GetImageListLength  PrependMagickMethod(GetImageListLength)
#define GetImageMask  PrependMagickMethod(GetImageMask)
#define GetImageMean  PrependMagickMethod(GetImageMean)
#define GetImageMoments  PrependMagickMethod(GetImageMoments)
#define GetImageOption  PrependMagickMethod(GetImageOption)
#define GetImagePerceptualHash  PrependMagickMethod(GetImagePerceptualHash)
#define GetImagePixelCacheType  PrependMagickMethod(GetImagePixelCacheType)
#define GetImageProfile  PrependMagickMethod(GetImageProfile)
#define GetImageProperty  PrependMagickMethod(GetImageProperty)
#define GetImageQuantizeError  PrependMagickMethod(GetImageQuantizeError)
#define GetImageQuantumDepth  PrependMagickMethod(GetImageQuantumDepth)
#define GetImageRange  PrependMagickMethod(GetImageRange)
#define GetImageReferenceCount  PrependMagickMethod(GetImageReferenceCount)
#define GetImageRegistry  PrependMagickMethod(GetImageRegistry)
#define GetImageStatistics  PrependMagickMethod(GetImageStatistics)
#define GetImageTotalInkDensity  PrependMagickMethod(GetImageTotalInkDensity)
#define GetImageType  PrependMagickMethod(GetImageType)
#define GetImageViewAuthenticMetacontent  PrependMagickMethod(GetImageViewAuthenticMetacontent)
#define GetImageViewAuthenticPixels  PrependMagickMethod(GetImageViewAuthenticPixels)
#define GetImageViewException  PrependMagickMethod(GetImageViewException)
#define GetImageViewExtent  PrependMagickMethod(GetImageViewExtent)
#define GetImageViewImage  PrependMagickMethod(GetImageViewImage)
#define GetImageViewIterator  PrependMagickMethod(GetImageViewIterator)
#define GetImageViewVirtualMetacontent  PrependMagickMethod(GetImageViewVirtualMetacontent)
#define GetImageViewVirtualPixels  PrependMagickMethod(GetImageViewVirtualPixels)
#define GetImageVirtualPixelMethod  PrependMagickMethod(GetImageVirtualPixelMethod)
#define GetLastImageInList  PrependMagickMethod(GetLastImageInList)
#define GetLastValueInLinkedList  PrependMagickMethod(GetLastValueInLinkedList)
#define GetLocaleExceptionMessage  PrependMagickMethod(GetLocaleExceptionMessage)
#define GetLocaleInfoList  PrependMagickMethod(GetLocaleInfoList)
#define GetLocaleInfo_  PrependMagickMethod(GetLocaleInfo_)
#define GetLocaleList  PrependMagickMethod(GetLocaleList)
#define GetLocaleMessage  PrependMagickMethod(GetLocaleMessage)
#define GetLocaleOptions  PrependMagickMethod(GetLocaleOptions)
#define GetLocaleValue  PrependMagickMethod(GetLocaleValue)
#define GetLogInfoList  PrependMagickMethod(GetLogInfoList)
#define GetLogList  PrependMagickMethod(GetLogList)
#define GetLogName  PrependMagickMethod(GetLogName)
#define GetMagicInfoList  PrependMagickMethod(GetMagicInfoList)
#define GetMagicInfo  PrependMagickMethod(GetMagicInfo)
#define GetMagicList  PrependMagickMethod(GetMagicList)
#define GetMagicName  PrependMagickMethod(GetMagicName)
#define GetMagicPatternExtent  PrependMagickMethod(GetMagicPatternExtent)
#define GetMatrixColumns  PrependMagickMethod(GetMatrixColumns)
#define GetMatrixElement  PrependMagickMethod(GetMatrixElement)
#define GetMatrixRows  PrependMagickMethod(GetMatrixRows)
#define GetMaxMemoryRequest  PrependMagickMethod(GetMaxMemoryRequest)
#define GetMimeDescription  PrependMagickMethod(GetMimeDescription)
#define GetMimeInfoList  PrependMagickMethod(GetMimeInfoList)
#define GetMimeInfo  PrependMagickMethod(GetMimeInfo)
#define GetMimeList  PrependMagickMethod(GetMimeList)
#define GetMimeType  PrependMagickMethod(GetMimeType)
#define GetMontageInfo  PrependMagickMethod(GetMontageInfo)
#define GetMultilineTypeMetrics  PrependMagickMethod(GetMultilineTypeMetrics)
#define GetNextImageArtifact  PrependMagickMethod(GetNextImageArtifact)
#define GetNextImageInList  PrependMagickMethod(GetNextImageInList)
#define GetNextImageOption  PrependMagickMethod(GetNextImageOption)
#define GetNextImageProfile  PrependMagickMethod(GetNextImageProfile)
#define GetNextImageProperty  PrependMagickMethod(GetNextImageProperty)
#define GetNextImageRegistry  PrependMagickMethod(GetNextImageRegistry)
#define GetNextKeyInSplayTree  PrependMagickMethod(GetNextKeyInSplayTree)
#define GetNextToken  PrependMagickMethod(GetNextToken)
#define GetNextValueInLinkedList  PrependMagickMethod(GetNextValueInLinkedList)
#define GetNextValueInSplayTree  PrependMagickMethod(GetNextValueInSplayTree)
#define GetNextXMLTreeTag  PrependMagickMethod(GetNextXMLTreeTag)
#define GetNumberColors  PrependMagickMethod(GetNumberColors)
#define GetNumberOfElementsInLinkedList  PrependMagickMethod(GetNumberOfElementsInLinkedList)
#define GetNumberOfNodesInSplayTree  PrependMagickMethod(GetNumberOfNodesInSplayTree)
#define GetOneAuthenticPixel  PrependMagickMethod(GetOneAuthenticPixel)
#define GetOneCacheViewAuthenticPixel  PrependMagickMethod(GetOneCacheViewAuthenticPixel)
#define GetOneCacheViewVirtualMethodPixel  PrependMagickMethod(GetOneCacheViewVirtualMethodPixel)
#define GetOneCacheViewVirtualPixelInfo  PrependMagickMethod(GetOneCacheViewVirtualPixelInfo)
#define GetOneCacheViewVirtualPixel  PrependMagickMethod(GetOneCacheViewVirtualPixel)
#define GetOneVirtualPixelInfo  PrependMagickMethod(GetOneVirtualPixelInfo)
#define GetOneVirtualPixel  PrependMagickMethod(GetOneVirtualPixel)
#define GetOpenCLDeviceBenchmarkScore  PrependMagickMethod(GetOpenCLDeviceBenchmarkScore)
#define GetOpenCLDeviceEnabled  PrependMagickMethod(GetOpenCLDeviceEnabled)
#define GetOpenCLDeviceName  PrependMagickMethod(GetOpenCLDeviceName)
#define GetOpenCLDevices  PrependMagickMethod(GetOpenCLDevices)
#define GetOpenCLDeviceType  PrependMagickMethod(GetOpenCLDeviceType)
#define GetOpenCLDeviceVersion  PrependMagickMethod(GetOpenCLDeviceVersion)
#define GetOpenCLEnabled  PrependMagickMethod(GetOpenCLEnabled)
#define GetOpenCLKernelProfileRecords  PrependMagickMethod(GetOpenCLKernelProfileRecords)
#define GetOptimalKernelWidth1D  PrependMagickMethod(GetOptimalKernelWidth1D)
#define GetOptimalKernelWidth2D  PrependMagickMethod(GetOptimalKernelWidth2D)
#define GetOptimalKernelWidth  PrependMagickMethod(GetOptimalKernelWidth)
#define GetPageGeometry  PrependMagickMethod(GetPageGeometry)
#define GetPathAttributes  PrependMagickMethod(GetPathAttributes)
#define GetPathComponent  PrependMagickMethod(GetPathComponent)
#define GetPathComponents  PrependMagickMethod(GetPathComponents)
#define GetPathTemplate  PrependMagickMethod(GetPathTemplate)
#define GetPixelCacheColorspace  PrependMagickMethod(GetPixelCacheColorspace)
#define GetPixelCacheFilename  PrependMagickMethod(GetPixelCacheFilename)
#define GetPixelCacheMethods  PrependMagickMethod(GetPixelCacheMethods)
#define GetPixelCacheNexusExtent  PrependMagickMethod(GetPixelCacheNexusExtent)
#define GetPixelCachePixels  PrependMagickMethod(GetPixelCachePixels)
#define GetPixelCacheStorageClass  PrependMagickMethod(GetPixelCacheStorageClass)
#define GetPixelCacheTileSize  PrependMagickMethod(GetPixelCacheTileSize)
#define GetPixelCacheVirtualMethod  PrependMagickMethod(GetPixelCacheVirtualMethod)
#define GetPixelInfoIntensity  PrependMagickMethod(GetPixelInfoIntensity)
#define GetPixelInfo  PrependMagickMethod(GetPixelInfo)
#define GetPixelIntensity  PrependMagickMethod(GetPixelIntensity)
#define GetPolicyInfoList  PrependMagickMethod(GetPolicyInfoList)
#define GetPolicyList  PrependMagickMethod(GetPolicyList)
#define GetPolicyValue  PrependMagickMethod(GetPolicyValue)
#define GetPreviousImageInList  PrependMagickMethod(GetPreviousImageInList)
#define GetPseudoRandomValue  PrependMagickMethod(GetPseudoRandomValue)
#define GetQuantizeInfo  PrependMagickMethod(GetQuantizeInfo)
#define GetQuantumEndian  PrependMagickMethod(GetQuantumEndian)
#define GetQuantumExtent  PrependMagickMethod(GetQuantumExtent)
#define GetQuantumFormat  PrependMagickMethod(GetQuantumFormat)
#define GetQuantumInfo  PrependMagickMethod(GetQuantumInfo)
#define GetQuantumPixels  PrependMagickMethod(GetQuantumPixels)
#define GetQuantumType  PrependMagickMethod(GetQuantumType)
#define GetRandomInfoNormalize  PrependMagickMethod(GetRandomInfoNormalize)
#define GetRandomInfoSeed  PrependMagickMethod(GetRandomInfoSeed)
#define GetRandomKey  PrependMagickMethod(GetRandomKey)
#define GetRandomSecretKey  PrependMagickMethod(GetRandomSecretKey)
#define GetRandomValue  PrependMagickMethod(GetRandomValue)
#define GetResizeFilterBlur  PrependMagickMethod(GetResizeFilterBlur)
#define GetResizeFilterCoefficient  PrependMagickMethod(GetResizeFilterCoefficient)
#define GetResizeFilterScale  PrependMagickMethod(GetResizeFilterScale)
#define GetResizeFilterSupport  PrependMagickMethod(GetResizeFilterSupport)
#define GetResizeFilterWeightingType  PrependMagickMethod(GetResizeFilterWeightingType)
#define GetResizeFilterWeight  PrependMagickMethod(GetResizeFilterWeight)
#define GetResizeFilterWindowSupport  PrependMagickMethod(GetResizeFilterWindowSupport)
#define GetResizeFilterWindowWeightingType  PrependMagickMethod(GetResizeFilterWindowWeightingType)
#define GetRootValueFromSplayTree  PrependMagickMethod(GetRootValueFromSplayTree)
#define GetSignatureBlocksize  PrependMagickMethod(GetSignatureBlocksize)
#define GetSignatureDigest  PrependMagickMethod(GetSignatureDigest)
#define GetSignatureDigestsize  PrependMagickMethod(GetSignatureDigestsize)
#define GetStreamInfoClientData  PrependMagickMethod(GetStreamInfoClientData)
#define GetStringInfoDatum  PrependMagickMethod(GetStringInfoDatum)
#define GetStringInfoLength  PrependMagickMethod(GetStringInfoLength)
#define GetStringInfoName  PrependMagickMethod(GetStringInfoName)
#define GetStringInfoPath  PrependMagickMethod(GetStringInfoPath)
#define GetThresholdMap  PrependMagickMethod(GetThresholdMap)
#define GetTimerInfo  PrependMagickMethod(GetTimerInfo)
#define GetTypeInfoByFamily  PrependMagickMethod(GetTypeInfoByFamily)
#define GetTypeInfoList  PrependMagickMethod(GetTypeInfoList)
#define GetTypeInfo  PrependMagickMethod(GetTypeInfo)
#define GetTypeList  PrependMagickMethod(GetTypeList)
#define GetTypeMetrics  PrependMagickMethod(GetTypeMetrics)
#define GetUserTime  PrependMagickMethod(GetUserTime)
#define GetValueFromLinkedList  PrependMagickMethod(GetValueFromLinkedList)
#define GetValueFromSplayTree  PrependMagickMethod(GetValueFromSplayTree)
#define GetVirtualMemoryBlob  PrependMagickMethod(GetVirtualMemoryBlob)
#define GetVirtualMetacontentFromNexus  PrependMagickMethod(GetVirtualMetacontentFromNexus)
#define GetVirtualMetacontent  PrependMagickMethod(GetVirtualMetacontent)
#define GetVirtualPixelCacheNexus  PrependMagickMethod(GetVirtualPixelCacheNexus)
#define GetVirtualPixelQueue  PrependMagickMethod(GetVirtualPixelQueue)
#define GetVirtualPixelsNexus  PrependMagickMethod(GetVirtualPixelsNexus)
#define GetVirtualPixels  PrependMagickMethod(GetVirtualPixels)
#define GetXMLTreeAttribute  PrependMagickMethod(GetXMLTreeAttribute)
#define GetXMLTreeAttributes  PrependMagickMethod(GetXMLTreeAttributes)
#define GetXMLTreeChild  PrependMagickMethod(GetXMLTreeChild)
#define GetXMLTreeContent  PrependMagickMethod(GetXMLTreeContent)
#define GetXMLTreeOrdered  PrependMagickMethod(GetXMLTreeOrdered)
#define GetXMLTreePath  PrependMagickMethod(GetXMLTreePath)
#define GetXMLTreeProcessingInstructions  PrependMagickMethod(GetXMLTreeProcessingInstructions)
#define GetXMLTreeSibling  PrependMagickMethod(GetXMLTreeSibling)
#define GetXMLTreeTag  PrependMagickMethod(GetXMLTreeTag)
#define GlobExpression  PrependMagickMethod(GlobExpression)
#define GradientImage  PrependMagickMethod(GradientImage)
#define GravityAdjustGeometry  PrependMagickMethod(GravityAdjustGeometry)
#define GrayscaleImage  PrependMagickMethod(GrayscaleImage)
#define HaldClutImage  PrependMagickMethod(HaldClutImage)
#define HeapOverflowSanityCheck  PrependMagickMethod(HeapOverflowSanityCheck)
#define HoughLineImage  PrependMagickMethod(HoughLineImage)
#define HuffmanDecodeImage  PrependMagickMethod(HuffmanDecodeImage)
#define HuffmanEncodeImage  PrependMagickMethod(HuffmanEncodeImage)
#define IdentifyImageGray  PrependMagickMethod(IdentifyImageGray)
#define IdentifyImageMonochrome  PrependMagickMethod(IdentifyImageMonochrome)
#define IdentifyImage  PrependMagickMethod(IdentifyImage)
#define IdentifyImageType  PrependMagickMethod(IdentifyImageType)
#define IdentifyPaletteImage  PrependMagickMethod(IdentifyPaletteImage)
#define ImageListToArray  PrependMagickMethod(ImageListToArray)
#define ImagesToBlob  PrependMagickMethod(ImagesToBlob)
#define ImagesToCustomStream  PrependMagickMethod(ImagesToCustomStream)
#define ImageToBlob  PrependMagickMethod(ImageToBlob)
#define ImageToCustomStream  PrependMagickMethod(ImageToCustomStream)
#define ImageToFile  PrependMagickMethod(ImageToFile)
#define ImplodeImage  PrependMagickMethod(ImplodeImage)
#define ImportImagePixels  PrependMagickMethod(ImportImagePixels)
#define ImportQuantumPixels  PrependMagickMethod(ImportQuantumPixels)
#define InheritException  PrependMagickMethod(InheritException)
#define InitializeExceptionInfo  PrependMagickMethod(InitializeExceptionInfo)
#define InitializePixelChannelMap  PrependMagickMethod(InitializePixelChannelMap)
#define InitializeSignature  PrependMagickMethod(InitializeSignature)
#define InjectImageBlob  PrependMagickMethod(InjectImageBlob)
#define InsertImageInList  PrependMagickMethod(InsertImageInList)
#define InsertTagIntoXMLTree  PrependMagickMethod(InsertTagIntoXMLTree)
#define InsertValueInLinkedList  PrependMagickMethod(InsertValueInLinkedList)
#define InsertValueInSortedLinkedList  PrependMagickMethod(InsertValueInSortedLinkedList)
#define IntegralRotateImage  PrependMagickMethod(IntegralRotateImage)
#define InterpolatePixelChannel  PrependMagickMethod(InterpolatePixelChannel)
#define InterpolatePixelChannels  PrependMagickMethod(InterpolatePixelChannels)
#define InterpolatePixelInfo  PrependMagickMethod(InterpolatePixelInfo)
#define InterpolativeResizeImage  PrependMagickMethod(InterpolativeResizeImage)
#define InterpretImageFilename  PrependMagickMethod(InterpretImageFilename)
#define InterpretImageProperties  PrependMagickMethod(InterpretImageProperties)
#define InterpretLocaleValue  PrependMagickMethod(InterpretLocaleValue)
#define InterpretSiPrefixValue  PrependMagickMethod(InterpretSiPrefixValue)
#define InverseFourierTransformImage  PrependMagickMethod(InverseFourierTransformImage)
#define InvokeDelegate  PrependMagickMethod(InvokeDelegate)
#define InvokeDynamicImageFilter  PrependMagickMethod(InvokeDynamicImageFilter)
#define IsBlobExempt  PrependMagickMethod(IsBlobExempt)
#define IsBlobSeekable  PrependMagickMethod(IsBlobSeekable)
#define IsBlobTemporary  PrependMagickMethod(IsBlobTemporary)
#define IsCommandOption  PrependMagickMethod(IsCommandOption)
#define IsEquivalentAlpha  PrependMagickMethod(IsEquivalentAlpha)
#define IsEquivalentImage  PrependMagickMethod(IsEquivalentImage)
#define IsEquivalentIntensity  PrependMagickMethod(IsEquivalentIntensity)
#define IsEventLogging  PrependMagickMethod(IsEventLogging)
#define IsFuzzyEquivalencePixelInfo  PrependMagickMethod(IsFuzzyEquivalencePixelInfo)
#define IsFuzzyEquivalencePixel  PrependMagickMethod(IsFuzzyEquivalencePixel)
#define IsGeometry  PrependMagickMethod(IsGeometry)
#define IsGlob  PrependMagickMethod(IsGlob)
#define IsHighDynamicRangeImage  PrependMagickMethod(IsHighDynamicRangeImage)
#define IsHistogramImage  PrependMagickMethod(IsHistogramImage)
#define IsImageGray  PrependMagickMethod(IsImageGray)
#define IsImageMonochrome  PrependMagickMethod(IsImageMonochrome)
#define IsImageObject  PrependMagickMethod(IsImageObject)
#define IsImageOpaque  PrependMagickMethod(IsImageOpaque)
#define IsImagesEqual  PrependMagickMethod(IsImagesEqual)
#define IsImageView  PrependMagickMethod(IsImageView)
#define IsLinkedListEmpty  PrependMagickMethod(IsLinkedListEmpty)
#define IsOptionMember  PrependMagickMethod(IsOptionMember)
#define IsPaletteImage  PrependMagickMethod(IsPaletteImage)
#define IsPathAccessible  PrependMagickMethod(IsPathAccessible)
#define IsRightsAuthorized  PrependMagickMethod(IsRightsAuthorized)
#define IsSceneGeometry  PrependMagickMethod(IsSceneGeometry)
#define IsStringFalse  PrependMagickMethod(IsStringFalse)
#define IsStringTrue  PrependMagickMethod(IsStringTrue)
#define IsTaintImage  PrependMagickMethod(IsTaintImage)
#define KuwaharaImage  PrependMagickMethod(KuwaharaImage)
#define LeastSquaresAddTerms  PrependMagickMethod(LeastSquaresAddTerms)
#define LevelImageColors  PrependMagickMethod(LevelImageColors)
#define LevelImage  PrependMagickMethod(LevelImage)
#define LevelizeImage  PrependMagickMethod(LevelizeImage)
#define LinearStretchImage  PrependMagickMethod(LinearStretchImage)
#define LinkedListToArray  PrependMagickMethod(LinkedListToArray)
#define LiquidRescaleImage  PrependMagickMethod(LiquidRescaleImage)
#define ListCoderInfo  PrependMagickMethod(ListCoderInfo)
#define ListColorInfo  PrependMagickMethod(ListColorInfo)
#define ListCommandOptions  PrependMagickMethod(ListCommandOptions)
#define ListConfigureInfo  PrependMagickMethod(ListConfigureInfo)
#define ListDelegateInfo  PrependMagickMethod(ListDelegateInfo)
#define ListFiles  PrependMagickMethod(ListFiles)
#define ListLocaleInfo  PrependMagickMethod(ListLocaleInfo)
#define ListLogInfo  PrependMagickMethod(ListLogInfo)
#define ListMagicInfo  PrependMagickMethod(ListMagicInfo)
#define ListMimeInfo  PrependMagickMethod(ListMimeInfo)
#define ListModuleInfo  PrependMagickMethod(ListModuleInfo)
#define ListPolicyInfo  PrependMagickMethod(ListPolicyInfo)
#define ListThresholdMapFile  PrependMagickMethod(ListThresholdMapFile)
#define ListThresholdMaps  PrependMagickMethod(ListThresholdMaps)
#define ListTypeInfo  PrependMagickMethod(ListTypeInfo)
#define LoadFontConfigFonts  PrependMagickMethod(LoadFontConfigFonts)
#define LocalContrastImage  PrependMagickMethod(LocalContrastImage)
#define LocaleCompare  PrependMagickMethod(LocaleCompare)
#define LocaleComponentGenesis  PrependMagickMethod(LocaleComponentGenesis)
#define LocaleComponentTerminus  PrependMagickMethod(LocaleComponentTerminus)
#define LocaleLowercase  PrependMagickMethod(LocaleLowercase)
#define LocaleLower  PrependMagickMethod(LocaleLower)
#define LocaleNCompare  PrependMagickMethod(LocaleNCompare)
#define LocaleUppercase  PrependMagickMethod(LocaleUppercase)
#define LocaleUpper  PrependMagickMethod(LocaleUpper)
#define LockSemaphoreInfo  PrependMagickMethod(LockSemaphoreInfo)
#define LogComponentGenesis  PrependMagickMethod(LogComponentGenesis)
#define LogComponentTerminus  PrependMagickMethod(LogComponentTerminus)
#define LZWEncodeImage  PrependMagickMethod(LZWEncodeImage)
#define MagicComponentGenesis  PrependMagickMethod(MagicComponentGenesis)
#define MagicComponentTerminus  PrependMagickMethod(MagicComponentTerminus)
#define MagnifyImage  PrependMagickMethod(MagnifyImage)
#define MapBlob  PrependMagickMethod(MapBlob)
#define MatrixToImage  PrependMagickMethod(MatrixToImage)
#define MeanShiftImage  PrependMagickMethod(MeanShiftImage)
#define MergeImageLayers  PrependMagickMethod(MergeImageLayers)
#define MimeComponentGenesis  PrependMagickMethod(MimeComponentGenesis)
#define MimeComponentTerminus  PrependMagickMethod(MimeComponentTerminus)
#define MinifyImage  PrependMagickMethod(MinifyImage)
#define MinMaxStretchImage  PrependMagickMethod(MinMaxStretchImage)
#define ModifyImage  PrependMagickMethod(ModifyImage)
#define ModulateImage  PrependMagickMethod(ModulateImage)
#define MonitorComponentGenesis  PrependMagickMethod(MonitorComponentGenesis)
#define MonitorComponentTerminus  PrependMagickMethod(MonitorComponentTerminus)
#define MontageImageList  PrependMagickMethod(MontageImageList)
#define MontageImages  PrependMagickMethod(MontageImages)
#define MorphImages  PrependMagickMethod(MorphImages)
#define MorphologyApply  PrependMagickMethod(MorphologyApply)
#define MorphologyImage  PrependMagickMethod(MorphologyImage)
#define MotionBlurImage  PrependMagickMethod(MotionBlurImage)
#define MSBOrderLong  PrependMagickMethod(MSBOrderLong)
#define MSBOrderShort  PrependMagickMethod(MSBOrderShort)
#define MultilineCensus  PrependMagickMethod(MultilineCensus)
#define MVGMacroCompare  PrependMagickMethod(MVGMacroCompare)
#define NegateImage  PrependMagickMethod(NegateImage)
#define NewImageList  PrependMagickMethod(NewImageList)
#define NewImageView  PrependMagickMethod(NewImageView)
#define NewImageViewRegion  PrependMagickMethod(NewImageViewRegion)
#define NewLinkedList  PrependMagickMethod(NewLinkedList)
#define NewSplayTree  PrependMagickMethod(NewSplayTree)
#define NewXMLTree  PrependMagickMethod(NewXMLTree)
#define NewXMLTreeTag  PrependMagickMethod(NewXMLTreeTag)
#define NormalizeImage  PrependMagickMethod(NormalizeImage)
#define NullMatrix  PrependMagickMethod(NullMatrix)
#define OilPaintImage  PrependMagickMethod(OilPaintImage)
#define OpaquePaintImage  PrependMagickMethod(OpaquePaintImage)
#define OpenBlob  PrependMagickMethod(OpenBlob)
#define OpenDistributePixelCache  PrependMagickMethod(OpenDistributePixelCache)
#define OpenStream  PrependMagickMethod(OpenStream)
#define OptimizeImageLayers  PrependMagickMethod(OptimizeImageLayers)
#define OptimizeImageTransparency  PrependMagickMethod(OptimizeImageTransparency)
#define OptimizePlusImageLayers  PrependMagickMethod(OptimizePlusImageLayers)
#define OrderedDitherImage  PrependMagickMethod(OrderedDitherImage)
#define PackbitsEncodeImage  PrependMagickMethod(PackbitsEncodeImage)
#define ParseAbsoluteGeometry  PrependMagickMethod(ParseAbsoluteGeometry)
#define ParseAffineGeometry  PrependMagickMethod(ParseAffineGeometry)
#define ParseChannelOption  PrependMagickMethod(ParseChannelOption)
#define ParseCommandOption  PrependMagickMethod(ParseCommandOption)
#define ParseGeometry  PrependMagickMethod(ParseGeometry)
#define ParseGravityGeometry  PrependMagickMethod(ParseGravityGeometry)
#define ParseMetaGeometry  PrependMagickMethod(ParseMetaGeometry)
#define ParsePageGeometry  PrependMagickMethod(ParsePageGeometry)
#define ParsePixelChannelOption  PrependMagickMethod(ParsePixelChannelOption)
#define ParseRegionGeometry  PrependMagickMethod(ParseRegionGeometry)
#define PasskeyDecipherImage  PrependMagickMethod(PasskeyDecipherImage)
#define PasskeyEncipherImage  PrependMagickMethod(PasskeyEncipherImage)
#define PerceptibleImage  PrependMagickMethod(PerceptibleImage)
#define PersistPixelCache  PrependMagickMethod(PersistPixelCache)
#define PingBlob  PrependMagickMethod(PingBlob)
#define PingImage  PrependMagickMethod(PingImage)
#define PingImages  PrependMagickMethod(PingImages)
#define PlasmaImage  PrependMagickMethod(PlasmaImage)
#define PolaroidImage  PrependMagickMethod(PolaroidImage)
#define PolicyComponentGenesis  PrependMagickMethod(PolicyComponentGenesis)
#define PolicyComponentTerminus  PrependMagickMethod(PolicyComponentTerminus)
#define PolynomialImage  PrependMagickMethod(PolynomialImage)
#define PosterizeImage  PrependMagickMethod(PosterizeImage)
#define PrependImageToList  PrependMagickMethod(PrependImageToList)
#define PreviewImage  PrependMagickMethod(PreviewImage)
#define PrintStringInfo  PrependMagickMethod(PrintStringInfo)
#define process_message  PrependMagickMethod(process_message)
#define ProfileImage  PrependMagickMethod(ProfileImage)
#define PruneTagFromXMLTree  PrependMagickMethod(PruneTagFromXMLTree)
#define QuantizeImage  PrependMagickMethod(QuantizeImage)
#define QuantizeImages  PrependMagickMethod(QuantizeImages)
#define QueryColorCompliance  PrependMagickMethod(QueryColorCompliance)
#define QueryColorname  PrependMagickMethod(QueryColorname)
#define QueueAuthenticPixelCacheNexus  PrependMagickMethod(QueueAuthenticPixelCacheNexus)
#define QueueAuthenticPixels  PrependMagickMethod(QueueAuthenticPixels)
#define QueueCacheViewAuthenticPixels  PrependMagickMethod(QueueCacheViewAuthenticPixels)
#define RaiseImage  PrependMagickMethod(RaiseImage)
#define RandomComponentGenesis  PrependMagickMethod(RandomComponentGenesis)
#define RandomComponentTerminus  PrependMagickMethod(RandomComponentTerminus)
#define RandomThresholdImage  PrependMagickMethod(RandomThresholdImage)
#define RangeThresholdImage  PrependMagickMethod(RangeThresholdImage)
#define ReadBlobByte  PrependMagickMethod(ReadBlobByte)
#define ReadBlobDouble  PrependMagickMethod(ReadBlobDouble)
#define ReadBlobFloat  PrependMagickMethod(ReadBlobFloat)
#define ReadBlobLongLong  PrependMagickMethod(ReadBlobLongLong)
#define ReadBlobLong  PrependMagickMethod(ReadBlobLong)
#define ReadBlobLSBLong  PrependMagickMethod(ReadBlobLSBLong)
#define ReadBlobLSBShort  PrependMagickMethod(ReadBlobLSBShort)
#define ReadBlobLSBSignedLong  PrependMagickMethod(ReadBlobLSBSignedLong)
#define ReadBlobLSBSignedShort  PrependMagickMethod(ReadBlobLSBSignedShort)
#define ReadBlobMSBLongLong  PrependMagickMethod(ReadBlobMSBLongLong)
#define ReadBlobMSBLong  PrependMagickMethod(ReadBlobMSBLong)
#define ReadBlobMSBShort  PrependMagickMethod(ReadBlobMSBShort)
#define ReadBlobMSBSignedLong  PrependMagickMethod(ReadBlobMSBSignedLong)
#define ReadBlobMSBSignedShort  PrependMagickMethod(ReadBlobMSBSignedShort)
#define ReadBlob  PrependMagickMethod(ReadBlob)
#define ReadBlobShort  PrependMagickMethod(ReadBlobShort)
#define ReadBlobSignedLong  PrependMagickMethod(ReadBlobSignedLong)
#define ReadBlobSignedShort  PrependMagickMethod(ReadBlobSignedShort)
#define ReadBlobStream  PrependMagickMethod(ReadBlobStream)
#define ReadBlobString  PrependMagickMethod(ReadBlobString)
#define ReadDistributePixelCacheMetacontent  PrependMagickMethod(ReadDistributePixelCacheMetacontent)
#define ReadDistributePixelCachePixels  PrependMagickMethod(ReadDistributePixelCachePixels)
#define ReadImage  PrependMagickMethod(ReadImage)
#define ReadImages  PrependMagickMethod(ReadImages)
#define ReadInlineImage  PrependMagickMethod(ReadInlineImage)
#define ReadPSDLayers  PrependMagickMethod(ReadPSDLayers)
#define ReadStream  PrependMagickMethod(ReadStream)
#define ReferenceBlob  PrependMagickMethod(ReferenceBlob)
#define ReferenceImage  PrependMagickMethod(ReferenceImage)
#define ReferencePixelCache  PrependMagickMethod(ReferencePixelCache)
#define RegisterAAIImage  PrependMagickMethod(RegisterAAIImage)
#define RegisterARTImage  PrependMagickMethod(RegisterARTImage)
#define RegisterAVSImage  PrependMagickMethod(RegisterAVSImage)
#define RegisterBGRImage  PrependMagickMethod(RegisterBGRImage)
#define RegisterBMPImage  PrependMagickMethod(RegisterBMPImage)
#define RegisterBRAILLEImage  PrependMagickMethod(RegisterBRAILLEImage)
#define RegisterCALSImage  PrependMagickMethod(RegisterCALSImage)
#define RegisterCAPTIONImage  PrependMagickMethod(RegisterCAPTIONImage)
#define RegisterCINImage  PrependMagickMethod(RegisterCINImage)
#define RegisterCIPImage  PrependMagickMethod(RegisterCIPImage)
#define RegisterCLIPImage  PrependMagickMethod(RegisterCLIPImage)
#define RegisterCMYKImage  PrependMagickMethod(RegisterCMYKImage)
#define RegisterCUBEImage  PrependMagickMethod(RegisterCUBEImage)
#define RegisterCUTImage  PrependMagickMethod(RegisterCUTImage)
#define RegisterDCMImage  PrependMagickMethod(RegisterDCMImage)
#define RegisterDDSImage  PrependMagickMethod(RegisterDDSImage)
#define RegisterDEBUGImage  PrependMagickMethod(RegisterDEBUGImage)
#define RegisterDIBImage  PrependMagickMethod(RegisterDIBImage)
#define RegisterDJVUImage  PrependMagickMethod(RegisterDJVUImage)
#define RegisterDNGImage  PrependMagickMethod(RegisterDNGImage)
#define RegisterDOTImage  PrependMagickMethod(RegisterDOTImage)
#define RegisterDPXImage  PrependMagickMethod(RegisterDPXImage)
#define RegisterEPTImage  PrependMagickMethod(RegisterEPTImage)
#define RegisterEXRImage  PrependMagickMethod(RegisterEXRImage)
#define RegisterFAXImage  PrependMagickMethod(RegisterFAXImage)
#define RegisterFITSImage  PrependMagickMethod(RegisterFITSImage)
#define RegisterGIFImage  PrependMagickMethod(RegisterGIFImage)
#define RegisterGRADIENTImage  PrependMagickMethod(RegisterGRADIENTImage)
#define RegisterGRAYImage  PrependMagickMethod(RegisterGRAYImage)
#define RegisterHALDImage  PrependMagickMethod(RegisterHALDImage)
#define RegisterHDRImage  PrependMagickMethod(RegisterHDRImage)
#define RegisterHEICImage  PrependMagickMethod(RegisterHEICImage)
#define RegisterHISTOGRAMImage  PrependMagickMethod(RegisterHISTOGRAMImage)
#define RegisterHRZImage  PrependMagickMethod(RegisterHRZImage)
#define RegisterHTMLImage  PrependMagickMethod(RegisterHTMLImage)
#define RegisterICONImage  PrependMagickMethod(RegisterICONImage)
#define RegisterINFOImage  PrependMagickMethod(RegisterINFOImage)
#define RegisterINLINEImage  PrependMagickMethod(RegisterINLINEImage)
#define RegisterIPLImage  PrependMagickMethod(RegisterIPLImage)
#define RegisterJBIGImage  PrependMagickMethod(RegisterJBIGImage)
#define RegisterJNXImage  PrependMagickMethod(RegisterJNXImage)
#define RegisterJP2Image  PrependMagickMethod(RegisterJP2Image)
#define RegisterJPEGImage  PrependMagickMethod(RegisterJPEGImage)
#define RegisterJSONImage  PrependMagickMethod(RegisterJSONImage)
#define RegisterLABELImage  PrependMagickMethod(RegisterLABELImage)
#define RegisterMACImage  PrependMagickMethod(RegisterMACImage)
#define RegisterMAPImage  PrependMagickMethod(RegisterMAPImage)
#define RegisterMASKImage  PrependMagickMethod(RegisterMASKImage)
#define RegisterMATImage  PrependMagickMethod(RegisterMATImage)
#define RegisterMATTEImage  PrependMagickMethod(RegisterMATTEImage)
#define RegisterMETAImage  PrependMagickMethod(RegisterMETAImage)
#define RegisterMIFFImage  PrependMagickMethod(RegisterMIFFImage)
#define RegisterMONOImage  PrependMagickMethod(RegisterMONOImage)
#define RegisterMPCImage  PrependMagickMethod(RegisterMPCImage)
#define RegisterMPEGImage  PrependMagickMethod(RegisterMPEGImage)
#define RegisterMPRImage  PrependMagickMethod(RegisterMPRImage)
#define RegisterMSLImage  PrependMagickMethod(RegisterMSLImage)
#define RegisterMTVImage  PrependMagickMethod(RegisterMTVImage)
#define RegisterMVGImage  PrependMagickMethod(RegisterMVGImage)
#define RegisterNULLImage  PrependMagickMethod(RegisterNULLImage)
#define RegisterOTBImage  PrependMagickMethod(RegisterOTBImage)
#define RegisterPALMImage  PrependMagickMethod(RegisterPALMImage)
#define RegisterPANGOImage  PrependMagickMethod(RegisterPANGOImage)
#define RegisterPATTERNImage  PrependMagickMethod(RegisterPATTERNImage)
#define RegisterPCDImage  PrependMagickMethod(RegisterPCDImage)
#define RegisterPCLImage  PrependMagickMethod(RegisterPCLImage)
#define RegisterPCXImage  PrependMagickMethod(RegisterPCXImage)
#define RegisterPDBImage  PrependMagickMethod(RegisterPDBImage)
#define RegisterPDFImage  PrependMagickMethod(RegisterPDFImage)
#define RegisterPESImage  PrependMagickMethod(RegisterPESImage)
#define RegisterPGXImage  PrependMagickMethod(RegisterPGXImage)
#define RegisterPICTImage  PrependMagickMethod(RegisterPICTImage)
#define RegisterPIXImage  PrependMagickMethod(RegisterPIXImage)
#define RegisterPLASMAImage  PrependMagickMethod(RegisterPLASMAImage)
#define RegisterPNGImage  PrependMagickMethod(RegisterPNGImage)
#define RegisterPNMImage  PrependMagickMethod(RegisterPNMImage)
#define RegisterPS2Image  PrependMagickMethod(RegisterPS2Image)
#define RegisterPS3Image  PrependMagickMethod(RegisterPS3Image)
#define RegisterPSDImage  PrependMagickMethod(RegisterPSDImage)
#define RegisterPSImage  PrependMagickMethod(RegisterPSImage)
#define RegisterPWPImage  PrependMagickMethod(RegisterPWPImage)
#define RegisterRAWImage  PrependMagickMethod(RegisterRAWImage)
#define RegisterRGBImage  PrependMagickMethod(RegisterRGBImage)
#define RegisterRGFImage  PrependMagickMethod(RegisterRGFImage)
#define RegisterRLAImage  PrependMagickMethod(RegisterRLAImage)
#define RegisterRLEImage  PrependMagickMethod(RegisterRLEImage)
#define RegisterSCREENSHOTImage  PrependMagickMethod(RegisterSCREENSHOTImage)
#define RegisterSCRImage  PrependMagickMethod(RegisterSCRImage)
#define RegisterSCTImage  PrependMagickMethod(RegisterSCTImage)
#define RegisterSFWImage  PrependMagickMethod(RegisterSFWImage)
#define RegisterSGIImage  PrependMagickMethod(RegisterSGIImage)
#define RegisterSIXELImage  PrependMagickMethod(RegisterSIXELImage)
#define RegisterStaticModule  PrependMagickMethod(RegisterStaticModule)
#define RegisterStaticModules  PrependMagickMethod(RegisterStaticModules)
#define RegisterSTEGANOImage  PrependMagickMethod(RegisterSTEGANOImage)
#define RegisterSUNImage  PrependMagickMethod(RegisterSUNImage)
#define RegisterSVGImage  PrependMagickMethod(RegisterSVGImage)
#define RegisterTGAImage  PrependMagickMethod(RegisterTGAImage)
#define RegisterTHUMBNAILImage  PrependMagickMethod(RegisterTHUMBNAILImage)
#define RegisterTIFFImage  PrependMagickMethod(RegisterTIFFImage)
#define RegisterTILEImage  PrependMagickMethod(RegisterTILEImage)
#define RegisterTIMImage  PrependMagickMethod(RegisterTIMImage)
#define RegisterTTFImage  PrependMagickMethod(RegisterTTFImage)
#define RegisterTXTImage  PrependMagickMethod(RegisterTXTImage)
#define RegisterUILImage  PrependMagickMethod(RegisterUILImage)
#define RegisterUndefinedImage  PrependMagickMethod(RegisterUndefinedImage)
#define RegisterURLImage  PrependMagickMethod(RegisterURLImage)
#define RegisterUYVYImage  PrependMagickMethod(RegisterUYVYImage)
#define RegisterVICARImage  PrependMagickMethod(RegisterVICARImage)
#define RegisterVIDImage  PrependMagickMethod(RegisterVIDImage)
#define RegisterVIFFImage  PrependMagickMethod(RegisterVIFFImage)
#define RegisterVIPSImage  PrependMagickMethod(RegisterVIPSImage)
#define RegisterWBMPImage  PrependMagickMethod(RegisterWBMPImage)
#define RegisterWEBPImage  PrependMagickMethod(RegisterWEBPImage)
#define RegisterWMFImage  PrependMagickMethod(RegisterWMFImage)
#define RegisterWPGImage  PrependMagickMethod(RegisterWPGImage)
#define RegisterXBMImage  PrependMagickMethod(RegisterXBMImage)
#define RegisterXCFImage  PrependMagickMethod(RegisterXCFImage)
#define RegisterXCImage  PrependMagickMethod(RegisterXCImage)
#define RegisterXImage  PrependMagickMethod(RegisterXImage)
#define RegisterXPMImage  PrependMagickMethod(RegisterXPMImage)
#define RegisterXPSImage  PrependMagickMethod(RegisterXPSImage)
#define RegisterXTRNImage  PrependMagickMethod(RegisterXTRNImage)
#define RegisterXWDImage  PrependMagickMethod(RegisterXWDImage)
#define RegisterYCBCRImage  PrependMagickMethod(RegisterYCBCRImage)
#define RegisterYUVImage  PrependMagickMethod(RegisterYUVImage)
#define RegistryComponentGenesis  PrependMagickMethod(RegistryComponentGenesis)
#define RegistryComponentTerminus  PrependMagickMethod(RegistryComponentTerminus)
#define RelinquishAlignedMemory  PrependMagickMethod(RelinquishAlignedMemory)
#define RelinquishDistributePixelCache  PrependMagickMethod(RelinquishDistributePixelCache)
#define RelinquishSemaphoreInfo  PrependMagickMethod(RelinquishSemaphoreInfo)
#define RelinquishUniqueFileResource  PrependMagickMethod(RelinquishUniqueFileResource)
#define RelinquishVirtualMemory  PrependMagickMethod(RelinquishVirtualMemory)
#define RemapImage  PrependMagickMethod(RemapImage)
#define RemapImages  PrependMagickMethod(RemapImages)
#define RemoteDisplayCommand  PrependMagickMethod(RemoteDisplayCommand)
#define RemoveDuplicateLayers  PrependMagickMethod(RemoveDuplicateLayers)
#define RemoveElementByValueFromLinkedList  PrependMagickMethod(RemoveElementByValueFromLinkedList)
#define RemoveElementFromLinkedList  PrependMagickMethod(RemoveElementFromLinkedList)
#define RemoveFirstImageFromList  PrependMagickMethod(RemoveFirstImageFromList)
#define RemoveImageArtifact  PrependMagickMethod(RemoveImageArtifact)
#define RemoveImageFromList  PrependMagickMethod(RemoveImageFromList)
#define RemoveImageOption  PrependMagickMethod(RemoveImageOption)
#define RemoveImageProfile  PrependMagickMethod(RemoveImageProfile)
#define RemoveImageProperty  PrependMagickMethod(RemoveImageProperty)
#define RemoveImageRegistry  PrependMagickMethod(RemoveImageRegistry)
#define RemoveLastElementFromLinkedList  PrependMagickMethod(RemoveLastElementFromLinkedList)
#define RemoveLastImageFromList  PrependMagickMethod(RemoveLastImageFromList)
#define RemoveNodeByValueFromSplayTree  PrependMagickMethod(RemoveNodeByValueFromSplayTree)
#define RemoveNodeFromSplayTree  PrependMagickMethod(RemoveNodeFromSplayTree)
#define RemoveZeroDelayLayers  PrependMagickMethod(RemoveZeroDelayLayers)
#define ReplaceImageInList  PrependMagickMethod(ReplaceImageInList)
#define ReplaceImageInListReturnLast  PrependMagickMethod(ReplaceImageInListReturnLast)
#define ResampleImage  PrependMagickMethod(ResampleImage)
#define ResamplePixelColor  PrependMagickMethod(ResamplePixelColor)
#define ResetCacheAnonymousMemory  PrependMagickMethod(ResetCacheAnonymousMemory)
#define ResetImageArtifactIterator  PrependMagickMethod(ResetImageArtifactIterator)
#define ResetImageOptionIterator  PrependMagickMethod(ResetImageOptionIterator)
#define ResetImageOptions  PrependMagickMethod(ResetImageOptions)
#define ResetImagePage  PrependMagickMethod(ResetImagePage)
#define ResetImagePixels  PrependMagickMethod(ResetImagePixels)
#define ResetImageProfileIterator  PrependMagickMethod(ResetImageProfileIterator)
#define ResetImagePropertyIterator  PrependMagickMethod(ResetImagePropertyIterator)
#define ResetImageRegistryIterator  PrependMagickMethod(ResetImageRegistryIterator)
#define ResetLinkedListIterator  PrependMagickMethod(ResetLinkedListIterator)
#define ResetMaxMemoryRequest  PrependMagickMethod(ResetMaxMemoryRequest)
#define ResetPixelCacheChannels  PrependMagickMethod(ResetPixelCacheChannels)
#define ResetPixelCacheEpoch  PrependMagickMethod(ResetPixelCacheEpoch)
#define ResetQuantumState  PrependMagickMethod(ResetQuantumState)
#define ResetSplayTreeIterator  PrependMagickMethod(ResetSplayTreeIterator)
#define ResetSplayTree  PrependMagickMethod(ResetSplayTree)
#define ResetStreamAnonymousMemory  PrependMagickMethod(ResetStreamAnonymousMemory)
#define ResetStringInfo  PrependMagickMethod(ResetStringInfo)
#define ResetTimer  PrependMagickMethod(ResetTimer)
#define ResetVirtualAnonymousMemory  PrependMagickMethod(ResetVirtualAnonymousMemory)
#define ResizeImage  PrependMagickMethod(ResizeImage)
#define ResizeQuantumMemory  PrependMagickMethod(ResizeQuantumMemory)
#define ResourceComponentGenesis  PrependMagickMethod(ResourceComponentGenesis)
#define ResourceComponentTerminus  PrependMagickMethod(ResourceComponentTerminus)
#define ReverseImageList  PrependMagickMethod(ReverseImageList)
#define RollImage  PrependMagickMethod(RollImage)
#define RotateImage  PrependMagickMethod(RotateImage)
#define RotationalBlurImage  PrependMagickMethod(RotationalBlurImage)
#define SampleImage  PrependMagickMethod(SampleImage)
#define SanitizeString  PrependMagickMethod(SanitizeString)
#define ScaleGeometryKernelInfo  PrependMagickMethod(ScaleGeometryKernelInfo)
#define ScaleImage  PrependMagickMethod(ScaleImage)
#define ScaleKernelInfo  PrependMagickMethod(ScaleKernelInfo)
#define ScaleResampleFilter  PrependMagickMethod(ScaleResampleFilter)
#define SeekBlob  PrependMagickMethod(SeekBlob)
#define SegmentImage  PrependMagickMethod(SegmentImage)
#define SelectiveBlurImage  PrependMagickMethod(SelectiveBlurImage)
#define SemaphoreComponentGenesis  PrependMagickMethod(SemaphoreComponentGenesis)
#define SemaphoreComponentTerminus  PrependMagickMethod(SemaphoreComponentTerminus)
#define SeparateImage  PrependMagickMethod(SeparateImage)
#define SeparateImages  PrependMagickMethod(SeparateImages)
#define SepiaToneImage  PrependMagickMethod(SepiaToneImage)
#define SetBlobExempt  PrependMagickMethod(SetBlobExempt)
#define SetBlobExtent  PrependMagickMethod(SetBlobExtent)
#define SetCacheViewStorageClass  PrependMagickMethod(SetCacheViewStorageClass)
#define SetCacheViewVirtualPixelMethod  PrependMagickMethod(SetCacheViewVirtualPixelMethod)
#define SetClientName  PrependMagickMethod(SetClientName)
#define SetClientPath  PrependMagickMethod(SetClientPath)
#define SetCustomStreamData  PrependMagickMethod(SetCustomStreamData)
#define SetCustomStreamReader  PrependMagickMethod(SetCustomStreamReader)
#define SetCustomStreamSeeker  PrependMagickMethod(SetCustomStreamSeeker)
#define SetCustomStreamTeller  PrependMagickMethod(SetCustomStreamTeller)
#define SetCustomStreamWriter  PrependMagickMethod(SetCustomStreamWriter)
#define SetErrorHandler  PrependMagickMethod(SetErrorHandler)
#define SetFatalErrorHandler  PrependMagickMethod(SetFatalErrorHandler)
#define SetGeometryInfo  PrependMagickMethod(SetGeometryInfo)
#define SetGeometry  PrependMagickMethod(SetGeometry)
#define SetImageAlphaChannel  PrependMagickMethod(SetImageAlphaChannel)
#define SetImageAlpha  PrependMagickMethod(SetImageAlpha)
#define SetImageArtifact  PrependMagickMethod(SetImageArtifact)
#define SetImageBackgroundColor  PrependMagickMethod(SetImageBackgroundColor)
#define SetImageChannelMask  PrependMagickMethod(SetImageChannelMask)
#define SetImageColorMetric  PrependMagickMethod(SetImageColorMetric)
#define SetImageColor  PrependMagickMethod(SetImageColor)
#define SetImageColorspace  PrependMagickMethod(SetImageColorspace)
#define SetImageDepth  PrependMagickMethod(SetImageDepth)
#define SetImageExtent  PrependMagickMethod(SetImageExtent)
#define SetImageGray  PrependMagickMethod(SetImageGray)
#define SetImageInfoBlob  PrependMagickMethod(SetImageInfoBlob)
#define SetImageInfoCustomStream  PrependMagickMethod(SetImageInfoCustomStream)
#define SetImageInfoFile  PrependMagickMethod(SetImageInfoFile)
#define SetImageInfo  PrependMagickMethod(SetImageInfo)
#define SetImageInfoProgressMonitor  PrependMagickMethod(SetImageInfoProgressMonitor)
#define SetImageMask  PrependMagickMethod(SetImageMask)
#define SetImageMonochrome  PrependMagickMethod(SetImageMonochrome)
#define SetImageOption  PrependMagickMethod(SetImageOption)
#define SetImageProfile  PrependMagickMethod(SetImageProfile)
#define SetImageProgressMonitor  PrependMagickMethod(SetImageProgressMonitor)
#define SetImageProgress  PrependMagickMethod(SetImageProgress)
#define SetImageProperty  PrependMagickMethod(SetImageProperty)
#define SetImageRegionMask  PrependMagickMethod(SetImageRegionMask)
#define SetImageRegistry  PrependMagickMethod(SetImageRegistry)
#define SetImageStorageClass  PrependMagickMethod(SetImageStorageClass)
#define SetImageType  PrependMagickMethod(SetImageType)
#define SetImageViewDescription  PrependMagickMethod(SetImageViewDescription)
#define SetImageViewIterator  PrependMagickMethod(SetImageViewIterator)
#define SetImageVirtualPixelMethod  PrependMagickMethod(SetImageVirtualPixelMethod)
#define SetLogEventMask  PrependMagickMethod(SetLogEventMask)
#define SetLogFormat  PrependMagickMethod(SetLogFormat)
#define SetLogMethod  PrependMagickMethod(SetLogMethod)
#define SetLogName  PrependMagickMethod(SetLogName)
#define SetMatrixElement  PrependMagickMethod(SetMatrixElement)
#define SetOpenCLDeviceEnabled  PrependMagickMethod(SetOpenCLDeviceEnabled)
#define SetOpenCLEnabled  PrependMagickMethod(SetOpenCLEnabled)
#define SetOpenCLKernelProfileEnabled  PrependMagickMethod(SetOpenCLKernelProfileEnabled)
#define SetPixelCacheMethods  PrependMagickMethod(SetPixelCacheMethods)
#define SetPixelCacheVirtualMethod  PrependMagickMethod(SetPixelCacheVirtualMethod)
#define SetPixelChannelMask  PrependMagickMethod(SetPixelChannelMask)
#define SetPixelMetaChannels  PrependMagickMethod(SetPixelMetaChannels)
#define SetQuantumAlphaType  PrependMagickMethod(SetQuantumAlphaType)
#define SetQuantumDepth  PrependMagickMethod(SetQuantumDepth)
#define SetQuantumEndian  PrependMagickMethod(SetQuantumEndian)
#define SetQuantumFormat  PrependMagickMethod(SetQuantumFormat)
#define SetQuantumImageType  PrependMagickMethod(SetQuantumImageType)
#define SetQuantumMinIsWhite  PrependMagickMethod(SetQuantumMinIsWhite)
#define SetQuantumPack  PrependMagickMethod(SetQuantumPack)
#define SetQuantumPad  PrependMagickMethod(SetQuantumPad)
#define SetQuantumQuantum  PrependMagickMethod(SetQuantumQuantum)
#define SetQuantumScale  PrependMagickMethod(SetQuantumScale)
#define SetRandomKey  PrependMagickMethod(SetRandomKey)
#define SetRandomSecretKey  PrependMagickMethod(SetRandomSecretKey)
#define SetRandomTrueRandom  PrependMagickMethod(SetRandomTrueRandom)
#define SetResampleFilterInterpolateMethod  PrependMagickMethod(SetResampleFilterInterpolateMethod)
#define SetResampleFilter  PrependMagickMethod(SetResampleFilter)
#define SetResampleFilterVirtualPixelMethod  PrependMagickMethod(SetResampleFilterVirtualPixelMethod)
#define SetSignatureDigest  PrependMagickMethod(SetSignatureDigest)
#define SetStreamInfoClientData  PrependMagickMethod(SetStreamInfoClientData)
#define SetStreamInfoMap  PrependMagickMethod(SetStreamInfoMap)
#define SetStreamInfoStorageType  PrependMagickMethod(SetStreamInfoStorageType)
#define SetStringInfoDatum  PrependMagickMethod(SetStringInfoDatum)
#define SetStringInfoLength  PrependMagickMethod(SetStringInfoLength)
#define SetStringInfoName  PrependMagickMethod(SetStringInfoName)
#define SetStringInfoPath  PrependMagickMethod(SetStringInfoPath)
#define SetStringInfo  PrependMagickMethod(SetStringInfo)
#define SetWarningHandler  PrependMagickMethod(SetWarningHandler)
#define SetXMLTreeAttribute  PrependMagickMethod(SetXMLTreeAttribute)
#define SetXMLTreeContent  PrependMagickMethod(SetXMLTreeContent)
#define ShadeImage  PrependMagickMethod(ShadeImage)
#define ShadowImage  PrependMagickMethod(ShadowImage)
#define SharpenImage  PrependMagickMethod(SharpenImage)
#define ShaveImage  PrependMagickMethod(ShaveImage)
#define ShearImage  PrependMagickMethod(ShearImage)
#define ShearRotateImage  PrependMagickMethod(ShearRotateImage)
#define ShowKernelInfo  PrependMagickMethod(ShowKernelInfo)
#define ShredFile  PrependMagickMethod(ShredFile)
#define SigmoidalContrastImage  PrependMagickMethod(SigmoidalContrastImage)
#define SignatureImage  PrependMagickMethod(SignatureImage)
#define SimilarityImage  PrependMagickMethod(SimilarityImage)
#define sixel_decode  PrependMagickMethod(sixel_decode)
#define sixel_output_create  PrependMagickMethod(sixel_output_create)
#define SketchImage  PrependMagickMethod(SketchImage)
#define SmushImages  PrependMagickMethod(SmushImages)
#define SolarizeImage  PrependMagickMethod(SolarizeImage)
#define SortColormapByIntensity  PrependMagickMethod(SortColormapByIntensity)
#define SparseColorImage  PrependMagickMethod(SparseColorImage)
#define SpliceImageIntoList  PrependMagickMethod(SpliceImageIntoList)
#define SpliceImage  PrependMagickMethod(SpliceImage)
#define SplitImageList  PrependMagickMethod(SplitImageList)
#define SplitStringInfo  PrependMagickMethod(SplitStringInfo)
#define SpreadImage  PrependMagickMethod(SpreadImage)
#define StartTimer  PrependMagickMethod(StartTimer)
#define StatisticImage  PrependMagickMethod(StatisticImage)
#define SteganoImage  PrependMagickMethod(SteganoImage)
#define StereoAnaglyphImage  PrependMagickMethod(StereoAnaglyphImage)
#define StereoImage  PrependMagickMethod(StereoImage)
#define StreamImage  PrependMagickMethod(StreamImage)
#define StringInfoToHexString  PrependMagickMethod(StringInfoToHexString)
#define StringInfoToString  PrependMagickMethod(StringInfoToString)
#define StringToArgv  PrependMagickMethod(StringToArgv)
#define StringToArrayOfDoubles  PrependMagickMethod(StringToArrayOfDoubles)
#define StringToken  PrependMagickMethod(StringToken)
#define StringToList  PrependMagickMethod(StringToList)
#define StringToStringInfo  PrependMagickMethod(StringToStringInfo)
#define StringToStrings  PrependMagickMethod(StringToStrings)
#define StripImage  PrependMagickMethod(StripImage)
#define StripString  PrependMagickMethod(StripString)
#define SubstituteString  PrependMagickMethod(SubstituteString)
#define SwirlImage  PrependMagickMethod(SwirlImage)
#define SyncAuthenticPixelCacheNexus  PrependMagickMethod(SyncAuthenticPixelCacheNexus)
#define SyncAuthenticPixels  PrependMagickMethod(SyncAuthenticPixels)
#define SyncCacheViewAuthenticPixels  PrependMagickMethod(SyncCacheViewAuthenticPixels)
#define SyncExifProfile  PrependMagickMethod(SyncExifProfile)
#define SyncImageList  PrependMagickMethod(SyncImageList)
#define SyncImagePixelCache  PrependMagickMethod(SyncImagePixelCache)
#define SyncImage  PrependMagickMethod(SyncImage)
#define SyncImageProfiles  PrependMagickMethod(SyncImageProfiles)
#define SyncImageSettings  PrependMagickMethod(SyncImageSettings)
#define SyncImagesSettings  PrependMagickMethod(SyncImagesSettings)
#define SyncNextImageInList  PrependMagickMethod(SyncNextImageInList)
#define TellBlob  PrependMagickMethod(TellBlob)
#define TextureImage  PrependMagickMethod(TextureImage)
#define ThumbnailImage  PrependMagickMethod(ThumbnailImage)
#define TintImage  PrependMagickMethod(TintImage)
#define Tokenizer  PrependMagickMethod(Tokenizer)
#define TransferImageViewIterator  PrependMagickMethod(TransferImageViewIterator)
#define TransformImageColorspace  PrependMagickMethod(TransformImageColorspace)
#define TransformImage  PrependMagickMethod(TransformImage)
#define TransparentPaintImageChroma  PrependMagickMethod(TransparentPaintImageChroma)
#define TransparentPaintImage  PrependMagickMethod(TransparentPaintImage)
#define TransposeImage  PrependMagickMethod(TransposeImage)
#define TransverseImage  PrependMagickMethod(TransverseImage)
#define TrimImage  PrependMagickMethod(TrimImage)
#define TypeComponentGenesis  PrependMagickMethod(TypeComponentGenesis)
#define TypeComponentTerminus  PrependMagickMethod(TypeComponentTerminus)
#define UniqueImageColors  PrependMagickMethod(UniqueImageColors)
#define UnityAddKernelInfo  PrependMagickMethod(UnityAddKernelInfo)
#define UnlockSemaphoreInfo  PrependMagickMethod(UnlockSemaphoreInfo)
#define UnmapBlob  PrependMagickMethod(UnmapBlob)
#define UnregisterAAIImage  PrependMagickMethod(UnregisterAAIImage)
#define UnregisterARTImage  PrependMagickMethod(UnregisterARTImage)
#define UnregisterAVSImage  PrependMagickMethod(UnregisterAVSImage)
#define UnregisterBGRImage  PrependMagickMethod(UnregisterBGRImage)
#define UnregisterBMPImage  PrependMagickMethod(UnregisterBMPImage)
#define UnregisterBRAILLEImage  PrependMagickMethod(UnregisterBRAILLEImage)
#define UnregisterCALSImage  PrependMagickMethod(UnregisterCALSImage)
#define UnregisterCAPTIONImage  PrependMagickMethod(UnregisterCAPTIONImage)
#define UnregisterCINImage  PrependMagickMethod(UnregisterCINImage)
#define UnregisterCIPImage  PrependMagickMethod(UnregisterCIPImage)
#define UnregisterCLIPImage  PrependMagickMethod(UnregisterCLIPImage)
#define UnregisterCMYKImage  PrependMagickMethod(UnregisterCMYKImage)
#define UnregisterCUBEImage  PrependMagickMethod(UnregisterCUBEImage)
#define UnregisterCUTImage  PrependMagickMethod(UnregisterCUTImage)
#define UnregisterDCMImage  PrependMagickMethod(UnregisterDCMImage)
#define UnregisterDDSImage  PrependMagickMethod(UnregisterDDSImage)
#define UnregisterDEBUGImage  PrependMagickMethod(UnregisterDEBUGImage)
#define UnregisterDIBImage  PrependMagickMethod(UnregisterDIBImage)
#define UnregisterDJVUImage  PrependMagickMethod(UnregisterDJVUImage)
#define UnregisterDNGImage  PrependMagickMethod(UnregisterDNGImage)
#define UnregisterDOTImage  PrependMagickMethod(UnregisterDOTImage)
#define UnregisterDPXImage  PrependMagickMethod(UnregisterDPXImage)
#define UnregisterEPTImage  PrependMagickMethod(UnregisterEPTImage)
#define UnregisterEXRImage  PrependMagickMethod(UnregisterEXRImage)
#define UnregisterFAXImage  PrependMagickMethod(UnregisterFAXImage)
#define UnregisterFITSImage  PrependMagickMethod(UnregisterFITSImage)
#define UnregisterGIFImage  PrependMagickMethod(UnregisterGIFImage)
#define UnregisterGRADIENTImage  PrependMagickMethod(UnregisterGRADIENTImage)
#define UnregisterGRAYImage  PrependMagickMethod(UnregisterGRAYImage)
#define UnregisterHALDImage  PrependMagickMethod(UnregisterHALDImage)
#define UnregisterHDRImage  PrependMagickMethod(UnregisterHDRImage)
#define UnregisterHEICImage  PrependMagickMethod(UnregisterHEICImage)
#define UnregisterHISTOGRAMImage  PrependMagickMethod(UnregisterHISTOGRAMImage)
#define UnregisterHRZImage  PrependMagickMethod(UnregisterHRZImage)
#define UnregisterHTMLImage  PrependMagickMethod(UnregisterHTMLImage)
#define UnregisterICONImage  PrependMagickMethod(UnregisterICONImage)
#define UnregisterINFOImage  PrependMagickMethod(UnregisterINFOImage)
#define UnregisterINLINEImage  PrependMagickMethod(UnregisterINLINEImage)
#define UnregisterIPLImage  PrependMagickMethod(UnregisterIPLImage)
#define UnregisterJBIGImage  PrependMagickMethod(UnregisterJBIGImage)
#define UnregisterJNXImage  PrependMagickMethod(UnregisterJNXImage)
#define UnregisterJP2Image  PrependMagickMethod(UnregisterJP2Image)
#define UnregisterJPEGImage  PrependMagickMethod(UnregisterJPEGImage)
#define UnregisterJSONImage  PrependMagickMethod(UnregisterJSONImage)
#define UnregisterLABELImage  PrependMagickMethod(UnregisterLABELImage)
#define UnregisterMACImage  PrependMagickMethod(UnregisterMACImage)
#define UnregisterMAPImage  PrependMagickMethod(UnregisterMAPImage)
#define UnregisterMASKImage  PrependMagickMethod(UnregisterMASKImage)
#define UnregisterMATImage  PrependMagickMethod(UnregisterMATImage)
#define UnregisterMATTEImage  PrependMagickMethod(UnregisterMATTEImage)
#define UnregisterMETAImage  PrependMagickMethod(UnregisterMETAImage)
#define UnregisterMIFFImage  PrependMagickMethod(UnregisterMIFFImage)
#define UnregisterMONOImage  PrependMagickMethod(UnregisterMONOImage)
#define UnregisterMPCImage  PrependMagickMethod(UnregisterMPCImage)
#define UnregisterMPEGImage  PrependMagickMethod(UnregisterMPEGImage)
#define UnregisterMPRImage  PrependMagickMethod(UnregisterMPRImage)
#define UnregisterMSLImage  PrependMagickMethod(UnregisterMSLImage)
#define UnregisterMTVImage  PrependMagickMethod(UnregisterMTVImage)
#define UnregisterMVGImage  PrependMagickMethod(UnregisterMVGImage)
#define UnregisterNULLImage  PrependMagickMethod(UnregisterNULLImage)
#define UnregisterOTBImage  PrependMagickMethod(UnregisterOTBImage)
#define UnregisterPALMImage  PrependMagickMethod(UnregisterPALMImage)
#define UnregisterPANGOImage  PrependMagickMethod(UnregisterPANGOImage)
#define UnregisterPATTERNImage  PrependMagickMethod(UnregisterPATTERNImage)
#define UnregisterPCDImage  PrependMagickMethod(UnregisterPCDImage)
#define UnregisterPCLImage  PrependMagickMethod(UnregisterPCLImage)
#define UnregisterPCXImage  PrependMagickMethod(UnregisterPCXImage)
#define UnregisterPDBImage  PrependMagickMethod(UnregisterPDBImage)
#define UnregisterPDFImage  PrependMagickMethod(UnregisterPDFImage)
#define UnregisterPESImage  PrependMagickMethod(UnregisterPESImage)
#define UnregisterPGXImage  PrependMagickMethod(UnregisterPGXImage)
#define UnregisterPICTImage  PrependMagickMethod(UnregisterPICTImage)
#define UnregisterPIXImage  PrependMagickMethod(UnregisterPIXImage)
#define UnregisterPLASMAImage  PrependMagickMethod(UnregisterPLASMAImage)
#define UnregisterPNGImage  PrependMagickMethod(UnregisterPNGImage)
#define UnregisterPNMImage  PrependMagickMethod(UnregisterPNMImage)
#define UnregisterPS2Image  PrependMagickMethod(UnregisterPS2Image)
#define UnregisterPS3Image  PrependMagickMethod(UnregisterPS3Image)
#define UnregisterPSDImage  PrependMagickMethod(UnregisterPSDImage)
#define UnregisterPSImage  PrependMagickMethod(UnregisterPSImage)
#define UnregisterPWPImage  PrependMagickMethod(UnregisterPWPImage)
#define UnregisterRAWImage  PrependMagickMethod(UnregisterRAWImage)
#define UnregisterRGBImage  PrependMagickMethod(UnregisterRGBImage)
#define UnregisterRGFImage  PrependMagickMethod(UnregisterRGFImage)
#define UnregisterRLAImage  PrependMagickMethod(UnregisterRLAImage)
#define UnregisterRLEImage  PrependMagickMethod(UnregisterRLEImage)
#define UnregisterSCREENSHOTImage  PrependMagickMethod(UnregisterSCREENSHOTImage)
#define UnregisterSCRImage  PrependMagickMethod(UnregisterSCRImage)
#define UnregisterSCTImage  PrependMagickMethod(UnregisterSCTImage)
#define UnregisterSFWImage  PrependMagickMethod(UnregisterSFWImage)
#define UnregisterSGIImage  PrependMagickMethod(UnregisterSGIImage)
#define UnregisterSIXELImage  PrependMagickMethod(UnregisterSIXELImage)
#define UnregisterStaticModule  PrependMagickMethod(UnregisterStaticModule)
#define UnregisterStaticModules  PrependMagickMethod(UnregisterStaticModules)
#define UnregisterSTEGANOImage  PrependMagickMethod(UnregisterSTEGANOImage)
#define UnregisterSUNImage  PrependMagickMethod(UnregisterSUNImage)
#define UnregisterSVGImage  PrependMagickMethod(UnregisterSVGImage)
#define UnregisterTGAImage  PrependMagickMethod(UnregisterTGAImage)
#define UnregisterTHUMBNAILImage  PrependMagickMethod(UnregisterTHUMBNAILImage)
#define UnregisterTIFFImage  PrependMagickMethod(UnregisterTIFFImage)
#define UnregisterTILEImage  PrependMagickMethod(UnregisterTILEImage)
#define UnregisterTIMImage  PrependMagickMethod(UnregisterTIMImage)
#define UnregisterTTFImage  PrependMagickMethod(UnregisterTTFImage)
#define UnregisterTXTImage  PrependMagickMethod(UnregisterTXTImage)
#define UnregisterUILImage  PrependMagickMethod(UnregisterUILImage)
#define UnregisterUndefinedImage  PrependMagickMethod(UnregisterUndefinedImage)
#define UnregisterURLImage  PrependMagickMethod(UnregisterURLImage)
#define UnregisterUYVYImage  PrependMagickMethod(UnregisterUYVYImage)
#define UnregisterVICARImage  PrependMagickMethod(UnregisterVICARImage)
#define UnregisterVIDImage  PrependMagickMethod(UnregisterVIDImage)
#define UnregisterVIFFImage  PrependMagickMethod(UnregisterVIFFImage)
#define UnregisterVIPSImage  PrependMagickMethod(UnregisterVIPSImage)
#define UnregisterWBMPImage  PrependMagickMethod(UnregisterWBMPImage)
#define UnregisterWEBPImage  PrependMagickMethod(UnregisterWEBPImage)
#define UnregisterWMFImage  PrependMagickMethod(UnregisterWMFImage)
#define UnregisterWPGImage  PrependMagickMethod(UnregisterWPGImage)
#define UnregisterXBMImage  PrependMagickMethod(UnregisterXBMImage)
#define UnregisterXCFImage  PrependMagickMethod(UnregisterXCFImage)
#define UnregisterXCImage  PrependMagickMethod(UnregisterXCImage)
#define UnregisterXImage  PrependMagickMethod(UnregisterXImage)
#define UnregisterXPMImage  PrependMagickMethod(UnregisterXPMImage)
#define UnregisterXPSImage  PrependMagickMethod(UnregisterXPSImage)
#define UnregisterXTRNImage  PrependMagickMethod(UnregisterXTRNImage)
#define UnregisterXWDImage  PrependMagickMethod(UnregisterXWDImage)
#define UnregisterYCBCRImage  PrependMagickMethod(UnregisterYCBCRImage)
#define UnregisterYUVImage  PrependMagickMethod(UnregisterYUVImage)
#define UnsharpMaskImage  PrependMagickMethod(UnsharpMaskImage)
#define UpdateImageViewIterator  PrependMagickMethod(UpdateImageViewIterator)
#define UpdateSignature  PrependMagickMethod(UpdateSignature)
#define VignetteImage  PrependMagickMethod(VignetteImage)
#define WaveImage  PrependMagickMethod(WaveImage)
#define WaveletDenoiseImage  PrependMagickMethod(WaveletDenoiseImage)
#define WhiteThresholdImage  PrependMagickMethod(WhiteThresholdImage)
#define WriteBlobByte  PrependMagickMethod(WriteBlobByte)
#define WriteBlobFloat  PrependMagickMethod(WriteBlobFloat)
#define WriteBlobLongLong  PrependMagickMethod(WriteBlobLongLong)
#define WriteBlobLong  PrependMagickMethod(WriteBlobLong)
#define WriteBlobLSBLong  PrependMagickMethod(WriteBlobLSBLong)
#define WriteBlobLSBShort  PrependMagickMethod(WriteBlobLSBShort)
#define WriteBlobLSBSignedLong  PrependMagickMethod(WriteBlobLSBSignedLong)
#define WriteBlobLSBSignedShort  PrependMagickMethod(WriteBlobLSBSignedShort)
#define WriteBlobMSBLong  PrependMagickMethod(WriteBlobMSBLong)
#define WriteBlobMSBShort  PrependMagickMethod(WriteBlobMSBShort)
#define WriteBlobMSBSignedShort  PrependMagickMethod(WriteBlobMSBSignedShort)
#define WriteBlob  PrependMagickMethod(WriteBlob)
#define WriteBlobShort  PrependMagickMethod(WriteBlobShort)
#define WriteBlobSignedLong  PrependMagickMethod(WriteBlobSignedLong)
#define WriteBlobString  PrependMagickMethod(WriteBlobString)
#define WriteDistributePixelCacheMetacontent  PrependMagickMethod(WriteDistributePixelCacheMetacontent)
#define WriteDistributePixelCachePixels  PrependMagickMethod(WriteDistributePixelCachePixels)
#define WriteImage  PrependMagickMethod(WriteImage)
#define WriteImages  PrependMagickMethod(WriteImages)
#define WritePSDLayers  PrependMagickMethod(WritePSDLayers)
#define WriteStream  PrependMagickMethod(WriteStream)
#define XAnimateBackgroundImage  PrependMagickMethod(XAnimateBackgroundImage)
#define XAnimateImages  PrependMagickMethod(XAnimateImages)
#define XAnnotateImage  PrependMagickMethod(XAnnotateImage)
#define XBestFont  PrependMagickMethod(XBestFont)
#define XBestIconSize  PrependMagickMethod(XBestIconSize)
#define XBestPixel  PrependMagickMethod(XBestPixel)
#define XBestVisualInfo  PrependMagickMethod(XBestVisualInfo)
#define XCheckDefineCursor  PrependMagickMethod(XCheckDefineCursor)
#define XCheckRefreshWindows  PrependMagickMethod(XCheckRefreshWindows)
#define XClientMessage  PrependMagickMethod(XClientMessage)
#define XColorBrowserWidget  PrependMagickMethod(XColorBrowserWidget)
#define XCommandWidget  PrependMagickMethod(XCommandWidget)
#define XComponentGenesis  PrependMagickMethod(XComponentGenesis)
#define XComponentTerminus  PrependMagickMethod(XComponentTerminus)
#define XConfigureImageColormap  PrependMagickMethod(XConfigureImageColormap)
#define XConfirmWidget  PrependMagickMethod(XConfirmWidget)
#define XConstrainWindowPosition  PrependMagickMethod(XConstrainWindowPosition)
#define XDelay  PrependMagickMethod(XDelay)
#define XDestroyResourceInfo  PrependMagickMethod(XDestroyResourceInfo)
#define XDestroyWindowColors  PrependMagickMethod(XDestroyWindowColors)
#define XDialogWidget  PrependMagickMethod(XDialogWidget)
#define XDisplayBackgroundImage  PrependMagickMethod(XDisplayBackgroundImage)
#define XDisplayImageInfo  PrependMagickMethod(XDisplayImageInfo)
#define XDisplayImage  PrependMagickMethod(XDisplayImage)
#define XDrawImage  PrependMagickMethod(XDrawImage)
#define XError  PrependMagickMethod(XError)
#define XFileBrowserWidget  PrependMagickMethod(XFileBrowserWidget)
#define XFontBrowserWidget  PrependMagickMethod(XFontBrowserWidget)
#define XFreeResources  PrependMagickMethod(XFreeResources)
#define XFreeStandardColormap  PrependMagickMethod(XFreeStandardColormap)
#define XGetAnnotateInfo  PrependMagickMethod(XGetAnnotateInfo)
#define XGetImportInfo  PrependMagickMethod(XGetImportInfo)
#define XGetMapInfo  PrependMagickMethod(XGetMapInfo)
#define XGetPixelInfo  PrependMagickMethod(XGetPixelInfo)
#define XGetResourceClass  PrependMagickMethod(XGetResourceClass)
#define XGetResourceDatabase  PrependMagickMethod(XGetResourceDatabase)
#define XGetResourceInfo  PrependMagickMethod(XGetResourceInfo)
#define XGetResourceInstance  PrependMagickMethod(XGetResourceInstance)
#define XGetScreenDensity  PrependMagickMethod(XGetScreenDensity)
#define XGetWindowColor  PrependMagickMethod(XGetWindowColor)
#define XGetWindowInfo  PrependMagickMethod(XGetWindowInfo)
#define XHighlightEllipse  PrependMagickMethod(XHighlightEllipse)
#define XHighlightLine  PrependMagickMethod(XHighlightLine)
#define XHighlightRectangle  PrependMagickMethod(XHighlightRectangle)
#define XImportImage  PrependMagickMethod(XImportImage)
#define XInfoWidget  PrependMagickMethod(XInfoWidget)
#define XInitializeWindows  PrependMagickMethod(XInitializeWindows)
#define XListBrowserWidget  PrependMagickMethod(XListBrowserWidget)
#define XMakeCursor  PrependMagickMethod(XMakeCursor)
#define XMakeImage  PrependMagickMethod(XMakeImage)
#define XMakeMagnifyImage  PrependMagickMethod(XMakeMagnifyImage)
#define XMakeStandardColormap  PrependMagickMethod(XMakeStandardColormap)
#define XMakeWindow  PrependMagickMethod(XMakeWindow)
#define XMenuWidget  PrependMagickMethod(XMenuWidget)
#define XMLTreeInfoToXML  PrependMagickMethod(XMLTreeInfoToXML)
#define XNoticeWidget  PrependMagickMethod(XNoticeWidget)
#define XPreferencesWidget  PrependMagickMethod(XPreferencesWidget)
#define XProgressMonitorWidget  PrependMagickMethod(XProgressMonitorWidget)
#define XQueryColorCompliance  PrependMagickMethod(XQueryColorCompliance)
#define XQueryPosition  PrependMagickMethod(XQueryPosition)
#define XRefreshWindow  PrependMagickMethod(XRefreshWindow)
#define XRemoteCommand  PrependMagickMethod(XRemoteCommand)
#define XRenderImage  PrependMagickMethod(XRenderImage)
#define XRetainWindowColors  PrependMagickMethod(XRetainWindowColors)
#define XSetCursorState  PrependMagickMethod(XSetCursorState)
#define XSetWindows  PrependMagickMethod(XSetWindows)
#define XTextViewWidget  PrependMagickMethod(XTextViewWidget)
#define XUserPreferences  PrependMagickMethod(XUserPreferences)
#define XWarning  PrependMagickMethod(XWarning)
#define XWindowByID  PrependMagickMethod(XWindowByID)
#define XWindowByName  PrependMagickMethod(XWindowByName)
#define XWindowByProperty  PrependMagickMethod(XWindowByProperty)
#define ZeroKernelNans  PrependMagickMethod(ZeroKernelNans)
#define ZLIBEncodeImage  PrependMagickMethod(ZLIBEncodeImage)
#endif

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
