/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.LocalException;
import com.zeroc.IceInternal.CancellationHandler;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.OutgoingAsyncBase;
import com.zeroc.IceInternal.ProxyOutgoingAsyncBase;
import com.zeroc.IceInternal.RetryQueue;
import java.util.concurrent.Future;

class RetryTask
implements Runnable,
CancellationHandler {
    private final Instance _instance;
    private final RetryQueue _queue;
    private final ProxyOutgoingAsyncBase _outAsync;
    private Future<?> _future;
    private boolean _cancelled = false;

    RetryTask(Instance instance, RetryQueue queue, ProxyOutgoingAsyncBase outAsync) {
        this._instance = instance;
        this._queue = queue;
        this._outAsync = outAsync;
    }

    @Override
    public void run() {
        if (this.cancel()) {
            this._outAsync.retry();
            this._queue.remove(this);
        }
    }

    @Override
    public void asyncRequestCanceled(OutgoingAsyncBase outAsync, LocalException ex) {
        if (this._queue.remove(this) && this.cancel()) {
            if (this._instance.traceLevels().retry >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("operation retry canceled\n");
                s.append(Ex.toString(ex));
                this._instance.initializationData().logger.trace(this._instance.traceLevels().retryCat, s.toString());
            }
            if (this._outAsync.completed(ex)) {
                this._outAsync.invokeCompletedAsync();
            }
        }
    }

    public boolean destroy() {
        if (this.cancel()) {
            try {
                this._outAsync.abort(new CommunicatorDestroyedException());
            }
            catch (CommunicatorDestroyedException communicatorDestroyedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public synchronized void setFuture(Future<?> future) {
        this._future = future;
        if (this._cancelled) {
            this._future.cancel(false);
        }
    }

    private synchronized boolean cancel() {
        if (this._cancelled) {
            return false;
        }
        if (this._future != null) {
            this._future.cancel(false);
        }
        this._cancelled = true;
        return true;
    }
}

