/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceSSL;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.PluginInitializationException;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.SecurityException;
import com.zeroc.IceInternal.ProtocolPluginFacade;
import com.zeroc.IceInternal.Util;
import com.zeroc.IceSSL.CertificateVerifier;
import com.zeroc.IceSSL.ConnectionInfo;
import com.zeroc.IceSSL.PasswordCallback;
import com.zeroc.IceSSL.TrustManager;
import com.zeroc.IceSSL.X509KeyManagerI;
import com.zeroc.IceSSL.X509TrustManagerI;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

class SSLEngine {
    private Communicator _communicator;
    private Logger _logger;
    private ProtocolPluginFacade _facade;
    private int _securityTraceLevel;
    private String _securityTraceCategory;
    private boolean _initialized;
    private SSLContext _context;
    private String _defaultDir;
    private CipherExpression[] _ciphers;
    private boolean _allCiphers;
    private boolean _noCiphers;
    private String[] _protocols;
    private boolean _checkCertName;
    private boolean _serverNameIndication;
    private int _verifyDepthMax;
    private int _verifyPeer;
    private CertificateVerifier _verifier;
    private PasswordCallback _passwordCallback;
    private TrustManager _trustManager;
    private InputStream _keystoreStream;
    private InputStream _truststoreStream;
    private List<InputStream> _seeds = new ArrayList<InputStream>();
    private CertPathValidator _validator;
    private PKIXParameters _validatorParams;

    SSLEngine(ProtocolPluginFacade facade) {
        this._communicator = facade.getCommunicator();
        this._logger = this._communicator.getLogger();
        this._facade = facade;
        this._securityTraceLevel = this._communicator.getProperties().getPropertyAsIntWithDefault("IceSSL.Trace.Security", 0);
        this._securityTraceCategory = "Security";
        this._trustManager = new TrustManager(this._communicator);
    }

    void initialize() {
        String passwordCallbackClass;
        String[] protocols;
        if (this._initialized) {
            return;
        }
        String prefix = "IceSSL.";
        Properties properties = this.communicator().getProperties();
        String ciphers = properties.getProperty("IceSSL.Ciphers");
        if (ciphers.length() > 0) {
            this.parseCiphers(ciphers);
        }
        if ((protocols = properties.getPropertyAsList("IceSSL.Protocols")).length != 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (String prot : protocols) {
                String[] s = prot.toUpperCase();
                if (s.equals("SSL3") || s.equals("SSLV3")) {
                    l.add("SSLv3");
                    continue;
                }
                if (s.equals("TLS") || s.equals("TLS1") || s.equals("TLSV1") || s.equals("TLS1_0") || s.equals("TLSV1_0")) {
                    l.add("TLSv1");
                    continue;
                }
                if (s.equals("TLS1_1") || s.equals("TLSV1_1")) {
                    l.add("TLSv1.1");
                    continue;
                }
                if (s.equals("TLS1_2") || s.equals("TLSV1_2")) {
                    l.add("TLSv1.2");
                    continue;
                }
                if (s.equals("TLS1_3") || s.equals("TLSV1_3")) {
                    l.add("TLSv1.3");
                    continue;
                }
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: unrecognized protocol `" + prot + "'";
                throw e;
            }
            this._protocols = new String[l.size()];
            l.toArray(this._protocols);
        }
        this._checkCertName = properties.getPropertyAsIntWithDefault("IceSSL.CheckCertName", 0) > 0;
        this._serverNameIndication = properties.getPropertyAsIntWithDefault("IceSSL.CheckCertName", 0) > 1;
        this._verifyDepthMax = properties.getPropertyAsIntWithDefault("IceSSL.VerifyDepthMax", 3);
        this._verifyPeer = properties.getPropertyAsIntWithDefault("IceSSL.VerifyPeer", 2);
        String certVerifierClass = properties.getProperty("IceSSL.CertVerifier");
        if (certVerifierClass.length() > 0) {
            if (this._verifier != null) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: certificate verifier already installed";
                throw e;
            }
            Class<?> cls = null;
            try {
                cls = this._facade.findClass(certVerifierClass);
            }
            catch (Throwable ex) {
                throw new PluginInitializationException("IceSSL: unable to load certificate verifier class " + certVerifierClass, ex);
            }
            try {
                this._verifier = (CertificateVerifier)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new PluginInitializationException("IceSSL: unable to instantiate certificate verifier class " + certVerifierClass, ex);
            }
        }
        if ((passwordCallbackClass = properties.getProperty("IceSSL.PasswordCallback")).length() > 0) {
            if (this._passwordCallback != null) {
                PluginInitializationException e = new PluginInitializationException();
                e.reason = "IceSSL: password callback already installed";
                throw e;
            }
            Class<?> cls = null;
            try {
                cls = this._facade.findClass(passwordCallbackClass);
            }
            catch (Throwable ex) {
                throw new PluginInitializationException("IceSSL: unable to load password callback class " + passwordCallbackClass, ex);
            }
            try {
                this._passwordCallback = (PasswordCallback)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new PluginInitializationException("IceSSL: unable to instantiate password callback class " + passwordCallbackClass, ex);
            }
        }
        if (this._context == null) {
            try {
                this._defaultDir = properties.getProperty("IceSSL.DefaultDir");
                SecureRandom rand = new SecureRandom();
                String seedFiles = properties.getProperty("IceSSL.Random");
                if (seedFiles.length() > 0) {
                    String[] arr;
                    for (String file : arr = seedFiles.split(File.pathSeparator)) {
                        try {
                            InputStream seedStream = this.openResource(file);
                            if (seedStream == null) {
                                PluginInitializationException e = new PluginInitializationException();
                                e.reason = "IceSSL: random seed file not found:\n" + file;
                                throw e;
                            }
                            this._seeds.add(seedStream);
                        }
                        catch (IOException ex) {
                            throw new PluginInitializationException("IceSSL: unable to access random seed file:\n" + file, ex);
                        }
                    }
                }
                if (!this._seeds.isEmpty()) {
                    byte[] seed = null;
                    int start = 0;
                    for (InputStream in : this._seeds) {
                        try {
                            int num = in.available();
                            if (seed == null) {
                                seed = new byte[num];
                            } else {
                                byte[] tmp = new byte[seed.length + num];
                                System.arraycopy(seed, 0, tmp, 0, seed.length);
                                start = seed.length;
                                seed = tmp;
                            }
                            in.read(seed, start, num);
                        }
                        catch (IOException ex) {
                            throw new PluginInitializationException("IceSSL: error while reading random seed", ex);
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    rand.setSeed(seed);
                }
                this._seeds.clear();
                rand.nextInt();
                String keystorePath = properties.getProperty("IceSSL.Keystore");
                String password = properties.getProperty("IceSSL.Password");
                String keystorePassword = properties.getProperty("IceSSL.KeystorePassword");
                String defaultType = KeyStore.getDefaultType();
                String keystoreType = properties.getPropertyWithDefault("IceSSL.KeystoreType", defaultType);
                String alias = properties.getProperty("IceSSL.Alias");
                boolean overrideAlias = !alias.isEmpty();
                String truststorePath = properties.getProperty("IceSSL.Truststore");
                String truststorePassword = properties.getProperty("IceSSL.TruststorePassword");
                String truststoreType = properties.getPropertyWithDefault("IceSSL.TruststoreType", KeyStore.getDefaultType());
                KeyManager[] keyManagers = null;
                KeyStore keys = null;
                if (this._keystoreStream != null || keystorePath.length() > 0) {
                    Object e;
                    InputStream keystoreStream = null;
                    try {
                        if (this._keystoreStream != null) {
                            keystoreStream = this._keystoreStream;
                        } else {
                            keystoreStream = this.openResource(keystorePath);
                            if (keystoreStream == null) {
                                PluginInitializationException e2 = new PluginInitializationException();
                                e2.reason = "IceSSL: keystore not found:\n" + keystorePath;
                                throw e2;
                            }
                        }
                        keys = KeyStore.getInstance(keystoreType);
                        char[] passwordChars = null;
                        if (keystorePassword.length() > 0) {
                            passwordChars = keystorePassword.toCharArray();
                        } else if (this._passwordCallback != null) {
                            passwordChars = this._passwordCallback.getKeystorePassword();
                        } else if (keystoreType.equals("BKS") || keystoreType.equals("PKCS12")) {
                            passwordChars = new char[]{};
                        }
                        keys.load(keystoreStream, passwordChars);
                        if (passwordChars != null) {
                            Arrays.fill(passwordChars, '\u0000');
                        }
                        keystorePassword = null;
                    }
                    catch (IOException ex) {
                        throw new PluginInitializationException("IceSSL: unable to load keystore:\n" + keystorePath, ex);
                    }
                    finally {
                        if (keystoreStream != null) {
                            try {
                                keystoreStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                    char[] passwordChars = new char[]{};
                    if (password.length() > 0) {
                        passwordChars = password.toCharArray();
                    } else if (this._passwordCallback != null) {
                        passwordChars = this._passwordCallback.getPassword(alias);
                    }
                    kmf.init(keys, passwordChars);
                    if (passwordChars.length > 0) {
                        Arrays.fill(passwordChars, '\u0000');
                    }
                    password = null;
                    keyManagers = kmf.getKeyManagers();
                    if (alias.isEmpty()) {
                        e = keys.aliases();
                        while (e.hasMoreElements()) {
                            String a = e.nextElement();
                            if (!keys.isKeyEntry(a)) continue;
                            alias = a;
                            break;
                        }
                    }
                    if (!alias.isEmpty()) {
                        if (!keys.isKeyEntry(alias)) {
                            e = new PluginInitializationException();
                            ((PluginInitializationException)e).reason = "IceSSL: keystore does not contain an entry with alias `" + alias + "'";
                            throw e;
                        }
                        for (int i = 0; i < keyManagers.length; ++i) {
                            keyManagers[i] = new X509KeyManagerI((X509ExtendedKeyManager)keyManagers[i], alias, overrideAlias);
                        }
                    }
                }
                KeyStore ts = null;
                if (this._truststoreStream != null || truststorePath.length() > 0) {
                    if (this._truststoreStream != null && this._truststoreStream == this._keystoreStream || truststorePath.length() > 0 && truststorePath.equals(keystorePath)) {
                        assert (keys != null);
                        ts = keys;
                    } else {
                        InputStream truststoreStream = null;
                        try {
                            if (this._truststoreStream != null) {
                                truststoreStream = this._truststoreStream;
                            } else {
                                truststoreStream = this.openResource(truststorePath);
                                if (truststoreStream == null) {
                                    PluginInitializationException e = new PluginInitializationException();
                                    e.reason = "IceSSL: truststore not found:\n" + truststorePath;
                                    throw e;
                                }
                            }
                            ts = KeyStore.getInstance(truststoreType);
                            char[] passwordChars = null;
                            if (truststorePassword.length() > 0) {
                                passwordChars = truststorePassword.toCharArray();
                            } else if (this._passwordCallback != null) {
                                passwordChars = this._passwordCallback.getTruststorePassword();
                            } else if (truststoreType.equals("BKS") || truststoreType.equals("PKCS12")) {
                                passwordChars = new char[]{};
                            }
                            ts.load(truststoreStream, passwordChars);
                            if (passwordChars != null) {
                                Arrays.fill(passwordChars, '\u0000');
                            }
                            truststorePassword = null;
                        }
                        catch (IOException ex) {
                            throw new PluginInitializationException("IceSSL: unable to load truststore:\n" + truststorePath, ex);
                        }
                        finally {
                            if (truststoreStream != null) {
                                try {
                                    truststoreStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
                javax.net.ssl.TrustManager[] trustManagers = null;
                String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                javax.net.ssl.TrustManager[] tmf = TrustManagerFactory.getInstance(algorithm);
                KeyStore trustStore = null;
                if (ts != null) {
                    trustStore = ts;
                } else if (properties.getPropertyAsInt("IceSSL.UsePlatformCAs") <= 0) {
                    if (keys != null) {
                        trustStore = keys;
                    } else {
                        trustManagers = new javax.net.ssl.TrustManager[]{new X509TrustManager(){

                            @Override
                            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                throw new CertificateException("no trust anchors");
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                throw new CertificateException("no trust anchors");
                            }

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return new X509Certificate[0];
                            }
                        }};
                    }
                } else {
                    trustStore = null;
                }
                if (trustStore != null && trustStore.size() == 0) {
                    throw new PluginInitializationException("IceSSL: truststore is empty");
                }
                if (trustManagers == null) {
                    tmf.init(trustStore);
                    trustManagers = tmf.getTrustManagers();
                }
                assert (trustManagers != null);
                this._validator = CertPathValidator.getInstance("PKIX");
                HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
                for (javax.net.ssl.TrustManager tm : trustManagers) {
                    X509Certificate[] certs;
                    for (X509Certificate cert : certs = ((X509TrustManager)tm).getAcceptedIssuers()) {
                        if (cert.getBasicConstraints() < 0) continue;
                        anchors.add(new TrustAnchor(cert, null));
                    }
                }
                if (!anchors.isEmpty()) {
                    this._validatorParams = new PKIXParameters(anchors);
                    this._validatorParams.setRevocationEnabled(false);
                }
                for (int i = 0; i < trustManagers.length; ++i) {
                    trustManagers[i] = new X509TrustManagerI(this, (X509TrustManager)trustManagers[i]);
                }
                this._context = SSLContext.getInstance("TLS");
                this._context.init(keyManagers, trustManagers, rand);
            }
            catch (GeneralSecurityException ex) {
                throw new PluginInitializationException("IceSSL: unable to initialize context", ex);
            }
        }
        this._seeds.clear();
        this._keystoreStream = null;
        this._truststoreStream = null;
        this._initialized = true;
    }

    Certificate[] getVerifiedCertificateChain(Certificate[] chain) {
        if (this._validator == null) {
            return chain;
        }
        if (this._validatorParams == null) {
            return null;
        }
        ArrayList<Certificate> certs = new ArrayList<Certificate>(Arrays.asList(chain));
        try {
            CertPath path = CertificateFactory.getInstance("X.509").generateCertPath(certs);
            CertPathValidatorResult result = this._validator.validate(path, this._validatorParams);
            X509Certificate root = ((PKIXCertPathValidatorResult)result).getTrustAnchor().getTrustedCert();
            if (!root.equals(chain[chain.length - 1])) {
                certs.add(root);
            }
            return certs.toArray(new Certificate[certs.size()]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    void context(SSLContext context) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plug-in is already initialized";
            throw ex;
        }
        assert (this._context == null);
        this._context = context;
    }

    SSLContext context() {
        return this._context;
    }

    void setCertificateVerifier(CertificateVerifier verifier) {
        this._verifier = verifier;
    }

    CertificateVerifier getCertificateVerifier() {
        return this._verifier;
    }

    void setPasswordCallback(PasswordCallback callback) {
        this._passwordCallback = callback;
    }

    PasswordCallback getPasswordCallback() {
        return this._passwordCallback;
    }

    void setKeystoreStream(InputStream stream) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is already initialized";
            throw ex;
        }
        this._keystoreStream = stream;
    }

    void setTruststoreStream(InputStream stream) {
        if (this._initialized) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plugin is already initialized";
            throw ex;
        }
        this._truststoreStream = stream;
    }

    void addSeedStream(InputStream stream) {
        this._seeds.add(stream);
    }

    int securityTraceLevel() {
        return this._securityTraceLevel;
    }

    boolean initialized() {
        return this._initialized;
    }

    javax.net.ssl.SSLEngine createSSLEngine(boolean incoming, String host, int port) {
        javax.net.ssl.SSLEngine engine;
        try {
            engine = host != null ? this._context.createSSLEngine(host, port) : this._context.createSSLEngine();
            engine.setUseClientMode(!incoming);
        }
        catch (Exception ex) {
            throw new SecurityException("IceSSL: couldn't create SSL engine", ex);
        }
        String[] cipherSuites = this.filterCiphers(engine.getSupportedCipherSuites(), engine.getEnabledCipherSuites());
        try {
            engine.setEnabledCipherSuites(cipherSuites);
        }
        catch (IllegalArgumentException ex) {
            throw new SecurityException("IceSSL: invalid ciphersuite", ex);
        }
        if (this._securityTraceLevel >= 1) {
            StringBuilder s = new StringBuilder(128);
            s.append("enabling SSL ciphersuites:");
            for (String suite : cipherSuites) {
                s.append("\n  ");
                s.append(suite);
            }
            this._logger.trace(this._securityTraceCategory, s.toString());
        }
        if (this._protocols != null) {
            try {
                engine.setEnabledProtocols(this._protocols);
            }
            catch (IllegalArgumentException ex) {
                throw new SecurityException("IceSSL: invalid protocol", ex);
            }
        } else {
            ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(engine.getEnabledProtocols()));
            if (protocols.remove("SSLv3")) {
                engine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            }
        }
        if (incoming) {
            if (this._verifyPeer == 0) {
                engine.setWantClientAuth(false);
                engine.setNeedClientAuth(false);
            } else if (this._verifyPeer == 1) {
                engine.setWantClientAuth(true);
            } else {
                engine.setNeedClientAuth(true);
            }
        } else if (this._checkCertName && this._verifyPeer > 0 && host != null) {
            SSLParameters params = new SSLParameters();
            params.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(params);
        }
        if (!incoming && this._serverNameIndication) {
            SNIHostName serverName = null;
            try {
                serverName = new SNIHostName(host);
                SSLParameters sslParams = engine.getSSLParameters();
                ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
                serverNames.add(serverName);
                sslParams.setServerNames(serverNames);
                engine.setSSLParameters(sslParams);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            engine.beginHandshake();
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: handshake error", ex);
        }
        return engine;
    }

    String[] filterCiphers(String[] supportedCiphers, String[] defaultCiphers) {
        LinkedList<Object> result = new LinkedList<Object>();
        if (this._allCiphers) {
            for (String string : supportedCiphers) {
                result.add(string);
            }
        } else if (!this._noCiphers) {
            for (String string : defaultCiphers) {
                result.add(string);
            }
        }
        if (this._ciphers != null) {
            for (CipherExpression cipherExpression : this._ciphers) {
                if (cipherExpression.not) {
                    Iterator e = result.iterator();
                    while (e.hasNext()) {
                        String cipher = (String)e.next();
                        if (cipherExpression.cipher != null) {
                            if (!cipherExpression.cipher.equals(cipher)) continue;
                            e.remove();
                            continue;
                        }
                        assert (cipherExpression.re != null);
                        Matcher m = cipherExpression.re.matcher(cipher);
                        if (!m.find()) continue;
                        e.remove();
                    }
                    continue;
                }
                if (cipherExpression.cipher != null) {
                    result.add(0, cipherExpression.cipher);
                    continue;
                }
                assert (cipherExpression.re != null);
                for (String cipher : supportedCiphers) {
                    Matcher m = cipherExpression.re.matcher(cipher);
                    if (!m.find()) continue;
                    result.add(0, cipher);
                }
            }
        }
        String[] arr = new String[result.size()];
        result.toArray(arr);
        return arr;
    }

    void traceConnection(String desc, javax.net.ssl.SSLEngine engine, boolean incoming) {
        SSLSession session = engine.getSession();
        String msg = "SSL summary for " + (incoming ? "incoming" : "outgoing") + " connection\ncipher = " + session.getCipherSuite() + "\nprotocol = " + session.getProtocol() + "\n" + desc;
        this._logger.trace(this._securityTraceCategory, msg);
    }

    Communicator communicator() {
        return this._communicator;
    }

    void verifyPeer(String address, ConnectionInfo info, String desc) {
        if (!info.incoming && this._verifyPeer > 0 && !info.verified) {
            throw new SecurityException("IceSSL: server did not supply a certificate");
        }
        if (this._verifyDepthMax > 0 && info.certs != null && info.certs.length > this._verifyDepthMax) {
            String msg = (info.incoming ? "incoming" : "outgoing") + " connection rejected:\nlength of peer's certificate chain (" + info.certs.length + ") exceeds maximum of " + this._verifyDepthMax + "\n" + desc;
            if (this._securityTraceLevel >= 1) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            SecurityException ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
        if (!this._trustManager.verify(info, desc)) {
            String msg = (info.incoming ? "incoming" : "outgoing") + " connection rejected by trust manager\n" + desc;
            if (this._securityTraceLevel >= 1) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            SecurityException ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
        if (this._verifier != null && !this._verifier.verify(info)) {
            String msg = (info.incoming ? "incoming" : "outgoing") + " connection rejected by certificate verifier\n" + desc;
            if (this._securityTraceLevel >= 1) {
                this._logger.trace(this._securityTraceCategory, msg);
            }
            SecurityException ex = new SecurityException();
            ex.reason = msg;
            throw ex;
        }
    }

    void trustManagerFailure(boolean incoming, CertificateException ex) throws CertificateException {
        if (this._verifyPeer == 0) {
            if (this._securityTraceLevel >= 1) {
                String msg = "ignoring peer verification failure";
                if (this._securityTraceLevel > 1) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    msg = msg + ":\n" + sw.toString();
                }
                this._logger.trace(this._securityTraceCategory, msg);
            }
        } else {
            throw ex;
        }
    }

    private void parseCiphers(String ciphers) {
        ArrayList<CipherExpression> cipherList = new ArrayList<CipherExpression>();
        String[] expr = ciphers.split("[ \t]+");
        for (int i = 0; i < expr.length; ++i) {
            PluginInitializationException ex;
            if (expr[i].equals("ALL")) {
                if (i != 0) {
                    ex = new PluginInitializationException();
                    ex.reason = "IceSSL: `ALL' must be first in cipher list `" + ciphers + "'";
                    throw ex;
                }
                this._allCiphers = true;
                continue;
            }
            if (expr[i].equals("NONE")) {
                if (i != 0) {
                    ex = new PluginInitializationException();
                    ex.reason = "IceSSL: `NONE' must be first in cipher list `" + ciphers + "'";
                    throw ex;
                }
                this._noCiphers = true;
                continue;
            }
            CipherExpression ce = new CipherExpression();
            String exp = expr[i];
            if (exp.charAt(0) == '!') {
                ce.not = true;
                if (exp.length() > 1) {
                    exp = exp.substring(1);
                } else {
                    PluginInitializationException ex2 = new PluginInitializationException();
                    ex2.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    throw ex2;
                }
            }
            if (exp.charAt(0) == '(') {
                if (!exp.endsWith(")")) {
                    PluginInitializationException ex3 = new PluginInitializationException();
                    ex3.reason = "IceSSL: invalid cipher expression `" + exp + "'";
                    throw ex3;
                }
                try {
                    ce.re = Pattern.compile(exp.substring(1, exp.length() - 2));
                }
                catch (PatternSyntaxException ex4) {
                    throw new PluginInitializationException("IceSSL: invalid cipher expression `" + exp + "'", ex4);
                }
            } else {
                ce.cipher = exp;
            }
            cipherList.add(ce);
        }
        this._ciphers = new CipherExpression[cipherList.size()];
        cipherList.toArray(this._ciphers);
    }

    private InputStream openResource(String path) throws IOException {
        boolean isAbsolute = false;
        try {
            new URL(path);
            isAbsolute = true;
        }
        catch (MalformedURLException ex) {
            File f = new File(path);
            isAbsolute = f.isAbsolute();
        }
        InputStream stream = Util.openResource(this.getClass().getClassLoader(), path);
        if (stream == null && this._defaultDir.length() > 0 && !isAbsolute) {
            stream = Util.openResource(this.getClass().getClassLoader(), this._defaultDir + File.separator + path);
        }
        if (stream != null) {
            stream = new BufferedInputStream(stream);
        }
        return stream;
    }

    private static class CipherExpression {
        boolean not;
        String cipher;
        Pattern re;

        private CipherExpression() {
        }
    }
}

