/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceBox;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import com.zeroc.IceBox.AlreadyStartedException;
import com.zeroc.IceBox.AlreadyStoppedException;
import com.zeroc.IceBox.NoSuchServiceException;
import com.zeroc.IceBox.ServiceManagerPrx;
import java.util.ArrayList;
import java.util.List;

public final class Admin {
    private static void usage() {
        System.err.println("Usage: com.zeroc.IceBox.Admin [options] [command...]\nOptions:\n-h, --help          Show this message.\n-v, --version       Display the Ice version.\n\nCommands:\nstart SERVICE       Start a service.\nstop SERVICE        Stop a service.\nshutdown            Shutdown the server.");
    }

    public static void main(String[] args) {
        int status = 0;
        ArrayList<String> commands = new ArrayList<String>();
        try (Communicator communicator = Util.initialize(args, commands);){
            Runtime.getRuntime().addShutdownHook(new Thread(() -> communicator.destroy()));
            status = Admin.run(communicator, commands);
        }
        System.exit(status);
    }

    public static int run(Communicator communicator, List<String> commands) {
        ServiceManagerPrx manager;
        if (commands.isEmpty()) {
            Admin.usage();
            return 0;
        }
        for (String command : commands) {
            if (command.equals("-h") || command.equals("--help")) {
                Admin.usage();
                return 0;
            }
            if (command.equals("-v") || command.equals("--version")) {
                System.out.println(Util.stringVersion());
                return 0;
            }
            if (!command.startsWith("-")) continue;
            System.err.println("IceBox.Admin: unknown option `" + command + "'");
            Admin.usage();
            return 1;
        }
        ObjectPrx base = communicator.propertyToProxy("IceBoxAdmin.ServiceManager.Proxy");
        if (base == null) {
            String managerProxy;
            Properties properties = communicator.getProperties();
            Identity managerIdentity = new Identity();
            managerIdentity.category = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox");
            managerIdentity.name = "ServiceManager";
            if (properties.getProperty("Ice.Default.Locator").length() == 0) {
                String managerEndpoints = properties.getProperty("IceBox.ServiceManager.Endpoints");
                if (managerEndpoints.length() == 0) {
                    System.err.println("IceBox.Admin: property `IceBoxAdmin.ServiceManager.Proxy' is not set");
                    return 1;
                }
                managerProxy = "\"" + communicator.identityToString(managerIdentity) + "\" :" + managerEndpoints;
            } else {
                String managerAdapterId = properties.getProperty("IceBox.ServiceManager.AdapterId");
                if (managerAdapterId.length() == 0) {
                    System.err.println("IceBox.Admin: property `IceBoxAdmin.ServiceManager.Proxy' is not set");
                    return 1;
                }
                managerProxy = "\"" + communicator.identityToString(managerIdentity) + "\" @" + managerAdapterId;
            }
            base = communicator.stringToProxy(managerProxy);
        }
        if ((manager = ServiceManagerPrx.checkedCast(base)) == null) {
            System.err.println("IceBox.Admin: `" + base.toString() + "' is not an IceBox::ServiceManager");
            return 1;
        }
        for (int i = 0; i < commands.size(); ++i) {
            String service;
            String command = commands.get(i);
            if (command.equals("shutdown")) {
                manager.shutdown();
                continue;
            }
            if (command.equals("start")) {
                if (++i >= commands.size()) {
                    System.err.println("IceBox.Admin: no service name specified.");
                    return 1;
                }
                service = commands.get(i);
                try {
                    manager.startService(service);
                    continue;
                }
                catch (NoSuchServiceException ex) {
                    System.err.println("IceBox.Admin: unknown service `" + service + "'");
                    return 1;
                }
                catch (AlreadyStartedException ex) {
                    System.err.println("IceBox.Admin: service already started.");
                    continue;
                }
            }
            if (command.equals("stop")) {
                if (++i >= commands.size()) {
                    System.err.println("IceBox.Admin: no service name specified.");
                    return 1;
                }
                service = commands.get(i);
                try {
                    manager.stopService(service);
                    continue;
                }
                catch (NoSuchServiceException ex) {
                    System.err.println("IceBox.Admin: unknown service `" + service + "'");
                    return 1;
                }
                catch (AlreadyStoppedException ex) {
                    System.err.println("IceBox.Admin: service already stopped.");
                    continue;
                }
            }
            System.err.println("IceBox.Admin: unknown command `" + command + "'");
            Admin.usage();
            return 1;
        }
        return 0;
    }
}

