/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.klimt.font.UFont;

public class UnusedSpace {
    private static final int HALF_SIZE = 20;
    private double meanX2;
    private double meanY2;
    private final List<Point> points = new ArrayList<Point>();
    private static final Map<Object, UnusedSpace> cache = new HashMap<Object, UnusedSpace>();

    public static UnusedSpace getUnusedSpace(UFont font, char c) {
        List<Object> key = Arrays.asList(font, Character.valueOf(c));
        UnusedSpace result = cache.get(key);
        if (result == null) {
            result = new UnusedSpace(font, c);
            cache.put(key, result);
        }
        return result;
    }

    private UnusedSpace(UFont font, char c) {
        BufferedImage im = new BufferedImage(40, 40, 1);
        Graphics2D g2d = im.createGraphics();
        String text = "" + c;
        g2d.setFont(font.getUnderlayingFont(text));
        g2d.drawString(text, 20, 20);
        int minI = Integer.MAX_VALUE;
        int minJ = Integer.MAX_VALUE;
        int maxI = Integer.MIN_VALUE;
        int maxJ = Integer.MIN_VALUE;
        for (int i = 0; i < im.getWidth(); ++i) {
            for (int j = 0; j < im.getHeight(); ++j) {
                if (!UnusedSpace.isPoint(im, i, j)) continue;
                if (i < minI) {
                    minI = i;
                }
                if (j < minJ) {
                    minJ = j;
                }
                if (i > maxI) {
                    maxI = i;
                }
                if (j > maxJ) {
                    maxJ = j;
                }
                this.points.add(new Point(i, j));
            }
        }
        double min = Double.MAX_VALUE;
        for (int i = minI * 4; i <= maxI * 4; ++i) {
            for (int j = minJ * 4; j < maxJ * 4; ++j) {
                Point p = new Point((double)i / 4.0, (double)j / 4.0);
                double d = this.biggestDistSqFromPoint(p);
                if (!(d < min)) continue;
                min = d;
                this.meanX2 = (double)i / 4.0 - 20.0;
                this.meanY2 = (double)j / 4.0 - 20.0;
            }
        }
    }

    private double biggestDistSqFromPoint(Point p) {
        double result = 0.0;
        for (Point other : this.points) {
            double d = p.getDistSq(other);
            if (!(d > result)) continue;
            result = d;
        }
        return result;
    }

    private static boolean isPoint(BufferedImage im, int x, int y) {
        int color = im.getRGB(x, y) & 0xFFFFFF;
        return color != 0;
    }

    public double getCenterX() {
        return this.meanX2;
    }

    public double getCenterY() {
        return this.meanY2;
    }

    static class Point {
        private final double x;
        private final double y;

        Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getDistSq(Point other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            return dx * dx + dy * dy;
        }
    }
}

