/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.Condition;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleRow;
import oracle.jdbc.driver.ClosedConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedScrollableResultSet;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

class InsensitiveScrollableResultSet
extends GeneratedScrollableResultSet {
    protected boolean isAllFetched;
    protected boolean isDoneFetchingRows = false;
    protected final long maxRows;
    final boolean resultFromCache;
    private Condition publishingCondition;
    private volatile MovementState movementState = MovementState.INITIAL;
    private final ErrorSet continueOnErrorSet;

    InsensitiveScrollableResultSet(PhysicalConnection c, OracleStatement s) throws SQLException {
        super(c, s);
        this.fetchedRowCount = s.validRows;
        this.resultFromCache = s.resultFromCache;
        s.resultFromCache = false;
        this.isAllFetched = s.isAllFetched;
        this.maxRows = s.getMaxRows();
        if (this.maxRows > 0L && this.maxRows <= this.fetchedRowCount) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
        }
        this.continueOnErrorSet = s.getContinueOnErrorSet();
    }

    void ensureOpen() throws SQLException {
        this.ensureOpen(null);
    }

    void ensureOpen(String where) throws SQLException {
        if (this.closed) {
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, where).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, where).fillInStackTrace();
        }
        this.ensureOpenStatement(where);
    }

    void ensureOpenPlus(String where) throws SQLException {
        this.ensureOpen(where);
        if (this.isForwardOnly()) {
            throw (SQLException)DatabaseError.createSqlException(75, where).fillInStackTrace();
        }
    }

    private final void ensureOpenStatement(String where) throws SQLException {
        if (this.statement.closed) {
            throw (SQLException)DatabaseError.createSqlException(9, where).fillInStackTrace();
        }
    }

    protected boolean isForwardOnly() {
        return false;
    }

    @Override
    public int getType() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getType");
            int n = this.doGetType();
            return n;
        }
    }

    @Override
    protected int doGetType() {
        return 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getConcurrency");
            int n = 1007;
            return n;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen("getCursorName");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        if (this.closed) {
            return;
        }
        super.doClose();
        if (this.statement.numReturnParams <= 0) {
            this.doneFetchingRows(false);
            this.statement.endOfResultSet();
            this.statement.closeCursorOnPlainStatement();
        }
        this.statement.closeByDependent();
        if (this.statement.isClosed() && this.statement.wrapper != null) {
            this.statement.wrapper.beClosed(this.connection.isClosedInternal());
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("wasNull");
            boolean bl = this.statement.wasNullValue(this.currentRow);
            return bl;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("rowDeleted");
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getMetaData");
            if (!this.statement.isOpen) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData").fillInStackTrace();
            }
            ResultSetMetaData resultSetMetaData = this.statement.getResultSetMetaData();
            return resultSetMetaData;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getStatement");
            oracle.jdbc.internal.OracleStatement oracleStatement = this.statement.wrapper == null ? this.statement : this.statement.wrapper;
            return oracleStatement;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("findColumn");
            int n = this.statement.getColumnIndex(columnName);
            return n;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("setFetchSize");
            this.statement.setPrefetchInternal(rows, false, false);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getFetchSize");
            int n = this.statement.getPrefetchInternal(false);
            return n;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isBeforeFirst");
            boolean bl = !this.isEmptyResultSet() && this.currentRow == -1L;
            return bl;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isAfterLast");
            boolean bl = !this.isEmptyResultSet() && this.currentRow == this.fetchedRowCount;
            return bl;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isFirst");
            boolean bl = !this.isEmptyResultSet() && this.currentRow == 0L;
            return bl;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("isLast");
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast").fillInStackTrace();
            }
            if (!this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount) {
                this.fetchMoreRows();
            }
            assert (this.isAllFetched || this.fetchedRowCount > this.currentRow + 1L) : "isAllFetched: " + this.isAllFetched + ", fetchedRowCount: " + this.fetchedRowCount + ", currentRow: " + this.currentRow;
            if (this.fetchedRowCount == 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount;
            return bl;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getRow");
            if (this.isEmptyResultSet()) {
                int n = 0;
                return n;
            }
            if (this.currentRow == this.fetchedRowCount) {
                int n = 0;
                return n;
            }
            int n = (int)this.currentRow + 1;
            return n;
        }
    }

    @Override
    public boolean absolute(int rowIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("absolute");
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "absolute").fillInStackTrace();
            }
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute").fillInStackTrace();
            }
            boolean bl = this.absoluteInternal(rowIndex);
            return bl;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("first");
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "first").fillInStackTrace();
            }
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first").fillInStackTrace();
            }
            boolean bl = this.absoluteInternal(1L);
            return bl;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("next");
            if (this.statement.sqlKind.isPlsqlOrCall()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next").fillInStackTrace();
            }
            boolean bl = this.absoluteInternal(this.currentRow + 2L);
            return bl;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("previous");
            if (this.currentRow > -1L) {
                boolean bl = this.absoluteInternal(this.currentRow);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("last");
            if (this.isEmptyResultSet()) {
                boolean bl = false;
                return bl;
            }
            while (!this.isAllFetched) {
                this.fetchMoreRows();
            }
            this.currentRow = this.fetchedRowCount - 1L;
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("beforeFirst");
            if (this.isForwardOnly()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
            }
            this.absolute(0);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("afterLast");
            if (!this.isEmptyResultSet()) {
                while (!this.isAllFetched) {
                    this.fetchMoreRows();
                }
                this.currentRow = this.fetchedRowCount;
            }
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpenPlus("relative");
            if (rows == 0) {
                boolean bl = this.isValidRow();
                return bl;
            }
            if (rows == 1) {
                boolean bl = this.next();
                return bl;
            }
            if (rows == -1) {
                boolean bl = this.previous();
                return bl;
            }
            if (this.currentRow + (long)rows < 0L) {
                boolean bl = this.absoluteInternal(0L);
                return bl;
            }
            boolean bl = this.absoluteInternal(this.currentRow + (long)rows + 1L);
            return bl;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("refreshRow");
            if (!this.statement.isRowidPrepended) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow").fillInStackTrace();
            }
            if (this.currentRow < 0L || this.currentRow >= this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11, "refreshRow").fillInStackTrace();
            }
            try {
                long start = this.currentRow;
                if (this.getFetchDirection() == 1001) {
                    start = Math.max(0L, this.currentRow - (long)this.getFetchSize());
                }
                this.refreshRows(start, this.getFetchSize());
            }
            catch (SQLRecoverableException sqlre) {
                throw sqlre;
            }
            catch (SQLException e) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Unsupported syntax for refreshRow()", (Throwable)e).fillInStackTrace();
            }
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            assert (type != null) : "type: null";
            this.ensureOpen("getObject");
            this.ensureValidColumnIndex(columnIndex);
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, "getObject").fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, "getObject").fillInStackTrace();
            }
            T t = this.statement.getObject(this.currentRow, columnIndex, type);
            return t;
        }
    }

    private final void ensureValidColumnIndex(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (columnIndex < 1 || columnIndex > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
            }
        }
    }

    @Override
    public int getBytes(int columnIndex, byte[] buffer, int offset) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBytes").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBytes").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            int n = this.statement.getBytes(this.currentRow, columnIndex, buffer, offset);
            return n;
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getAuthorizationIndicator");
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, "getAuthorizationIndicator").fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, "getAuthorizationIndicator").fillInStackTrace();
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.statement.getAuthorizationIndicator(this.currentRow, columnIndex);
            return authorizationIndicator;
        }
    }

    void hackLast() throws SQLException {
        assert (this.isAfterLast()) : "not after last";
        this.currentRow = this.fetchedRowCount - 1L;
    }

    protected boolean absoluteInternal(long rowIndex) throws SQLException {
        this.movementState = MovementState.MOVED_SYNCHRONOUSLY;
        long row = rowIndex - 1L;
        if (rowIndex == 0L) {
            this.currentRow = row;
        } else if (row >= 0L && row < this.fetchedRowCount) {
            this.currentRow = row;
        } else if (row >= 0L) {
            this.fetchNextRows(row);
        } else {
            this.fetchLastRows(-rowIndex);
        }
        assert (this.currentRow < this.fetchedRowCount || this.isAllFetched) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount + ", isAllFetched: " + this.isAllFetched;
        assert (-1L <= this.currentRow && this.currentRow <= this.fetchedRowCount) : "currentRow: " + this.currentRow + ", fetchedRowCount: " + this.fetchedRowCount;
        return this.isCurrentRowValid();
    }

    private final void fetchNextRows(long targetRow) throws SQLException {
        while (!this.isAllFetched && this.fetchedRowCount <= targetRow) {
            this.fetchMoreRows();
        }
        this.handleFetchNextRowsCompletion(targetRow);
    }

    private final void handleFetchNextRowsCompletion(long targetRow) throws SQLException {
        if (targetRow < this.fetchedRowCount) {
            this.currentRow = targetRow;
        } else {
            assert (this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
            this.currentRow = this.fetchedRowCount;
            if (this.isForwardOnly()) {
                this.doneFetchingRows(false);
            }
        }
    }

    private final void fetchNextRowsAsync(long targetRow, Consumer<Throwable> callback) {
        if (this.isAllFetched || targetRow < this.fetchedRowCount) {
            callback.accept(null);
        } else {
            this.fetchMoreRowsAsync(error -> {
                if (error == null) {
                    this.fetchNextRowsAsync(targetRow, callback);
                } else {
                    callback.accept((Throwable)error);
                }
            });
        }
    }

    private final void fetchLastRows(long offsetFromLast) throws SQLException {
        while (!this.isAllFetched) {
            this.fetchMoreRows();
        }
        long row = this.fetchedRowCount - offsetFromLast;
        this.currentRow = row >= 0L && row < this.fetchedRowCount ? row : -1L;
    }

    protected void fetchMoreRows() throws SQLException {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        this.clearWarnings();
        this.fetchedRowCount += this.statement.fetchMoreRows(this.fetchedRowCount);
        this.handleFetchMoreRowsCompletion();
    }

    private final void fetchMoreRowsAsync(Consumer<Throwable> callback) {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        try {
            this.clearWarnings();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        ErrorSet statementErrorSet = this.statement.getContinueOnErrorSet();
        this.statement.setContinueOnErrorSet(this.continueOnErrorSet);
        try {
            this.statement.fetchMoreRowsAsync(this.fetchedRowCount, (numberOfRowsFetched, error) -> {
                try {
                    if (error == null) {
                        this.fetchedRowCount += numberOfRowsFetched.longValue();
                        this.handleFetchMoreRowsCompletion();
                    }
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                callback.accept((Throwable)error);
            });
        }
        finally {
            this.statement.setContinueOnErrorSet(statementErrorSet);
        }
    }

    private final void handleFetchMoreRowsCompletion() throws SQLException {
        this.isAllFetched = this.statement.isAllFetched;
        if (this.currentRow == this.fetchedRowCount && this.isForwardOnly()) {
            this.doneFetchingRows(false);
        }
        if (this.maxRows > 0L && this.fetchedRowCount > this.maxRows) {
            this.fetchedRowCount = this.maxRows;
            this.doneFetchingRows(false);
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 275);
        }
    }

    @Override
    protected void doneFetchingRows(boolean fromPrepareForNewResult) throws SQLException {
        if (this.isDoneFetchingRows) {
            return;
        }
        this.isDoneFetchingRows = true;
        this.isAllFetched = true;
        try {
            this.statement.closeQuery();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isEmptyResultSet() throws SQLException {
        if (this.fetchedRowCount > 0L) {
            return false;
        }
        if (this.isAllFetched) {
            return true;
        }
        this.fetchMoreRows();
        assert (this.fetchedRowCount >= 0L) : "fetchedRowCount: " + this.fetchedRowCount;
        return this.fetchedRowCount == 0L;
    }

    @Override
    boolean isValidRow() throws SQLException {
        return this.isCurrentRowValid();
    }

    private final boolean isCurrentRowValid() {
        return this.currentRow > -1L && this.currentRow < this.fetchedRowCount;
    }

    protected long getValidRows() {
        return this.fetchedRowCount;
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.statement;
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        assert (this.currentRow < this.fetchedRowCount) : "currentRow:" + this.currentRow + " fetchedRowCount:" + this.fetchedRowCount;
        if (!this.isAllFetched && this.currentRow + 1L == this.fetchedRowCount) {
            this.fetchMoreRows();
        }
        this.statement.removeRowFromCache(this.currentRow);
        --this.fetchedRowCount;
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return this.resultFromCache;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return this.statement.getCompileKey();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return this.statement.getRuntimeKey();
    }

    @Override
    int refreshRows(long firstRow, int numberOfRows) throws SQLException {
        return this.statement.refreshRows(firstRow, numberOfRows);
    }

    @Override
    void insertRow(RowId rowId) throws SQLException {
        if (this.currentRow < this.fetchedRowCount) {
            this.statement.insertRow(this.currentRow + 1L, rowId);
            ++this.currentRow;
        } else {
            this.statement.insertRow(this.currentRow, rowId);
        }
        ++this.fetchedRowCount;
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.statement.accessors != null) {
            return this.statement.numberOfDefinePositions - (1 + this.statement.offsetOfFirstUserColumn);
        }
        return this.getMetaData().getColumnCount();
    }

    RowId getPrependedRowId() throws SQLException {
        return this.statement.getPrependedRowId(this.currentRow);
    }

    @Override
    public int getCursorId() throws SQLException {
        return this.statement.cursorId;
    }

    @Override
    public final <T> Flow.Publisher<T> publisherOracle(Function<? super OracleRow, T> rowMappingFunction) throws SQLException {
        if (!this.statement.isFetchAsyncSupported()) {
            throw new SQLFeatureNotSupportedException(this.connection.getProtocolType() + " type connections do not support OracleResultSet.publisherOracle(Function)");
        }
        if (this.getType() == 1005) {
            throw new SQLFeatureNotSupportedException("Scrollable ResultSets do not support OracleResultSet.publisherOracle(Function)");
        }
        Objects.requireNonNull(rowMappingFunction, "rowMappingFunction can not be null");
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("publisherOracle");
            RowPublisher<T> rowPublisher = new RowPublisher<T>(rowMappingFunction);
            this.closed = true;
            this.lockBeforePublishing();
            RowPublisher<T> rowPublisher2 = rowPublisher;
            return rowPublisher2;
        }
    }

    private final void lockBeforePublishing() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.movementState != MovementState.INITIAL) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1712).fillInStackTrace();
            }
            this.movementState = MovementState.PUBLISHING_NOW;
            this.publishingCondition = this.connection.getMonitorLock().newCondition();
        }
    }

    @Override
    protected final void awaitPublishing() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            try {
                while (this.movementState == MovementState.PUBLISHING_NOW) {
                    this.publishingCondition.await();
                }
            }
            catch (InterruptedException interrupt) {
                throw new SQLException(interrupt);
            }
        }
    }

    private final void unlockAfterPublishing() {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            assert (this.movementState == MovementState.PUBLISHING_NOW);
            this.movementState = MovementState.PUBLISHING_COMPLETE;
            this.publishingCondition.signalAll();
        }
    }

    private final void closeOnPublishingComplete() throws Exception {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.closed = false;
            this.close();
        }
    }

    private static final class PersistentRow
    implements OracleRow {
        private final Object[] columnObjects;
        private final Map<String, Integer> columnIndexMap;
        private final OracleConnection closedConnection = new ClosedConnection();

        private PersistentRow(Object[] columnObjects, Map<String, Integer> columnIndexMap) {
            this.columnObjects = columnObjects;
            this.columnIndexMap = columnIndexMap;
        }

        @Override
        public final <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            String sanitizedColumnLabel = PersistentRow.sanitizeColumnLabel(columnLabel);
            Integer columnIndex = this.columnIndexMap.get(sanitizedColumnLabel);
            if (columnIndex == null) {
                throw (SQLException)DatabaseError.createSqlException(6, columnLabel).fillInStackTrace();
            }
            return this.getObject(columnIndex, type);
        }

        @Override
        public final <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            if (columnIndex < 1 || columnIndex > this.columnObjects.length) {
                throw (SQLException)DatabaseError.createSqlException(3, (Object)columnIndex).fillInStackTrace();
            }
            Object objectAtIndex = this.columnObjects[columnIndex - 1];
            return JavaToJavaConverter.convert(objectAtIndex, type, this.closedConnection, null, null);
        }

        @Override
        public final OracleRow clone() {
            try {
                return (OracleRow)super.clone();
            }
            catch (CloneNotSupportedException cloneFailure) {
                throw new RuntimeException(cloneFailure);
            }
        }

        private static String sanitizeColumnLabel(String columnLabel) {
            if (columnLabel == null) {
                return null;
            }
            if (columnLabel.length() > 1 && columnLabel.startsWith("\"") && columnLabel.endsWith("\"")) {
                return columnLabel.substring(1, columnLabel.length() - 1).toUpperCase();
            }
            return columnLabel.toUpperCase();
        }

        private static Map<String, Integer> createColumnIndexMap(ResultSetMetaData metaData) throws SQLException {
            int columnCount = metaData.getColumnCount();
            HashMap<String, Integer> newMap = new HashMap<String, Integer>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                String unsanitizedKey = metaData.getColumnLabel(i);
                String sanitizedKey = PersistentRow.sanitizeColumnLabel(unsanitizedKey);
                newMap.put(sanitizedKey, i);
            }
            return Collections.unmodifiableMap(newMap);
        }
    }

    private final class RowPublisher<T>
    extends PhasedPublisher<T> {
        private final Function<? super OracleRow, T> rowMappingFunction;
        private Map<String, Integer> persistentColumnIndexMap;

        private RowPublisher(Function<? super OracleRow, T> rowMappingFunction) {
            super(InsensitiveScrollableResultSet.this.connection.getAsyncExecutor(), InsensitiveScrollableResultSet.this.connection.getJoinPhaser(), () -> {
                InsensitiveScrollableResultSet.this.closeOnPublishingComplete();
                InsensitiveScrollableResultSet.this.unlockAfterPublishing();
            });
            this.rowMappingFunction = rowMappingFunction;
        }

        @Override
        protected final void requestNext(BiConsumer<T, Throwable> callback) {
            try {
                InsensitiveScrollableResultSet.this.ensureOpenStatement("publisherOracle");
            }
            catch (SQLException closedStatementFailure) {
                callback.accept(null, closedStatementFailure);
                return;
            }
            long targetRow = InsensitiveScrollableResultSet.this.currentRow + 1L;
            if (InsensitiveScrollableResultSet.this.isAllFetched || targetRow < InsensitiveScrollableResultSet.this.fetchedRowCount) {
                try {
                    InsensitiveScrollableResultSet.this.handleFetchNextRowsCompletion(targetRow);
                }
                catch (SQLException sqlException) {
                    callback.accept(null, sqlException);
                    return;
                }
                if (InsensitiveScrollableResultSet.this.isCurrentRowValid()) {
                    this.mapCurrentRow(callback);
                    return;
                }
                callback.accept(null, null);
                return;
            }
            this.nextAsyncOracle((hasNext, error) -> {
                if (error != null) {
                    callback.accept(null, (Throwable)error);
                } else if (!hasNext.booleanValue()) {
                    callback.accept(null, null);
                } else {
                    this.mapCurrentRow(callback);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void mapCurrentRow(BiConsumer<T, Throwable> callback) {
            try {
                T mappedRow;
                ExpiringRow currentRow = new ExpiringRow();
                try (Monitor.CloseableLock lock = InsensitiveScrollableResultSet.this.connection.acquireCloseableLock();){
                    mappedRow = this.rowMappingFunction.apply(currentRow);
                }
                finally {
                    currentRow.setExpired();
                }
                if (mappedRow != null) {
                    callback.accept(mappedRow, null);
                } else {
                    callback.accept(null, new NullPointerException("Row mapping function returned null"));
                }
            }
            catch (Throwable error) {
                callback.accept(null, error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void nextAsyncOracle(BiConsumer<Boolean, Throwable> callback) {
            try (Monitor.CloseableLock lock = InsensitiveScrollableResultSet.this.connection.acquireCloseableLock();){
                InsensitiveScrollableResultSet.this.closed = false;
                try {
                    long targetRow = InsensitiveScrollableResultSet.this.currentRow + 1L;
                    InsensitiveScrollableResultSet.this.fetchNextRowsAsync(targetRow, error -> {
                        Boolean result = null;
                        try {
                            if (error == null) {
                                InsensitiveScrollableResultSet.this.handleFetchNextRowsCompletion(targetRow);
                                result = InsensitiveScrollableResultSet.this.isCurrentRowValid();
                            }
                        }
                        catch (Throwable throwable) {
                            error = CompletionStageUtil.suppress(throwable, error);
                        }
                        finally {
                            callback.accept(result, (Throwable)error);
                        }
                    });
                }
                finally {
                    InsensitiveScrollableResultSet.this.closed = true;
                }
            }
        }

        private final Map<String, Integer> getPersistentColumnIndexMap() throws SQLException {
            if (this.persistentColumnIndexMap == null) {
                ResultSetMetaData metaData = InsensitiveScrollableResultSet.this.getMetaData();
                this.persistentColumnIndexMap = PersistentRow.createColumnIndexMap(metaData);
            }
            return this.persistentColumnIndexMap;
        }

        private final class ExpiringRow
        implements OracleRow {
            private volatile boolean isExpired = false;

            private ExpiringRow() {
            }

            @Override
            public final <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
                try (Monitor.CloseableLock lock = InsensitiveScrollableResultSet.this.connection.acquireCloseableLock();){
                    this.ensureUnexpired();
                    InsensitiveScrollableResultSet.this.ensureValidColumnIndex(columnIndex);
                    InsensitiveScrollableResultSet.this.ensureOpenStatement("OracleRow.getObject");
                    T t = InsensitiveScrollableResultSet.this.statement.getObject(InsensitiveScrollableResultSet.this.currentRow, columnIndex, type);
                    return t;
                }
            }

            @Override
            public final <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
                try (Monitor.CloseableLock lock = InsensitiveScrollableResultSet.this.connection.acquireCloseableLock();){
                    this.ensureUnexpired();
                    int columnIndex = InsensitiveScrollableResultSet.this.statement.getColumnIndex(columnLabel);
                    T t = InsensitiveScrollableResultSet.this.statement.getObject(InsensitiveScrollableResultSet.this.currentRow, columnIndex, type);
                    return t;
                }
            }

            private final void ensureUnexpired() throws SQLException {
                if (this.isExpired) {
                    throw (SQLException)DatabaseError.createSqlException(InsensitiveScrollableResultSet.this.getConnectionDuringExceptionHandling(), 1711).fillInStackTrace();
                }
            }

            private final void setExpired() {
                this.isExpired = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            @Override
            public final OracleRow clone() {
                try (Monitor.CloseableLock lock = InsensitiveScrollableResultSet.this.connection.acquireCloseableLock();){
                    InsensitiveScrollableResultSet.this.closed = false;
                    try {
                        InsensitiveScrollableResultSet.this.ensureOpenStatement("OracleRow.clone");
                        ResultSetMetaData metaData = InsensitiveScrollableResultSet.this.getMetaData();
                        int columnCount = metaData.getColumnCount();
                        Object[] columnObjects = new Object[columnCount];
                        for (int i = 0; i < columnCount; ++i) {
                            columnObjects[i] = InsensitiveScrollableResultSet.this.statement.getObject(InsensitiveScrollableResultSet.this.currentRow, i + 1);
                        }
                        PersistentRow persistentRow = new PersistentRow(columnObjects, RowPublisher.this.getPersistentColumnIndexMap());
                        InsensitiveScrollableResultSet.this.closed = true;
                        return persistentRow;
                    }
                    catch (Throwable throwable) {
                        InsensitiveScrollableResultSet.this.closed = true;
                        throw throwable;
                    }
                }
                catch (SQLException cloningFailure) {
                    throw new RuntimeException("Failed to create a persistent clone", cloningFailure);
                }
            }
        }
    }

    static enum MovementState {
        INITIAL,
        MOVED_SYNCHRONOUSLY,
        PUBLISHING_NOW,
        PUBLISHING_COMPLETE;

    }
}

