/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.nkf;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.transcode.EConv;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.nkf.Command;
import org.jruby.ext.nkf.CommandParser;
import org.jruby.ext.nkf.Option;
import org.jruby.ext.nkf.Options;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.io.EncodingUtils;

@JRubyModule(name={"NKF"})
public class RubyNKF {
    private static final ByteList BEGIN_MIME_STRING = new ByteList(ByteList.plain((CharSequence)"=?"));
    private static final ByteList END_MIME_STRING = new ByteList(ByteList.plain((CharSequence)"?="));
    private static final ByteList PACK_BASE64 = new ByteList(ByteList.plain((CharSequence)"m"));
    private static final ByteList PACK_QENCODE = new ByteList(ByteList.plain((CharSequence)"M"));
    public static final Map<Integer, String> NKFCharsetMap = new HashMap<Integer, String>(20, 1.0f);
    @Deprecated
    public static final NKFCharset AUTO = NKFCharset.AUTO;
    @Deprecated
    public static final NKFCharset JIS = NKFCharset.JIS;
    @Deprecated
    public static final NKFCharset EUC = NKFCharset.EUC;
    @Deprecated
    public static final NKFCharset SJIS = NKFCharset.SJIS;
    @Deprecated
    public static final NKFCharset BINARY = NKFCharset.BINARY;
    @Deprecated
    public static final NKFCharset NOCONV = NKFCharset.NOCONV;
    @Deprecated
    public static final NKFCharset UNKNOWN = NKFCharset.UNKNOWN;
    @Deprecated
    public static final NKFCharset ASCII = NKFCharset.ASCII;
    @Deprecated
    public static final NKFCharset UTF8 = NKFCharset.UTF8;
    @Deprecated
    public static final NKFCharset UTF16 = NKFCharset.UTF16;
    @Deprecated
    public static final NKFCharset UTF32 = NKFCharset.UTF32;
    @Deprecated
    public static final NKFCharset OTHER = NKFCharset.OTHER;
    @Deprecated
    public static final NKFCharset BASE64 = NKFCharset.BASE64;
    @Deprecated
    public static final NKFCharset QENCODE = NKFCharset.QENCODE;
    @Deprecated
    public static final NKFCharset MIME_DETECT = NKFCharset.MIME_DETECT;

    public static void load(Ruby ruby) {
        RubyNKF.createNKF(ruby);
    }

    public static void createNKF(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("NKF");
        rubyModule.defineConstant("NKF_VERSION", (IRubyObject)ruby.newString("2.1.2"));
        rubyModule.defineConstant("NKF_RELEASE_DATE", (IRubyObject)ruby.newString("2011-09-08"));
        rubyModule.defineConstant("VERSION", (IRubyObject)ruby.newString("2.1.2 (JRuby_2011-09-08)"));
        for (NKFCharset nKFCharset : NKFCharset.values()) {
            NKFCharsetMap.put(nKFCharset.value, nKFCharset.name());
            if (nKFCharset.value > 12) continue;
            rubyModule.defineConstant(nKFCharset.name(), RubyNKF.charsetMappedValue(ruby, nKFCharset));
        }
        rubyModule.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, module=true)
    public static IRubyObject guess(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNKF.charsetMappedValue(threadContext.runtime, RubyNKF.guess(threadContext, iRubyObject2));
    }

    public static NKFCharset guess(ThreadContext threadContext, IRubyObject iRubyObject) {
        CharsetDecoder charsetDecoder;
        Ruby ruby = threadContext.runtime;
        if (!iRubyObject.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject.getMetaClass() + " into String");
        }
        ByteList byteList = iRubyObject.convertToString().getByteList();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.getUnsafeBytes(), byteList.begin(), byteList.length());
        try {
            charsetDecoder = Charset.forName("x-JISAutoDetect").newDecoder();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw ruby.newStandardError("charsets.jar is required to use NKF#guess. Please install JRE which supports m17n.");
        }
        try {
            charsetDecoder.decode(byteBuffer);
            if (!charsetDecoder.isCharsetDetected()) {
                return NKFCharset.UNKNOWN;
            }
            Charset charset = charsetDecoder.detectedCharset();
            String string = charset.name();
            if ("Shift_JIS".equals(string)) {
                return NKFCharset.SJIS;
            }
            if ("Windows-31j".equalsIgnoreCase(string)) {
                return NKFCharset.JIS;
            }
            if ("EUC-JP".equals(string)) {
                return NKFCharset.EUC;
            }
            if ("ISO-2022-JP".equals(string)) {
                return NKFCharset.JIS;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        if (byteList.getEncoding() == UTF8Encoding.INSTANCE) {
            return NKFCharset.UTF8;
        }
        if (byteList.getEncoding().toString().startsWith("UTF-16")) {
            return NKFCharset.UTF16;
        }
        if (byteList.getEncoding().toString().startsWith("UTF-32")) {
            return NKFCharset.UTF32;
        }
        return NKFCharset.UNKNOWN;
    }

    private static IRubyObject charsetMappedValue(Ruby ruby, NKFCharset nKFCharset) {
        switch (nKFCharset.ordinal()) {
            case 0: 
            case 5: 
            case 6: {
                return ruby.getNil();
            }
            case 4: {
                Encoding encoding = ruby.getEncodingService().getAscii8bitEncoding();
                return ruby.getEncodingService().convertEncodingToRubyEncoding(encoding);
            }
        }
        Encoding encoding = ruby.getEncodingService().getEncodingFromString(nKFCharset.getCharset());
        return ruby.getEncodingService().convertEncodingToRubyEncoding(encoding);
    }

    @JRubyMethod(name={"guess1"}, module=true)
    public static IRubyObject guess1(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNKF.guess(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"guess2"}, module=true)
    public static IRubyObject guess2(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyNKF.guess(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"nkf"}, module=true)
    public static IRubyObject nkf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ByteList byteList;
        Ruby ruby = threadContext.runtime;
        if (!iRubyObject2.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject2.getMetaClass() + " into String");
        }
        if (!iRubyObject3.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject3.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> map = RubyNKF.parseOpt(iRubyObject2.convertToString().toString());
        if (map.get("input").getValue() == NKFCharset.AUTO.getValue()) {
            map.put("input", RubyNKF.guess(threadContext, iRubyObject3));
        }
        Converter converter = Converter.isMimeText(byteList = iRubyObject3.convertToString().getByteList(), map) ? new MimeConverter(threadContext, map) : new DefaultConverter(threadContext, map);
        RubyString rubyString = converter.convert(byteList);
        if (map.get("mime-encode") == NKFCharset.BASE64) {
            rubyString = Converter.encodeMimeString(ruby, rubyString, RubyNKF.PACK_BASE64);
        } else if (map.get("mime-encode") == NKFCharset.QENCODE) {
            rubyString = Converter.encodeMimeString(ruby, rubyString, RubyNKF.PACK_QENCODE);
        }
        return rubyString;
    }

    public static Command parseOption(String string) {
        Options options = new Options();
        options.addOption("b");
        options.addOption("u");
        options.addOption("j", "jis");
        options.addOption("s", "sjis");
        options.addOption("e", "euc");
        options.addOption("w", null, "[0-9][0-9]");
        options.addOption("J", "jis-input");
        options.addOption("S", "sjis-input");
        options.addOption("E", "euc-input");
        options.addOption("W", null, "[0-9][0-9]");
        options.addOption("t");
        options.addOption("i_");
        options.addOption("o_");
        options.addOption("r");
        options.addOption("h1", "hiragana");
        options.addOption("h2", "katakana");
        options.addOption("h3", "katakana-hiragana");
        options.addOption("T");
        options.addOption("l");
        options.addOption("f", null, "[0-9]+-[0-9]*");
        options.addOption("F");
        options.addOption("Z", null, "[0-3]");
        options.addOption("X");
        options.addOption("x");
        options.addOption("B", null, "[0-2]");
        options.addOption("I");
        options.addOption("L", null, "[uwm]");
        options.addOption("d");
        options.addOption("c");
        options.addOption("m", null, "[BQN0]");
        options.addOption("M", null, "[BQ]");
        options.addOption(null, "fj");
        options.addOption(null, "unix");
        options.addOption(null, "mac");
        options.addOption(null, "msdos");
        options.addOption(null, "windows");
        options.addOption(null, "mime");
        options.addOption(null, "base64");
        options.addOption(null, "mime-input");
        options.addOption(null, "base64-input");
        options.addOption(null, "ic", "ic=(.*)");
        options.addOption(null, "oc", "oc=(.*)");
        options.addOption(null, "fb-skip");
        options.addOption(null, "fb-html");
        options.addOption(null, "fb-xml");
        options.addOption(null, "fb-perl");
        options.addOption(null, "fb-java");
        options.addOption(null, "fb-subchar", "fb-subchar=(.*)");
        options.addOption(null, "no-cp932ext");
        options.addOption(null, "cap-input");
        options.addOption(null, "url-input");
        options.addOption(null, "numchar-input");
        options.addOption(null, "no-best-fit-chars");
        CommandParser commandParser = new CommandParser();
        Command command = commandParser.parse(options, string);
        return command;
    }

    private static Map<String, NKFCharset> parseOpt(String string) {
        Option option;
        HashMap<String, NKFCharset> hashMap = new HashMap<String, NKFCharset>();
        hashMap.put("input", NKFCharset.AUTO);
        hashMap.put("output", NKFCharset.JIS);
        hashMap.put("mime-decode", NKFCharset.MIME_DETECT);
        hashMap.put("mime-encode", NKFCharset.NOCONV);
        Command command = RubyNKF.parseOption(string);
        if (command.hasOption("j")) {
            hashMap.put("output", NKFCharset.JIS);
        }
        if (command.hasOption("s")) {
            hashMap.put("output", NKFCharset.SJIS);
        }
        if (command.hasOption("e")) {
            hashMap.put("output", NKFCharset.EUC);
        }
        if (command.hasOption("w")) {
            option = command.getOption("w");
            if ("32".equals(option.getValue())) {
                hashMap.put("output", NKFCharset.UTF32);
            } else if ("16".equals(option.getValue())) {
                hashMap.put("output", NKFCharset.UTF16);
            } else {
                hashMap.put("output", NKFCharset.UTF8);
            }
        }
        if (command.hasOption("J")) {
            hashMap.put("input", NKFCharset.JIS);
        }
        if (command.hasOption("S")) {
            hashMap.put("input", NKFCharset.SJIS);
        }
        if (command.hasOption("E")) {
            hashMap.put("input", NKFCharset.EUC);
        }
        if (command.hasOption("W")) {
            option = command.getOption("W");
            if ("32".equals(option.getValue())) {
                hashMap.put("input", NKFCharset.UTF32);
            } else if ("16".equals(option.getValue())) {
                hashMap.put("input", NKFCharset.UTF16);
            } else {
                hashMap.put("input", NKFCharset.UTF8);
            }
        }
        if (command.hasOption("m")) {
            option = command.getOption("m");
            if (option.getValue() == null) {
                hashMap.put("mime-decode", NKFCharset.MIME_DETECT);
            } else if ("B".equals(option.getValue())) {
                hashMap.put("mime-decode", NKFCharset.BASE64);
            } else if ("Q".equals(option.getValue())) {
                hashMap.put("mime-decode", NKFCharset.QENCODE);
            } else if (!"N".equals(option.getValue()) && "0".equals(option.getValue())) {
                hashMap.put("mime-decode", NKFCharset.NOCONV);
            }
        }
        if (command.hasOption("M")) {
            option = command.getOption("M");
            if (option.getValue() == null) {
                hashMap.put("mime-encode", NKFCharset.NOCONV);
            } else if ("B".equals(option.getValue())) {
                hashMap.put("mime-encode", NKFCharset.BASE64);
            } else if ("Q".equals(option.getValue())) {
                hashMap.put("mime-encode", NKFCharset.QENCODE);
            }
        }
        if (command.hasOption("base64")) {
            hashMap.put("mime-encode", NKFCharset.BASE64);
        }
        if (command.hasOption("oc")) {
            option = command.getOption("oc");
            if ("ISO-2022-JP".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.JIS);
            } else if ("EUC-JP".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.EUC);
            } else if ("CP932".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.SJIS);
            } else if ("Shift_JIS".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.SJIS);
            } else if ("Windows-31J".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.JIS);
            } else if ("UTF-8".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.UTF8);
            } else if ("UTF-8N".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.UTF8);
            } else if ("UTF-16".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.UTF16);
            } else if ("UTF-16BE-BOM".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.UTF16);
            } else if ("UTF-32".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.UTF32);
            } else if ("UTF-32BE-BOM".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("output", NKFCharset.UTF32);
            }
        }
        if (command.hasOption("ic")) {
            option = command.getOption("ic");
            if ("ISO-2022-JP".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.JIS);
            } else if ("EUC-JP".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.EUC);
            } else if ("CP932".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.SJIS);
            } else if ("Shift_JIS".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.SJIS);
            } else if ("Windows-31J".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.SJIS);
            } else if ("UTF-8".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.UTF8);
            } else if ("UTF-8N".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.UTF8);
            } else if ("UTF-16".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.UTF16);
            } else if ("UTF-16BE-BOM".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.UTF16);
            } else if ("UTF-32".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.UTF32);
            } else if ("UTF-32BE-BOM".compareToIgnoreCase(option.getValue()) == 0) {
                hashMap.put("input", NKFCharset.UTF32);
            }
        }
        return hashMap;
    }

    public static enum NKFCharset {
        AUTO(0, "x-JISAutoDetect"),
        JIS(1, "ISO-2022-JP"),
        EUC(2, "EUC-JP"),
        SJIS(3, "Shift_JIS"),
        BINARY(4, null),
        NOCONV(4, null),
        UNKNOWN(0, null),
        ASCII(5, "iso-8859-1"),
        UTF8(6, "UTF-8"),
        UTF16(8, "UTF-16"),
        UTF32(12, "UTF-32"),
        OTHER(16, null),
        BASE64(20, "base64"),
        QENCODE(21, "qencode"),
        MIME_DETECT(22, "MimeAutoDetect");

        private final int value;
        private final String charset;

        private NKFCharset(int n2, String string2) {
            this.value = n2;
            this.charset = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }

    static abstract class Converter {
        protected final ThreadContext context;
        protected final Map<String, NKFCharset> options;

        public Converter(ThreadContext threadContext, Map<String, NKFCharset> map) {
            this.context = threadContext;
            this.options = map;
        }

        static boolean isMimeText(ByteList byteList, Map<String, NKFCharset> map) {
            if (byteList.length() <= 6) {
                return false;
            }
            if (map.get("mime-decode") == NKFCharset.NOCONV) {
                return false;
            }
            if (byteList.indexOf(BEGIN_MIME_STRING) < 0) {
                return false;
            }
            return byteList.lastIndexOf(END_MIME_STRING) >= 0;
        }

        private static RubyString encodeMimeString(Ruby ruby, RubyString rubyString, ByteList byteList) {
            RubyArray rubyArray = RubyArray.newArray((Ruby)ruby, (IRubyObject)rubyString);
            return Pack.pack((Ruby)ruby, (RubyArray)rubyArray, (ByteList)byteList).chomp(ruby.getCurrentContext());
        }

        abstract RubyString convert(ByteList var1);

        ByteList convert_byte(ByteList byteList, String string, NKFCharset nKFCharset) {
            String string2 = nKFCharset.getCharset();
            if (string == null) {
                string = byteList.getEncoding().toString();
            }
            if (string2.equals(string)) {
                return byteList.dup();
            }
            byte[] byArray = string2.getBytes();
            EConv eConv = EncodingUtils.econvOpenOpts((ThreadContext)this.context, (byte[])string.getBytes(), (byte[])byArray, (int)0, (IRubyObject)this.context.nil);
            if (eConv == null) {
                throw this.context.runtime.newArgumentError("invalid encoding pair: " + string + " to " + string2);
            }
            ByteList byteList2 = EncodingUtils.econvStrConvert((ThreadContext)this.context, (EConv)eConv, (ByteList)byteList, (int)2);
            byteList2.setEncoding(this.context.runtime.getEncodingService().findEncodingOrAliasEntry(byArray).getEncoding());
            return byteList2;
        }
    }

    static class MimeConverter
    extends Converter {
        public MimeConverter(ThreadContext threadContext, Map<String, NKFCharset> map) {
            super(threadContext, map);
        }

        private String detectCharset(String string) {
            if (string.compareToIgnoreCase(NKFCharset.UTF8.getCharset()) == 0) {
                return NKFCharset.UTF8.getCharset();
            }
            if (string.compareToIgnoreCase(NKFCharset.JIS.getCharset()) == 0) {
                return NKFCharset.JIS.getCharset();
            }
            if (string.compareToIgnoreCase(NKFCharset.EUC.getCharset()) == 0) {
                return NKFCharset.EUC.getCharset();
            }
            return NKFCharset.ASCII.getCharset();
        }

        private ByteList decodeMimeString(String string) {
            String[] stringArray = string.split("^=\\?|\\?|\\?=$");
            String string2 = this.detectCharset(stringArray[1]);
            char c = stringArray[2].charAt(0);
            RubyString rubyString = EncodingUtils.newExternalStringWithEncoding((Ruby)this.context.runtime, (String)stringArray[3], (Encoding)ASCIIEncoding.INSTANCE);
            RubyArray rubyArray = 'B' == c || 'b' == c ? Pack.unpack((ThreadContext)this.context, (RubyString)rubyString, (ByteList)PACK_BASE64) : Pack.unpack((ThreadContext)this.context, (RubyString)rubyString, (ByteList)PACK_QENCODE);
            RubyString rubyString2 = (RubyString)rubyArray.entry(0);
            ByteList byteList = rubyString2.asString().getByteList();
            return this.convert_byte(byteList, string2, (NKFCharset)((Object)this.options.get("output")));
        }

        RubyString makeRubyString(ArrayList<ByteList> arrayList) {
            ByteList byteList = new ByteList();
            for (ByteList byteList2 : arrayList) {
                byteList.append(byteList2);
            }
            return this.context.runtime.newString(byteList);
        }

        @Override
        RubyString convert(ByteList byteList) {
            String string = Helpers.decodeByteList((Ruby)this.context.runtime, (ByteList)byteList);
            String[] stringArray = string.split("\\s");
            ArrayList<ByteList> arrayList = new ArrayList<ByteList>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(this.decodeMimeString(stringArray[i]));
            }
            return this.makeRubyString(arrayList);
        }
    }

    static class DefaultConverter
    extends Converter {
        public DefaultConverter(ThreadContext threadContext, Map<String, NKFCharset> map) {
            super(threadContext, map);
        }

        @Override
        RubyString convert(ByteList byteList) {
            NKFCharset nKFCharset = (NKFCharset)((Object)this.options.get("input"));
            NKFCharset nKFCharset2 = (NKFCharset)((Object)this.options.get("output"));
            ByteList byteList2 = this.convert_byte(byteList, nKFCharset.getCharset(), nKFCharset2);
            return this.context.runtime.newString(byteList2);
        }
    }
}

