﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

namespace Aws {
namespace GuardDuty {
namespace Model {
enum class MalwareProtectionScanType { NOT_SET, BACKUP_INITIATED, ON_DEMAND, GUARDDUTY_INITIATED };

namespace MalwareProtectionScanTypeMapper {
AWS_GUARDDUTY_API MalwareProtectionScanType GetMalwareProtectionScanTypeForName(const Aws::String& name);

AWS_GUARDDUTY_API Aws::String GetNameForMalwareProtectionScanType(MalwareProtectionScanType value);
}  // namespace MalwareProtectionScanTypeMapper
}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
