﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/ExperimentSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {
class ListExperimentsResult {
 public:
  AWS_FIS_API ListExperimentsResult() = default;
  AWS_FIS_API ListExperimentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FIS_API ListExperimentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The experiments.</p>
   */
  inline const Aws::Vector<ExperimentSummary>& GetExperiments() const { return m_experiments; }
  template <typename ExperimentsT = Aws::Vector<ExperimentSummary>>
  void SetExperiments(ExperimentsT&& value) {
    m_experimentsHasBeenSet = true;
    m_experiments = std::forward<ExperimentsT>(value);
  }
  template <typename ExperimentsT = Aws::Vector<ExperimentSummary>>
  ListExperimentsResult& WithExperiments(ExperimentsT&& value) {
    SetExperiments(std::forward<ExperimentsT>(value));
    return *this;
  }
  template <typename ExperimentsT = ExperimentSummary>
  ListExperimentsResult& AddExperiments(ExperimentsT&& value) {
    m_experimentsHasBeenSet = true;
    m_experiments.emplace_back(std::forward<ExperimentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListExperimentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListExperimentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ExperimentSummary> m_experiments;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_experimentsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
