﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/NotebookSessionSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListNotebookSessionsResult {
 public:
  AWS_ATHENA_API ListNotebookSessionsResult() = default;
  AWS_ATHENA_API ListNotebookSessionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListNotebookSessionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of the sessions belonging to the notebook.</p>
   */
  inline const Aws::Vector<NotebookSessionSummary>& GetNotebookSessionsList() const { return m_notebookSessionsList; }
  template <typename NotebookSessionsListT = Aws::Vector<NotebookSessionSummary>>
  void SetNotebookSessionsList(NotebookSessionsListT&& value) {
    m_notebookSessionsListHasBeenSet = true;
    m_notebookSessionsList = std::forward<NotebookSessionsListT>(value);
  }
  template <typename NotebookSessionsListT = Aws::Vector<NotebookSessionSummary>>
  ListNotebookSessionsResult& WithNotebookSessionsList(NotebookSessionsListT&& value) {
    SetNotebookSessionsList(std::forward<NotebookSessionsListT>(value));
    return *this;
  }
  template <typename NotebookSessionsListT = NotebookSessionSummary>
  ListNotebookSessionsResult& AddNotebookSessionsList(NotebookSessionsListT&& value) {
    m_notebookSessionsListHasBeenSet = true;
    m_notebookSessionsList.emplace_back(std::forward<NotebookSessionsListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the <code>NextToken</code> from the response object of the previous page
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListNotebookSessionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListNotebookSessionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<NotebookSessionSummary> m_notebookSessionsList;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_notebookSessionsListHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
