import parseUrl from 'extract-tld';
const protocolId = {
    http: 1,
    rsync: 3,
    https: 5,
    ftp: 9
};
function processUrl(url) {
    const mirrorListable = ['http', 'https'];
    const protocol = url.split(':')[0];
    return {
        name: parseUrl.parseUrl(url)?.domain,
        full: url,
        protocol,
        partial: url.split('$repo')[0],
        mirrorListable: mirrorListable.indexOf(protocol) >= 0
    };
}
function getProtocolId(protocol) {
    return protocolId[protocol];
}
export default processUrl;
export { processUrl, getProtocolId };
//# sourceMappingURL=processUrl.js.map