/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.el.VariableMapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.AstLiteralExpression;
import org.apache.el.parser.Node;
import org.apache.el.util.ReflectionUtil;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String string, Node node, FunctionMapper functionMapper, VariableMapper variableMapper, Class<?> clazz) {
        this.expr = string;
        this.node = node;
        this.fnMapper = functionMapper;
        this.varMapper = variableMapper;
        this.expectedType = clazz;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueExpressionImpl)) {
            return false;
        }
        if (object.hashCode() != this.hashCode()) {
            return false;
        }
        return this.getNode().equals(((ValueExpressionImpl)object).getNode());
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.expr;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    public Class<?> getType(ELContext eLContext) throws PropertyNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        Class<?> clazz = this.getNode().getType(evaluationContext);
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return clazz;
    }

    public <T> T getValue(ELContext eLContext) throws PropertyNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        Object object = this.getNode().getValue(evaluationContext);
        if (this.expectedType != null) {
            object = eLContext.convertToType(object, this.expectedType);
        }
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return (T)object;
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException eLException) {
            return false;
        }
    }

    public boolean isReadOnly(ELContext eLContext) throws PropertyNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        boolean bl = this.getNode().isReadOnly(evaluationContext);
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return bl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.expr = objectInput.readUTF();
        String string = objectInput.readUTF();
        if (!string.isEmpty()) {
            this.expectedType = ReflectionUtil.forName(string);
        }
        this.fnMapper = (FunctionMapper)objectInput.readObject();
        this.varMapper = (VariableMapper)objectInput.readObject();
    }

    public void setValue(ELContext eLContext, Object object) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        this.getNode().setValue(evaluationContext, object);
        eLContext.notifyAfterEvaluation(this.getExpressionString());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.expr);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        objectOutput.writeObject(this.fnMapper);
        objectOutput.writeObject(this.varMapper);
    }

    public String toString() {
        return "ValueExpression[" + this.expr + "]";
    }

    public ValueReference getValueReference(ELContext eLContext) {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        eLContext.notifyBeforeEvaluation(this.getExpressionString());
        ValueReference valueReference = this.getNode().getValueReference(evaluationContext);
        eLContext.notifyAfterEvaluation(this.getExpressionString());
        return valueReference;
    }
}

