/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.MultiToken;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.SpecialToken;
import com.dickimawbooks.texparserlib.TeXMode;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public class MathBg
extends BgChar
implements Expandable,
MultiToken {
    private boolean isinline = true;

    public MathBg(boolean bl) {
        this('$', bl);
    }

    public MathBg(char c, boolean bl) {
        this((int)c, bl);
    }

    public MathBg(int n, boolean bl) {
        super(n);
        this.isinline = bl;
    }

    @Override
    public Object clone() {
        return new MathBg(this.getCharCode(), this.isInLine());
    }

    @Override
    public boolean isSingleToken() {
        return this.isInLine();
    }

    @Override
    public int getCatCode() {
        return 3;
    }

    @Override
    public TeXObjectList splitTokens(TeXParser teXParser) {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new SpecialToken(this, this.getCharCode(), 3));
        if (!this.isInLine()) {
            teXObjectList.add(new SpecialToken(this, this.getCharCode(), 3));
        }
        return teXObjectList;
    }

    @Override
    public TeXObject reconstitute(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.POP_SHORT;
        TeXObject teXObject = TeXParserUtils.peek(teXParser, teXObjectList, by);
        if (teXObject.isSingleToken() && ((SingleToken)teXObject).getCatCode() == 3) {
            this.isinline = true;
            TeXParserUtils.pop(teXParser, teXObjectList, by);
        }
        return this;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList(1);
        teXObjectList.add(this);
        teXParser.startGroup();
        teXParser.getSettings().setMode(this.isInLine() ? TeXMode.INLINE_MATH : TeXMode.DISPLAY_MATH);
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public String format() {
        String string = new String(Character.toChars(this.getCharCode()));
        return this.isInLine() ? string : String.format("%s%s", string, string);
    }

    @Override
    public String toString() {
        return String.format("%s[delim=%s]", this.getClass().getName(), this.format());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return teXParser.getMathDelim(this.isInLine());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.getCharCode()));
        if (!this.isinline) {
            teXObjectList.add(teXParser.getListener().getOther(this.getCharCode()));
        }
        return teXObjectList;
    }

    @Override
    public String show(TeXParser teXParser) throws IOException {
        return String.format("math character %s", new String(Character.toChars(this.getCharCode())));
    }

    public boolean isInLine() {
        return this.isinline;
    }

    @Override
    public Group createGroup(TeXParser teXParser) {
        MathGroup mathGroup = teXParser.getListener().createMathGroup();
        mathGroup.setInLine(this.isInLine());
        return mathGroup;
    }
}

