/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.LMDirichletSimilarity;
import org.apache.lucene.search.similarities.LMSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.SimilarityFactory;

public class LMDirichletSimilarityFactory
extends SimilarityFactory {
    private boolean discountOverlaps;
    private Float mu;

    @Override
    public void init(SolrParams params) {
        super.init(params);
        this.discountOverlaps = params.getBool("discountOverlaps", true);
        this.mu = params.getFloat("mu");
    }

    @Override
    public Similarity getSimilarity() {
        if (this.mu == null) {
            this.mu = Float.valueOf(2000.0f);
        }
        LMSimilarity.DefaultCollectionModel model = new LMSimilarity.DefaultCollectionModel();
        return new LMDirichletSimilarity((LMSimilarity.CollectionModel)model, this.discountOverlaps, this.mu.floatValue());
    }
}

