/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.CreateAliasCmd;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexCollectionCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMMAND = "cmd";
    public static final String REINDEX_STATUS = "reindexStatus";
    public static final String REMOVE_SOURCE = "removeSource";
    public static final String TARGET = "target";
    public static final String TARGET_COL_PREFIX = ".rx_";
    public static final String CHK_COL_PREFIX = ".rx_ck_";
    public static final String REINDEXING_STATE = CollectionAdminRequest.PROPERTY_PREFIX + "rx";
    public static final String STATE = "state";
    public static final String PHASE = "phase";
    private static final List<String> COLLECTION_PARAMS = Arrays.asList("configName", "numShards", "nrtReplicas", "pullReplicas", "tlogReplicas", "replicationFactor", "shards", "createNodeSet", "createNodeSet.shuffle");
    private final CollectionCommandContext ccc;
    private static AtomicInteger tmpCollectionSeq = new AtomicInteger();
    private static final String REINDEXING_STATE_PATH = "/.reindexing";

    public ReindexCollectionCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        boolean createdTarget;
        Exception exc;
        Replica daemonReplica;
        String chkCollection;
        Object targetCollection;
        boolean aborted;
        Map<String, Object> reindexingState;
        String collection;
        block64: {
            block65: {
                block62: {
                    block63: {
                        block60: {
                            block61: {
                                log.debug("*** called: {}", (Object)message);
                                String extCollection = message.getStr("name");
                                if (extCollection == null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection name must be specified");
                                }
                                boolean followAliases = message.getBool("followAliases", false);
                                collection = followAliases ? this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extCollection) : extCollection;
                                if (!clusterState.hasCollection(collection)) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection name must exist");
                                }
                                String target = message.getStr(TARGET);
                                if (target == null) {
                                    target = collection;
                                } else if (followAliases) {
                                    target = this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(target);
                                }
                                boolean sameTarget = target.equals(collection) || target.equals(extCollection);
                                boolean removeSource = message.getBool(REMOVE_SOURCE, false);
                                Cmd command = Cmd.get(message.getStr(COMMAND, Cmd.START.toLower()));
                                if (command == null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown command: " + message.getStr(COMMAND));
                                }
                                reindexingState = ReindexCollectionCmd.getReindexingState(this.ccc.getSolrCloudManager().getDistribStateManager(), collection);
                                if (!reindexingState.containsKey(STATE)) {
                                    reindexingState.put(STATE, State.IDLE.toLower());
                                }
                                State state = State.get(reindexingState.get(STATE));
                                if (command == Cmd.ABORT) {
                                    log.info("Abort requested for collection {}, setting the state to ABORTED.", (Object)collection);
                                    if (state != State.RUNNING) {
                                        log.debug("Abort requested for collection {} but command is not running: {}", (Object)collection, (Object)state);
                                        return;
                                    }
                                    this.setReindexingState(collection, State.ABORTED, null);
                                    reindexingState.put(STATE, "aborting");
                                    results.add(REINDEX_STATUS, reindexingState);
                                    return;
                                }
                                if (command == Cmd.STATUS) {
                                    results.add(REINDEX_STATUS, reindexingState);
                                    return;
                                }
                                if (state == State.RUNNING) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Reindex is already running for collection " + collection + ". If you are sure this is not the case you can issue &cmd=abort to clean up this state.");
                                }
                                DocCollection coll = clusterState.getCollection(collection);
                                aborted = false;
                                int batchSize = message.getInt("rows", Integer.valueOf(100));
                                String query = message.getStr("q", "*:*");
                                String fl = message.getStr("fl", "*");
                                Integer rf = message.getInt("replicationFactor", coll.getReplicationFactor());
                                Integer numNrt = message.getInt("nrtReplicas", coll.getNumNrtReplicas());
                                Integer numTlog = message.getInt("tlogReplicas", coll.getNumTlogReplicas());
                                Integer numPull = message.getInt("pullReplicas", coll.getNumPullReplicas());
                                int numShards = message.getInt("numShards", Integer.valueOf(coll.getActiveSlices().size()));
                                DocRouter router = coll.getRouter();
                                if (router == null) {
                                    router = DocRouter.DEFAULT;
                                }
                                String configName = message.getStr("configName", coll.getConfigName());
                                int seq = tmpCollectionSeq.getAndIncrement();
                                if (sameTarget) {
                                    while (clusterState.hasCollection((String)(targetCollection = TARGET_COL_PREFIX + extCollection + "_" + seq))) {
                                        seq = tmpCollectionSeq.getAndIncrement();
                                        if (clusterState.hasCollection((String)targetCollection)) continue;
                                        break;
                                    }
                                } else {
                                    targetCollection = target;
                                }
                                chkCollection = CHK_COL_PREFIX + extCollection;
                                Object daemonUrl = null;
                                daemonReplica = null;
                                exc = null;
                                createdTarget = false;
                                try {
                                    ZkNodeProps props;
                                    SolrResponse solrResponse;
                                    ZkNodeProps cmd;
                                    reindexingState.clear();
                                    reindexingState.put("actualSourceCollection", collection);
                                    reindexingState.put("actualTargetCollection", targetCollection);
                                    reindexingState.put("checkpointCollection", chkCollection);
                                    reindexingState.put("inputDocs", this.getNumberOfDocs(collection));
                                    reindexingState.put(PHASE, "creating target and checkpoint collections");
                                    this.setReindexingState(collection, State.RUNNING, reindexingState);
                                    NamedList cmdResults = new NamedList();
                                    if (clusterState.hasCollection((String)targetCollection)) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Target collection " + (String)targetCollection + " already exists! Delete it first.");
                                    }
                                    if (clusterState.hasCollection(chkCollection)) {
                                        cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", chkCollection});
                                        new DeleteCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
                                        CollectionHandlingUtils.checkResults("deleting old checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, true);
                                    }
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        return;
                                    }
                                    HashMap<String, Object> propMap = new HashMap<String, Object>();
                                    propMap.put("operation", CollectionParams.CollectionAction.CREATE.toLower());
                                    propMap.put("name", targetCollection);
                                    propMap.put("numShards", numShards);
                                    propMap.put("collection.configName", configName);
                                    propMap.put("router.name", router.getName());
                                    for (String string : coll.keySet()) {
                                        if (!string.startsWith("router.")) continue;
                                        propMap.put(string, coll.get(string));
                                    }
                                    for (String string : message.keySet()) {
                                        if (string.startsWith("router.")) {
                                            propMap.put(string, message.getStr(string));
                                            continue;
                                        }
                                        if (!COLLECTION_PARAMS.contains(string)) continue;
                                        propMap.put(string, message.get(string));
                                    }
                                    propMap.put("waitForFinalState", true);
                                    if (rf != null) {
                                        propMap.put("replicationFactor", rf);
                                    }
                                    if (numNrt != null) {
                                        propMap.put("nrtReplicas", numNrt);
                                    }
                                    if (numTlog != null) {
                                        propMap.put("tlogReplicas", numTlog);
                                    }
                                    if (numPull != null) {
                                        propMap.put("pullReplicas", numPull);
                                    }
                                    cmd = new ZkNodeProps(propMap);
                                    cmdResults = new NamedList();
                                    new CreateCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
                                    createdTarget = true;
                                    CollectionHandlingUtils.checkResults("creating target collection " + (String)targetCollection, (NamedList<Object>)cmdResults, true);
                                    cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.CREATE.toLower(), "name", chkCollection, "numShards", "1", "replicationFactor", "1", "collection.configName", "_default", "waitForFinalState", "true"});
                                    cmdResults = new NamedList();
                                    new CreateCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
                                    CollectionHandlingUtils.checkResults("creating checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, true);
                                    try {
                                        for (String string : List.of(targetCollection, chkCollection)) {
                                            this.ccc.getZkStateReader().waitForState(string, 30L, TimeUnit.SECONDS, Objects::nonNull);
                                        }
                                    }
                                    catch (TimeoutException e) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create temporary collection(s)");
                                    }
                                    clusterState = this.ccc.getSolrCloudManager().getClusterState();
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        return;
                                    }
                                    cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", collection, "readOnly", "true"});
                                    if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                                        this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionModifyCollection, cmd, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
                                    } else {
                                        this.ccc.offerStateUpdate((MapWriter)cmd);
                                    }
                                    TestInjection.injectReindexLatch();
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        return;
                                    }
                                    ModifiableSolrParams q = new ModifiableSolrParams();
                                    q.set("qt", new String[]{"/stream"});
                                    q.set("collection", new String[]{collection});
                                    q.set("expr", new String[]{"daemon(id=\"" + (String)targetCollection + "\",terminate=\"true\",commit(" + (String)targetCollection + ",update(" + (String)targetCollection + ",batchSize=" + batchSize + ",topic(" + chkCollection + "," + collection + ",q=\"" + query + "\",fl=\"" + fl + "\",id=\"topic_" + (String)targetCollection + "\",rows=\"" + batchSize + "\",initialCheckpoint=\"0\"))))"});
                                    log.debug("- starting copying documents from {} to {}", (Object)collection, targetCollection);
                                    try {
                                        solrResponse = new QueryRequest((SolrParams)q).process((SolrClient)this.ccc.getSolrCloudManager().getSolrClient());
                                    }
                                    catch (Exception e) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to copy documents from " + collection + " to " + (String)targetCollection, (Throwable)e);
                                    }
                                    daemonReplica = this.getReplicaForDaemon(solrResponse, coll);
                                    if (daemonReplica == null) {
                                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to copy documents from " + collection + " to " + (String)targetCollection + ": " + Utils.toJSONString((Object)solrResponse));
                                    }
                                    reindexingState.put("daemonUrl", daemonReplica.getCoreUrl());
                                    reindexingState.put("daemonName", targetCollection);
                                    reindexingState.put(PHASE, "copying documents");
                                    this.setReindexingState(collection, State.RUNNING, reindexingState);
                                    this.waitForDaemon((String)targetCollection, daemonReplica, collection, (String)targetCollection, reindexingState);
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        if (!aborted) break block60;
                                        break block61;
                                    }
                                    log.debug("- finished copying from {} to {}", (Object)collection, targetCollection);
                                    TestInjection.injectReindexFailure();
                                    if (sameTarget) {
                                        log.debug("- setting up alias from {} to {}", (Object)extCollection, targetCollection);
                                        cmd = new ZkNodeProps(new String[]{"name", extCollection, "collections", targetCollection});
                                        cmdResults = new NamedList();
                                        new CreateAliasCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
                                        CollectionHandlingUtils.checkResults("setting up alias " + extCollection + " -> " + (String)targetCollection, (NamedList<Object>)cmdResults, true);
                                        reindexingState.put("alias", extCollection + " -> " + (String)targetCollection);
                                    }
                                    reindexingState.remove("daemonUrl");
                                    reindexingState.remove("daemonName");
                                    reindexingState.put("processedDocs", this.getNumberOfDocs((String)targetCollection));
                                    reindexingState.put(PHASE, "copying done, finalizing");
                                    this.setReindexingState(collection, State.RUNNING, reindexingState);
                                    if (this.maybeAbort(collection)) {
                                        aborted = true;
                                        if (!aborted) break block62;
                                        break block63;
                                    }
                                    log.debug("- deleting {}", (Object)chkCollection);
                                    cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", chkCollection});
                                    cmdResults = new NamedList();
                                    new DeleteCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
                                    CollectionHandlingUtils.checkResults("deleting checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, true);
                                    if (removeSource) {
                                        log.debug("- deleting source collection");
                                        cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection, "followAliases", "false"});
                                        cmdResults = new NamedList();
                                        new DeleteCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
                                        CollectionHandlingUtils.checkResults("deleting source collection " + collection, (NamedList<Object>)cmdResults, true);
                                    } else {
                                        props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", collection, "readOnly", null});
                                        if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                                            this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionModifyCollection, props, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
                                        } else {
                                            this.ccc.offerStateUpdate((MapWriter)props);
                                        }
                                    }
                                    props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", targetCollection, REINDEXING_STATE, State.FINISHED.toLower()});
                                    if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                                        this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionModifyCollection, props, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
                                    } else {
                                        this.ccc.offerStateUpdate((MapWriter)props);
                                    }
                                    reindexingState.put(STATE, State.FINISHED.toLower());
                                    reindexingState.put(PHASE, "done");
                                    this.removeReindexingState(collection);
                                    if (!aborted) break block64;
                                    break block65;
                                }
                                catch (Exception e) {
                                    log.warn("Error during reindexing of {}", (Object)extCollection, (Object)e);
                                    exc = e;
                                    aborted = true;
                                    return;
                                }
                            }
                            this.cleanup(collection, (String)targetCollection, chkCollection, daemonReplica, (String)targetCollection, createdTarget);
                            if (exc != null) {
                                results.add("error", (Object)exc.toString());
                            }
                            reindexingState.put(STATE, State.ABORTED.toLower());
                        }
                        results.add(REINDEX_STATUS, reindexingState);
                        return;
                    }
                    this.cleanup(collection, (String)targetCollection, chkCollection, daemonReplica, (String)targetCollection, createdTarget);
                    if (exc != null) {
                        results.add("error", (Object)exc.toString());
                    }
                    reindexingState.put(STATE, State.ABORTED.toLower());
                }
                results.add(REINDEX_STATUS, reindexingState);
                return;
            }
            this.cleanup(collection, (String)targetCollection, chkCollection, daemonReplica, (String)targetCollection, createdTarget);
            if (exc != null) {
                results.add("error", (Object)exc.toString());
            }
            reindexingState.put(STATE, State.ABORTED.toLower());
        }
        results.add(REINDEX_STATUS, reindexingState);
        return;
        finally {
            if (aborted) {
                this.cleanup(collection, (String)targetCollection, chkCollection, daemonReplica, (String)targetCollection, createdTarget);
                if (exc != null) {
                    results.add("error", (Object)exc.toString());
                }
                reindexingState.put(STATE, State.ABORTED.toLower());
            }
            results.add(REINDEX_STATUS, reindexingState);
        }
    }

    private Map<String, Object> setReindexingState(String collection, State state, Map<String, Object> props) throws Exception {
        String path = "/collections/" + collection + REINDEXING_STATE_PATH;
        DistribStateManager stateManager = this.ccc.getSolrCloudManager().getDistribStateManager();
        if (props == null) {
            props = stateManager.getJson(path);
        }
        HashMap<String, Object> copyProps = new HashMap<String, Object>(props);
        copyProps.put(STATE, state.toLower());
        if (stateManager.hasData(path)) {
            stateManager.setData(path, Utils.toJSON(copyProps), -1);
        } else {
            stateManager.makePath(path, Utils.toJSON(copyProps), CreateMode.PERSISTENT, false);
        }
        return copyProps;
    }

    private void removeReindexingState(String collection) throws Exception {
        String path = "/collections/" + collection + REINDEXING_STATE_PATH;
        DistribStateManager stateManager = this.ccc.getSolrCloudManager().getDistribStateManager();
        if (stateManager.hasData(path)) {
            stateManager.removeData(path, -1);
        }
    }

    @VisibleForTesting
    public static Map<String, Object> getReindexingState(DistribStateManager stateManager, String collection) throws Exception {
        String path = "/collections/" + collection + REINDEXING_STATE_PATH;
        return new TreeMap<String, Object>(stateManager.getJson(path));
    }

    private long getNumberOfDocs(String collection) {
        CloudSolrClient solrClient = this.ccc.getCoreContainer().getZkController().getSolrClient();
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("q", new String[]{"*:*"});
            params.add("rows", new String[]{"0"});
            QueryResponse rsp = solrClient.query(collection, (SolrParams)params);
            return rsp.getResults().getNumFound();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private boolean maybeAbort(String collection) throws Exception {
        DocCollection coll = this.ccc.getSolrCloudManager().getClusterState().getCollectionOrNull(collection);
        if (coll == null) {
            log.info("## Aborting - collection {} no longer present.", (Object)collection);
            return true;
        }
        Map<String, Object> reindexingState = ReindexCollectionCmd.getReindexingState(this.ccc.getSolrCloudManager().getDistribStateManager(), collection);
        State state = State.get(reindexingState.getOrDefault(STATE, State.RUNNING.toLower()));
        if (state != State.ABORTED) {
            return false;
        }
        log.info("## Aborting - collection {} state is {}", (Object)collection, (Object)state);
        return true;
    }

    private Replica getReplicaForDaemon(SolrResponse rsp, DocCollection coll) {
        List list;
        Map rs = (Map)rsp.getResponse().get("result-set");
        if ((rs == null || rs.isEmpty()) && log.isDebugEnabled()) {
            log.debug(" -- Missing daemon information in response: {}", (Object)Utils.toJSONString((Object)rsp));
        }
        if ((list = (List)rs.get("docs")) == null) {
            if (log.isDebugEnabled()) {
                log.debug(" -- Missing daemon information in response: {}", (Object)Utils.toJSONString((Object)rsp));
            }
            return null;
        }
        String replicaName = null;
        for (Object o : list) {
            Map map = (Map)o;
            String op = (String)map.get("DaemonOp");
            if (op == null) continue;
            String[] parts = op.split("\\s+");
            if (parts.length != 4) {
                log.debug(" -- Invalid daemon location info, expected 4 tokens: {}", (Object)op);
                return null;
            }
            if (parts[3].contains("shard") && parts[3].contains("replica")) {
                replicaName = parts[3];
                break;
            }
            log.debug(" -- daemon location info likely invalid: {}", (Object)op);
            return null;
        }
        if (replicaName == null) {
            return null;
        }
        for (Replica r : coll.getReplicas()) {
            if (!replicaName.equals(r.getCoreName())) continue;
            return r;
        }
        return null;
    }

    private void waitForDaemon(String daemonName, Replica daemonReplica, String sourceCollection, String targetCollection, Map<String, Object> reindexingState) throws Exception {
        boolean isRunning;
        int statusCheck = 0;
        do {
            isRunning = false;
            ++statusCheck;
            try {
                NamedList<Object> rsp = this.executeDaemonAction("list", daemonName, daemonReplica);
                Map rs = (Map)rsp.get("result-set");
                if (rs == null || rs.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find daemon list: missing result-set: " + Utils.toJSONString(rsp));
                }
                List list = (List)rs.get("docs");
                if (list == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find daemon list: missing result-set: " + Utils.toJSONString(rsp));
                }
                if (list.isEmpty()) break;
                for (Object o : list) {
                    Map map = (Map)o;
                    String id = (String)map.get("id");
                    if (!daemonName.equals(id)) continue;
                    isRunning = true;
                    TestInjection.injectReindexFailure();
                    break;
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception waiting for daemon " + daemonName + " at " + daemonReplica.getCoreUrl(), (Throwable)e);
            }
            if (statusCheck % 5 == 0) {
                reindexingState.put("processedDocs", this.getNumberOfDocs(targetCollection));
                this.setReindexingState(sourceCollection, State.RUNNING, reindexingState);
            }
            this.ccc.getSolrCloudManager().getTimeSource().sleep(2000L);
        } while (isRunning && !this.maybeAbort(sourceCollection));
    }

    private void killDaemon(String daemonName, Replica daemonReplica) throws Exception {
        Map rs;
        if (log.isDebugEnabled()) {
            log.debug("-- killing daemon {} at {}", (Object)daemonName, (Object)daemonReplica.getCoreUrl());
        }
        NamedList<Object> rsp = this.executeDaemonAction("stop", daemonName, daemonReplica);
        if (log.isDebugEnabled()) {
            log.debug(" -- stop daemon response: {}", (Object)Utils.toJSONString(rsp));
        }
        if ((rs = (Map)rsp.get("result-set")) == null || rs.isEmpty()) {
            log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString(rsp));
            return;
        }
        List list = (List)rs.get("docs");
        if (list == null) {
            log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString(rsp));
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        for (Object o : list) {
            Map map = (Map)o;
            String op = (String)map.get("DaemonOp");
            if (op == null || !op.contains(daemonName) || !op.contains("stopped")) continue;
            TimeOut timeOut = new TimeOut(60L, TimeUnit.SECONDS, this.ccc.getSolrCloudManager().getTimeSource());
            while (!timeOut.hasTimedOut()) {
                Number stopTime;
                rsp = this.executeDaemonAction("list", daemonName, daemonReplica);
                rs = (Map)rsp.get("result-set");
                if (rs == null || rs.isEmpty()) {
                    log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString(rsp));
                    break;
                }
                List list2 = (List)rs.get("docs");
                if (list2 == null) {
                    log.warn("Problem killing daemon {}: missing result-set: {}", (Object)daemonName, (Object)Utils.toJSONString(rsp));
                    break;
                }
                if (list2.isEmpty()) break;
                Map status2 = null;
                for (Object o2 : list2) {
                    Map map2 = (Map)o2;
                    if (!daemonName.equals(map2.get("id"))) continue;
                    status2 = map2;
                    break;
                }
                if (status2 != null && (stopTime = (Number)status2.get("stopTime")).longValue() <= 0L) continue;
                break;
            }
            if (!timeOut.hasTimedOut()) continue;
            log.warn("Problem killing daemon {}: timed out waiting for daemon to stop.", (Object)daemonName);
        }
        this.executeDaemonAction("kill", daemonName, daemonReplica);
    }

    private NamedList<Object> executeDaemonAction(String action, String daemonName, Replica daemonReplica) throws Exception {
        Http2SolrClient solrClient = this.ccc.getCoreContainer().getDefaultHttpSolrClient();
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("qt", new String[]{"/stream"});
        solrParams.set("action", new String[]{action});
        solrParams.set("id", new String[]{daemonName});
        solrParams.set("distrib", false);
        QueryRequest req = new QueryRequest((SolrParams)solrParams);
        QueryResponse solrResponse = (QueryResponse)solrClient.requestWithBaseUrl(daemonReplica.getBaseUrl(), daemonReplica.getCoreName(), (SolrRequest)req);
        return solrResponse.getResponse();
    }

    private void cleanup(String collection, String targetCollection, String chkCollection, Replica daemonReplica, String daemonName, boolean createdTarget) throws Exception {
        ZkNodeProps cmd;
        log.info("## Cleaning up after abort or error");
        if (daemonReplica != null) {
            this.killDaemon(daemonName, daemonReplica);
        }
        ClusterState clusterState = this.ccc.getSolrCloudManager().getClusterState();
        NamedList cmdResults = new NamedList();
        if (createdTarget && !collection.equals(targetCollection) && clusterState.hasCollection(targetCollection)) {
            log.debug(" -- removing {}", (Object)targetCollection);
            cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", targetCollection, "followAliases", "false"});
            new DeleteCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
            CollectionHandlingUtils.checkResults("CLEANUP: deleting target collection " + targetCollection, (NamedList<Object>)cmdResults, false);
        }
        if (clusterState.hasCollection(chkCollection)) {
            log.debug(" -- removing {}", (Object)chkCollection);
            cmd = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", chkCollection, "followAliases", "false"});
            cmdResults = new NamedList();
            new DeleteCollectionCmd(this.ccc).call(clusterState, cmd, (NamedList<Object>)cmdResults);
            CollectionHandlingUtils.checkResults("CLEANUP: deleting checkpoint collection " + chkCollection, (NamedList<Object>)cmdResults, false);
        }
        log.debug(" -- turning readOnly mode off for {}", (Object)collection);
        ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower(), "collection", collection, "readOnly", null});
        if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
            this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionModifyCollection, props, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
        } else {
            this.ccc.offerStateUpdate((MapWriter)props);
        }
        this.removeReindexingState(collection);
    }

    public static enum Cmd {
        START,
        ABORT,
        STATUS;

        static final Map<String, Cmd> cmds;

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public static Cmd get(String p) {
            if (p == null) {
                return null;
            }
            p = p.toLowerCase(Locale.ROOT);
            return cmds.get(p);
        }

        static {
            cmds = Stream.of(Cmd.values()).collect(Collectors.toUnmodifiableMap(Cmd::toLower, Function.identity()));
        }
    }

    public static enum State {
        IDLE,
        RUNNING,
        ABORTED,
        FINISHED;

        static final Map<String, State> states;

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public static State get(Object p) {
            if (p == null) {
                return null;
            }
            p = String.valueOf(p).toLowerCase(Locale.ROOT);
            return states.get(p);
        }

        static {
            states = Stream.of(State.values()).collect(Collectors.toUnmodifiableMap(State::toLower, Function.identity()));
        }
    }
}

