/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.yaml;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.SpecVersion;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.base.TextualTSFactory;
import tools.jackson.core.io.IOContext;
import tools.jackson.dataformat.yaml.PackageVersion;
import tools.jackson.dataformat.yaml.UTF8Reader;
import tools.jackson.dataformat.yaml.UTF8Writer;
import tools.jackson.dataformat.yaml.YAMLFactoryBuilder;
import tools.jackson.dataformat.yaml.YAMLGenerator;
import tools.jackson.dataformat.yaml.YAMLParser;
import tools.jackson.dataformat.yaml.YAMLReadFeature;
import tools.jackson.dataformat.yaml.YAMLWriteFeature;
import tools.jackson.dataformat.yaml.util.StringQuotingChecker;

public class YAMLFactory
extends TextualTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_YAML = "YAML";
    protected static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLReadFeature.collectDefaults();
    protected static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLWriteFeature.collectDefaults();
    protected final SpecVersion _version;
    protected final StringQuotingChecker _quotingChecker;
    protected final LoadSettings _loadSettings;
    protected final DumpSettings _dumpSettings;

    public YAMLFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_YAML_PARSER_FEATURE_FLAGS, DEFAULT_YAML_GENERATOR_FEATURE_FLAGS);
        this._version = null;
        this._quotingChecker = StringQuotingChecker.Default.instance();
        this._loadSettings = null;
        this._dumpSettings = null;
    }

    public YAMLFactory(YAMLFactory src) {
        super((TextualTSFactory)src);
        this._version = src._version;
        this._quotingChecker = src._quotingChecker;
        this._loadSettings = src._loadSettings;
        this._dumpSettings = src._dumpSettings;
    }

    protected YAMLFactory(YAMLFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
        this._version = b.yamlVersionToWrite();
        this._quotingChecker = b.stringQuotingChecker();
        this._loadSettings = b.loadSettings();
        this._dumpSettings = b.dumpSettings();
    }

    public YAMLFactoryBuilder rebuild() {
        return new YAMLFactoryBuilder(this);
    }

    public static YAMLFactoryBuilder builder() {
        return new YAMLFactoryBuilder();
    }

    public YAMLFactory copy() {
        return new YAMLFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new YAMLFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<YAMLReadFeature> getFormatReadFeatureType() {
        return YAMLReadFeature.class;
    }

    public Class<YAMLWriteFeature> getFormatWriteFeatureType() {
        return YAMLWriteFeature.class;
    }

    public int getFormatReadFeatures() {
        return this._formatReadFeatures;
    }

    public int getFormatWriteFeatures() {
        return this._formatWriteFeatures;
    }

    public boolean isEnabled(YAMLReadFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public boolean isEnabled(YAMLWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    protected YAMLParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        return new YAMLParser(readCtxt, ioCtxt, this._getBufferRecycler(), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._loadSettings, this._createReader(in, null, ioCtxt));
    }

    protected YAMLParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, Reader r) {
        return new YAMLParser(readCtxt, ioCtxt, this._getBufferRecycler(), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._loadSettings, r);
    }

    protected YAMLParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, char[] data, int offset, int len, boolean recyclable) {
        return new YAMLParser(readCtxt, ioCtxt, this._getBufferRecycler(), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._loadSettings, new CharArrayReader(data, offset, len));
    }

    protected YAMLParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        return new YAMLParser(readCtxt, ioCtxt, this._getBufferRecycler(), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._loadSettings, this._createReader(data, offset, len, null, ioCtxt));
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    protected YAMLGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, Writer out) {
        return new YAMLGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), this._quotingChecker, out, this._version, this._dumpSettings);
    }

    protected YAMLGenerator _createUTF8Generator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        return this._createGenerator(writeCtxt, ioCtxt, this._createWriter(ioCtxt, out, JsonEncoding.UTF8));
    }

    protected Writer _createWriter(IOContext ioCtxt, OutputStream out, JsonEncoding enc) {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(out);
        }
        try {
            return new OutputStreamWriter(out, enc.getJavaName());
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(in, autoClose);
        }
        try {
            return new InputStreamReader(in, enc.getJavaName());
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected Reader _createReader(byte[] data, int offset, int len, JsonEncoding enc, IOContext ctxt) {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(data, offset, len, true);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        try {
            return new InputStreamReader((InputStream)in, enc.getJavaName());
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }
}

