/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.ROWID;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CRowidAccessor
extends RowidAccessor {
    T4CMAREngine mare;
    final int[] meta;
    static final int KGRD_EXTENDED_OBJECT = 6;
    static final int KGRD_EXTENDED_BLOCK = 6;
    static final int KGRD_EXTENDED_FILE = 3;
    static final int KGRD_EXTENDED_SLOT = 3;
    static final int kd4_ubridtype_physical = 1;
    static final int kd4_ubridtype_logical = 2;
    static final int kd4_ubridtype_remote = 3;
    static final int kd4_ubridtype_exttab = 4;
    static final int kd4_ubridtype_future2 = 5;
    static final int kd4_ubridtype_max = 5;
    static final int kd4_ubridlen_typeind = 1;
    static final int kd4_ubridlen_physobjd = 4;
    static final int kd4_ubridlen_physfno = 2;
    static final int kd4_ubridlen_physbno = 4;
    static final int kd4_ubridlen_physsno = 2;
    static final byte[] kgrd_indbyte_char;
    static final byte[] kgrd_basis_64;
    static final byte[] kgrd_index_64;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    T4CRowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$29, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.meta = new int[1];
            this.mare = _mare;
            this.defineType = 104;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$29, null);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$29, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CRowidAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$30, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, _definedColumnType, _definedColumnSize, _mare);
            }
            this.meta = new int[1];
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.defineType = 104;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$30, null);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean isStream = false;
            if (!this.isUseless()) {
                if (this.isUnexpected()) {
                    long pos = this.rowData.getPosition();
                    this.unmarshalColumnMetadata();
                    this.unmarshalBytes();
                    this.rowData.setPosition(pos);
                    this.setNull(this.lastRowProcessed, true);
                } else if (this.isNullByDescribe()) {
                    this.setNull(this.lastRowProcessed, true);
                    this.unmarshalColumnMetadata();
                    if (this.statement.connection.versionNumber < 9200) {
                        this.processIndicator(0);
                    }
                } else {
                    this.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes();
                }
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            boolean bl2 = isStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.isNullByDescribe || this.previousRowProcessed == -1) {
                this.setNull(this.lastRowProcessed, true);
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            } else if (this.lastRowProcessed == 0) {
                if (this.previousRowProcessed == -1) {
                    this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
                }
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            } else if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
                this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
            } else {
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    AccessorPrototype newPrototype(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            AccessorPrototype p2;
            void numRows;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if (!$assertionsDisabled && numRows < 0) {
                AssertionError assertionError = new AssertionError((Object)("numRows: " + (int)numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$7, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            AccessorPrototype accessorPrototype = p2 = new AccessorPrototype((int)numRows, this, this.statement.rowData){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                Accessor newAccessor(OracleStatement stmt) throws SQLException {
                    T4CRowidAccessor acc = new T4CRowidAccessor(stmt, T4CRowidAccessor.this.describeMaxLength, T4CRowidAccessor.this.nullable, -1, T4CRowidAccessor.this.precision, T4CRowidAccessor.this.scale, T4CRowidAccessor.this.contflag, -1, T4CRowidAccessor.this.formOfUse, T4CRowidAccessor.this.definedColumnType, T4CRowidAccessor.this.definedColumnSize, null);
                    this.initializeRowData(acc);
                    return acc;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(T4CRowidAccessor.class, Integer.TYPE, Accessor.class, ByteArray.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("newAccessor", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$7, this, accessorPrototype);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$7, this, null);
            }
            return accessorPrototype;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.setOffset(this.lastRowProcessed);
            this.rowData.putShort((short)0);
            if (this.describeType == 208) {
                len = (int)this.mare.unmarshalUB4();
                if (len > 0) {
                    ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, len);
                }
            } else {
                len = this.mare.unmarshalUB1();
                if (len > 0) {
                    this.rowData.putInt((int)this.mare.unmarshalUB4());
                    this.rowData.putShort((short)this.mare.unmarshalUB2());
                    this.rowData.put((byte)this.mare.unmarshalUB1());
                    this.rowData.putInt((int)this.mare.unmarshalUB4());
                    this.rowData.putShort((short)this.mare.unmarshalUB2());
                }
            }
            this.processIndicator(len);
            this.rowData.putShort(this.getOffset(this.lastRowProcessed), (short)len);
            this.setLength(this.lastRowProcessed, (int)(this.rowData.getPosition() - this.getOffset(this.lastRowProcessed)));
            this.setNull(this.lastRowProcessed, len == 0);
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$8, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte[] getDecodedBytes(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, n2);
            }
            this.rowData.pushPosition(this.getOffset((int)currentRow));
            int meta = this.rowData.getShort();
            if (this.describeType == 208) {
                byte[] b0 = this.getBytesInternal((int)currentRow);
                byte[] b1 = new byte[4096];
                meta = T4CRowidAccessor.kgrdub2c(b0, meta, 2, b1, 2);
                b1[0] = (byte)(meta >> 8 & 0xFF);
                b1[1] = (byte)(meta & 0xFF);
                byte[] b2 = new byte[meta + 2];
                System.arraycopy(b1, 0, b2, 0, b2.length);
                this.rowData.popPosition();
                byte[] byArray = b2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, null);
                }
                return b2;
            }
            short len = (short)meta;
            long rba = 0L;
            int partitionID = 0;
            short tableID = 0;
            long blockNumber = 0L;
            int slotNumber = 0;
            if (len > 0) {
                rba = (long)this.rowData.getInt() & 0xFFFFFFFFL;
                partitionID = this.rowData.getShort() & 0xFFFF;
                tableID = (short)(this.rowData.get() & 0xFF);
                blockNumber = (long)this.rowData.getInt() & 0xFFFFFFFFL;
                slotNumber = this.rowData.getShort() & 0xFFFF;
            }
            this.rowData.popPosition();
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "$1.unmarshalOneRow : len=" + len + ",rba=" + rba + ",partition=" + partitionID + ",tableID=" + tableID + ",blockNumber=" + blockNumber + ",slotNumber=" + slotNumber);
            }
            if (rba == 0L && partitionID == 0 && tableID == 0 && blockNumber == 0L && slotNumber == 0) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            long[] args = new long[]{rba, partitionID, blockNumber, slotNumber};
            byte[] base64format = T4CRowidAccessor.rowidToString(args);
            int nbBytesToKeep = 18;
            if (this.byteLength - 2 < 18) {
                nbBytesToKeep = this.byteLength - 2;
            }
            byte[] result = new byte[nbBytesToKeep + 2];
            System.arraycopy(base64format, 0, result, 2, nbBytesToKeep);
            result[0] = (byte)((nbBytesToKeep & 0xFF00) >> 8);
            result[1] = (byte)(nbBytesToKeep & 0xFF);
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, string);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            byte[] b2 = this.getDecodedBytes((int)currentRow);
            if (b2 == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, string);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            long off = this.getOffset((int)currentRow);
            if (this.describeType == 208 && this.rowData.get(off + 2L) != 1) {
                int len = (b2[0] & 0xFF) << 8 | b2[1] & 0xFF;
                String string = new String(b2, 2, len, StandardCharsets.US_ASCII);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, string);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, null);
                }
                return string;
            }
            long[] l2 = T4CRowidAccessor.stringToRowid(b2, 2, b2.length - 2);
            String string = new String(T4CRowidAccessor.rowidToString(l2), StandardCharsets.US_ASCII);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, n2);
            }
            if (this.definedColumnType == 0) {
                Object object = super.getObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, object);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, null);
                }
                return object;
            }
            if (this.isNull((int)currentRow)) {
                Object var3_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, var3_4);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, null);
                }
                return null;
            }
            switch (this.definedColumnType) {
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    String string = this.getString((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, string);
                        ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, null);
                    }
                    return string;
                }
                case -8: {
                    ROWID rOWID = this.getROWID((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, rOWID);
                        ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, null);
                    }
                    return rOWID;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, null);
                }
                return null;
            }
            byte[] b0 = this.getDecodedBytes((int)currentRow);
            if (b0 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, null);
                }
                return null;
            }
            byte[] b1 = new byte[b0.length - 2];
            System.arraycopy(b0, 2, b1, 0, b1.length);
            byte[] byArray = b1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, null);
            }
            return b1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    static final byte[] rowidToString(long[] lArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long[] rowid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$13, null, new Object[]{lArray});
            }
            long rba = rowid[0];
            long tidpid = rowid[1];
            long ridrba = rowid[2];
            long ridsqn = rowid[3];
            int size = 18;
            byte[] ret = new byte[size];
            int offset = 0;
            offset = T4CRowidAccessor.kgrd42b(ret, rba, 6, offset);
            offset = T4CRowidAccessor.kgrd42b(ret, tidpid, 3, offset);
            offset = T4CRowidAccessor.kgrd42b(ret, ridrba, 6, offset);
            offset = T4CRowidAccessor.kgrd42b(ret, ridsqn, 3, offset);
            byte[] byArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$13, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$13, null, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final long[] rcToRowid(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            byte[] data;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$14, null, byArray, n2, n3);
            }
            int size = 18;
            if (length != 18) {
                SQLException sQLException = new SQLException("Rowid size incorrect.");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$14, null, sQLException);
                }
                throw sQLException;
            }
            long[] ret = new long[4];
            String value = new String(data, (int)offset, (int)length, StandardCharsets.US_ASCII);
            long blockNumber = Long.parseLong(value.substring(0, 8), 16);
            long slotNumber = Long.parseLong(value.substring(9, 13), 16);
            long partitionID = Long.parseLong(value.substring(14, 18), 16);
            ret[0] = 0L;
            ret[1] = partitionID;
            ret[2] = blockNumber;
            ret[3] = slotNumber;
            long[] lArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$14, null, lArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$14, null, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final void kgrdr2rc(int n2, int n3, int n4, int n5, int n6, byte[] byArray, int n7) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void tidpid;
            void ridsqn;
            int offset;
            void ridrba;
            void dstBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$15, null, n2, n3, n4, n5, n6, byArray, n7);
            }
            offset = T4CRowidAccessor.lmx42h((byte[])dstBytes, (long)ridrba, 8, offset);
            dstBytes[offset++] = 46;
            offset = T4CRowidAccessor.lmx42h((byte[])dstBytes, (long)ridsqn, 4, offset);
            dstBytes[offset++] = 46;
            offset = T4CRowidAccessor.lmx42h((byte[])dstBytes, (long)tidpid, 4, offset);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int lmx42h(byte[] byArray, long l2, int n2, int n3) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void size;
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$16, null, byArray, l2, n2, n3);
            }
            String hexRep = Long.toHexString((long)value).toUpperCase();
            void size_t = size;
            int hexRepOff = 0;
            do {
                if (hexRepOff < hexRep.length()) {
                    charsAsBytes[offset + size - true] = (byte)hexRep.charAt(hexRep.length() - hexRepOff - 1);
                    ++hexRepOff;
                    continue;
                }
                charsAsBytes[offset + size - true] = 48;
            } while (--size > 0);
            void var9_8 = size_t + offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$16, null, (int)var9_8);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$16, null, null);
            }
            return (int)var9_8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int kgrdc2ub(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void dst;
            void src_offset;
            byte[] src;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, byArray, n2, byArray2, n3, n4);
            }
            byte rowid_type = T4CRowidAccessor.getRowidType(src, (int)src_offset);
            void byte_rowid = dst;
            void bytes_to_convert = length - true;
            int next_input_byte = 0;
            byte[] kgrd_char64_tosigned = kgrd_index_64;
            int byte_used_len = 1 + (3 * ((length - true) / 4) + ((length - true) % 4 != false ? (length - true) % 4 - true : 0));
            if (bytes_to_convert == false) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, sQLException);
                }
                throw sQLException;
            }
            byte_rowid[dst_offset + false] = rowid_type;
            next_input_byte = src_offset + true;
            int next_output_byte = 1;
            while (bytes_to_convert > 0) {
                byte byte_after_this;
                if (bytes_to_convert == true) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, sQLException);
                    }
                    throw sQLException;
                }
                byte this_byte = kgrd_char64_tosigned[src[next_input_byte]];
                if (this_byte == -1) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, sQLException);
                    }
                    throw sQLException;
                }
                if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, sQLException);
                    }
                    throw sQLException;
                }
                byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 0xFF) << 2 | (byte_after_this & 0x30) >> 4);
                if (bytes_to_convert == 2) break;
                ++next_output_byte;
                this_byte = byte_after_this;
                if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, sQLException);
                    }
                    throw sQLException;
                }
                byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 0xFF) << 4 | (byte_after_this & 0x3C) >> 2);
                if (bytes_to_convert == 3) break;
                ++next_output_byte;
                this_byte = byte_after_this;
                if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(132).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, sQLException);
                    }
                    throw sQLException;
                }
                byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 3) << 6 | byte_after_this);
                bytes_to_convert -= 4;
                ++next_input_byte;
                ++next_output_byte;
            }
            int n5 = byte_used_len;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, n5);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final long[] stringToRowid(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int size;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$18, null, byArray, n2, n3);
            }
            if (length != (size = 18)) {
                SQLException sQLException = new SQLException("Rowid size incorrect.");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$18, null, sQLException);
                }
                throw sQLException;
            }
            long[] ret = new long[4];
            try {
                void offset;
                byte[] data;
                ret[0] = T4CRowidAccessor.kgrdb42(data, 6, (int)offset);
                ret[1] = T4CRowidAccessor.kgrdb42(data, 3, (int)(offset += 6));
                ret[2] = T4CRowidAccessor.kgrdb42(data, 6, (int)(offset += 3));
                ret[3] = T4CRowidAccessor.kgrdb42(data, 3, (int)(offset += 6));
                offset += 3;
            }
            catch (Exception e2) {
                ret[0] = 0L;
                ret[1] = 0L;
                ret[2] = 0L;
                ret[3] = 0L;
            }
            long[] lArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$18, null, lArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$18, null, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int kgrd42b(byte[] byArray, long l2, int n2, int n3) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void value;
            void size;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$19, null, byArray, l2, n2, n3);
            }
            void size_t = size;
            void val = value;
            while (size > 0) {
                charsAsBytes[offset + size - true] = kgrd_basis_64[(int)val & 0x3F];
                val = val >>> 6 & 0x3FFFFFFL;
                --size;
            }
            void var9_7 = size_t + offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$19, null, (int)var9_7);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$19, null, null);
            }
            return (int)var9_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final long kgrdb42(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int size;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$20, null, byArray, n2, n3);
            }
            long ret = 0L;
            for (int i2 = 0; i2 < size; ++i2) {
                void offset;
                byte[] charsAsBytes;
                byte value = charsAsBytes[offset + i2];
                if ((value = kgrd_index_64[value]) == -1) {
                    SQLException sQLException = new SQLException("Char data to rowid conversion failed.");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$20, null, sQLException);
                    }
                    throw sQLException;
                }
                ret <<= 6;
                ret |= (long)value;
            }
            long l2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$20, null, l2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$20, null, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final void kgrdr2ec(int n2, int n3, int n4, int n5, int n6, byte[] byArray, int n7) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void ridsqn;
            void ridrba;
            void tidpid;
            int dstOffset;
            void dstBytes;
            int tidrba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$21, null, n2, n3, n4, n5, n6, byArray, n7);
            }
            dstOffset = T4CRowidAccessor.kgrd42b(tidrba, (byte[])dstBytes, dstOffset, 6);
            dstOffset = T4CRowidAccessor.kgrd42b((int)tidpid, (byte[])dstBytes, dstOffset, 3);
            dstOffset = T4CRowidAccessor.kgrd42b((int)ridrba, (byte[])dstBytes, dstOffset, 6);
            dstOffset = T4CRowidAccessor.kgrd42b((int)ridsqn, (byte[])dstBytes, dstOffset, 3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$21, null);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$21, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int kgrd42b(int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void dstOffset;
            void digits;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$22, null, n2, byArray, n3, n4);
            }
            void len = digits;
            while (digits > 0) {
                int value;
                dstBytes[dstOffset + --digits] = kgrd_basis_64[value & 0x3F];
                value >>= 6;
            }
            void var6_6 = dstOffset + len;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$22, null, (int)var6_6);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$22, null, null);
            }
            return (int)var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int kgrdub2c(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$23, null, byArray, n2, n3, byArray2, n4);
            }
            int rid_length = -1;
            byte rid_type = bytes[offset];
            if (rid_type == 1) {
                void dstOffset;
                void dstBytes;
                int[] int_bytes = new int[bytes.length];
                for (int i2 = 0; i2 < bytes.length; ++i2) {
                    int_bytes[i2] = bytes[i2] & 0xFF;
                }
                void temp = offset + true;
                int tidrba = (((int_bytes[temp + false] << 8) + int_bytes[temp + true] << 8) + int_bytes[temp + 2] << 8) + int_bytes[temp + 3];
                temp = offset + 5;
                int tidpid = (int_bytes[temp + false] << 8) + int_bytes[temp + true];
                int tidtbl = 0;
                temp = offset + 7;
                int ridrba = (((int_bytes[temp + false] << 8) + int_bytes[temp + true] << 8) + int_bytes[temp + 2] << 8) + int_bytes[temp + 3];
                temp = offset + 11;
                int ridsqn = (int_bytes[temp + false] << 8) + int_bytes[temp + true];
                if (tidrba == 0) {
                    T4CRowidAccessor.kgrdr2rc(tidrba, tidpid, tidtbl, ridrba, ridsqn, (byte[])dstBytes, (int)dstOffset);
                } else {
                    T4CRowidAccessor.kgrdr2ec(tidrba, tidpid, tidtbl, ridrba, ridsqn, (byte[])dstBytes, (int)dstOffset);
                }
                rid_length = 18;
            } else {
                void size;
                int next_output_byte = 0;
                void bytes_to_convert = size - true;
                int body_length = 4 * (size / 3) + (size % 3 == false ? size % 3 + true : 0);
                int char_length = 1 + body_length - 1;
                if (char_length != 0) {
                    dstBytes[dstOffset + false] = kgrd_indbyte_char[rid_type - 1];
                    void next_input_byte = offset + true;
                    next_output_byte = 1;
                    byte second_byte = 0;
                    while (bytes_to_convert > 0) {
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 0xFF) >> 2];
                        if (bytes_to_convert == true) {
                            dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 3) << 4];
                            break;
                        }
                        second_byte = (byte)(bytes[next_input_byte + true] & 0xFF);
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 3) << 4 | (second_byte & 0xF0) >> 4];
                        if (bytes_to_convert == 2) {
                            dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(second_byte & 0xF) << 2];
                            break;
                        }
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(second_byte & 0xF) << 2 | (bytes[next_input_byte += 2] & 0xC0) >> 6];
                        dstBytes[dstOffset + next_output_byte] = kgrd_basis_64[bytes[next_input_byte] & 0x3F];
                        bytes_to_convert -= 3;
                        ++next_input_byte;
                        ++next_output_byte;
                    }
                }
                rid_length = next_output_byte;
            }
            int n5 = rid_length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$23, null, n5);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$23, null, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    static final byte[] rowidToDTYBURI(long[] lArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long[] rowid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$24, null, new Object[]{lArray});
            }
            int tidrba = (int)rowid[0];
            int tidpid = (int)rowid[1];
            int ridrba = (int)rowid[2];
            int ridsqn = (int)rowid[3];
            int tidrbaOffset = 1;
            int tidpidOffset = tidrbaOffset + 4;
            int ridrbaOffset = tidpidOffset + 2;
            int ridsqnOffset = ridrbaOffset + 4;
            byte[] kd4ubrid = new byte[ridsqnOffset + 2];
            kd4ubrid[0] = 1;
            kd4ubrid[tidrbaOffset] = (byte)(tidrba >> 24 & 0xFF);
            kd4ubrid[tidrbaOffset + 1] = (byte)(tidrba >> 16 & 0xFF);
            kd4ubrid[tidrbaOffset + 2] = (byte)(tidrba >> 8 & 0xFF);
            kd4ubrid[tidrbaOffset + 3] = (byte)(tidrba & 0xFF);
            kd4ubrid[tidpidOffset] = (byte)(tidpid >> 8 & 0xFF);
            kd4ubrid[tidpidOffset + 1] = (byte)(tidpid & 0xFF);
            kd4ubrid[ridrbaOffset] = (byte)(ridrba >> 24 & 0xFF);
            kd4ubrid[ridrbaOffset + 1] = (byte)(ridrba >> 16 & 0xFF);
            kd4ubrid[ridrbaOffset + 2] = (byte)(ridrba >> 8 & 0xFF);
            kd4ubrid[ridrbaOffset + 3] = (byte)(ridrba & 0xFF);
            kd4ubrid[ridsqnOffset] = (byte)(ridsqn >> 8 & 0xFF);
            kd4ubrid[ridsqnOffset + 1] = (byte)(ridsqn & 0xFF);
            byte[] byArray = kd4ubrid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$24, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$24, null, null);
            }
            return kd4ubrid;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] rowidToDTYBRI(long[] lArray, int n2, int n3, int n4) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void sdbaBits;
            void dbabBits;
            void sdbaOfBits;
            long[] rowid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$25, null, lArray, n2, n3, n4);
            }
            int tidrba = (int)rowid[0];
            int tidpid = (int)rowid[1];
            int ridrba = (int)rowid[2];
            int ridsqn = (int)rowid[3];
            int tidrbaOffset = 0;
            int krdbaOffset = 4;
            int ridsqnOffset = krdbaOffset + 4;
            byte[] kd4lbrid = new byte[ridsqnOffset + 2];
            kd4lbrid[tidrbaOffset] = (byte)(tidrba >> 24 & 0xFF);
            kd4lbrid[tidrbaOffset + 1] = (byte)(tidrba >> 16 & 0xFF);
            kd4lbrid[tidrbaOffset + 2] = (byte)(tidrba >> 8 & 0xFF);
            kd4lbrid[tidrbaOffset + 3] = (byte)(tidrba & 0xFF);
            int tidpidHi = tidpid >> sdbaOfBits;
            int tidpidLo = tidpid & (1 << sdbaOfBits) - 1;
            int krdba = ridrba + (tidpidHi << dbabBits | tidpidLo << sdbaBits - sdbaOfBits);
            kd4lbrid[krdbaOffset] = (byte)(krdba >> 24 & 0xFF);
            kd4lbrid[krdbaOffset + 1] = (byte)(krdba >> 16 & 0xFF);
            kd4lbrid[krdbaOffset + 2] = (byte)(krdba >> 8 & 0xFF);
            kd4lbrid[krdbaOffset + 3] = (byte)(krdba & 0xFF);
            kd4lbrid[ridsqnOffset] = (byte)(ridsqn >> 8 & 0xFF);
            kd4lbrid[ridsqnOffset + 1] = (byte)(ridsqn & 0xFF);
            byte[] byArray = kd4lbrid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$25, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$25, null, null);
            }
            return kd4lbrid;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean isRestricted(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] rowidChars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$26, null, new Object[]{byArray});
            }
            for (int i2 = 0; i2 < rowidChars.length; ++i2) {
                if (46 != rowidChars[i2]) continue;
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$26, null, bl2);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$26, null, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$26, null, bl3);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$26, null, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final boolean isUROWID(byte[] byArray, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            byte[] data;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$27, null, byArray, n2);
            }
            boolean bl3 = bl2 = T4CRowidAccessor.getRowidType(data, (int)offset) == 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$27, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$27, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final byte getRowidType(byte[] byArray, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            byte[] data;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$28, null, byArray, n2);
            }
            byte rowid_type = 5;
            switch (data[offset]) {
                case 65: {
                    rowid_type = 1;
                    break;
                }
                case 42: {
                    rowid_type = 2;
                    break;
                }
                case 45: {
                    rowid_type = 3;
                    break;
                }
                case 40: {
                    rowid_type = 4;
                    break;
                }
                case 41: {
                    rowid_type = 5;
                }
            }
            byte by = rowid_type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$28, null, by);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$28, null, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CRowidAccessor.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$30 = T4CRowidAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CRowidAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CRowidAccessor.class.getDeclaredMethod("getRowidType", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CRowidAccessor.class.getDeclaredMethod("isUROWID", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CRowidAccessor.class.getDeclaredMethod("isRestricted", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CRowidAccessor.class.getDeclaredMethod("rowidToDTYBRI", long[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CRowidAccessor.class.getDeclaredMethod("rowidToDTYBURI", long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CRowidAccessor.class.getDeclaredMethod("kgrdub2c", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CRowidAccessor.class.getDeclaredMethod("kgrd42b", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CRowidAccessor.class.getDeclaredMethod("kgrdr2ec", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CRowidAccessor.class.getDeclaredMethod("kgrdb42", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CRowidAccessor.class.getDeclaredMethod("kgrd42b", byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CRowidAccessor.class.getDeclaredMethod("stringToRowid", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CRowidAccessor.class.getDeclaredMethod("kgrdc2ub", byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CRowidAccessor.class.getDeclaredMethod("lmx42h", byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CRowidAccessor.class.getDeclaredMethod("kgrdr2rc", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CRowidAccessor.class.getDeclaredMethod("rcToRowid", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CRowidAccessor.class.getDeclaredMethod("rowidToString", long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CRowidAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CRowidAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CRowidAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CRowidAccessor.class.getDeclaredMethod("getDecodedBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CRowidAccessor.class.getDeclaredMethod("unmarshalBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CRowidAccessor.class.getDeclaredMethod("newPrototype", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CRowidAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CRowidAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CRowidAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CRowidAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CRowidAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CRowidAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CRowidAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        kgrd_indbyte_char = new byte[]{65, 42, 45, 40, 41};
        kgrd_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        kgrd_index_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    }
}

