/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.ermodel.weakassociations.ColumnMatchKeys;
import schemacrawler.ermodel.weakassociations.TableColumns;
import schemacrawler.ermodel.weakassociations.TableMatchKeys;
import schemacrawler.ermodel.weakassociations.WeakColumnReference;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationsAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationsAnalyzer.class.getName());
    private final TableMatchKeys tableMatchKeys;
    private final Predicate<ColumnReference> weakAssociationRule;

    public WeakAssociationsAnalyzer(TableMatchKeys matchKeys, Predicate<ColumnReference> weakAssociationRule) {
        this.tableMatchKeys = Objects.requireNonNull(matchKeys, "No table match keys provided");
        this.weakAssociationRule = Objects.requireNonNull(weakAssociationRule, "No rules provided");
    }

    public Collection<WeakColumnReference> analyzeTables() {
        if (this.tableMatchKeys.getTables().size() < 2) {
            return Collections.emptySet();
        }
        LOGGER.log(Level.INFO, "Finding weak associations");
        ArrayList<WeakColumnReference> weakAssociations = new ArrayList<WeakColumnReference>();
        List<Table> tables = this.tableMatchKeys.getTables();
        ColumnMatchKeys columnMatchKeys = new ColumnMatchKeys(tables);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, new StringFormat("Column match keys <%s>", columnMatchKeys));
            LOGGER.log(Level.FINER, new StringFormat("Table match keys <%s>", this.tableMatchKeys));
        }
        for (Table table : tables) {
            TableColumns pkTableColumns = new TableColumns(table);
            LOGGER.log(Level.FINER, new StringFormat("Table candidate keys <%s>", pkTableColumns));
            for (Column pkColumn : pkTableColumns.getCandidateKeys()) {
                HashSet<String> fkColumnMatchKeys = new HashSet<String>();
                if (pkColumn.isPartOfPrimaryKey() && this.tableMatchKeys.containsKey(table)) {
                    fkColumnMatchKeys.addAll(this.tableMatchKeys.get(table));
                }
                if (columnMatchKeys.containsKey(pkColumn)) {
                    fkColumnMatchKeys.addAll(columnMatchKeys.get(pkColumn));
                }
                HashSet<Column> fkColumns = new HashSet<Column>();
                for (String fkColumnMatchKey : fkColumnMatchKeys) {
                    if (!columnMatchKeys.containsKey(fkColumnMatchKey)) continue;
                    fkColumns.addAll(columnMatchKeys.get(fkColumnMatchKey));
                }
                for (Column fkColumn : fkColumns) {
                    WeakColumnReference proposedWeakAssociation;
                    if (fkColumn.isPartOfForeignKey() || !(proposedWeakAssociation = new WeakColumnReference(fkColumn, pkColumn)).isValid() || !this.weakAssociationRule.test(proposedWeakAssociation)) continue;
                    LOGGER.log(Level.FINE, new StringFormat("Found weak association <%s>", proposedWeakAssociation));
                    weakAssociations.add(proposedWeakAssociation);
                }
            }
        }
        Collections.sort(weakAssociations);
        return weakAssociations;
    }
}

