/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.bytecode.BytecodeDSLCheckedAccess;
import com.oracle.truffle.api.bytecode.BytecodeDSLUncheckedAccess;
import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.frame.FrameExtensions;
import com.oracle.truffle.api.memory.ByteArraySupport;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BytecodeDSLAccess {
    private static volatile BytecodeDSLAccess safeSingleton;
    private static volatile BytecodeDSLAccess unsafeSingleton;

    public static final BytecodeDSLAccess lookup(Object token, boolean allowUnsafe) {
        BytecodeDSLAccess impl;
        BytecodeRootNodes.checkToken(token);
        if (allowUnsafe && !Boolean.getBoolean("truffle.dsl.DisableUnsafeBytecodeDSLAccess")) {
            impl = unsafeSingleton;
            if (impl == null) {
                impl = unsafeSingleton = BytecodeDSLAccess.createUnsafe();
            }
        } else {
            impl = safeSingleton;
            if (impl == null) {
                impl = safeSingleton = BytecodeDSLAccess.createSafe();
            }
        }
        return impl;
    }

    BytecodeDSLAccess() {
    }

    private static BytecodeDSLAccess createSafe() {
        return new BytecodeDSLCheckedAccess();
    }

    private static BytecodeDSLAccess createUnsafe() {
        return new BytecodeDSLUncheckedAccess();
    }

    public abstract ByteArraySupport getByteArraySupport();

    public abstract FrameExtensions getFrameExtensions();

    public abstract int readInt(int[] var1, int var2);

    public abstract void writeInt(int[] var1, int var2, int var3);

    public abstract <T> T readObject(T[] var1, int var2);

    public abstract <T> void writeObject(T[] var1, int var2, T var3);

    public abstract <T> T uncheckedCast(Object var1, Class<T> var2);
}

