/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction.oned;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.eclipse.elk.alg.common.compaction.oned.CGraph;
import org.eclipse.elk.alg.common.compaction.oned.CGroup;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.ICompactionAlgorithm;
import org.eclipse.elk.alg.common.compaction.oned.IConstraintCalculationAlgorithm;
import org.eclipse.elk.alg.common.compaction.oned.ILockFunction;
import org.eclipse.elk.alg.common.compaction.oned.ISpacingsHandler;
import org.eclipse.elk.alg.common.compaction.oned.LongestPathCompaction;
import org.eclipse.elk.alg.common.compaction.oned.QuadraticConstraintCalculation;
import org.eclipse.elk.alg.common.compaction.oned.ScanlineConstraintCalculator;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.Pair;

public final class OneDimensionalCompactor {
    public static final ICompactionAlgorithm LONGEST_PATH_COMPACTION = new LongestPathCompaction();
    private ICompactionAlgorithm compactionAlgorithm = LONGEST_PATH_COMPACTION;
    public static final IConstraintCalculationAlgorithm SCANLINE_CONSTRAINTS = new ScanlineConstraintCalculator();
    public static final IConstraintCalculationAlgorithm QUADRATIC_CONSTRAINTS = new QuadraticConstraintCalculation();
    private IConstraintCalculationAlgorithm constraintAlgorithm = SCANLINE_CONSTRAINTS;
    public CGraph cGraph;
    public ILockFunction lockFun;
    public ISpacingsHandler spacingsHandler = ISpacingsHandler.DEFAULT_SPACING_HANDLER;
    public Direction direction = Direction.UNDEFINED;
    private boolean finished = false;

    public OneDimensionalCompactor(CGraph cGraph) {
        this.cGraph = cGraph;
        this.calculateGroupOffsets();
        for (CNode n : cGraph.cNodes) {
            if (n.cGroup == null) {
                CGroup.of().nodes(n).create(cGraph);
            }
            n.hitboxPreCompaction = new ElkRectangle(n.hitbox);
        }
    }

    public OneDimensionalCompactor setSpacingsHandler(ISpacingsHandler handler) {
        this.spacingsHandler = handler;
        return this;
    }

    public OneDimensionalCompactor setCompactionAlgorithm(ICompactionAlgorithm compactor) {
        this.compactionAlgorithm = compactor;
        return this;
    }

    public OneDimensionalCompactor setConstraintAlgorithm(IConstraintCalculationAlgorithm theConstraintAlgorithm) {
        this.constraintAlgorithm = theConstraintAlgorithm;
        return this;
    }

    public OneDimensionalCompactor compact() {
        if (this.finished) {
            throw new IllegalStateException("The " + this.getClass().getSimpleName() + " instance has been finished already.");
        }
        if (this.direction == Direction.UNDEFINED) {
            this.changeDirection(Direction.LEFT);
        }
        for (CGroup g : this.cGraph.cGroups) {
            g.outDegree = g.outDegreeReal;
        }
        for (CNode n : this.cGraph.cNodes) {
            n.startPos = Double.NEGATIVE_INFINITY;
        }
        this.compactionAlgorithm.compact(this);
        return this;
    }

    public OneDimensionalCompactor finish() {
        this.changeDirection(Direction.LEFT);
        this.finished = true;
        return this;
    }

    public OneDimensionalCompactor changeDirection(Direction dir) {
        if (this.finished) {
            throw new IllegalStateException("The " + this.getClass().getSimpleName() + " instance has been finished already.");
        }
        if (!this.cGraph.supports(dir)) {
            throw new RuntimeException("The direction " + String.valueOf((Object)dir) + " is not supported by the CGraph instance.");
        }
        if (dir == this.direction) {
            return this;
        }
        Direction oldDirection = this.direction;
        this.direction = dir;
        block0 : switch (oldDirection) {
            case UNDEFINED: {
                switch (dir) {
                    case LEFT: {
                        this.calculateConstraints();
                        break block0;
                    }
                    case RIGHT: {
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case UP: {
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                }
                break;
            }
            case LEFT: {
                switch (dir) {
                    case RIGHT: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                    case UP: {
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (dir) {
                    case LEFT: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                    case UP: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                }
                break;
            }
            case UP: {
                switch (dir) {
                    case LEFT: {
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case RIGHT: {
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case DOWN: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                }
                break;
            }
            case DOWN: {
                switch (dir) {
                    case LEFT: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case RIGHT: {
                        this.mirrorHitboxes();
                        this.transposeHitboxes();
                        this.mirrorHitboxes();
                        this.calculateConstraints();
                        break block0;
                    }
                    case UP: {
                        this.mirrorHitboxes();
                        this.reverseConstraints();
                        break block0;
                    }
                }
                break;
            }
        }
        return this;
    }

    public boolean isLocked(CGroup group, Direction dir) {
        for (CNode n : group.cNodes) {
            if (!this.isLocked(n, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocked(CNode node, Direction dir) {
        if (this.lockFun != null) {
            return this.lockFun.isLocked(node, dir);
        }
        return false;
    }

    public OneDimensionalCompactor setLockFunction(ILockFunction fun) {
        this.lockFun = fun;
        return this;
    }

    public OneDimensionalCompactor forceConstraintsRecalculation() {
        this.calculateConstraints();
        return this;
    }

    public OneDimensionalCompactor calculateGroupOffsets() {
        for (CGroup group : this.cGraph.cGroups) {
            group.reference = null;
            for (CNode n : group.cNodes) {
                n.cGroupOffset.reset();
                if (group.reference != null && !(n.hitbox.x < group.reference.hitbox.x)) continue;
                group.reference = n;
            }
            for (CNode n : group.cNodes) {
                n.cGroupOffset.x = n.hitbox.x - group.reference.hitbox.x;
                n.cGroupOffset.y = n.hitbox.y - group.reference.hitbox.y;
            }
        }
        return this;
    }

    private void mirrorHitboxes() {
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.hitbox.x = -cNode.hitbox.x - cNode.hitbox.width;
        }
        this.calculateGroupOffsets();
    }

    private void transposeHitboxes() {
        for (CNode cNode : this.cGraph.cNodes) {
            double tmp = cNode.hitbox.x;
            cNode.hitbox.x = cNode.hitbox.y;
            cNode.hitbox.y = tmp;
            tmp = cNode.hitbox.width;
            cNode.hitbox.width = cNode.hitbox.height;
            cNode.hitbox.height = tmp;
            tmp = cNode.cGroupOffset.x;
            cNode.cGroupOffset.x = cNode.cGroupOffset.y;
            cNode.cGroupOffset.y = tmp;
        }
        this.calculateGroupOffsets();
    }

    private void calculateConstraints() {
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.constraints.clear();
        }
        List<Pair<CNode, CNode>> cstrs = this.direction.isHorizontal() ? this.cGraph.predefinedHorizontalConstraints : this.cGraph.predefinedVerticalConstraints;
        cstrs.forEach(p -> {
            if (this.direction == Direction.LEFT || this.direction == Direction.UP) {
                ((CNode)p.getFirst()).constraints.add((CNode)p.getSecond());
            } else {
                ((CNode)p.getSecond()).constraints.add((CNode)p.getFirst());
            }
        });
        this.constraintAlgorithm.calculateConstraints(this);
        this.calculateConstraintsForCGroups();
    }

    private void calculateConstraintsForCGroups() {
        for (CGroup group : this.cGraph.cGroups) {
            group.outDegree = 0;
            group.outDegreeReal = 0;
            group.incomingConstraints.clear();
        }
        for (CGroup group : this.cGraph.cGroups) {
            for (CNode cNode : group.cNodes) {
                for (CNode inc : cNode.constraints) {
                    if (inc.cGroup == group) continue;
                    group.incomingConstraints.add(inc);
                    ++inc.cGroup.outDegree;
                    ++inc.cGroup.outDegreeReal;
                }
            }
        }
    }

    private void reverseConstraints() {
        HashMap incMap = Maps.newHashMap();
        for (CNode cNode : this.cGraph.cNodes) {
            incMap.put(cNode, Lists.newArrayList());
        }
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.startPos = Double.NEGATIVE_INFINITY;
            for (CNode inc : cNode.constraints) {
                ((List)incMap.get(inc)).add(cNode);
            }
        }
        for (CNode cNode : this.cGraph.cNodes) {
            cNode.constraints.clear();
            cNode.constraints = (List)incMap.get(cNode);
        }
        this.calculateConstraintsForCGroups();
    }
}

