/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nio;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.InputFileStdlib;
import net.sourceforge.plantuml.nio.NFolder;
import net.sourceforge.plantuml.preproc.Stdlib;

public final class NFolderStdlib
implements NFolder {
    private final Stdlib stdlib;
    private final Path pathInsideStdlib;

    public NFolderStdlib(Stdlib stdlib) {
        this(stdlib, Paths.get("", new String[0]));
    }

    private NFolderStdlib(Stdlib stdlib, Path pathInsideStdlib) {
        this.stdlib = Objects.requireNonNull(stdlib);
        this.pathInsideStdlib = Objects.requireNonNull(pathInsideStdlib).normalize();
    }

    @Override
    public InputFile getInputFile(Path nameOrPath) throws IOException {
        return new InputFileStdlib(this.stdlib, this.pathInsideStdlib.resolve(nameOrPath).normalize());
    }

    @Override
    public NFolder getSubfolder(Path nameOrPath) throws IOException {
        return new NFolderStdlib(this.stdlib, this.pathInsideStdlib.resolve(nameOrPath).normalize());
    }

    public String toString() {
        String prefix = this.pathInsideStdlib.toString().replace('\\', '/');
        return this.stdlib.getName() + "!" + prefix;
    }
}

