/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.ImmutableSortRemoveRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveRule
extends RelRule<Config>
implements TransformationRule {
    protected SortRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public SortRemoveRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (!call.getPlanner().getRelTraitDefs().contains(RelCollationTraitDef.INSTANCE)) {
            return;
        }
        Sort sort = (Sort)call.rel(0);
        if (sort.offset != null || sort.fetch != null) {
            return;
        }
        RelCollation collation = sort.getCollation();
        assert (collation == sort.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE));
        RelTraitSet traits = sort.getInput().getTraitSet().replace(collation).replaceIf(ConventionTraitDef.INSTANCE, sort::getConvention);
        call.transformTo(SortRemoveRule.convert(call.getPlanner(), sort.getInput(), traits));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortRemoveRule.Config.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs());

        @Override
        default public SortRemoveRule toRule() {
            return new SortRemoveRule(this);
        }
    }
}

