/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.gce;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.NetworkInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cloud.gce.GceInstancesService;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.discovery.SeedHostsProvider;
import org.opensearch.transport.TransportService;

public class GceSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(GceSeedHostsProvider.class);
    public static final Setting<List<String>> TAGS_SETTING = Setting.listSetting((String)"discovery.gce.tags", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private final GceInstancesService gceInstancesService;
    private TransportService transportService;
    private NetworkService networkService;
    private final String project;
    private final List<String> zones;
    private final List<String> tags;
    private final TimeValue refreshInterval;
    private long lastRefresh;
    private List<TransportAddress> cachedDynamicHosts;

    public GceSeedHostsProvider(Settings settings, GceInstancesService gceInstancesService, TransportService transportService, NetworkService networkService) {
        this.settings = settings;
        this.gceInstancesService = gceInstancesService;
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = (TimeValue)GceInstancesService.REFRESH_SETTING.get(settings);
        this.project = gceInstancesService.projectId();
        this.zones = gceInstancesService.zones();
        this.tags = (List)TAGS_SETTING.get(settings);
        if (logger.isDebugEnabled()) {
            logger.debug("using tags {}", this.tags);
        }
    }

    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        if (this.project == null || this.project.isEmpty() || this.zones == null || this.zones.isEmpty()) {
            throw new IllegalArgumentException("one or more gce discovery settings are missing. Check opensearch.yml file. Should have [" + GceInstancesService.PROJECT_SETTING.getKey() + "] and [" + GceInstancesService.ZONE_SETTING.getKey() + "].");
        }
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDynamicHosts != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("using cache to retrieve node list");
                }
                return this.cachedDynamicHosts;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        logger.debug("start building nodes list using GCE API");
        this.cachedDynamicHosts = new ArrayList<TransportAddress>();
        String ipAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddresses(((List)NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(this.settings)).toArray(Strings.EMPTY_ARRAY));
            if (inetAddress != null) {
                ipAddress = NetworkAddress.format((InetAddress)inetAddress);
            }
        }
        catch (IOException inetAddress) {
            // empty catch block
        }
        try {
            Collection<Instance> instances = this.gceInstancesService.instances();
            if (instances == null) {
                logger.trace("no instance found for project [{}], zones [{}].", (Object)this.project, this.zones);
                return this.cachedDynamicHosts;
            }
            for (Instance instance : instances) {
                String name = instance.getName();
                String type = instance.getMachineType();
                String status = instance.getStatus();
                logger.trace("gce instance {} with status {} found.", (Object)name, (Object)status);
                if ("TERMINATED".equals(status)) {
                    logger.debug("node {} is TERMINATED. Ignoring", (Object)name);
                    continue;
                }
                boolean filterByTag = false;
                if (!this.tags.isEmpty()) {
                    logger.trace("start filtering instance {} with tags {}.", (Object)name, this.tags);
                    if (instance.getTags() == null || instance.getTags().isEmpty() || instance.getTags().getItems() == null || instance.getTags().getItems().isEmpty()) {
                        logger.trace("no tags for this instance but we asked for tags. {} won't be part of the cluster.", (Object)name);
                        filterByTag = true;
                    } else {
                        logger.trace("comparing instance tags {} with tags filter {}.", (Object)instance.getTags().getItems(), this.tags);
                        for (String tag : this.tags) {
                            boolean found = false;
                            for (String instancetag : instance.getTags().getItems()) {
                                if (!instancetag.equals(tag)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            filterByTag = true;
                            break;
                        }
                    }
                }
                if (filterByTag) {
                    logger.trace("filtering out instance {} based tags {}, not part of {}", (Object)name, this.tags, (Object)(instance.getTags() == null || instance.getTags().getItems() == null ? "" : instance.getTags()));
                    continue;
                }
                logger.trace("instance {} with tags {} is added to discovery", (Object)name, this.tags);
                String ip_public = null;
                String ip_private = null;
                List interfaces = instance.getNetworkInterfaces();
                for (NetworkInterface networkInterface : interfaces) {
                    if (ip_public == null && networkInterface.getAccessConfigs() != null) {
                        for (AccessConfig accessConfig : networkInterface.getAccessConfigs()) {
                            if (!Strings.hasText((String)accessConfig.getNatIP())) continue;
                            ip_public = accessConfig.getNatIP();
                            break;
                        }
                    }
                    if (ip_private == null) {
                        ip_private = networkInterface.getNetworkIP();
                    }
                    if (ip_private == null || ip_public == null) continue;
                    break;
                }
                try {
                    TransportAddress[] addresses;
                    if (ip_private.equals(ipAddress)) {
                        logger.trace("current node found. Ignoring {} - {}", (Object)name, (Object)ip_private);
                        continue;
                    }
                    String address = ip_private;
                    if (instance.getMetadata() != null && instance.getMetadata().containsKey((Object)"opensearch_port")) {
                        Object opensearch_port = instance.getMetadata().get((Object)"opensearch_port");
                        logger.trace("opensearch_port is defined with {}", opensearch_port);
                        if (opensearch_port instanceof String) {
                            String osp = (String)opensearch_port;
                            address = address.concat(":").concat(osp);
                        } else {
                            logger.trace("opensearch_port is instance of {}. Ignoring...", (Object)opensearch_port.getClass().getName());
                        }
                    }
                    for (TransportAddress transportAddress : addresses = this.transportService.addressesFromString(address)) {
                        logger.trace("adding {}, type {}, address {}, transport_address {}, status {}", (Object)name, (Object)type, (Object)ip_private, (Object)transportAddress, (Object)status);
                        this.cachedDynamicHosts.add(transportAddress);
                    }
                }
                catch (Exception e) {
                    String finalIpPrivate = ip_private;
                    logger.warn(() -> new ParameterizedMessage("failed to add {}, address {}", (Object)name, (Object)finalIpPrivate), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.warn("exception caught during discovery", (Throwable)e);
        }
        logger.debug("{} addresses added", (Object)this.cachedDynamicHosts.size());
        logger.debug("using transport addresses {}", this.cachedDynamicHosts);
        return this.cachedDynamicHosts;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

