/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.scan;

import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.response.QueryExemplarsFunctionResponseHandle;
import org.opensearch.sql.prometheus.request.PrometheusQueryExemplarsRequest;
import org.opensearch.sql.storage.TableScanOperator;

public class QueryExemplarsFunctionTableScanOperator
extends TableScanOperator {
    private final PrometheusClient prometheusClient;
    private final PrometheusQueryExemplarsRequest request;
    private QueryExemplarsFunctionResponseHandle queryExemplarsFunctionResponseHandle;
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public void open() {
        super.open();
        this.queryExemplarsFunctionResponseHandle = AccessController.doPrivileged(() -> {
            try {
                JSONArray responseArray = this.prometheusClient.queryExemplars(this.request.getQuery(), this.request.getStartTime(), this.request.getEndTime());
                return new QueryExemplarsFunctionResponseHandle(responseArray);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException(String.format("Error fetching data from prometheus server: %s", e.getMessage()));
            }
        });
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public boolean hasNext() {
        return this.queryExemplarsFunctionResponseHandle.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.queryExemplarsFunctionResponseHandle.next();
    }

    @Override
    public String explain() {
        return String.format(Locale.ROOT, "query_exemplars(%s, %s, %s)", this.request.getQuery(), this.request.getStartTime(), this.request.getEndTime());
    }

    @Override
    public ExecutionEngine.Schema schema() {
        return this.queryExemplarsFunctionResponseHandle.schema();
    }

    @Generated
    public QueryExemplarsFunctionTableScanOperator(PrometheusClient prometheusClient, PrometheusQueryExemplarsRequest request) {
        this.prometheusClient = prometheusClient;
        this.request = request;
    }

    @Generated
    public PrometheusQueryExemplarsRequest getRequest() {
        return this.request;
    }
}

