/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rule.RuleEntityParser;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.Rule;

@ExperimentalApi
public class XContentRuleParser
implements RuleEntityParser {
    private final FeatureType featureType;
    private static final Logger logger = LogManager.getLogger(XContentRuleParser.class);

    public XContentRuleParser(FeatureType featureType) {
        this.featureType = featureType;
    }

    @Override
    public Rule parse(String src) {
        Rule rule;
        block8: {
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, src);
            try {
                rule = Rule.Builder.fromXContent(parser, this.featureType).build();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.info("Issue met when parsing rule : {}", (Object)e.getMessage());
                    throw new RuntimeException("Cannot parse rule from index.");
                }
            }
            parser.close();
        }
        return rule;
    }
}

