/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.broadcast;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class BroadcastRequest<Request extends BroadcastRequest<Request>>
extends ActionRequest
implements IndicesRequest.Replaceable {
    protected String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();
    protected boolean shouldCancelOnTimeout = false;
    private final TimeValue DEFAULT_TIMEOUT_SECONDS = TimeValue.timeValueSeconds((long)30L);
    private TimeValue timeout;

    public BroadcastRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    protected BroadcastRequest(String ... indices) {
        this.indices = indices;
    }

    protected BroadcastRequest(String[] indices, IndicesOptions indicesOptions) {
        this.indices = indices;
        this.indicesOptions = indicesOptions;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public final Request indices(String ... indices) {
        this.indices = indices;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, (TimeValue)this.DEFAULT_TIMEOUT_SECONDS, (String)(this.getClass().getSimpleName() + ".timeout"));
        return (Request)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final Request indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (Request)this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    public void setShouldCancelOnTimeout(boolean shouldCancelOnTimeout) {
        this.shouldCancelOnTimeout = shouldCancelOnTimeout;
    }

    public boolean getShouldCancelOnTimeout() {
        return this.shouldCancelOnTimeout;
    }
}

