/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MathUtil;

public class DocBaseBitSetIterator
extends AbstractDocIdSetIterator {
    private final FixedBitSet bits;
    private final int length;
    private final long cost;
    private final int docBase;

    public DocBaseBitSetIterator(FixedBitSet bits, long cost, int docBase) {
        if (cost < 0L) {
            throw new IllegalArgumentException("cost must be >= 0, got " + cost);
        }
        if ((docBase & 0x3F) != 0) {
            throw new IllegalArgumentException("docBase need to be a multiple of 64, got " + docBase);
        }
        this.bits = bits;
        this.length = bits.length() + docBase;
        this.cost = cost;
        this.docBase = docBase;
    }

    public FixedBitSet getBitSet() {
        return this.bits;
    }

    public int getDocBase() {
        return this.docBase;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        if (target >= this.length) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        int next = this.bits.nextSetBit(Math.max(0, target - this.docBase));
        if (next == Integer.MAX_VALUE) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = next + this.docBase;
        return this.doc;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        int actualUpto = Math.min(upTo, this.length);
        if ((actualUpto = MathUtil.unsignedMin(actualUpto, offset + bitSet.length())) > this.doc) {
            FixedBitSet.orRange(this.bits, this.doc - this.docBase, bitSet, this.doc - offset, actualUpto - this.doc);
            this.advance(actualUpto);
        }
        super.intoBitSet(upTo, bitSet, offset);
    }
}

