/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskTreebank
extends Treebank {
    private static boolean PRINT_FILENAMES = false;
    private final List<File> filePaths = new ArrayList<File>();
    private final List<FileFilter> fileFilters = new ArrayList<FileFilter>();
    private File currentFile;

    public DiskTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public DiskTreebank(String encoding) {
        this(new LabeledScoredTreeReaderFactory(), encoding);
    }

    public DiskTreebank(TreeReaderFactory trf) {
        super(trf);
    }

    public DiskTreebank(TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
    }

    public DiskTreebank(int initialCapacity) {
        this(initialCapacity, new LabeledScoredTreeReaderFactory());
    }

    public DiskTreebank(int initialCapacity, TreeReaderFactory trf) {
        this(trf);
    }

    @Override
    public void clear() {
        this.filePaths.clear();
        this.fileFilters.clear();
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        if (path.exists()) {
            this.filePaths.add(path);
            this.fileFilters.add(filt);
        } else {
            System.err.printf("%s: File/path %s does not exist. Skipping.\n", this.getClass().getName(), path.getPath());
        }
    }

    @Override
    public void apply(TreeVisitor tp) {
        for (Tree t : this) {
            tp.visitTree(t);
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public List<File> getCurrentPaths() {
        return Collections.unmodifiableList(this.filePaths);
    }

    public void printFileNames() {
        PRINT_FILENAMES = true;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new DiskTreebankIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiskTreebankIterator
    implements Iterator<Tree> {
        private TreeReader tr = null;
        private Tree storedTree = null;
        private final List<File> localPathList;
        private final List<FileFilter> localFilterList;
        private int fileListPtr = 0;
        private File currentFile;
        private int curLineId = 1;
        private List<File> curFileList;
        private Iterator<File> curPathIter;

        private DiskTreebankIterator() {
            this.localPathList = new ArrayList<File>(DiskTreebank.this.filePaths);
            this.localFilterList = new ArrayList<FileFilter>(DiskTreebank.this.fileFilters);
            if (this.primeNextPath() && this.primeNextFile()) {
                this.storedTree = this.primeNextTree();
            }
        }

        private boolean primeNextPath() {
            while (this.fileListPtr < this.localPathList.size() && this.fileListPtr < this.localFilterList.size()) {
                File nextPath = this.localPathList.get(this.fileListPtr);
                FileFilter nextFilter = this.localFilterList.get(this.fileListPtr);
                ++this.fileListPtr;
                List<File> pathListing = nextPath.isDirectory() ? Arrays.asList(nextPath.listFiles(nextFilter)) : Collections.singletonList(nextPath);
                if (pathListing == null) continue;
                if (pathListing.size() > 1) {
                    Collections.sort(pathListing);
                }
                this.curFileList = new ArrayList<File>();
                for (File path : pathListing) {
                    if (path.isDirectory()) {
                        this.localPathList.add(path);
                        this.localFilterList.add(nextFilter);
                        continue;
                    }
                    this.curFileList.add(path);
                }
                if (this.curFileList.size() == 0) continue;
                this.curPathIter = this.curFileList.iterator();
                return true;
            }
            return false;
        }

        private boolean primeNextFile() {
            try {
                if (this.curPathIter.hasNext() || this.primeNextPath() && this.curPathIter.hasNext()) {
                    this.currentFile = this.curPathIter.next();
                    if (PRINT_FILENAMES) {
                        System.err.println(this.currentFile);
                    }
                    if (this.tr != null) {
                        this.tr.close();
                    }
                    this.tr = DiskTreebank.this.treeReaderFactory().newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.currentFile), DiskTreebank.this.encoding())));
                    this.curLineId = 1;
                    return true;
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.printf("%s: Filesystem does not support encoding:\n%s\n", this.getClass().getName(), e.toString());
                throw new RuntimeException(e);
            }
            catch (FileNotFoundException e) {
                System.err.printf("%s: File does not exist:\n%s\n", this.getClass().getName(), e.toString());
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                System.err.printf("%s: Unable to close open tree reader:\n%s\n", this.getClass().getName(), this.currentFile.getPath());
                throw new RuntimeException(e);
            }
            return false;
        }

        private Tree primeNextTree() {
            Tree t = null;
            try {
                t = this.tr.readTree();
                if (t == null && this.primeNextFile()) {
                    t = this.tr.readTree();
                }
                if (t != null && t.label() != null && t.label() instanceof HasIndex) {
                    HasIndex lab = (HasIndex)((Object)t.label());
                    lab.setSentIndex(this.curLineId++);
                    lab.setDocID(this.currentFile.getName());
                }
            }
            catch (IOException e) {
                System.err.printf("%s: Error reading from file %s:\n%s\n", this.getClass().getName(), this.currentFile.getPath(), e.toString());
                throw new RuntimeException(e);
            }
            return t;
        }

        @Override
        public boolean hasNext() {
            return this.storedTree != null;
        }

        @Override
        public Tree next() {
            if (this.storedTree == null) {
                throw new NoSuchElementException();
            }
            Tree ret = this.storedTree;
            this.storedTree = this.primeNextTree();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

