/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.slf4j.Logger;

public class DelayedFuture<T>
extends DelayedOperation {
    private final Logger log = new LogContext().logger(DelayedFuture.class.getName());
    private final List<CompletableFuture<T>> futures;
    private final Runnable responseCallback;
    private final long timeoutMs;

    public DelayedFuture(long timeoutMs, List<CompletableFuture<T>> futures, Runnable responseCallback) {
        super(timeoutMs);
        this.timeoutMs = timeoutMs;
        this.futures = futures;
        this.responseCallback = responseCallback;
    }

    public boolean tryComplete() {
        this.log.trace("Trying to complete operation for {} futures", (Object)this.futures.size());
        long pending = this.futures.stream().filter(future -> !future.isDone()).count();
        if (pending == 0L) {
            this.log.trace("All futures have been completed or have errors, completing the delayed operation");
            return this.forceComplete();
        }
        this.log.trace("{} future still pending, not completing the delayed operation", (Object)pending);
        return false;
    }

    public void onComplete() {
        List<CompletableFuture> pendingFutures = this.futures.stream().filter(future -> !future.isDone()).toList();
        this.log.trace("Completing operation for {} futures, expired {}", (Object)this.futures.size(), (Object)pendingFutures.size());
        pendingFutures.forEach(future -> future.completeExceptionally((Throwable)new TimeoutException("Request has been timed out after " + this.timeoutMs + " ms")));
        this.responseCallback.run();
    }

    public void onExpiration() {
    }
}

