/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Remove local maxima not connected to the boundary of the image.


GrayscaleGrindPeakImageFilter removes peaks in a grayscale image. Peaks are local maxima in the
grayscale topography that are not connected to boundaries of the
image. Gray level values adjacent to a peak are extrapolated through
the peak.

This filter is used to smooth over local maxima without affecting the
values of local minima. If you take the difference between the output
of this filter and the original image (and perhaps threshold the
difference above a small value), you'll obtain a map of the local
maxima.

This filter uses the GrayscaleGeodesicDilateImageFilter . It provides its own input as the "mask" input to the geodesic
erosion. The "marker" image for the geodesic erosion is constructed
such that boundary pixels match the boundary pixels of the input image
and the interior pixels are set to the minimum pixel value in the
input image.

This filter is the dual to the GrayscaleFillholeImageFilter which implements the Fillhole algorithm. Since it is a dual, it is
somewhat superfluous but is provided as a convenience.

Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleGrindPeak for the procedural interface

 itk::GrayscaleGrindPeakImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleGrindPeakImageFilter.h
*/
public class GrayscaleGrindPeakImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleGrindPeakImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleGrindPeakImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleGrindPeakImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleGrindPeakImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleGrindPeakImageFilter::~GrayscaleGrindPeakImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleGrindPeakImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleGrindPeakImageFilter::GrayscaleGrindPeakImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleGrindPeakImageFilter() {
    this(SimpleITKJNI.new_GrayscaleGrindPeakImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleGrindPeakImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.GrayscaleGrindPeakImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::GrayscaleGrindPeakImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.GrayscaleGrindPeakImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleGrindPeakImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.GrayscaleGrindPeakImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleGrindPeakImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.GrayscaleGrindPeakImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleGrindPeakImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleGrindPeakImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleGrindPeakImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleGrindPeakImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleGrindPeakImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GrayscaleGrindPeakImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
