/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import shadow.bundletool.com.android.zipflinger.BytesSource;
import shadow.bundletool.com.android.zipflinger.LargeFileSource;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.StreamSource;

public class Sources {
    public static final int LARGE_LIMIT = 100000000;

    public static Source from(File file2, String name, int compressionLevel) throws IOException {
        return Sources.from(file2.toPath(), name, compressionLevel);
    }

    public static Source from(Path path, String name, int compressionLevel) throws IOException {
        if (Files.size(path) > 100000000L) {
            return new LargeFileSource(path, name, compressionLevel);
        }
        return new BytesSource(path, name, compressionLevel);
    }

    public static Source from(InputStream in4, String name, int compressionLevel) throws IOException {
        return Sources.from(in4, name, compressionLevel, 100000000);
    }

    public static Source from(InputStream in4, String name, int compressionLevel, int largeLimit) throws IOException {
        return new StreamSource(in4, name, compressionLevel, largeLimit);
    }
}

