/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import shadow.bundletool.com.android.ProgressManagerAdapter;
import shadow.bundletool.com.android.annotations.concurrency.Slow;

public class CancellableFileIo {
    @Slow
    public static boolean exists(Path file2, LinkOption ... options) {
        ProgressManagerAdapter.checkCanceled();
        return Files.exists(file2, options);
    }

    @Slow
    public static boolean notExists(Path file2, LinkOption ... options) {
        ProgressManagerAdapter.checkCanceled();
        return Files.notExists(file2, options);
    }

    @Slow
    public static boolean isDirectory(Path file2, LinkOption ... options) {
        ProgressManagerAdapter.checkCanceled();
        return Files.isDirectory(file2, options);
    }

    @Slow
    public static boolean isRegularFile(Path file2, LinkOption ... options) {
        ProgressManagerAdapter.checkCanceled();
        return Files.isRegularFile(file2, options);
    }

    @Slow
    public static boolean isSymbolicLink(Path file2) {
        ProgressManagerAdapter.checkCanceled();
        return Files.isSymbolicLink(file2);
    }

    @Slow
    public static boolean isReadable(Path file2) {
        ProgressManagerAdapter.checkCanceled();
        return Files.isReadable(file2);
    }

    @Slow
    public static boolean isWritable(Path file2) {
        ProgressManagerAdapter.checkCanceled();
        return Files.isWritable(file2);
    }

    @Slow
    public static boolean isExecutable(Path file2) {
        ProgressManagerAdapter.checkCanceled();
        return Files.isExecutable(file2);
    }

    @Slow
    public static boolean isHidden(Path file2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.isHidden(file2);
    }

    @Slow
    public static boolean isSameFile(Path path1, Path path2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.isSameFile(path1, path2);
    }

    @Slow
    public static long size(Path file2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.size(file2);
    }

    @Slow
    public static FileTime getLastModifiedTime(Path file2, LinkOption ... options) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.getLastModifiedTime(file2, options);
    }

    @Slow
    public static Object getAttribute(Path file2, String attribute, LinkOption ... options) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.getAttribute(file2, attribute, options);
    }

    @Slow
    public static <A extends BasicFileAttributes> A readAttributes(Path file2, Class<A> type, LinkOption ... options) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.readAttributes(file2, type, options);
    }

    @Slow
    public static Stream<Path> list(Path dir) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.list(dir);
    }

    @Slow
    public static Stream<Path> walk(Path start, FileVisitOption ... options) throws IOException {
        return CancellableFileIo.walk(start, Integer.MAX_VALUE, options);
    }

    @Slow
    public static Stream<Path> walk(Path start, int maxDepth, FileVisitOption ... options) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.walk(start, maxDepth, options).filter(path -> {
            ProgressManagerAdapter.checkCanceled();
            return true;
        });
    }

    @Slow
    public static Path walkFileTree(Path start, Set<FileVisitOption> options, int maxDepth, final FileVisitor<? super Path> visitor2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.walkFileTree(start, options, maxDepth, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ProgressManagerAdapter.checkCanceled();
                return visitor2.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                return visitor2.visitFile(file2, attrs);
            }

            @Override
            public FileVisitResult visitFileFailed(Path file2, IOException exc) throws IOException {
                return visitor2.visitFileFailed(file2, exc);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return visitor2.postVisitDirectory(dir, exc);
            }
        });
    }

    @Slow
    public static Path walkFileTree(Path start, FileVisitor<? super Path> visitor2) throws IOException {
        return CancellableFileIo.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, visitor2);
    }

    @Slow
    public static InputStream newInputStream(Path file2, OpenOption ... options) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.newInputStream(file2, options);
    }

    @Slow
    public static BufferedReader newBufferedReader(Path file2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.newBufferedReader(file2);
    }

    @Slow
    public static SeekableByteChannel newByteChannel(Path file2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.newByteChannel(file2, options, attrs);
    }

    @Slow
    public static SeekableByteChannel newByteChannel(Path file2, OpenOption ... options) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.newByteChannel(file2, options);
    }

    @Slow
    public static byte[] readAllBytes(Path file2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.readAllBytes(file2);
    }

    @Slow
    public static List<String> readAllLines(Path file2) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.readAllLines(file2, StandardCharsets.UTF_8);
    }

    @Slow
    public static List<String> readAllLines(Path file2, Charset cs4) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.readAllLines(file2, cs4);
    }

    @Slow
    public static String readString(Path file2) throws IOException {
        return new String(CancellableFileIo.readAllBytes(file2), StandardCharsets.UTF_8);
    }

    @Slow
    public static Path readSymbolicLink(Path link) throws IOException {
        ProgressManagerAdapter.checkCanceled();
        return Files.readSymbolicLink(link);
    }
}

