/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STCompiletimeMessage;
import org.stringtemplate.v4.misc.STGroupCompiletimeMessage;
import org.stringtemplate.v4.misc.STLexerMessage;
import org.stringtemplate.v4.misc.STMessage;
import org.stringtemplate.v4.misc.STRuntimeMessage;

public class ErrorManager {
    public static STErrorListener DEFAULT_ERROR_LISTENER = new STErrorListener(){

        public void compileTimeError(STMessage msg) {
            System.err.println(msg);
        }

        public void runTimeError(STMessage msg) {
            if (msg.error != ErrorType.NO_SUCH_PROPERTY) {
                System.err.println(msg);
            }
        }

        public void IOError(STMessage msg) {
            System.err.println(msg);
        }

        public void internalError(STMessage msg) {
            System.err.println(msg);
        }

        public void error(String s15) {
            this.error(s15, null);
        }

        public void error(String s15, Throwable e15) {
            System.err.println(s15);
            if (e15 != null) {
                e15.printStackTrace(System.err);
            }
        }
    };
    public final STErrorListener listener;

    public ErrorManager() {
        this(DEFAULT_ERROR_LISTENER);
    }

    public ErrorManager(STErrorListener listener) {
        this.listener = listener;
    }

    public void compileTimeError(ErrorType error, Token templateToken, Token t15) {
        CharStream input = t15.getInputStream();
        String srcName = null;
        if (input != null && (srcName = input.getSourceName()) != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STCompiletimeMessage(error, srcName, templateToken, t15, null, (Object)t15.getText()));
    }

    public void lexerError(String srcName, String msg, Token templateToken, RecognitionException e15) {
        if (srcName != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STLexerMessage(srcName, msg, templateToken, e15));
    }

    public void compileTimeError(ErrorType error, Token templateToken, Token t15, Object arg) {
        String srcName = t15.getInputStream().getSourceName();
        if (srcName != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STCompiletimeMessage(error, srcName, templateToken, t15, null, arg));
    }

    public void compileTimeError(ErrorType error, Token templateToken, Token t15, Object arg, Object arg2) {
        String srcName = t15.getInputStream().getSourceName();
        if (srcName != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STCompiletimeMessage(error, srcName, templateToken, t15, null, arg, arg2));
    }

    public void groupSyntaxError(ErrorType error, String srcName, RecognitionException e15, String msg) {
        Token t15 = e15.token;
        this.listener.compileTimeError(new STGroupCompiletimeMessage(error, srcName, e15.token, e15, (Object)msg));
    }

    public void groupLexerError(ErrorType error, String srcName, RecognitionException e15, String msg) {
        this.listener.compileTimeError(new STGroupCompiletimeMessage(error, srcName, e15.token, e15, (Object)msg));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Object arg) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, arg));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Throwable e15, Object arg) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, e15, arg));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Object arg, Object arg2) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, null, arg, arg2));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Object arg, Object arg2, Object arg3) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, null, arg, arg2, arg3));
    }

    public void IOError(ST self, ErrorType error, Throwable e15) {
        this.listener.IOError(new STMessage(error, self, e15));
    }

    public void IOError(ST self, ErrorType error, Throwable e15, Object arg) {
        this.listener.IOError(new STMessage(error, self, e15, arg));
    }

    public void internalError(ST self, String msg, Throwable e15) {
        this.listener.internalError(new STMessage(ErrorType.INTERNAL_ERROR, self, e15, msg));
    }
}

