/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;

public class WrappedSyntaxView
extends BoxView
implements TabExpander,
RSTAView {
    private int tabBase;
    private int tabSize;
    private Segment s;
    private Segment drawSeg;
    private Rectangle tempRect;
    private RSyntaxTextArea host;
    private FontMetrics metrics;
    private TokenImpl tempToken = new TokenImpl();
    private TokenImpl lineCountTempToken;
    private static final int MIN_WIDTH = 20;

    public WrappedSyntaxView(Element elem) {
        super(elem, 1);
        this.s = new Segment();
        this.drawSeg = new Segment();
        this.tempRect = new Rectangle();
        this.lineCountTempToken = new TokenImpl();
    }

    protected int calculateBreakPosition(int p05, Token tokenList, float x05) {
        int p15 = p05;
        RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
        float currentWidth = this.getWidth();
        if (currentWidth == 2.1474836E9f) {
            currentWidth = this.getPreferredSpan(0);
        }
        currentWidth = Math.max(currentWidth, 20.0f);
        for (Token t15 = tokenList; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            float tokenWidth = t15.getWidth(textArea, this, x05);
            if (tokenWidth > currentWidth) {
                if (p15 == p05) {
                    return t15.getOffsetBeforeX(textArea, this, 0.0f, currentWidth);
                }
                return t15.isWhitespace() ? p15 + t15.length() : p15;
            }
            currentWidth -= tokenWidth;
            x05 += tokenWidth;
            p15 += t15.length();
        }
        return p15 + 1;
    }

    @Override
    public void changedUpdate(DocumentEvent e15, Shape a15, ViewFactory f15) {
        this.updateChildren(e15, a15);
    }

    private void childAllocation2(int line, int y15, Rectangle alloc) {
        alloc.x += this.getOffset(0, line);
        alloc.y += y15;
        alloc.width = this.getSpan(0, line);
        alloc.height = this.getSpan(1, line);
        Insets margin = this.host.getMargin();
        if (margin != null) {
            alloc.y -= margin.top;
        }
    }

    protected void drawView(TokenPainter painter, Graphics2D g15, Rectangle r15, View view, int fontHeight, int y15, int line) {
        float x15 = r15.x;
        RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = this.getElement();
        int p05 = view.getStartOffset();
        int lineNumber = map.getElementIndex(p05);
        int p15 = view.getEndOffset();
        this.setSegment(p05, p15 - 1, document, this.drawSeg);
        int start = p05 - this.drawSeg.offset;
        Token token = document.getTokenListForLine(lineNumber);
        if (token != null && token.getType() == 0) {
            h15.paintLayeredHighlights(g15, p05, p15, r15, this.host, this);
            return;
        }
        while (token != null && token.isPaintable()) {
            int p16 = this.calculateBreakPosition(p05, token, x15);
            x15 = r15.x;
            h15.paintLayeredHighlights(g15, p05, p16, r15, this.host, this);
            while (token != null && token.isPaintable() && token.getEndOffset() - 1 < p16) {
                boolean paintBG = this.host.getPaintTokenBackgrounds(line, y15);
                x15 = painter.paint(token, g15, x15, y15, this.host, this, 0.0f, paintBG);
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.getOffset() < p16) {
                int tokenOffset = token.getOffset();
                this.tempToken.set(this.drawSeg.array, tokenOffset - start, p16 - 1 - start, tokenOffset, token.getType());
                this.tempToken.setLanguageIndex(token.getLanguageIndex());
                boolean paintBG = this.host.getPaintTokenBackgrounds(line, y15);
                painter.paint(this.tempToken, g15, x15, y15, this.host, this, 0.0f, paintBG);
                this.tempToken.copyFrom(token);
                this.tempToken.makeStartAt(p16);
                token = new TokenImpl(this.tempToken);
            }
            h15.paintParserHighlights(g15, p05, p16, r15, this.host, this);
            p05 = p16 == p05 ? p15 : p16;
            y15 += fontHeight;
        }
        if (this.host.getEOLMarkersVisible()) {
            SyntaxView.drawEOLMarker(this.host, g15, x15, (float)y15 - (float)fontHeight);
        }
    }

    protected void drawViewWithSelection(TokenPainter painter, Graphics2D g15, Rectangle r15, View view, int fontHeight, int y15, int selStart, int selEnd) {
        float x15 = r15.x;
        boolean useSTC = this.host.getUseSelectedTextColor();
        RSyntaxTextAreaHighlighter h15 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = this.getElement();
        int p05 = view.getStartOffset();
        int lineNumber = map.getElementIndex(p05);
        int p15 = view.getEndOffset();
        this.setSegment(p05, p15 - 1, document, this.drawSeg);
        int start = p05 - this.drawSeg.offset;
        Token token = document.getTokenListForLine(lineNumber);
        if (token != null && token.getType() == 0) {
            h15.paintLayeredHighlights(g15, p05, p15, r15, this.host, this);
            return;
        }
        while (token != null && token.isPaintable()) {
            int p16 = this.calculateBreakPosition(p05, token, x15);
            x15 = r15.x;
            h15.paintLayeredHighlights(g15, p05, p16, r15, this.host, this);
            while (token != null && token.isPaintable() && token.getEndOffset() - 1 < p16) {
                x15 = SyntaxView.drawTokenWithSelection(painter, token, g15, x15, y15, selStart, selEnd, this.host, this, 0.0f);
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.getOffset() < p16) {
                int tokenOffset = token.getOffset();
                Token orig = token;
                token = new TokenImpl(this.drawSeg, tokenOffset - start, p16 - 1 - start, tokenOffset, token.getType(), token.getLanguageIndex());
                token.setLanguageIndex(token.getLanguageIndex());
                if (token.containsPosition(selStart)) {
                    int selCount;
                    if (selStart > token.getOffset()) {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selStart - this.tempToken.getOffset();
                        x15 = painter.paint(this.tempToken, g15, x15, y15, this.host, this);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(selStart);
                        token = new TokenImpl(this.tempToken);
                    }
                    if ((selCount = Math.min(token.length(), selEnd - token.getOffset())) == token.length()) {
                        x15 = painter.paintSelected(token, g15, x15, y15, this.host, this, useSTC);
                    } else {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selCount;
                        x15 = painter.paintSelected(this.tempToken, g15, x15, y15, this.host, this, useSTC);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(token.getOffset() + selCount);
                        token = this.tempToken;
                        x15 = painter.paint(token, g15, x15, y15, this.host, this);
                    }
                } else if (token.containsPosition(selEnd)) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                    x15 = painter.paintSelected(this.tempToken, g15, x15, y15, this.host, this, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selEnd);
                    token = this.tempToken;
                    x15 = painter.paint(token, g15, x15, y15, this.host, this);
                } else {
                    x15 = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g15, x15, y15, this.host, this, useSTC) : painter.paint(token, g15, x15, y15, this.host, this);
                }
                token = new TokenImpl(orig);
                ((TokenImpl)token).makeStartAt(p16);
            }
            h15.paintParserHighlights(g15, p05, p16, r15, this.host, this);
            p05 = p16 == p05 ? p15 : p16;
            y15 += fontHeight;
        }
        if (this.host.getEOLMarkersVisible()) {
            SyntaxView.drawEOLMarker(this.host, g15, x15, (float)y15 - (float)fontHeight);
        }
    }

    @Override
    public Shape getChildAllocation(int index, Shape a15) {
        if (a15 != null) {
            Shape ca5 = this.getChildAllocationImpl(index, a15);
            if (ca5 != null && !this.isAllocationValid()) {
                Rectangle r15;
                Rectangle rectangle = r15 = ca5 instanceof Rectangle ? (Rectangle)ca5 : ca5.getBounds();
                if (r15.width == 0 && r15.height == 0) {
                    return null;
                }
            }
            return ca5;
        }
        return null;
    }

    public Shape getChildAllocationImpl(int line, Shape a15) {
        Rectangle alloc = this.getInsideAllocation(a15);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager fm4 = this.host.getFoldManager();
        int y15 = alloc.y;
        for (int i15 = 0; i15 < line; ++i15) {
            y15 += this.getSpan(1, i15);
            Fold fold = fm4.getFoldForLine(i15);
            if (fold == null || !fold.isCollapsed()) continue;
            i15 += fold.getCollapsedLineCount();
        }
        this.childAllocation2(line, y15, alloc);
        return alloc;
    }

    private float getEOLMarkerWidth(RSyntaxTextArea textArea) {
        return this.metrics.stringWidth("\u00b6");
    }

    @Override
    public float getMaximumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += this.getEOLMarkerWidth(this.host);
        }
        return span;
    }

    @Override
    public float getMinimumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += this.getEOLMarkerWidth(this.host);
        }
        return span;
    }

    @Override
    public float getPreferredSpan(int axis) {
        float span;
        this.updateMetrics();
        if (axis == 0) {
            span = super.getPreferredSpan(axis);
            span += this.getEOLMarkerWidth(this.host);
        } else {
            span = super.getPreferredSpan(axis);
            this.host = (RSyntaxTextArea)this.getContainer();
            if (this.host.isCodeFoldingEnabled()) {
                int lineCount = this.host.getLineCount();
                FoldManager fm4 = this.host.getFoldManager();
                for (int i15 = 0; i15 < lineCount; ++i15) {
                    if (!fm4.isLineHidden(i15)) continue;
                    span -= (float)this.getSpan(1, i15);
                }
            }
        }
        return span;
    }

    protected int getTabSize() {
        Integer i15 = (Integer)this.getDocument().getProperty("tabSize");
        int size = i15 != null ? i15 : 5;
        return size;
    }

    @Override
    protected View getViewAtPoint(int x15, int y15, Rectangle alloc) {
        int lineCount = this.getViewCount();
        int curY = alloc.y + this.getOffset(1, 0);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager fm4 = this.host.getFoldManager();
        for (int line = 1; line < lineCount; ++line) {
            int span = this.getSpan(1, line - 1);
            if (y15 < curY + span) {
                this.childAllocation2(line - 1, curY, alloc);
                return this.getView(line - 1);
            }
            curY += span;
            Fold fold = fm4.getFoldForLine(line - 1);
            if (fold == null || !fold.isCollapsed()) continue;
            line += fold.getCollapsedLineCount();
        }
        this.childAllocation2(lineCount - 1, curY, alloc);
        return this.getView(lineCount - 1);
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a15, ViewFactory f15) {
        this.updateChildren(changes, a15);
        Rectangle alloc = a15 != null && this.isAllocationValid() ? this.getInsideAllocation(a15) : null;
        int pos = changes.getOffset();
        View v15 = this.getViewAtPosition(pos, alloc);
        if (v15 != null) {
            v15.insertUpdate(changes, alloc, f15);
        }
    }

    @Override
    protected void loadChildren(ViewFactory f15) {
        Element e15 = this.getElement();
        int n15 = e15.getElementCount();
        if (n15 > 0) {
            View[] added = new View[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                added[i15] = new WrappedLine(e15.getElement(i15));
            }
            this.replace(0, 0, added);
        }
    }

    @Override
    public Shape modelToView(int pos, Shape a15, Position.Bias b15) throws BadLocationException {
        View v15;
        int testPos;
        if (!this.isAllocationValid()) {
            Rectangle alloc = a15.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        boolean isBackward = b15 == Position.Bias.Backward;
        int n15 = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        if (vIndex != -1 && vIndex < this.getViewCount() && (v15 = this.getView(vIndex)) != null && testPos >= v15.getStartOffset() && testPos < v15.getEndOffset()) {
            Shape childShape = this.getChildAllocation(vIndex, a15);
            if (childShape == null) {
                return null;
            }
            Shape retShape = v15.modelToView(pos, childShape, b15);
            if (retShape == null && v15.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v15 = this.getView(vIndex);
                retShape = v15.modelToView(pos, this.getChildAllocation(vIndex, a15), b15);
            }
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    @Override
    public Shape modelToView(int p05, Position.Bias b05, int p15, Position.Bias b15, Shape a15) throws BadLocationException {
        Rectangle r15;
        Shape s15;
        Shape s05 = this.modelToView(p05, a15, b05);
        if (p15 == this.getEndOffset()) {
            try {
                s15 = this.modelToView(p15, a15, b15);
            }
            catch (BadLocationException ble) {
                s15 = null;
            }
            if (s15 == null) {
                Rectangle alloc = a15 instanceof Rectangle ? (Rectangle)a15 : a15.getBounds();
                s15 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s15 = this.modelToView(p15, a15, b15);
        }
        Rectangle r05 = s05.getBounds();
        Rectangle rectangle = r15 = s15 instanceof Rectangle ? (Rectangle)s15 : s15.getBounds();
        if (r05.y != r15.y) {
            Rectangle alloc = a15 instanceof Rectangle ? (Rectangle)a15 : a15.getBounds();
            r05.x = alloc.x;
            r05.width = alloc.width;
        }
        r05.add(r15);
        if (p15 > p05) {
            r05.width -= r15.width;
        }
        return r05;
    }

    @Override
    public float nextTabStop(float x15, int tabOffset) {
        if (this.tabSize == 0) {
            return x15;
        }
        int ntabs = ((int)x15 - this.tabBase) / this.tabSize;
        return (float)this.tabBase + ((float)ntabs + 1.0f) * (float)this.tabSize;
    }

    @Override
    public void paint(Graphics g15, Shape a15) {
        Rectangle alloc = a15 instanceof Rectangle ? (Rectangle)a15 : a15.getBounds();
        this.tabBase = alloc.x;
        Graphics2D g2d = (Graphics2D)g15;
        this.host = (RSyntaxTextArea)this.getContainer();
        int ascent = this.host.getMaxAscent();
        int fontHeight = this.host.getLineHeight();
        FoldManager fm4 = this.host.getFoldManager();
        TokenPainter painter = this.host.getTokenPainter();
        Element root = this.getElement();
        int selStart = this.host.getSelectionStart();
        int selEnd = this.host.getSelectionEnd();
        int n15 = this.getViewCount();
        int x15 = alloc.x + this.getLeftInset();
        this.tempRect.y = alloc.y + this.getTopInset();
        Rectangle clip = g15.getClipBounds();
        for (int i15 = 0; i15 < n15; ++i15) {
            this.tempRect.x = x15 + this.getOffset(0, i15);
            this.tempRect.width = this.getSpan(0, i15);
            this.tempRect.height = this.getSpan(1, i15);
            if (this.tempRect.intersects(clip)) {
                Element lineElement = root.getElement(i15);
                int startOffset = lineElement.getStartOffset();
                int endOffset = lineElement.getEndOffset() - 1;
                View view = this.getView(i15);
                if (selStart == selEnd || startOffset >= selEnd || endOffset < selStart) {
                    this.drawView(painter, g2d, alloc, view, fontHeight, this.tempRect.y + ascent, i15);
                } else {
                    this.drawViewWithSelection(painter, g2d, alloc, view, fontHeight, this.tempRect.y + ascent, selStart, selEnd);
                }
            }
            this.tempRect.y += this.tempRect.height;
            Fold possibleFold = fm4.getFoldForLine(i15);
            if (possibleFold == null || !possibleFold.isCollapsed()) continue;
            i15 += possibleFold.getCollapsedLineCount();
            Color c15 = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
            if (c15 == null) continue;
            g15.setColor(c15);
            g15.drawLine(x15, this.tempRect.y - 1, this.host.getWidth(), this.tempRect.y - 1);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a15, ViewFactory f15) {
        this.updateChildren(changes, a15);
        Rectangle alloc = a15 != null && this.isAllocationValid() ? this.getInsideAllocation(a15) : null;
        int pos = changes.getOffset();
        View v15 = this.getViewAtPosition(pos, alloc);
        if (v15 != null) {
            v15.removeUpdate(changes, alloc, f15);
        }
    }

    private void setSegment(int p05, int p15, Document document, Segment seg) {
        try {
            document.getText(p05, p15 - p05, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    @Override
    public void setSize(float width, float height) {
        this.updateMetrics();
        if ((int)width != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.setWidthChangePending(true);
        }
        super.setSize(width, height);
        this.setWidthChangePending(false);
    }

    private void setWidthChangePending(boolean widthChangePending) {
        int count = this.getViewCount();
        for (int i15 = 0; i15 < count; ++i15) {
            View v15 = this.getView(i15);
            if (!(v15 instanceof WrappedLine)) continue;
            ((WrappedLine)v15).widthChangePending = widthChangePending;
        }
    }

    void updateChildren(DocumentEvent e15, Shape a15) {
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec5 = e15.getChange(elem);
        if (e15.getType() == DocumentEvent.EventType.CHANGE) {
            this.getContainer().repaint();
        } else if (ec5 != null) {
            Element[] removedElems = ec5.getChildrenRemoved();
            Element[] addedElems = ec5.getChildrenAdded();
            View[] added = new View[addedElems.length];
            for (int i15 = 0; i15 < addedElems.length; ++i15) {
                added[i15] = new WrappedLine(addedElems[i15]);
            }
            this.replace(ec5.getIndex(), removedElems.length, added);
            if (a15 != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container host = this.getContainer();
        Font f15 = host.getFont();
        this.metrics = host.getFontMetrics(f15);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    @Override
    public int viewToModel(float x15, float y15, Shape a15, Position.Bias[] bias) {
        View v15;
        Rectangle alloc;
        int offs = -1;
        if (!this.isAllocationValid()) {
            alloc = a15.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        if ((v15 = this.getViewAtPoint((int)x15, (int)y15, alloc = this.getInsideAllocation(a15))) != null) {
            offs = v15.viewToModel(x15, y15, alloc, bias);
            if (this.host.isCodeFoldingEnabled() && v15 == this.getView(this.getViewCount() - 1) && offs == v15.getEndOffset() - 1) {
                offs = this.host.getLastVisibleOffset();
            }
        }
        return offs;
    }

    @Override
    public int yForLine(Rectangle alloc, int line) throws BadLocationException {
        return this.yForLineContaining(alloc, this.getElement().getElement(line).getStartOffset());
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Rectangle r15;
        if (this.isAllocationValid() && (r15 = (Rectangle)this.modelToView(offs, alloc, Position.Bias.Forward)) != null) {
            if (this.host.isCodeFoldingEnabled()) {
                int line = this.host.getLineOfOffset(offs);
                FoldManager fm4 = this.host.getFoldManager();
                if (fm4.isLineHidden(line)) {
                    return -1;
                }
            }
            return r15.y;
        }
        return -1;
    }

    class WrappedLine
    extends View {
        private int nlines;
        private boolean widthChangePending;

        WrappedLine(Element elem) {
            super(elem);
        }

        final int calculateLineCount() {
            int nlines = 0;
            int startOffset = this.getStartOffset();
            int p15 = this.getEndOffset();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(startOffset);
            Token tokenList = doc.getTokenListForLine(line);
            float x05 = 0.0f;
            int p05 = startOffset;
            while (p05 < p15) {
                ++nlines;
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tokenList, p05, WrappedSyntaxView.this, textArea, x05, WrappedSyntaxView.this.lineCountTempToken);
                x05 = subList != null ? subList.x : x05;
                tokenList = subList != null ? subList.tokenList : null;
                int p16 = WrappedSyntaxView.this.calculateBreakPosition(p05, tokenList, x05);
                p05 = p16 == p05 ? ++p16 : p16;
            }
            return nlines;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    float width = WrappedSyntaxView.this.getWidth();
                    if (width == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return width;
                }
                case 1: {
                    if (this.nlines == 0 || this.widthChangePending) {
                        this.nlines = this.calculateLineCount();
                        this.widthChangePending = false;
                    }
                    return this.nlines * ((RSyntaxTextArea)this.getContainer()).getLineHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public void paint(Graphics g15, Shape a15) {
        }

        @Override
        public Shape modelToView(int pos, Shape a15, Position.Bias b15) throws BadLocationException {
            Rectangle alloc = a15.getBounds();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            alloc.width = 1;
            int p05 = this.getStartOffset();
            int p15 = this.getEndOffset();
            int testP = b15 == Position.Bias.Forward ? pos : Math.max(p05, pos - 1);
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(p05);
            Token tokenList = doc.getTokenListForLine(line);
            float x05 = alloc.x;
            while (p05 < p15) {
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tokenList, p05, WrappedSyntaxView.this, textArea, x05, WrappedSyntaxView.this.lineCountTempToken);
                x05 = subList != null ? subList.x : x05;
                tokenList = subList != null ? subList.tokenList : null;
                int p16 = WrappedSyntaxView.this.calculateBreakPosition(p05, tokenList, x05);
                if (pos >= p05 && testP < p16) {
                    alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p05, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    return alloc;
                }
                if (p16 == p15 - 1 && pos == p15 - 1) {
                    if (pos > p05) {
                        alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p05, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    }
                    return alloc;
                }
                p05 = p16 == p05 ? p15 : p16;
                alloc.y += alloc.height;
            }
            throw new BadLocationException(null, pos);
        }

        @Override
        public int viewToModel(float fx4, float fy4, Shape a15, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a15;
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            int x15 = (int)fx4;
            int y15 = (int)fy4;
            if (y15 < alloc.y) {
                return this.getStartOffset();
            }
            if (y15 > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            int p15 = this.getEndOffset();
            Element map = doc.getDefaultRootElement();
            int p05 = this.getStartOffset();
            int line = map.getElementIndex(p05);
            Token tlist = doc.getTokenListForLine(line);
            while (p05 < p15) {
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tlist, p05, WrappedSyntaxView.this, textArea, alloc.x, WrappedSyntaxView.this.lineCountTempToken);
                tlist = subList != null ? subList.tokenList : null;
                int p16 = WrappedSyntaxView.this.calculateBreakPosition(p05, tlist, alloc.x);
                if (y15 >= alloc.y && y15 < alloc.y + alloc.height) {
                    if (x15 < alloc.x) {
                        return p05;
                    }
                    if (x15 > alloc.x + alloc.width) {
                        return p16 - 1;
                    }
                    if (tlist != null) {
                        int n15 = tlist.getListOffset(textArea, WrappedSyntaxView.this, alloc.x, x15);
                        return Math.max(Math.min(n15, p16 - 1), p05);
                    }
                }
                p05 = p16 == p05 ? p15 : p16;
                alloc.y += alloc.height;
            }
            return this.getEndOffset() - 1;
        }

        private void handleDocumentEvent(DocumentEvent e15, Shape a15, ViewFactory f15) {
            int n15 = this.calculateLineCount();
            if (this.nlines != n15) {
                this.nlines = n15;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
                textArea.repaint();
                Gutter gutter = RSyntaxUtilities.getGutter(textArea);
                if (gutter != null) {
                    gutter.revalidate();
                    gutter.repaint();
                }
            } else if (a15 != null) {
                Container c15 = this.getContainer();
                Rectangle alloc = (Rectangle)a15;
                c15.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e15, Shape a15, ViewFactory f15) {
            this.handleDocumentEvent(e15, a15, f15);
        }

        @Override
        public void removeUpdate(DocumentEvent e15, Shape a15, ViewFactory f15) {
            this.handleDocumentEvent(e15, a15, f15);
        }
    }
}

