/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.DataProvider;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.PositionScrollVisibility;
import org.exbin.bined.basic.ScrollBarVerticalScale;
import org.exbin.bined.basic.ScrollViewDimension;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.VerticalScrollUnit;
import org.exbin.bined.section.SectionCodeAreaStructure;
import org.exbin.bined.section.SectionHorizontalScrollUnit;
import org.exbin.bined.section.capability.SectionScrollingCapable;
import org.exbin.bined.section.layout.SectionCodeAreaLayoutProfile;

@ParametersAreNonnullByDefault
public class SectionCodeAreaScrolling {
    @Nonnull
    protected final CodeAreaScrollPosition scrollPosition = new CodeAreaScrollPosition();
    @Nonnull
    protected ScrollBarVerticalScale scrollBarVerticalScale = ScrollBarVerticalScale.NORMAL;
    protected int horizontalExtentDifference;
    protected int verticalExtentDifference;
    protected int horizontalScrollBarHeight;
    protected int verticalScrollBarWidth;
    protected int lastVerticalScrollingValue = -1;
    @Nonnull
    protected VerticalScrollUnit verticalScrollUnit = VerticalScrollUnit.ROW;
    @Nonnull
    protected ScrollBarVisibility verticalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    protected SectionHorizontalScrollUnit horizontalScrollUnit = SectionHorizontalScrollUnit.PIXEL;
    @Nonnull
    protected ScrollBarVisibility horizontalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    protected final CodeAreaScrollPosition maximumScrollPosition = new CodeAreaScrollPosition();
    protected static final long ROW_POSITION_LIMIT = 0x100000002L;
    @Nullable
    private Runnable verticalExtentChangeListener = null;
    @Nullable
    private Runnable horizontalExtentChangeListener = null;

    public void updateCache(DataProvider codeArea, int horizontalScrollBarHeight, int verticalScrollBarWidth) {
        this.verticalScrollUnit = ((SectionScrollingCapable)((Object)codeArea)).getVerticalScrollUnit();
        this.verticalScrollBarVisibility = ((SectionScrollingCapable)((Object)codeArea)).getVerticalScrollBarVisibility();
        this.horizontalScrollUnit = ((SectionScrollingCapable)((Object)codeArea)).getHorizontalScrollUnit();
        this.horizontalScrollBarVisibility = ((SectionScrollingCapable)((Object)codeArea)).getHorizontalScrollBarVisibility();
        this.horizontalScrollBarHeight = horizontalScrollBarHeight;
        this.verticalScrollBarWidth = verticalScrollBarWidth;
    }

    public void computeViewDimension(ScrollViewDimension outputDimension, int dataViewWidth, int dataViewHeight, SectionCodeAreaLayoutProfile layoutProfile, SectionCodeAreaStructure structure, int characterWidth, int rowHeight) {
        int height;
        int width;
        int halfCharsPerRow = structure.getHalfCharsPerRow();
        int dataWidth = layoutProfile.computePositionX(halfCharsPerRow, characterWidth, characterWidth / 2);
        boolean fitsHorizontally = this.computeFitsHorizontally(dataViewWidth, dataWidth);
        long rowsPerData = structure.getRowsPerDocument();
        boolean fitsVertically = this.computeFitsVertically(dataViewHeight, rowsPerData, rowHeight);
        if (!fitsVertically) {
            fitsHorizontally = this.computeFitsHorizontally(dataViewWidth - this.verticalScrollBarWidth, dataWidth);
        }
        if (!fitsHorizontally) {
            fitsVertically = this.computeFitsVertically(dataViewHeight - this.horizontalScrollBarHeight, rowsPerData, rowHeight);
        }
        if (fitsHorizontally) {
            width = dataWidth;
            this.changeVerticalExtentDifference(0);
        } else {
            width = this.recomputeScrollViewWidth(dataViewWidth, characterWidth, dataWidth, halfCharsPerRow);
        }
        if (fitsVertically) {
            height = (int)(rowsPerData * (long)rowHeight);
            this.changeHorizontalExtentDifference(0);
        } else {
            height = this.recomputeScrollViewHeight(dataViewHeight, rowHeight, rowsPerData);
        }
        outputDimension.setDimension(dataViewWidth, dataViewHeight, width, height);
    }

    protected boolean computeFitsHorizontally(int dataViewWidth, int dataWidth) {
        return dataWidth <= dataViewWidth;
    }

    protected boolean computeFitsVertically(int dataViewHeight, long rowsPerData, int rowHeight) {
        int availableRows = (dataViewHeight + rowHeight - 1) / rowHeight;
        if (rowsPerData > (long)availableRows) {
            return false;
        }
        return rowsPerData * (long)rowHeight <= (long)dataViewHeight;
    }

    protected int recomputeScrollViewWidth(int dataViewWidth, int characterWidth, int dataWidth, int halfCharsPerRow) {
        int scrollViewWidth = 0;
        switch (this.horizontalScrollUnit) {
            case PIXEL: {
                scrollViewWidth = dataWidth;
                this.changeHorizontalExtentDifference(0);
                break;
            }
            case CHARACTER: {
                int charsPerDataView = dataViewWidth / characterWidth;
                scrollViewWidth = dataViewWidth + ((halfCharsPerRow + 1) / 2 - charsPerDataView);
                this.changeHorizontalExtentDifference(dataViewWidth - charsPerDataView);
                break;
            }
            case HALF_CHARACTER: {
                int halfCharsPerDataView = dataViewWidth / (characterWidth / 2);
                scrollViewWidth = dataViewWidth + (halfCharsPerRow - halfCharsPerDataView);
                this.changeHorizontalExtentDifference(dataViewWidth - halfCharsPerDataView);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
            }
        }
        return scrollViewWidth;
    }

    protected int recomputeScrollViewHeight(int dataViewHeight, int rowHeight, long rowsPerData) {
        int scrollViewHeight = 0;
        switch (this.verticalScrollUnit) {
            case PIXEL: {
                if (rowsPerData > (long)(Integer.MAX_VALUE / rowHeight)) {
                    this.scrollBarVerticalScale = ScrollBarVerticalScale.SCALED;
                    scrollViewHeight = Integer.MAX_VALUE;
                    this.changeVerticalExtentDifference(0);
                    break;
                }
                this.scrollBarVerticalScale = ScrollBarVerticalScale.NORMAL;
                scrollViewHeight = (int)(rowsPerData * (long)rowHeight);
                this.changeVerticalExtentDifference(0);
                break;
            }
            case ROW: {
                if (rowsPerData > (long)(Integer.MAX_VALUE - dataViewHeight)) {
                    this.scrollBarVerticalScale = ScrollBarVerticalScale.SCALED;
                    scrollViewHeight = Integer.MAX_VALUE;
                    this.changeVerticalExtentDifference(0);
                    break;
                }
                this.scrollBarVerticalScale = ScrollBarVerticalScale.NORMAL;
                int rowsPerDataView = dataViewHeight / rowHeight;
                scrollViewHeight = (int)((long)dataViewHeight + (rowsPerData - (long)rowsPerDataView));
                this.changeVerticalExtentDifference(dataViewHeight - rowsPerDataView);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.verticalScrollUnit);
            }
        }
        return scrollViewHeight;
    }

    public void updateHorizontalScrollBarValue(int scrollBarValue, int characterWidth) {
        if (characterWidth == 0) {
            return;
        }
        switch (this.horizontalScrollUnit) {
            case PIXEL: {
                this.scrollPosition.setCharPosition(scrollBarValue / characterWidth);
                this.scrollPosition.setCharOffset(scrollBarValue % characterWidth);
                break;
            }
            case CHARACTER: {
                this.scrollPosition.setCharPosition(scrollBarValue);
                this.scrollPosition.setCharOffset(0);
                break;
            }
            case HALF_CHARACTER: {
                this.scrollPosition.setCharPosition(scrollBarValue);
                this.scrollPosition.setCharOffset(0);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
            }
        }
    }

    public void updateVerticalScrollBarValue(int scrollBarValue, int rowHeight, int maxValue, long rowsPerDocumentToLastPage) {
        if (rowHeight == 0) {
            this.scrollPosition.setRowPosition(0L);
            this.scrollPosition.setRowOffset(0);
            return;
        }
        switch (this.verticalScrollUnit) {
            case PIXEL: {
                if (this.scrollBarVerticalScale == ScrollBarVerticalScale.SCALED) {
                    if (scrollBarValue == maxValue) {
                        this.scrollPosition.setScrollPosition(this.maximumScrollPosition);
                    } else {
                        long targetRow;
                        if (scrollBarValue > 0 && rowsPerDocumentToLastPage > (long)(maxValue / scrollBarValue)) {
                            targetRow = (long)scrollBarValue * (rowsPerDocumentToLastPage / (long)maxValue);
                            long rest = rowsPerDocumentToLastPage % (long)maxValue;
                            targetRow += rest * (long)scrollBarValue / (long)maxValue;
                        } else {
                            targetRow = (long)scrollBarValue * rowsPerDocumentToLastPage / Integer.MAX_VALUE;
                        }
                        this.scrollPosition.setRowPosition(targetRow);
                    }
                    if (this.verticalScrollUnit != VerticalScrollUnit.ROW) {
                        this.scrollPosition.setRowOffset(0);
                    }
                    return;
                }
                this.scrollPosition.setRowPosition(scrollBarValue / rowHeight);
                this.scrollPosition.setRowOffset(scrollBarValue % rowHeight);
                break;
            }
            case ROW: {
                if (this.scrollBarVerticalScale == ScrollBarVerticalScale.SCALED) {
                    if (scrollBarValue == maxValue) {
                        this.scrollPosition.setScrollPosition(this.maximumScrollPosition);
                    } else {
                        long targetRow;
                        if (scrollBarValue > 0 && rowsPerDocumentToLastPage > (long)(maxValue / scrollBarValue)) {
                            targetRow = (long)scrollBarValue * (rowsPerDocumentToLastPage / (long)maxValue);
                            long rest = rowsPerDocumentToLastPage % (long)maxValue;
                            targetRow += rest * (long)scrollBarValue / (long)maxValue;
                        } else {
                            targetRow = (long)scrollBarValue * rowsPerDocumentToLastPage / Integer.MAX_VALUE;
                        }
                        this.scrollPosition.setRowPosition(targetRow);
                    }
                    if (this.verticalScrollUnit != VerticalScrollUnit.ROW) {
                        this.scrollPosition.setRowOffset(0);
                    }
                    return;
                }
                int rowPosition = scrollBarValue;
                this.scrollPosition.setRowPosition(rowPosition);
                this.scrollPosition.setRowOffset(0);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.verticalScrollUnit);
            }
        }
    }

    public int getVerticalScrollValue(int rowHeight, long rowsPerDocument) {
        switch (this.verticalScrollUnit) {
            case PIXEL: {
                if (this.scrollBarVerticalScale == ScrollBarVerticalScale.SCALED) {
                    int scrollValue = this.scrollPosition.getRowPosition() < 0x100000002L ? (int)(this.scrollPosition.getRowPosition() * Integer.MAX_VALUE / rowsPerDocument) : (int)(this.scrollPosition.getRowPosition() / (rowsPerDocument / Integer.MAX_VALUE));
                    return scrollValue;
                }
                return (int)(this.scrollPosition.getRowPosition() * (long)rowHeight + (long)this.scrollPosition.getRowOffset());
            }
            case ROW: {
                if (this.scrollBarVerticalScale == ScrollBarVerticalScale.SCALED) {
                    int scrollValue = this.scrollPosition.getRowPosition() < 0x100000002L ? (int)(this.scrollPosition.getRowPosition() * Integer.MAX_VALUE / rowsPerDocument) : (int)(this.scrollPosition.getRowPosition() / (rowsPerDocument / Integer.MAX_VALUE));
                    return scrollValue;
                }
                return (int)this.scrollPosition.getRowPosition();
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(this.verticalScrollUnit);
    }

    public int getHorizontalScrollValue(int characterWidth) {
        switch (this.horizontalScrollUnit) {
            case PIXEL: {
                return this.scrollPosition.getCharPosition() * characterWidth + this.scrollPosition.getCharOffset();
            }
            case CHARACTER: {
                return this.scrollPosition.getCharPosition();
            }
            case HALF_CHARACTER: {
                return this.scrollPosition.getCharPosition();
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
    }

    public void setVerticalExtentChangeListener(Runnable verticalExtentChangeListener) {
        this.verticalExtentChangeListener = verticalExtentChangeListener;
    }

    public void setHorizontalExtentChangeListener(Runnable horizontalExtentChangeListener) {
        this.horizontalExtentChangeListener = horizontalExtentChangeListener;
    }

    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection direction, int rowsPerPage, long rowsPerDocument) {
        CodeAreaScrollPosition targetPosition = new CodeAreaScrollPosition();
        targetPosition.setScrollPosition(startPosition);
        switch (direction) {
            case UP: {
                if (startPosition.getRowPosition() == 0L) {
                    targetPosition.setRowOffset(0);
                    break;
                }
                targetPosition.setRowPosition(startPosition.getRowPosition() - 1L);
                break;
            }
            case DOWN: {
                if (!this.maximumScrollPosition.isRowPositionGreaterThan(startPosition)) break;
                targetPosition.setRowPosition(startPosition.getRowPosition() + 1L);
                break;
            }
            case LEFT: {
                if (startPosition.getCharPosition() == 0) {
                    targetPosition.setCharOffset(0);
                    break;
                }
                targetPosition.setCharPosition(startPosition.getCharPosition() - 1);
                break;
            }
            case RIGHT: {
                if (!this.maximumScrollPosition.isCharPositionGreaterThan(startPosition)) break;
                targetPosition.setCharPosition(startPosition.getCharPosition() + 1);
                break;
            }
            case PAGE_UP: {
                if (startPosition.getRowPosition() < (long)rowsPerPage) {
                    targetPosition.setRowPosition(0L);
                    targetPosition.setRowOffset(0);
                    break;
                }
                targetPosition.setRowPosition(startPosition.getRowPosition() - (long)rowsPerPage);
                break;
            }
            case PAGE_DOWN: {
                if (startPosition.getRowPosition() <= rowsPerDocument - (long)(rowsPerPage * 2)) {
                    targetPosition.setRowPosition(startPosition.getRowPosition() + (long)rowsPerPage);
                    break;
                }
                if (rowsPerDocument > (long)rowsPerPage) {
                    targetPosition.setRowPosition(rowsPerDocument - (long)rowsPerPage);
                    break;
                }
                targetPosition.setRowPosition(0L);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(direction);
            }
        }
        return targetPosition;
    }

    public void performScrolling(ScrollingDirection direction, int rowsPerPage, long rowsPerDocument) {
        this.setScrollPosition(this.computeScrolling(this.scrollPosition, direction, rowsPerPage, rowsPerDocument));
    }

    @Nonnull
    public PositionScrollVisibility computePositionScrollVisibility(long rowPosition, int charPosition, int bytesPerRow, int rowsPerPage, int halfCharsPerPage, int halfCharOffset, int rowOffset, int characterWidth, int rowHeight) {
        boolean partial = false;
        PositionScrollVisibility topVisibility = this.checkTopScrollVisibility(rowPosition);
        if (topVisibility == PositionScrollVisibility.NOT_VISIBLE) {
            return PositionScrollVisibility.NOT_VISIBLE;
        }
        partial |= topVisibility == PositionScrollVisibility.PARTIAL;
        PositionScrollVisibility bottomVisibility = this.checkBottomScrollVisibility(rowPosition, rowsPerPage, rowOffset, rowHeight);
        if (bottomVisibility == PositionScrollVisibility.NOT_VISIBLE) {
            return PositionScrollVisibility.NOT_VISIBLE;
        }
        partial |= bottomVisibility == PositionScrollVisibility.PARTIAL;
        PositionScrollVisibility leftVisibility = this.checkLeftScrollVisibility(charPosition, characterWidth);
        if (leftVisibility == PositionScrollVisibility.NOT_VISIBLE) {
            return PositionScrollVisibility.NOT_VISIBLE;
        }
        partial |= leftVisibility == PositionScrollVisibility.PARTIAL;
        PositionScrollVisibility rightVisibility = this.checkRightScrollVisibility(charPosition, halfCharsPerPage, halfCharOffset, characterWidth);
        if (rightVisibility == PositionScrollVisibility.NOT_VISIBLE) {
            return PositionScrollVisibility.NOT_VISIBLE;
        }
        return (partial |= rightVisibility == PositionScrollVisibility.PARTIAL) ? PositionScrollVisibility.PARTIAL : PositionScrollVisibility.VISIBLE;
    }

    @Nonnull
    public Optional<CodeAreaScrollPosition> computeRevealScrollPosition(long rowPosition, int halfCharsPosition, int bytesPerRow, int rowsPerPage, int halfCharsPerPage, int halfCharOffset, int rowOffset, int characterWidth, int rowHeight) {
        CodeAreaScrollPosition targetScrollPosition = new CodeAreaScrollPosition();
        targetScrollPosition.setScrollPosition(this.scrollPosition);
        boolean scrolled = false;
        if (this.checkBottomScrollVisibility(rowPosition, rowsPerPage, rowOffset, rowHeight) != PositionScrollVisibility.VISIBLE) {
            int bottomRowOffset = this.verticalScrollUnit != VerticalScrollUnit.PIXEL ? 0 : (rowsPerPage == 0 ? 0 : rowHeight - rowOffset);
            long targetRowPosition = rowPosition - (long)rowsPerPage;
            if (this.verticalScrollUnit == VerticalScrollUnit.ROW && rowOffset > 0) {
                ++targetRowPosition;
            }
            targetScrollPosition.setRowPosition(targetRowPosition);
            targetScrollPosition.setRowOffset(bottomRowOffset);
            scrolled = true;
        }
        if (this.checkTopScrollVisibility(rowPosition) != PositionScrollVisibility.VISIBLE) {
            targetScrollPosition.setRowPosition(rowPosition);
            targetScrollPosition.setRowOffset(0);
            scrolled = true;
        }
        if (this.checkRightScrollVisibility(halfCharsPosition, halfCharsPerPage, halfCharOffset, characterWidth) != PositionScrollVisibility.VISIBLE) {
            int rightCharOffset = this.horizontalScrollUnit != SectionHorizontalScrollUnit.PIXEL ? 0 : (halfCharsPerPage < 1 ? 0 : characterWidth - halfCharOffset % characterWidth);
            this.setHorizontalScrollPosition(targetScrollPosition, halfCharsPosition - halfCharsPerPage, rightCharOffset, characterWidth);
            scrolled = true;
        }
        if (this.checkLeftScrollVisibility(halfCharsPosition, characterWidth) != PositionScrollVisibility.VISIBLE) {
            this.setHorizontalScrollPosition(targetScrollPosition, halfCharsPosition, 0, characterWidth);
            scrolled = true;
        }
        return scrolled ? Optional.of(targetScrollPosition) : Optional.empty();
    }

    @Nonnull
    protected PositionScrollVisibility checkTopScrollVisibility(long rowPosition) {
        if (this.verticalScrollUnit == VerticalScrollUnit.ROW) {
            return rowPosition < this.scrollPosition.getRowPosition() ? PositionScrollVisibility.NOT_VISIBLE : PositionScrollVisibility.VISIBLE;
        }
        if (rowPosition > this.scrollPosition.getRowPosition() || rowPosition == this.scrollPosition.getRowPosition() && this.scrollPosition.getRowOffset() == 0) {
            return PositionScrollVisibility.VISIBLE;
        }
        if (rowPosition == this.scrollPosition.getRowPosition() && this.scrollPosition.getRowOffset() > 0) {
            return PositionScrollVisibility.PARTIAL;
        }
        return PositionScrollVisibility.NOT_VISIBLE;
    }

    @Nonnull
    protected PositionScrollVisibility checkBottomScrollVisibility(long rowPosition, int rowsPerPage, int rowOffset, int rowHeight) {
        int sumOffset = this.scrollPosition.getRowOffset() + rowOffset;
        long lastFullRow = this.scrollPosition.getRowPosition() + (long)rowsPerPage;
        if (rowOffset > 0) {
            --lastFullRow;
        }
        if (sumOffset >= rowHeight) {
            ++lastFullRow;
        }
        if (rowPosition <= lastFullRow) {
            return PositionScrollVisibility.VISIBLE;
        }
        if (sumOffset > 0 && sumOffset != rowHeight && rowPosition == lastFullRow + 1L) {
            return PositionScrollVisibility.PARTIAL;
        }
        return PositionScrollVisibility.NOT_VISIBLE;
    }

    @Nonnull
    protected PositionScrollVisibility checkLeftScrollVisibility(int halfCharsPosition, int characterWidth) {
        int halfCharPos = this.getHorizontalScrollHalfChar(this.scrollPosition, characterWidth);
        if (this.horizontalScrollUnit != SectionHorizontalScrollUnit.PIXEL) {
            return halfCharsPosition < halfCharPos ? PositionScrollVisibility.NOT_VISIBLE : PositionScrollVisibility.VISIBLE;
        }
        if (halfCharsPosition > halfCharPos || halfCharsPosition == halfCharPos && this.scrollPosition.getCharOffset() == 0) {
            return PositionScrollVisibility.VISIBLE;
        }
        if (halfCharsPosition == halfCharPos && this.scrollPosition.getCharOffset() > 0) {
            return PositionScrollVisibility.PARTIAL;
        }
        return PositionScrollVisibility.NOT_VISIBLE;
    }

    @Nonnull
    protected PositionScrollVisibility checkRightScrollVisibility(int halfCharsPosition, int halfCharsPerPage, int halfCharOffset, int characterWidth) {
        int sumOffset = this.scrollPosition.getCharOffset() + halfCharOffset;
        int lastFullHalfChar = this.getHorizontalScrollHalfChar(this.scrollPosition, characterWidth) + halfCharsPerPage;
        if (halfCharOffset > 0) {
            --lastFullHalfChar;
        }
        if (sumOffset >= characterWidth / 2) {
            ++lastFullHalfChar;
        }
        if (halfCharsPosition <= lastFullHalfChar) {
            return PositionScrollVisibility.VISIBLE;
        }
        if (sumOffset > 0 && sumOffset != characterWidth / 2 && halfCharsPosition == lastFullHalfChar + 1) {
            return PositionScrollVisibility.PARTIAL;
        }
        return PositionScrollVisibility.NOT_VISIBLE;
    }

    @Nonnull
    public Optional<CodeAreaScrollPosition> computeCenterOnScrollPosition(long rowPosition, int halfCharsPosition, int bytesPerRow, int rowsPerRect, int halfCharsPerRect, int dataViewWidth, int dataViewHeight, int rowOffset, int characterWidth, int rowHeight) {
        int charOffset;
        int targetRowOffset;
        CodeAreaScrollPosition targetScrollPosition = new CodeAreaScrollPosition();
        targetScrollPosition.setScrollPosition(this.scrollPosition);
        long centerRowPosition = rowPosition - (long)(rowsPerRect / 2);
        int rowCorrection = (rowsPerRect & 1) == 0 ? rowHeight : 0;
        int heightDiff = (rowsPerRect * rowHeight + rowCorrection - dataViewHeight) / 2;
        switch (this.verticalScrollUnit) {
            case PIXEL: {
                if (heightDiff > 0) {
                    targetRowOffset = heightDiff;
                    break;
                }
                targetRowOffset = 0;
                break;
            }
            case ROW: {
                targetRowOffset = 0;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.verticalScrollUnit);
            }
        }
        if (centerRowPosition < 0L) {
            centerRowPosition = 0L;
            targetRowOffset = 0;
        } else {
            CodeAreaScrollPosition centerPosition = new CodeAreaScrollPosition(centerRowPosition, targetRowOffset, 0, 0);
            if (centerPosition.isRowPositionGreaterThan(this.maximumScrollPosition)) {
                centerRowPosition = this.maximumScrollPosition.getRowPosition();
                targetRowOffset = this.maximumScrollPosition.getRowOffset();
            }
        }
        targetScrollPosition.setRowPosition(centerRowPosition);
        targetScrollPosition.setRowOffset(targetRowOffset);
        int halfSpaceSize = characterWidth / 2;
        int centerHalfCharPosition = halfCharsPosition - halfCharsPerRect / 2;
        int charCorrection = (halfCharsPerRect & 1) == 0 ? halfSpaceSize : 0;
        int widthDiff = (halfCharsPerRect * halfSpaceSize + charCorrection - dataViewWidth) / 2;
        switch (this.horizontalScrollUnit) {
            case PIXEL: {
                if (widthDiff > 0) {
                    charOffset = widthDiff;
                    break;
                }
                charOffset = 0;
                break;
            }
            case CHARACTER: {
                charOffset = 0;
                break;
            }
            case HALF_CHARACTER: {
                charOffset = 0;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
            }
        }
        if (centerHalfCharPosition < 0) {
            centerHalfCharPosition = 0;
            charOffset = 0;
        } else {
            CodeAreaScrollPosition centerPosition = this.createScrollPosition(centerHalfCharPosition, charOffset, characterWidth);
            if (centerPosition.isCharPositionGreaterThan(this.maximumScrollPosition)) {
                centerHalfCharPosition = this.getHorizontalScrollHalfChar(this.maximumScrollPosition, characterWidth);
                charOffset = this.maximumScrollPosition.getCharOffset();
            }
        }
        this.setHorizontalScrollPosition(targetScrollPosition, centerHalfCharPosition, charOffset, characterWidth);
        return Optional.of(targetScrollPosition);
    }

    public void updateMaximumScrollPosition(long rowsPerDocument, int rowsPerPage, int halfCharsPerRow, int halfCharsPerPage, int halfCharOffset, int rowOffset, int characterWidth) {
        this.maximumScrollPosition.reset();
        if (rowsPerDocument > (long)rowsPerPage) {
            this.maximumScrollPosition.setRowPosition(rowsPerDocument - (long)rowsPerPage);
            if (this.verticalScrollUnit == VerticalScrollUnit.PIXEL) {
                this.maximumScrollPosition.setRowOffset(rowOffset);
            }
        }
        if (halfCharsPerRow > halfCharsPerPage) {
            int halfCharsDifference = halfCharsPerRow - halfCharsPerPage;
            switch (this.horizontalScrollUnit) {
                case CHARACTER: {
                    this.maximumScrollPosition.setCharPosition(halfCharsDifference / 2 + ((halfCharsDifference & 1) == 1 || halfCharOffset > 0 ? 1 : 0));
                    break;
                }
                case HALF_CHARACTER: {
                    this.maximumScrollPosition.setCharPosition(halfCharsDifference + (halfCharOffset > 0 ? 1 : 0));
                    break;
                }
                case PIXEL: {
                    this.maximumScrollPosition.setCharPosition(halfCharsDifference / 2);
                    this.maximumScrollPosition.setCharOffset(halfCharOffset + (halfCharsDifference & 1) * (characterWidth / 2));
                    break;
                }
                default: {
                    throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
                }
            }
        }
    }

    public int getHorizontalScrollX(int characterWidth) {
        switch (this.horizontalScrollUnit) {
            case CHARACTER: {
                return this.scrollPosition.getCharPosition() * characterWidth;
            }
            case HALF_CHARACTER: {
                return this.scrollPosition.getCharPosition() / 2 * characterWidth + (this.scrollPosition.getCharPosition() & 1) * (characterWidth / 2);
            }
            case PIXEL: {
                return this.scrollPosition.getCharPosition() * characterWidth + this.scrollPosition.getCharOffset();
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
    }

    public int getHorizontalScrollHalfChar(CodeAreaScrollPosition position, int characterWidth) {
        switch (this.horizontalScrollUnit) {
            case CHARACTER: {
                return position.getCharPosition() * 2;
            }
            case HALF_CHARACTER: {
                return position.getCharPosition();
            }
            case PIXEL: {
                return position.getCharPosition() * 2 + (position.getCharOffset() >= characterWidth / 2 ? 1 : 0);
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
    }

    protected void setHorizontalScrollPosition(CodeAreaScrollPosition scrollPosition, int halfCharPos, int pixelOffset, int characterWidth) {
        switch (this.horizontalScrollUnit) {
            case CHARACTER: {
                scrollPosition.setCharPosition(halfCharPos / 2);
                scrollPosition.setCharOffset(0);
                break;
            }
            case HALF_CHARACTER: {
                scrollPosition.setCharPosition(halfCharPos);
                scrollPosition.setCharOffset(0);
                break;
            }
            case PIXEL: {
                int charPos = halfCharPos / 2;
                int halfSpaceWidth = characterWidth / 2;
                int offset = 0;
                if ((halfCharPos & 1) != 0 && halfSpaceWidth + pixelOffset > characterWidth) {
                    ++charPos;
                    offset = halfSpaceWidth + pixelOffset - characterWidth;
                }
                scrollPosition.setCharPosition(charPos);
                scrollPosition.setCharOffset(offset);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(this.horizontalScrollUnit);
            }
        }
    }

    @Nonnull
    protected CodeAreaScrollPosition createScrollPosition(int halfCharPos, int pixelOffset, int characterWidth) {
        CodeAreaScrollPosition targetScrollPosition = new CodeAreaScrollPosition();
        this.setHorizontalScrollPosition(targetScrollPosition, halfCharPos, pixelOffset, characterWidth);
        return targetScrollPosition;
    }

    @Nonnull
    public CodeAreaScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(CodeAreaScrollPosition scrollPosition) {
        this.scrollPosition.setScrollPosition(scrollPosition);
        if (scrollPosition.isRowPositionGreaterThan(this.maximumScrollPosition)) {
            this.scrollPosition.setRowPosition(this.maximumScrollPosition.getRowPosition());
            this.scrollPosition.setRowOffset(this.maximumScrollPosition.getRowOffset());
        }
        if (scrollPosition.isCharPositionGreaterThan(this.maximumScrollPosition)) {
            this.scrollPosition.setCharPosition(this.maximumScrollPosition.getCharPosition());
            this.scrollPosition.setCharOffset(this.maximumScrollPosition.getCharOffset());
        }
    }

    public int getHorizontalExtentDifference() {
        return this.horizontalExtentDifference;
    }

    public int getVerticalExtentDifference() {
        return this.verticalExtentDifference;
    }

    @Nonnull
    public ScrollBarVerticalScale getScrollBarVerticalScale() {
        return this.scrollBarVerticalScale;
    }

    public void setScrollBarVerticalScale(ScrollBarVerticalScale scrollBarVerticalScale) {
        this.scrollBarVerticalScale = scrollBarVerticalScale;
    }

    @Nonnull
    public VerticalScrollUnit getVerticalScrollUnit() {
        return this.verticalScrollUnit;
    }

    @Nonnull
    public ScrollBarVisibility getVerticalScrollBarVisibility() {
        return this.verticalScrollBarVisibility;
    }

    @Nonnull
    public SectionHorizontalScrollUnit getHorizontalScrollUnit() {
        return this.horizontalScrollUnit;
    }

    @Nonnull
    public ScrollBarVisibility getHorizontalScrollBarVisibility() {
        return this.horizontalScrollBarVisibility;
    }

    @Nonnull
    public CodeAreaScrollPosition getMaximumScrollPosition() {
        return this.maximumScrollPosition;
    }

    public void setLastVerticalScrollingValue(int value) {
        this.lastVerticalScrollingValue = value;
    }

    public int getLastVerticalScrollingValue() {
        return this.lastVerticalScrollingValue;
    }

    public void clearLastVerticalScrollingValue() {
        this.lastVerticalScrollingValue = -1;
    }

    protected void changeVerticalExtentDifference(int newDifference) {
        if (this.verticalExtentDifference != newDifference) {
            this.verticalExtentDifference = newDifference;
            if (this.verticalExtentChangeListener != null) {
                this.verticalExtentChangeListener.run();
            }
        }
    }

    protected void changeHorizontalExtentDifference(int newDifference) {
        if (this.horizontalExtentDifference != newDifference) {
            this.horizontalExtentDifference = newDifference;
            if (this.horizontalExtentChangeListener != null) {
                this.horizontalExtentChangeListener.run();
            }
        }
    }
}

