/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.CodeAreaCaret;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.EditOperation;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.PositionScrollVisibility;
import org.exbin.bined.basic.ScrollViewDimension;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.capability.EditModeCapable;
import org.exbin.bined.capability.RowWrappingCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.color.BasicCodeAreaDecorationColorType;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.section.SectionCodeAreaStructure;
import org.exbin.bined.section.SectionHorizontalScrollUnit;
import org.exbin.bined.section.capability.PositionCodeTypeCapable;
import org.exbin.bined.section.caret.CodeAreaCaretShape;
import org.exbin.bined.section.caret.CodeAreaCaretType;
import org.exbin.bined.section.layout.PositionIterator;
import org.exbin.bined.section.layout.SectionCodeAreaLayoutProfile;
import org.exbin.bined.section.layout.SpaceType;
import org.exbin.bined.section.theme.SectionBackgroundPaintMode;
import org.exbin.bined.swing.CodeAreaCharAssessor;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPaintState;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.AntialiasingMode;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;
import org.exbin.bined.swing.basic.DefaultCodeAreaCharAssessor;
import org.exbin.bined.swing.basic.DefaultCodeAreaColorAssessor;
import org.exbin.bined.swing.basic.DefaultCodeAreaMouseListener;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.capability.AntialiasingCapable;
import org.exbin.bined.swing.capability.CharAssessorPainterCapable;
import org.exbin.bined.swing.capability.ColorAssessorPainterCapable;
import org.exbin.bined.swing.capability.FontCapable;
import org.exbin.bined.swing.section.SectionCodeAreaDimensions;
import org.exbin.bined.swing.section.SectionCodeAreaScrollPane;
import org.exbin.bined.swing.section.SectionCodeAreaScrolling;
import org.exbin.bined.swing.section.SectionCodeAreaVisibility;
import org.exbin.bined.swing.section.caret.CaretsProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.section.caret.DefaultExtendedCodeAreaCaretsProfile;
import org.exbin.bined.swing.section.caret.SectionCodeAreaCaretsProfile;
import org.exbin.bined.swing.section.color.ColorsProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.section.color.SectionCodeAreaColorProfile;
import org.exbin.bined.swing.section.layout.DefaultSectionCodeAreaLayoutProfile;
import org.exbin.bined.swing.section.layout.LayoutProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.section.theme.SectionCodeAreaThemeProfile;
import org.exbin.bined.swing.section.theme.ThemeProfileCapableCodeAreaPainter;

@ParametersAreNonnullByDefault
public class SectionCodeAreaPainter
implements CodeAreaPainter,
ColorsProfileCapableCodeAreaPainter,
LayoutProfileCapableCodeAreaPainter,
ThemeProfileCapableCodeAreaPainter,
CaretsProfileCapableCodeAreaPainter,
CodeAreaPaintState,
ColorAssessorPainterCapable,
CharAssessorPainterCapable {
    @Nonnull
    protected final CodeAreaCore codeArea;
    protected volatile boolean initialized = false;
    protected volatile boolean fontChanged = false;
    protected volatile boolean layoutChanged = true;
    protected volatile boolean caretChanged = true;
    protected volatile boolean resetColors = true;
    @Nonnull
    protected final JComponent dataView;
    @Nonnull
    protected final SectionCodeAreaScrollPane scrollPanel;
    @Nonnull
    protected final DefaultCodeAreaMouseListener codeAreaMouseListener;
    @Nonnull
    protected final ComponentListener codeAreaComponentListener;
    @Nonnull
    protected final DataChangedListener codeAreaDataChangeListener;
    @Nonnull
    protected final BasicCodeAreaMetrics metrics = new BasicCodeAreaMetrics();
    @Nonnull
    protected final SectionCodeAreaStructure structure = new SectionCodeAreaStructure();
    @Nonnull
    protected final SectionCodeAreaScrolling scrolling = new SectionCodeAreaScrolling();
    @Nonnull
    protected final SectionCodeAreaDimensions dimensions = new SectionCodeAreaDimensions();
    @Nonnull
    protected final SectionCodeAreaVisibility visibility = new SectionCodeAreaVisibility();
    @Nonnull
    protected SectionCodeAreaLayoutProfile layoutProfile = new DefaultSectionCodeAreaLayoutProfile();
    @Nonnull
    protected CodeAreaColorsProfile colorsProfile = new SectionCodeAreaColorProfile();
    @Nonnull
    protected SectionCodeAreaThemeProfile themeProfile = new SectionCodeAreaThemeProfile();
    @Nonnull
    protected SectionCodeAreaCaretsProfile caretsProfile = new DefaultExtendedCodeAreaCaretsProfile();
    @Nullable
    protected CodeCharactersCase codeCharactersCase;
    @Nullable
    protected EditOperation editOperation;
    @Nullable
    protected PositionIterator positionIterator;
    protected final ScrollViewDimension viewDimension = new ScrollViewDimension();
    protected boolean showMirrorCursor;
    @Nonnull
    protected AntialiasingMode antialiasingMode = AntialiasingMode.AUTO;
    protected int rowPositionLength;
    protected int minRowPositionLength;
    protected int maxRowPositionLength;
    @Nullable
    protected Font font;
    @Nullable
    protected Charset charset;
    @Nullable
    protected CodeAreaColorAssessor colorAssessor = null;
    @Nullable
    protected CodeAreaCharAssessor charAssessor = null;
    @Nullable
    protected RowDataCache rowDataCache = null;
    @Nullable
    protected CursorDataCache cursorDataCache = null;
    protected static final char SPACE_CHAR = ' ';

    public SectionCodeAreaPainter(CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.colorAssessor = new DefaultCodeAreaColorAssessor();
        this.charAssessor = new DefaultCodeAreaCharAssessor();
        this.dataView = new JComponent(){};
        this.dataView.setBorder(null);
        this.dataView.setVisible(false);
        this.dataView.setLayout(null);
        this.dataView.setOpaque(false);
        this.dataView.setInheritsPopupMenu(true);
        this.dataView.setPreferredSize(new Dimension(0, 0));
        this.scrollPanel = new SectionCodeAreaScrollPane((CodeAreaSwingControl)((Object)codeArea), this.metrics, this.structure, this.scrolling, this.dimensions);
        this.scrollPanel.setViewportView(this.dataView);
        JViewport viewport = this.scrollPanel.getViewport();
        viewport.setOpaque(false);
        this.scrolling.setHorizontalExtentChangeListener(() -> this.horizontalExtentChanged());
        this.scrolling.setVerticalExtentChangeListener(() -> this.verticalExtentChanged());
        this.codeAreaMouseListener = new DefaultCodeAreaMouseListener(codeArea, this.scrollPanel);
        viewport.addMouseListener(this.codeAreaMouseListener);
        viewport.addMouseMotionListener(this.codeAreaMouseListener);
        viewport.addMouseWheelListener(this.codeAreaMouseListener);
        viewport.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e15) {
                int verticalScrollBarSize = SectionCodeAreaPainter.this.getVerticalScrollBarSize();
                int horizontalScrollBarSize = SectionCodeAreaPainter.this.getHorizontalScrollBarSize();
                if (SectionCodeAreaPainter.this.dimensions.getVerticalScrollBarSize() != verticalScrollBarSize || SectionCodeAreaPainter.this.dimensions.getHorizontalScrollBarSize() != horizontalScrollBarSize) {
                    SectionCodeAreaPainter.this.recomputeDimensions();
                    SectionCodeAreaPainter.this.recomputeScrollState();
                }
                JViewport viewport = SectionCodeAreaPainter.this.scrollPanel.getViewport();
                if (SectionCodeAreaPainter.this.viewDimension != null && (SectionCodeAreaPainter.this.viewDimension.getDataViewWidth() != viewport.getWidth() || SectionCodeAreaPainter.this.viewDimension.getDataViewHeight() != viewport.getHeight())) {
                    SectionCodeAreaPainter.this.updateScrollBars();
                }
            }
        });
        this.codeAreaComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e15) {
                SectionCodeAreaPainter.this.recomputeLayout();
            }
        };
        this.codeAreaDataChangeListener = () -> this.dataChanged();
        this.rebuildColors();
    }

    @Override
    public void attach() {
        this.codeArea.add(this.scrollPanel);
        this.codeArea.addMouseListener(this.codeAreaMouseListener);
        this.codeArea.addMouseMotionListener(this.codeAreaMouseListener);
        this.codeArea.addMouseWheelListener(this.codeAreaMouseListener);
        this.codeArea.addComponentListener(this.codeAreaComponentListener);
        this.codeArea.addDataChangedListener(this.codeAreaDataChangeListener);
    }

    @Override
    public void detach() {
        this.codeArea.remove(this.scrollPanel);
        this.codeArea.removeMouseListener(this.codeAreaMouseListener);
        this.codeArea.removeMouseMotionListener(this.codeAreaMouseListener);
        this.codeArea.removeMouseWheelListener(this.codeAreaMouseListener);
        this.codeArea.removeComponentListener(this.codeAreaComponentListener);
        this.codeArea.removeDataChangedListener(this.codeAreaDataChangeListener);
    }

    @Override
    public void reset() {
        this.resetColors();
        this.resetFont();
        this.resetLayout();
        this.resetCaret();
    }

    @Override
    public void resetColors() {
        this.resetColors = true;
    }

    @Override
    public void resetFont() {
        this.fontChanged = true;
        this.resetLayout();
    }

    @Override
    public void resetLayout() {
        this.layoutChanged = true;
    }

    @Override
    public void resetCaret() {
        this.caretChanged = true;
    }

    @Override
    public void rebuildColors() {
        this.colorsProfile.reinitialize();
    }

    private void recomputeLayout() {
        this.rowPositionLength = this.getRowPositionLength();
        this.recomputeDimensions();
        int halfCharsPerPage = this.dimensions.getHalfCharsPerPage();
        this.structure.updateCache(this.codeArea, halfCharsPerPage, this.layoutProfile);
        this.positionIterator = this.layoutProfile.createPositionIterator(this.structure.getCodeType(), this.structure.getViewMode(), this.structure.getBytesPerRow());
        this.codeCharactersCase = ((CodeCharactersCaseCapable)((Object)this.codeArea)).getCodeCharactersCase();
        this.showMirrorCursor = ((CaretCapable)((Object)this.codeArea)).isShowMirrorCursor();
        this.minRowPositionLength = ((RowWrappingCapable)((Object)this.codeArea)).getMinRowPositionLength();
        this.maxRowPositionLength = ((RowWrappingCapable)((Object)this.codeArea)).getMaxRowPositionLength();
        this.antialiasingMode = ((AntialiasingCapable)((Object)this.codeArea)).getAntialiasingMode();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        int halfCharsPerRow = this.structure.getHalfCharsPerRow();
        if (this.metrics.isInitialized()) {
            int characterWidth = this.metrics.getCharacterWidth();
            this.scrolling.updateMaximumScrollPosition(rowsPerDocument, rowsPerPage, halfCharsPerRow, halfCharsPerPage, this.dimensions.getHalfCharOffset(), this.dimensions.getRowOffset(), characterWidth);
        }
        this.updateScrollBars();
        this.layoutChanged = false;
    }

    private void updateCaret() {
        this.editOperation = ((EditModeCapable)((Object)this.codeArea)).getActiveOperation();
        this.caretChanged = false;
    }

    private void validateCaret() {
        CodeAreaCaret caret = ((CaretCapable)((Object)this.codeArea)).getCodeAreaCaret();
        CodeAreaCaretPosition caretPosition = caret.getCaretPosition();
        if (caretPosition.getDataPosition() > this.codeArea.getDataSize()) {
            caret.setCaretPosition(null);
        }
    }

    private void validateSelection() {
        CodeAreaSelection selectionHandler = ((SelectionCapable)((Object)this.codeArea)).getSelectionHandler();
        if (!selectionHandler.isEmpty()) {
            long dataSize = this.codeArea.getDataSize();
            if (dataSize == 0L) {
                ((SelectionCapable)((Object)this.codeArea)).clearSelection();
            } else {
                boolean selectionChanged = false;
                long start = selectionHandler.getStart();
                long end = selectionHandler.getEnd();
                if (start >= dataSize) {
                    start = dataSize;
                    selectionChanged = true;
                }
                if (end >= dataSize) {
                    end = dataSize;
                    selectionChanged = true;
                }
                if (selectionChanged) {
                    ((SelectionCapable)((Object)this.codeArea)).setSelection(start, end);
                }
            }
        }
    }

    private void recomputeDimensions() {
        int verticalScrollBarSize = this.getVerticalScrollBarSize();
        int horizontalScrollBarSize = this.getHorizontalScrollBarSize();
        Insets insets = this.codeArea.getInsets();
        int componentWidth = this.codeArea.getWidth() - insets.left - insets.right;
        int componentHeight = this.codeArea.getHeight() - insets.top - insets.bottom;
        this.dimensions.recomputeSizes(this.metrics, insets.right, insets.top, componentWidth, componentHeight, this.rowPositionLength, verticalScrollBarSize, horizontalScrollBarSize, this.layoutProfile);
    }

    public void recomputeCharPositions() {
        this.visibility.recomputeCharPositions(this.metrics, this.structure, this.dimensions, this.layoutProfile, this.scrolling);
        this.updateRowDataCache();
    }

    private void updateRowDataCache() {
        if (this.rowDataCache == null) {
            this.rowDataCache = new RowDataCache();
        }
        boolean shifted = this.layoutProfile.isHalfShiftedUsed();
        int maxRowDataChars = this.visibility.getMaxRowDataChars();
        int codeLength = this.structure.getCodeType().getMaxDigitsForByte();
        this.rowDataCache.headerCodeData = new char[this.structure.getCodeType().getMaxDigitsForByte()];
        this.rowDataCache.headerChars = new char[maxRowDataChars + codeLength];
        this.rowDataCache.headerCharsShifted = shifted ? new char[maxRowDataChars + codeLength] : null;
        this.rowDataCache.rowCodeData = new char[this.structure.getCodeType().getMaxDigitsForByte()];
        this.rowDataCache.rowData = new byte[this.structure.getBytesPerRow() + this.metrics.getMaxBytesPerChar() - 1];
        this.rowDataCache.rowPositionCode = new char[this.rowPositionLength];
        this.rowDataCache.rowCharacters = new char[maxRowDataChars];
        this.rowDataCache.rowCharactersShifted = shifted ? new char[maxRowDataChars] : null;
    }

    public void fontChanged(Graphics g15) {
        if (this.font == null) {
            this.reset();
        }
        this.charset = ((CharsetCapable)((Object)this.codeArea)).getCharset();
        this.font = ((FontCapable)((Object)this.codeArea)).getCodeFont();
        this.metrics.recomputeMetrics(g15.getFontMetrics(this.font), this.charset);
        this.recomputeLayout();
        this.recomputeCharPositions();
        this.initialized = true;
    }

    private void recomputeScrollState() {
        this.scrolling.setScrollPosition(((ScrollingCapable)((Object)this.codeArea)).getScrollPosition());
        int characterWidth = this.metrics.getCharacterWidth();
        if (characterWidth > 0) {
            this.scrolling.updateCache(this.codeArea, this.getHorizontalScrollBarSize(), this.getVerticalScrollBarSize());
            this.recomputeCharPositions();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void paintComponent(Graphics g15) {
        if (!this.initialized) {
            this.reset();
        }
        this.updateCache();
        if (this.font == null) {
            this.fontChanged(g15);
        }
        if (this.rowDataCache == null) {
            return;
        }
        if (this.antialiasingMode != AntialiasingMode.OFF && g15 instanceof Graphics2D) {
            Object antialiasingHint = this.antialiasingMode.getAntialiasingHint((Graphics2D)g15);
            ((Graphics2D)g15).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasingHint);
        }
        if (this.layoutChanged) {
            this.recomputeLayout();
            this.recomputeCharPositions();
        }
        this.paintOutsideArea(g15);
        this.paintHeader(g15);
        this.paintRowPosition(g15);
        this.paintMainArea(g15);
    }

    protected synchronized void updateCache() {
        if (this.resetColors) {
            this.resetColors = false;
            this.rebuildColors();
        }
    }

    public void paintOutsideArea(Graphics g15) {
        int lineX;
        int headerAreaHeight = this.dimensions.getHeaderAreaHeight();
        int rowPositionAreaWidth = this.dimensions.getRowPositionAreaWidth();
        Rectangle componentRect = this.dimensions.getComponentRectangle();
        int characterWidth = this.metrics.getCharacterWidth();
        g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_BACKGROUND));
        g15.fillRect(componentRect.x, componentRect.y, componentRect.width, headerAreaHeight);
        g15.setColor(this.colorsProfile.getColor(BasicCodeAreaDecorationColorType.LINE));
        if (this.themeProfile.showHeaderLine()) {
            g15.drawLine(componentRect.x, componentRect.y + headerAreaHeight - 1, componentRect.x + rowPositionAreaWidth, componentRect.y + headerAreaHeight - 1);
        }
        if (this.themeProfile.showRowPositionLine() && (lineX = componentRect.x + rowPositionAreaWidth - characterWidth / 2) >= componentRect.x) {
            g15.drawLine(lineX, componentRect.y, lineX, componentRect.y + headerAreaHeight);
        }
        if (this.themeProfile.showBoxLine()) {
            g15.drawLine(rowPositionAreaWidth - 1, headerAreaHeight - 1, rowPositionAreaWidth, headerAreaHeight - 1);
        }
    }

    public void paintHeader(Graphics g15) {
        int groupSize;
        int lineX;
        if (!this.dimensions.getLayoutProfile().isShowHeader()) {
            return;
        }
        Rectangle headerArea = this.dimensions.getHeaderAreaRectangle();
        Rectangle clipBounds = g15.getClipBounds();
        g15.setClip(clipBounds != null ? clipBounds.intersection(headerArea) : headerArea);
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int rowHeight = this.metrics.getRowHeight();
        int dataViewX = this.dimensions.getScrollPanelX();
        int skipRestFrom = this.visibility.getSkipRestFrom();
        int skipToChar = this.visibility.getSkipToChar();
        int skipRestFromChar = this.visibility.getSkipRestFromChar();
        g15.setFont(this.font);
        g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_BACKGROUND));
        g15.fillRect(headerArea.x, headerArea.y, headerArea.width, headerArea.height);
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        if ((viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) && this.visibility.isCodeSectionVisible()) {
            boolean paintGrid;
            int headerX = dataViewX - this.scrolling.getHorizontalScrollX(characterWidth);
            int headerY = headerArea.y + this.dimensions.getLayoutProfile().computeHeaderOffsetPositionY() + rowHeight - this.metrics.getSubFontSpace();
            Arrays.fill(this.rowDataCache.headerChars, ' ');
            if (this.layoutProfile.isHalfShiftedUsed()) {
                Arrays.fill(this.rowDataCache.headerCharsShifted, ' ');
            }
            int codeLength = this.structure.getCodeType().getMaxDigitsForByte();
            int base = this.structure.getPositionCodeType().getBase();
            g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.ALTERNATE_BACKGROUND));
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            int halfCharPos = this.positionIterator.getHalfCharPosition();
            boolean bl4 = paintGrid = this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.CHESSBOARD;
            while (this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW) {
                int byteOffset = this.positionIterator.getBytePosition();
                int gridStartX = paintGrid ? this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) : 0;
                int gridEndX = 0;
                CodeAreaUtils.longToBaseCode(this.rowDataCache.headerCodeData, 0, byteOffset, base, codeLength, true, this.codeCharactersCase);
                for (int i15 = this.positionIterator.getCodeOffset(); i15 < codeLength; ++i15) {
                    int charPos = halfCharPos / 2 - skipToChar;
                    if ((halfCharPos & 1) == 0) {
                        this.rowDataCache.headerChars[charPos] = this.rowDataCache.headerCodeData[i15];
                    } else {
                        this.rowDataCache.headerCharsShifted[charPos] = this.rowDataCache.headerCodeData[i15];
                    }
                    if (paintGrid && i15 + 1 == codeLength) {
                        gridEndX = this.layoutProfile.computePositionX(halfCharPos + 2, characterWidth, halfSpaceWidth);
                    }
                    halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
                }
                if (paintGrid && (byteOffset & 1) != 0) {
                    g15.fillRect(headerX + gridStartX, headerArea.y, gridEndX - gridStartX, headerArea.height);
                }
                if ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW && !this.positionIterator.isEndReached()) continue;
            }
            g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR));
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            halfCharPos = this.positionIterator.getHalfCharPosition();
            int renderCharOffset = halfCharPos / 2;
            int renderCharOffsetShifted = renderCharOffset / 2;
            Color renderColor = null;
            Color renderColorShifted = null;
            do {
                for (int i16 = 0; i16 < codeLength; ++i16) {
                    Color color;
                    char currentChar;
                    boolean nonshifted;
                    int charPos = halfCharPos / 2;
                    boolean sequenceBreak = false;
                    boolean bl5 = nonshifted = (halfCharPos & 1) == 0;
                    if (nonshifted) {
                        currentChar = this.rowDataCache.headerChars[charPos - skipToChar];
                        if (currentChar == ' ' && renderCharOffset == charPos) {
                            ++renderCharOffset;
                            continue;
                        }
                        color = this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR);
                        if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                            sequenceBreak = true;
                        }
                        if (sequenceBreak) {
                            if (renderCharOffset < charPos) {
                                this.drawCenteredChars(g15, this.rowDataCache.headerChars, renderCharOffset - skipToChar, charPos - renderCharOffset, characterWidth, headerX + renderCharOffset * characterWidth, headerY);
                            }
                            if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                                renderColor = color;
                                g15.setColor(color);
                            }
                            renderCharOffset = charPos;
                        }
                    } else {
                        currentChar = this.rowDataCache.headerCharsShifted[charPos - skipToChar];
                        if (currentChar == ' ' && renderCharOffsetShifted == charPos) {
                            ++renderCharOffsetShifted;
                            continue;
                        }
                        color = this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR);
                        if (!CodeAreaSwingUtils.areSameColors(color, renderColorShifted)) {
                            sequenceBreak = true;
                        }
                        if (sequenceBreak) {
                            if (renderCharOffsetShifted < charPos) {
                                this.drawCenteredChars(g15, this.rowDataCache.headerCharsShifted, renderCharOffsetShifted - skipToChar, charPos - renderCharOffsetShifted, characterWidth, headerX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, headerY);
                            }
                            if (!CodeAreaSwingUtils.areSameColors(color, renderColorShifted)) {
                                renderColorShifted = color;
                                g15.setColor(color);
                            }
                            renderCharOffsetShifted = charPos;
                        }
                    }
                    halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
                }
            } while ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW && !this.positionIterator.isEndReached());
            if (renderCharOffset < skipRestFromChar) {
                this.drawCenteredChars(g15, this.rowDataCache.headerChars, renderCharOffset - skipToChar, skipRestFromChar - renderCharOffset, characterWidth, headerX + renderCharOffset * characterWidth, headerY);
            }
            if (this.layoutProfile.isHalfShiftedUsed() && renderCharOffsetShifted < skipRestFromChar) {
                this.drawCenteredChars(g15, this.rowDataCache.headerCharsShifted, renderCharOffsetShifted - skipToChar, skipRestFromChar - renderCharOffsetShifted, characterWidth, headerX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, headerY);
            }
        }
        g15.setColor(this.colorsProfile.getColor(BasicCodeAreaDecorationColorType.LINE));
        if (this.themeProfile.showHeaderLine() || this.themeProfile.showBoxLine()) {
            g15.drawLine(headerArea.x, headerArea.y + headerArea.height - 1, headerArea.x + headerArea.width, headerArea.y + headerArea.height - 1);
        }
        int splitLinePos = this.visibility.getSplitLinePos();
        if (this.themeProfile.showSplitLine() && splitLinePos > 0 && (lineX = dataViewX + splitLinePos - this.scrolling.getHorizontalScrollX(characterWidth)) >= dataViewX) {
            g15.drawLine(lineX, headerArea.y, lineX, headerArea.y + headerArea.height);
        }
        if ((groupSize = this.themeProfile.getVerticalLineByteGroupSize()) > 0 && (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) && this.visibility.isCodeSectionVisible()) {
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            int halfCharPos = this.positionIterator.getHalfCharPosition();
            while (!this.positionIterator.isEndReached()) {
                SpaceType nextSpaceType = this.positionIterator.nextSpaceType();
                if (this.positionIterator.isEndReached() || this.positionIterator.getSection() != BasicCodeAreaSection.CODE_MATRIX) break;
                int spaceHalfCharSize = nextSpaceType.getHalfCharSize();
                halfCharPos += 2;
                if (this.positionIterator.getCodeOffset() == 0 && this.positionIterator.getBytePosition() % groupSize == 0) {
                    int lineX2 = dataViewX + this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) + spaceHalfCharSize * halfSpaceWidth / 2 - this.scrolling.getHorizontalScrollX(characterWidth);
                    g15.drawLine(lineX2, headerArea.y, lineX2, headerArea.y + headerArea.height);
                }
                halfCharPos += spaceHalfCharSize;
                if ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW) continue;
                break;
            }
        }
        g15.setClip(clipBounds);
    }

    public void paintRowPosition(Graphics g15) {
        int row;
        long dataPosition;
        if (!this.dimensions.getLayoutProfile().isShowRowPosition()) {
            return;
        }
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int subFontSpace = this.metrics.getSubFontSpace();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        Rectangle rowPosRectangle = this.dimensions.getRowPositionAreaRectangle();
        Rectangle dataViewRectangle = this.dimensions.getDataViewRectangle();
        Rectangle clipBounds = g15.getClipBounds();
        g15.setClip(clipBounds != null ? clipBounds.intersection(rowPosRectangle) : rowPosRectangle);
        g15.setFont(this.font);
        g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_BACKGROUND));
        g15.fillRect(rowPosRectangle.x, rowPosRectangle.y, rowPosRectangle.width, rowPosRectangle.height);
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        if (this.themeProfile.isPaintRowPosBackground() && (this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.STRIPED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.CHESSBOARD)) {
            dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow + (long)((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : bytesPerRow);
            int stripePositionY = rowPosRectangle.y - scrollPosition.getRowOffset() + ((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : rowHeight);
            g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.ALTERNATE_BACKGROUND));
            for (row = 0; row <= rowsPerRect / 2 && dataPosition <= dataSize; dataPosition += (long)(bytesPerRow * 2), ++row) {
                g15.fillRect(rowPosRectangle.x, stripePositionY, rowPosRectangle.width, rowHeight);
                stripePositionY += rowHeight * 2;
            }
        }
        dataPosition = (long)bytesPerRow * scrollPosition.getRowPosition();
        int positionY = rowPosRectangle.y + rowHeight - subFontSpace - scrollPosition.getRowOffset();
        g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR));
        for (row = 0; row <= rowsPerRect && dataPosition <= dataSize; ++row) {
            CodeAreaUtils.longToBaseCode(this.rowDataCache.rowPositionCode, 0, dataPosition < 0L ? 0L : dataPosition, this.structure.getPositionCodeType().getBase(), this.rowPositionLength, true, CodeCharactersCase.UPPER);
            this.drawCenteredChars(g15, this.rowDataCache.rowPositionCode, 0, this.rowPositionLength, characterWidth, rowPosRectangle.x + this.dimensions.getLayoutProfile().computeRowPositionOffsetPositionX(), positionY);
            positionY += rowHeight;
            if ((dataPosition += (long)bytesPerRow) < 0L) break;
        }
        g15.setColor(this.colorsProfile.getColor(BasicCodeAreaDecorationColorType.LINE));
        if (this.themeProfile.showRowPositionLine()) {
            int lineX = rowPosRectangle.x + rowPosRectangle.width - characterWidth / 2;
            if (lineX >= rowPosRectangle.x) {
                g15.drawLine(lineX, dataViewRectangle.y, lineX, dataViewRectangle.y + dataViewRectangle.height);
            }
            g15.drawLine(dataViewRectangle.x, dataViewRectangle.y - 1, dataViewRectangle.x + dataViewRectangle.width, dataViewRectangle.y - 1);
        }
        if (this.themeProfile.showBoxLine() && rowPosRectangle.width >= 0) {
            g15.drawLine(rowPosRectangle.width - 1, dataViewRectangle.y, rowPosRectangle.width - 1, dataViewRectangle.y + dataViewRectangle.height);
        }
        g15.setClip(clipBounds);
    }

    @Override
    public void paintMainArea(Graphics g15) {
        if (!this.initialized) {
            this.reset();
        }
        if (this.fontChanged) {
            this.fontChanged(g15);
            this.fontChanged = false;
        }
        Rectangle mainAreaRect = this.dimensions.getMainAreaRectangle();
        Rectangle dataViewRectangle = this.dimensions.getDataViewRectangle();
        int splitLinePos = this.visibility.getSplitLinePos();
        Rectangle clipBounds = g15.getClipBounds();
        g15.setClip(clipBounds != null ? clipBounds.intersection(mainAreaRect) : mainAreaRect);
        this.colorAssessor.startPaint(this);
        this.charAssessor.startPaint(this);
        this.paintBackground(g15);
        int characterWidth = this.metrics.getCharacterWidth();
        this.paintRows(g15);
        g15.setColor(this.colorsProfile.getColor(BasicCodeAreaDecorationColorType.LINE));
        int lineX = dataViewRectangle.x + splitLinePos - this.scrolling.getHorizontalScrollX(characterWidth);
        if (this.themeProfile.showSplitLine() && splitLinePos > 0) {
            g15.drawLine(lineX, dataViewRectangle.y, lineX, dataViewRectangle.y + dataViewRectangle.height);
        }
        int groupSize = this.themeProfile.getVerticalLineByteGroupSize();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int skipRestFrom = this.visibility.getSkipRestFrom();
        if (groupSize > 0 && (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) && this.visibility.isCodeSectionVisible()) {
            int halfSpaceWidth = characterWidth / 2;
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            int halfCharPos = this.positionIterator.getHalfCharPosition();
            while (!this.positionIterator.isEndReached()) {
                SpaceType nextSpaceType = this.positionIterator.nextSpaceType();
                if (this.positionIterator.isEndReached() || this.positionIterator.getSection() != BasicCodeAreaSection.CODE_MATRIX) break;
                int spaceHalfCharSize = nextSpaceType.getHalfCharSize();
                halfCharPos += 2;
                if (this.positionIterator.getBytePosition() > 0 && this.positionIterator.getCodeOffset() == 0 && this.positionIterator.getBytePosition() % groupSize == 0) {
                    int lineX2 = dataViewRectangle.x + this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) + spaceHalfCharSize * halfSpaceWidth / 2 - this.scrolling.getHorizontalScrollX(characterWidth);
                    g15.drawLine(lineX2, dataViewRectangle.y, lineX2, dataViewRectangle.y + dataViewRectangle.height);
                }
                halfCharPos += spaceHalfCharSize;
                if ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW) continue;
                break;
            }
        }
        g15.setClip(clipBounds);
        this.paintCursor(g15);
    }

    public void paintBackground(Graphics g15) {
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int rowsPerRect = this.dimensions.getRowsPerRect();
        Rectangle dataViewRect = this.dimensions.getDataViewRectangle();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_BACKGROUND));
        if (this.themeProfile.getBackgroundPaintMode() != SectionBackgroundPaintMode.TRANSPARENT) {
            g15.fillRect(dataViewRect.x, dataViewRect.y, dataViewRect.width, dataViewRect.height);
        }
        if (this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.STRIPED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.CHESSBOARD) {
            g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.ALTERNATE_BACKGROUND));
            long dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow;
            int rowAlternatingOffset = (int)(scrollPosition.getRowPosition() & 1L);
            int stripePositionY = dataViewRect.y - scrollPosition.getRowOffset();
            for (int row = 0; row <= rowsPerRect && dataPosition <= dataSize; dataPosition += (long)bytesPerRow, ++row) {
                boolean oddRow;
                boolean bl4 = oddRow = (row & 1) != rowAlternatingOffset;
                if (oddRow && (this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.STRIPED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.GRIDDED)) {
                    g15.fillRect(dataViewRect.x, stripePositionY, dataViewRect.width, rowHeight);
                }
                if (this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.CHESSBOARD) {
                    this.positionIterator.reset();
                    this.positionIterator.skip(this.visibility.getSkipTo());
                    int gridStartX = 0;
                    int halfCharPos = 0;
                    int bytePosition = 0;
                    boolean first = true;
                    do {
                        if (first || this.positionIterator.getCodeOffset() == 0) {
                            int nextGridStartX = first ? 0 : this.layoutProfile.computePositionX(this.positionIterator.getHalfCharPosition(), characterWidth, halfSpaceWidth);
                            first = false;
                            if (this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.GRIDDED && bytePosition & true && !oddRow || this.themeProfile.getBackgroundPaintMode() == SectionBackgroundPaintMode.CHESSBOARD && (bytePosition & 1) != (row + rowAlternatingOffset & 1)) {
                                int positionX = dataViewRect.x - this.scrolling.getHorizontalScrollX(characterWidth) + gridStartX;
                                int width = this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) - gridStartX;
                                g15.fillRect(positionX, stripePositionY, width, rowHeight);
                            }
                            gridStartX = nextGridStartX;
                        }
                        if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom() || this.positionIterator.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) break;
                        halfCharPos = this.positionIterator.getHalfCharPosition() + 2;
                        bytePosition = this.positionIterator.getBytePosition();
                        this.positionIterator.nextSpaceType();
                    } while (!this.positionIterator.isEndReached());
                }
                stripePositionY += rowHeight;
            }
        }
    }

    public void paintRows(Graphics g15) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewX = this.dimensions.getScrollPanelX();
        int dataViewY = this.dimensions.getScrollPanelY();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        long dataSize = this.codeArea.getDataSize();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        long dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow;
        int characterWidth = this.metrics.getCharacterWidth();
        int rowPositionX = dataViewX - this.scrolling.getHorizontalScrollX(characterWidth);
        int rowPositionY = dataViewY - scrollPosition.getRowOffset();
        g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR));
        for (int row = 0; row <= rowsPerRect && dataPosition <= dataSize; ++row) {
            this.prepareRowData(dataPosition);
            this.paintRowBackground(g15, dataPosition, rowPositionX, rowPositionY);
            this.paintRowText(g15, dataPosition, rowPositionX, rowPositionY);
            rowPositionY += rowHeight;
            if (Long.MAX_VALUE - dataPosition < (long)bytesPerRow) {
                dataPosition = Long.MAX_VALUE;
                continue;
            }
            dataPosition += (long)bytesPerRow;
        }
    }

    private void prepareRowData(long dataPosition) {
        int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        CodeType codeType = this.structure.getCodeType();
        int rowStart = 0;
        if (dataPosition < dataSize) {
            int rowDataSize = bytesPerRow + maxBytesPerChar - 1;
            if (dataSize - dataPosition < (long)rowDataSize) {
                rowDataSize = (int)(dataSize - dataPosition);
            }
            if (dataPosition < 0L) {
                rowStart = (int)(-dataPosition);
            }
            BinaryData data = this.codeArea.getContentData();
            data.copyToArray(dataPosition + (long)rowStart, this.rowDataCache.rowData, rowStart, rowDataSize - rowStart);
        }
        Arrays.fill(this.rowDataCache.rowCharacters, ' ');
        if (this.layoutProfile.isHalfShiftedUsed()) {
            Arrays.fill(this.rowDataCache.rowCharactersShifted, ' ');
        }
        this.positionIterator.reset();
        this.positionIterator.skip(this.visibility.getSkipTo());
        int skipToChar = this.visibility.getSkipToChar();
        int halfCharPos = this.positionIterator.getHalfCharPosition();
        boolean first = true;
        do {
            BasicCodeAreaSection section = this.positionIterator.getSection();
            if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom()) break;
            int byteOnRow = this.positionIterator.getBytePosition();
            int charPos = halfCharPos / 2 - skipToChar;
            int codeOffset = this.positionIterator.getCodeOffset();
            byte dataByte = this.rowDataCache.rowData[byteOnRow];
            if (section == BasicCodeAreaSection.CODE_MATRIX) {
                if (dataPosition + (long)byteOnRow < dataSize) {
                    if (first || codeOffset == 0) {
                        CodeAreaUtils.byteToCharsCode(dataByte, codeType, this.rowDataCache.rowCodeData, 0, this.codeCharactersCase);
                        first = false;
                    }
                    if ((halfCharPos & 1) == 0) {
                        this.rowDataCache.rowCharacters[charPos] = this.rowDataCache.rowCodeData[codeOffset];
                    } else {
                        this.rowDataCache.rowCharactersShifted[charPos] = this.rowDataCache.rowCodeData[codeOffset];
                    }
                }
            } else {
                int charDataLength;
                if (dataPosition + (long)byteOnRow >= dataSize) break;
                if (dataPosition + (long)maxBytesPerChar > dataSize) {
                    maxBytesPerChar = (int)(dataSize - dataPosition);
                }
                if (byteOnRow + (charDataLength = maxBytesPerChar) > this.rowDataCache.rowData.length) {
                    charDataLength = this.rowDataCache.rowData.length - byteOnRow;
                }
                char targetChar = this.charAssessor.getPreviewCharacter(dataPosition, byteOnRow, charDataLength, BasicCodeAreaSection.TEXT_PREVIEW);
                if ((halfCharPos & 1) == 0) {
                    this.rowDataCache.rowCharacters[charPos] = targetChar;
                } else {
                    this.rowDataCache.rowCharactersShifted[charPos] = targetChar;
                }
            }
            halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
        } while (!this.positionIterator.isEndReached());
    }

    public void paintRowBackground(Graphics g15, long rowDataPosition, int rowPositionX, int rowPositionY) {
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int charactersPerRow = this.structure.getHalfCharsPerRow();
        Color renderColor = null;
        this.positionIterator.reset();
        this.positionIterator.skip(this.visibility.getSkipTo());
        int renderOffset = this.positionIterator.getHalfCharPosition();
        int spaceSize = 0;
        int halfCharPos = this.positionIterator.getHalfCharPosition();
        do {
            boolean splitSpace;
            BasicCodeAreaSection section = this.positionIterator.getSection();
            if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom()) break;
            int byteOnRow = this.positionIterator.getBytePosition();
            int charPos = halfCharPos;
            boolean sequenceBreak = false;
            CodeAreaSelection selectionHandler = ((SelectionCapable)((Object)this.codeArea)).getSelectionHandler();
            boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
            Color color = this.colorAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charPos, section, inSelection);
            if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                sequenceBreak = true;
            }
            boolean bl4 = splitSpace = viewMode == CodeAreaViewMode.DUAL && this.positionIterator.getSection() == BasicCodeAreaSection.TEXT_PREVIEW && this.positionIterator.getBytePosition() == 0;
            if (splitSpace) {
                sequenceBreak = true;
                charPos = halfCharPos - spaceSize;
            }
            if (sequenceBreak) {
                if (renderOffset < charPos && renderColor != null) {
                    this.renderBackgroundSequence(g15, renderOffset, charPos, rowPositionX, rowPositionY);
                }
                if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                    renderColor = color;
                    if (color != null) {
                        g15.setColor(color);
                    }
                }
                renderOffset = charPos;
            }
            if (splitSpace) {
                renderOffset += spaceSize;
            }
            spaceSize = this.positionIterator.nextSpaceType().getHalfCharSize();
            halfCharPos += 2 + spaceSize;
        } while (!this.positionIterator.isEndReached());
        if (renderOffset < charactersPerRow && renderColor != null) {
            this.renderBackgroundSequence(g15, renderOffset, charactersPerRow, rowPositionX, rowPositionY);
        }
    }

    @Override
    @Nonnull
    public PositionScrollVisibility computePositionScrollVisibility(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int rowOffset = this.dimensions.getRowOffset();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        int charactersPerPage = this.dimensions.getHalfCharsPerPage();
        long dataPosition = caretPosition.getDataPosition();
        long rowPosition = dataPosition / (long)bytesPerRow;
        int halfCharPosition = this.computeHalfCharPosition(dataPosition, bytesPerRow, caretPosition);
        return this.scrolling.computePositionScrollVisibility(rowPosition, halfCharPosition, bytesPerRow, rowsPerPage, charactersPerPage, dataViewWidth, rowOffset, characterWidth, rowHeight);
    }

    @Override
    @Nonnull
    public Optional<CodeAreaScrollPosition> computeRevealScrollPosition(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int rowOffset = this.dimensions.getRowOffset();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        int halfCharsPerPage = this.dimensions.getHalfCharsPerPage();
        long dataPosition = caretPosition.getDataPosition();
        long rowPosition = dataPosition / (long)bytesPerRow;
        int halfCharPosition = this.computeHalfCharPosition(dataPosition, bytesPerRow, caretPosition);
        int halfCharOffset = dataViewWidth % (this.scrolling.getHorizontalScrollUnit() == SectionHorizontalScrollUnit.HALF_CHARACTER ? characterWidth : characterWidth / 2);
        return this.scrolling.computeRevealScrollPosition(rowPosition, halfCharPosition, bytesPerRow, rowsPerPage, halfCharsPerPage, halfCharOffset, rowOffset, characterWidth, rowHeight);
    }

    @Override
    @Nonnull
    public Optional<CodeAreaScrollPosition> computeCenterOnScrollPosition(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int dataViewHeight = this.dimensions.getDataViewHeight();
        int rowOffset = this.dimensions.getRowOffset();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        int halfCharsPerRect = this.dimensions.getHalfCharsPerRect();
        long dataPosition = caretPosition.getDataPosition();
        long rowPosition = dataPosition / (long)bytesPerRow;
        int halfCharPosition = this.computeHalfCharPosition(dataPosition, bytesPerRow, caretPosition);
        return this.scrolling.computeCenterOnScrollPosition(rowPosition, halfCharPosition, bytesPerRow, rowsPerRect, halfCharsPerRect, dataViewWidth, dataViewHeight, rowOffset, characterWidth, rowHeight);
    }

    private int computeHalfCharPosition(long dataPosition, int bytesPerRow, CodeAreaCaretPosition caretPosition) {
        int byteOffset = (int)(dataPosition % (long)bytesPerRow);
        return this.structure.computeFirstCodeHalfCharPos(byteOffset, this.getSection(caretPosition)) + caretPosition.getCodeOffset() * 2;
    }

    public void paintRowText(Graphics g15, long rowDataPosition, int rowPositionX, int rowPositionY) {
        int renderCharOffset;
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int subFontSpace = this.metrics.getSubFontSpace();
        int skipToChar = this.visibility.getSkipToChar();
        int skipRestFromChar = this.visibility.getSkipRestFromChar();
        g15.setFont(this.font);
        int positionY = rowPositionY + rowHeight - subFontSpace;
        Color lastColor = null;
        Color renderColor = null;
        Color renderColorShifted = null;
        this.positionIterator.reset();
        this.positionIterator.skip(this.visibility.getSkipTo());
        int halfCharPos = this.positionIterator.getHalfCharPosition();
        int renderCharOffsetShifted = renderCharOffset = halfCharPos / 2;
        do {
            boolean sequenceBreak;
            Color color;
            boolean inSelection;
            CodeAreaSelection selectionHandler;
            char currentChar;
            BasicCodeAreaSection section = this.positionIterator.getSection();
            int byteOnRow = this.positionIterator.getBytePosition();
            int charPos = halfCharPos / 2;
            if ((halfCharPos & 1) == 0) {
                currentChar = this.rowDataCache.rowCharacters[charPos - skipToChar];
                if (currentChar == ' ' && renderCharOffset == charPos) {
                    ++renderCharOffset;
                    continue;
                }
                selectionHandler = ((SelectionCapable)((Object)this.codeArea)).getSelectionHandler();
                inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
                color = this.colorAssessor.getPositionTextColor(rowDataPosition, byteOnRow, halfCharPos, section, inSelection);
                if (color == null) {
                    color = this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR);
                }
                sequenceBreak = false;
                if (!CodeAreaSwingUtils.areSameColors(color, renderColor)) {
                    if (renderColor == null) {
                        renderColor = color;
                    }
                    sequenceBreak = true;
                }
                if (sequenceBreak) {
                    if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor)) {
                        g15.setColor(renderColor);
                        lastColor = renderColor;
                    }
                    if (charPos > renderCharOffset) {
                        this.drawCenteredChars(g15, this.rowDataCache.rowCharacters, renderCharOffset - skipToChar, charPos - renderCharOffset, characterWidth, rowPositionX + renderCharOffset * characterWidth, positionY);
                    }
                    if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor = color)) {
                        g15.setColor(renderColor);
                        lastColor = renderColor;
                    }
                    renderCharOffset = charPos;
                }
            } else {
                currentChar = this.rowDataCache.rowCharactersShifted[charPos - skipToChar];
                if (currentChar == ' ' && renderCharOffsetShifted == charPos) {
                    ++renderCharOffsetShifted;
                    continue;
                }
                selectionHandler = ((SelectionCapable)((Object)this.codeArea)).getSelectionHandler();
                inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
                color = this.colorAssessor.getPositionTextColor(rowDataPosition, byteOnRow, halfCharPos, section, inSelection);
                if (color == null) {
                    color = this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR);
                }
                sequenceBreak = false;
                if (!CodeAreaSwingUtils.areSameColors(color, renderColorShifted)) {
                    if (renderColorShifted == null) {
                        renderColorShifted = color;
                    }
                    sequenceBreak = true;
                }
                if (sequenceBreak) {
                    if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColorShifted)) {
                        g15.setColor(renderColorShifted);
                        lastColor = renderColorShifted;
                    }
                    if (charPos > renderCharOffsetShifted) {
                        this.drawCenteredChars(g15, this.rowDataCache.rowCharactersShifted, renderCharOffsetShifted - skipToChar, charPos - renderCharOffsetShifted, characterWidth, rowPositionX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, positionY);
                    }
                    if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColorShifted = color)) {
                        g15.setColor(renderColorShifted);
                        lastColor = renderColorShifted;
                    }
                    renderCharOffsetShifted = charPos;
                }
            }
            halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
            if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom()) break;
        } while (!this.positionIterator.isEndReached());
        if (renderCharOffset < skipRestFromChar) {
            if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor)) {
                g15.setColor(renderColor);
                lastColor = renderColor;
            }
            this.drawCenteredChars(g15, this.rowDataCache.rowCharacters, renderCharOffset - skipToChar, skipRestFromChar - renderCharOffset, characterWidth, rowPositionX + renderCharOffset * characterWidth, positionY);
        }
        if (this.layoutProfile.isHalfShiftedUsed() && renderCharOffsetShifted < skipRestFromChar) {
            if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColorShifted)) {
                g15.setColor(renderColorShifted);
            }
            this.drawCenteredChars(g15, this.rowDataCache.rowCharactersShifted, renderCharOffsetShifted - skipToChar, skipRestFromChar - renderCharOffsetShifted, characterWidth, rowPositionX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, positionY);
        }
    }

    @Override
    @Nonnull
    public CodeAreaColorAssessor getColorAssessor() {
        return this.colorAssessor;
    }

    @Override
    public void setColorAssessor(CodeAreaColorAssessor colorAssessor) {
        this.colorAssessor = CodeAreaUtils.requireNonNull(colorAssessor);
    }

    @Override
    @Nonnull
    public CodeAreaCharAssessor getCharAssessor() {
        return this.charAssessor;
    }

    @Override
    public void setCharAssessor(CodeAreaCharAssessor charAssessor) {
        this.charAssessor = charAssessor;
    }

    @Override
    public void paintCursor(Graphics g15) {
        boolean cursorVisible;
        DefaultCodeAreaCaret caret;
        Rectangle cursorRect;
        int cursorDataLength;
        int cursorCharsLength;
        if (!this.codeArea.hasFocus()) {
            return;
        }
        if (this.caretChanged) {
            this.updateCaret();
        }
        int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
        Rectangle mainAreaRect = this.dimensions.getMainAreaRectangle();
        CodeType codeType = this.structure.getCodeType();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        if (this.cursorDataCache == null) {
            this.cursorDataCache = new CursorDataCache();
        }
        if (this.cursorDataCache.cursorCharsLength != (cursorCharsLength = codeType.getMaxDigitsForByte())) {
            this.cursorDataCache.cursorCharsLength = cursorCharsLength;
            this.cursorDataCache.cursorChars = new char[cursorCharsLength];
        }
        if (this.cursorDataCache.cursorDataLength != (cursorDataLength = maxBytesPerChar)) {
            this.cursorDataCache.cursorDataLength = cursorDataLength;
            this.cursorDataCache.cursorData = new byte[cursorDataLength];
        }
        if ((cursorRect = this.getCursorPositionRect((caret = (DefaultCodeAreaCaret)((CaretCapable)((Object)this.codeArea)).getCodeAreaCaret()).getDataPosition(), caret.getCodeOffset(), caret.getSection())).isEmpty()) {
            return;
        }
        Rectangle scrolledCursorRect = new Rectangle(cursorRect.x, cursorRect.y, cursorRect.width, cursorRect.height);
        Rectangle clipBounds = g15.getClipBounds();
        Rectangle intersection = scrolledCursorRect.intersection(mainAreaRect);
        boolean bl4 = cursorVisible = caret.isCursorVisible() && !intersection.isEmpty();
        if (cursorVisible) {
            g15.setClip(intersection);
            DefaultCodeAreaCaret.CursorRenderingMode renderingMode = caret.getRenderingMode();
            g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.CURSOR_COLOR));
            CodeAreaCaretShape caretShape = this.caretsProfile.identifyCaretShape(CodeAreaCaretType.INSERT);
            this.paintCursorRect(g15, intersection.x, intersection.y, intersection.width, intersection.height, renderingMode, caret, caretShape);
        }
        if (viewMode == CodeAreaViewMode.DUAL && this.showMirrorCursor) {
            this.updateMirrorCursorRect(caret.getDataPosition(), caret.getSection());
            Rectangle mirrorCursorRect = this.cursorDataCache.mirrorCursorRect;
            if (!mirrorCursorRect.isEmpty()) {
                boolean mirrorCursorVisible;
                intersection = mainAreaRect.intersection(mirrorCursorRect);
                boolean bl5 = mirrorCursorVisible = !intersection.isEmpty();
                if (mirrorCursorVisible) {
                    g15.setClip(intersection);
                    g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.CURSOR_COLOR));
                    Graphics2D g2d = (Graphics2D)g15.create();
                    g2d.setStroke(this.cursorDataCache.dashedStroke);
                    g2d.drawRect(mirrorCursorRect.x, mirrorCursorRect.y, mirrorCursorRect.width - 1, mirrorCursorRect.height - 1);
                    g2d.dispose();
                }
            }
        }
        g15.setClip(clipBounds);
    }

    private void paintCursorRect(Graphics g15, int cursorX, int cursorY, int width, int height, DefaultCodeAreaCaret.CursorRenderingMode renderingMode, DefaultCodeAreaCaret caret, CodeAreaCaretShape caretShape) {
        switch (renderingMode) {
            case PAINT: {
                this.caretsProfile.paintCaret(g15, cursorX, cursorY, width, height, caretShape);
                break;
            }
            case XOR: {
                g15.setXORMode(this.colorsProfile.getColor(CodeAreaBasicColors.TEXT_BACKGROUND));
                this.caretsProfile.paintCaret(g15, cursorX, cursorY, width, height, caretShape);
                g15.setPaintMode();
                break;
            }
            case NEGATIVE: {
                int characterWidth = this.metrics.getCharacterWidth();
                int rowHeight = this.metrics.getRowHeight();
                int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
                int subFontSpace = this.metrics.getSubFontSpace();
                int dataViewX = this.dimensions.getScrollPanelX();
                int dataViewY = this.dimensions.getScrollPanelY();
                CodeAreaViewMode viewMode = this.structure.getViewMode();
                CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
                long dataSize = this.codeArea.getDataSize();
                CodeType codeType = this.structure.getCodeType();
                this.caretsProfile.paintCaret(g15, cursorX, cursorY, width, height, caretShape);
                g15.setColor(this.colorsProfile.getColor(CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR));
                BinaryData contentData = this.codeArea.getContentData();
                int row = (cursorY + scrollPosition.getRowOffset() - dataViewY) / rowHeight;
                int posY = dataViewY + (row + 1) * rowHeight - subFontSpace - scrollPosition.getRowOffset();
                long dataPosition = caret.getDataPosition();
                CodeAreaSection section = caret.getSection();
                int codeOffset = caret.getCodeOffset();
                int bytesPerRow = this.structure.getBytesPerRow();
                int byteOffset = (int)(dataPosition % (long)bytesPerRow);
                int halfCharPos = this.layoutProfile.computeFirstByteHalfCharPos(byteOffset, section, this.structure);
                int relativeX = dataViewX - this.scrolling.getHorizontalScrollX(characterWidth);
                int posX = relativeX + this.layoutProfile.computePositionX(halfCharPos += codeOffset * 2, characterWidth, characterWidth / 2);
                if (viewMode != CodeAreaViewMode.CODE_MATRIX && caret.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
                    if (dataPosition >= dataSize) break;
                    int byteOnRow = (int)(dataPosition % (long)this.structure.getBytesPerRow());
                    int previewCharPos = this.visibility.getPreviewCharPos();
                    if (contentData.isEmpty()) {
                        this.cursorDataCache.cursorChars[0] = 32;
                    } else if (maxBytesPerChar > 1) {
                        int charDataLength = maxBytesPerChar;
                        if (dataPosition + (long)maxBytesPerChar > dataSize) {
                            charDataLength = (int)(dataSize - dataPosition);
                        }
                        contentData.copyToArray(dataPosition, this.cursorDataCache.cursorData, 0, charDataLength);
                        this.cursorDataCache.cursorChars[0] = this.charAssessor.getPreviewCursorCharacter(dataPosition, byteOnRow, previewCharPos, this.cursorDataCache.cursorData, charDataLength, BasicCodeAreaSection.TEXT_PREVIEW);
                        String displayString = new String(this.cursorDataCache.cursorData, 0, charDataLength, this.charset);
                        if (!displayString.isEmpty()) {
                            this.cursorDataCache.cursorChars[0] = displayString.charAt(0);
                        }
                    } else {
                        this.cursorDataCache.cursorData[0] = contentData.getByte(dataPosition);
                        this.cursorDataCache.cursorChars[0] = this.charAssessor.getPreviewCursorCharacter(dataPosition, byteOnRow, previewCharPos, this.cursorDataCache.cursorData, 1, BasicCodeAreaSection.TEXT_PREVIEW);
                    }
                    this.drawCenteredChars(g15, this.cursorDataCache.cursorChars, 0, 1, characterWidth, posX, posY);
                    break;
                }
                if (dataPosition < dataSize) {
                    byte dataByte = contentData.getByte(dataPosition);
                    CodeAreaUtils.byteToCharsCode(dataByte, codeType, this.cursorDataCache.cursorChars, 0, this.codeCharactersCase);
                } else {
                    Arrays.fill(this.cursorDataCache.cursorChars, ' ');
                }
                this.drawCenteredChars(g15, this.cursorDataCache.cursorChars, codeOffset, 1, characterWidth, posX, posY);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(renderingMode);
            }
        }
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition mousePositionToClosestCaretPosition(int positionX, int positionY, CaretOverlapMode overflowMode) {
        long cursorRowY;
        DefaultCodeAreaCaretPosition caret = new DefaultCodeAreaCaretPosition();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int rowHeight = this.metrics.getRowHeight();
        int rowPositionAreaWidth = this.dimensions.getRowPositionAreaWidth();
        int headerAreaHeight = this.dimensions.getHeaderAreaHeight();
        int diffX = 0;
        if (positionX < rowPositionAreaWidth) {
            if (overflowMode == CaretOverlapMode.PARTIAL_OVERLAP) {
                diffX = characterWidth;
            }
            positionX = rowPositionAreaWidth;
        }
        int cursorX = positionX - rowPositionAreaWidth + this.scrolling.getHorizontalScrollX(characterWidth) - diffX;
        int halfCharPosX = 0;
        int codeOffset = 0;
        int byteOnRow = 0;
        BasicCodeAreaSection section = null;
        this.positionIterator.reset();
        do {
            codeOffset = this.positionIterator.getCodeOffset();
            byteOnRow = this.positionIterator.getBytePosition();
            section = this.positionIterator.getSection();
            int nextSpaceSize = this.positionIterator.nextSpaceType().getHalfCharSize();
            int posX = this.layoutProfile.computePositionX(halfCharPosX + 2 + nextSpaceSize / 2, characterWidth, halfSpaceWidth);
            if (cursorX < posX) break;
            halfCharPosX += 2 + nextSpaceSize;
        } while (!this.positionIterator.isEndReached());
        int diffY = 0;
        if (positionY < headerAreaHeight) {
            if (overflowMode == CaretOverlapMode.PARTIAL_OVERLAP) {
                diffY = 1;
            }
            positionY = headerAreaHeight;
        }
        if ((cursorRowY = (long)((positionY - headerAreaHeight + scrollPosition.getRowOffset()) / rowHeight) + scrollPosition.getRowPosition() - (long)diffY) < 0L) {
            cursorRowY = 0L;
        }
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        long dataPosition = (long)byteOnRow + cursorRowY * (long)bytesPerRow;
        if (dataPosition < 0L) {
            dataPosition = 0L;
            codeOffset = 0;
        }
        if (dataPosition >= dataSize) {
            dataPosition = dataSize;
            codeOffset = 0;
        }
        caret.setSection(section);
        caret.setDataPosition(dataPosition);
        caret.setCodeOffset(codeOffset);
        return caret;
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction) {
        return this.structure.computeMovePosition(position, direction, this.dimensions.getRowsPerPage());
    }

    @Override
    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection direction) {
        int rowsPerPage = this.dimensions.getRowsPerPage();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        return this.scrolling.computeScrolling(startPosition, direction, rowsPerPage, rowsPerDocument);
    }

    @Nullable
    public Point getPositionPoint(long dataPosition, int codeOffset, CodeAreaSection section) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        long row = dataPosition / (long)bytesPerRow - scrollPosition.getRowPosition();
        if (row < -1L || row > (long)rowsPerRect) {
            return null;
        }
        int byteOffset = (int)(dataPosition % (long)bytesPerRow);
        Rectangle dataViewRect = this.dimensions.getDataViewRectangle();
        int caretY = (int)((long)dataViewRect.y + row * (long)rowHeight) - scrollPosition.getRowOffset();
        int halfCharPos = this.layoutProfile.computeFirstByteHalfCharPos(byteOffset, section, this.structure);
        int caretX = dataViewRect.x + this.layoutProfile.computePositionX(halfCharPos += codeOffset * 2, characterWidth, characterWidth / 2);
        return new Point(caretX -= this.scrolling.getHorizontalScrollX(characterWidth), caretY);
    }

    private void updateMirrorCursorRect(long dataPosition, CodeAreaSection section) {
        CodeType codeType = this.structure.getCodeType();
        Point mirrorCursorPoint = this.getPositionPoint(dataPosition, 0, section == BasicCodeAreaSection.CODE_MATRIX ? BasicCodeAreaSection.TEXT_PREVIEW : BasicCodeAreaSection.CODE_MATRIX);
        if (mirrorCursorPoint == null) {
            this.cursorDataCache.mirrorCursorRect.setSize(0, 0);
        } else {
            this.cursorDataCache.mirrorCursorRect.setBounds(mirrorCursorPoint.x, mirrorCursorPoint.y, this.metrics.getCharacterWidth() * (section == BasicCodeAreaSection.TEXT_PREVIEW ? codeType.getMaxDigitsForByte() : 1), this.metrics.getRowHeight());
        }
    }

    @Override
    public int getMouseCursorShape(int positionX, int positionY) {
        int dataViewX = this.dimensions.getScrollPanelX();
        int dataViewY = this.dimensions.getScrollPanelY();
        int scrollPanelWidth = this.dimensions.getScrollPanelWidth();
        int scrollPanelHeight = this.dimensions.getScrollPanelHeight();
        if (positionX >= dataViewX && positionX < dataViewX + scrollPanelWidth && positionY >= dataViewY && positionY < dataViewY + scrollPanelHeight) {
            return 2;
        }
        return 0;
    }

    @Override
    @Nonnull
    public BasicCodeAreaZone getPositionZone(int positionX, int positionY) {
        return this.dimensions.getPositionZone(positionX, positionY);
    }

    @Override
    @Nonnull
    public CodeAreaColorsProfile getColorsProfile() {
        return this.colorsProfile;
    }

    @Override
    public void setColorsProfile(CodeAreaColorsProfile colorsProfile) {
        this.colorsProfile = colorsProfile;
        this.codeArea.repaint();
    }

    @Override
    @Nonnull
    public SectionCodeAreaLayoutProfile getLayoutProfile() {
        return this.layoutProfile.createCopy();
    }

    @Override
    public void setLayoutProfile(SectionCodeAreaLayoutProfile layoutProfile) {
        this.layoutProfile = layoutProfile.createCopy();
        this.resetLayout();
    }

    @Override
    @Nonnull
    public SectionCodeAreaThemeProfile getThemeProfile() {
        return this.themeProfile.createCopy();
    }

    @Override
    public void setThemeProfile(SectionCodeAreaThemeProfile themeProfile) {
        this.themeProfile = themeProfile.createCopy();
        this.codeArea.repaint();
    }

    @Override
    @Nonnull
    public SectionCodeAreaCaretsProfile getCaretsProfile() {
        return this.caretsProfile;
    }

    @Override
    public void setCaretsProfile(SectionCodeAreaCaretsProfile caretsProfile) {
        this.caretsProfile = caretsProfile;
        this.codeArea.repaint();
    }

    protected void drawCenteredChars(Graphics g15, char[] drawnChars, int charOffset, int length, int cellWidth, int positionX, int positionY) {
        int pos;
        int group = 0;
        for (pos = 0; pos < length; ++pos) {
            int charsWidth;
            char drawnChar = drawnChars[charOffset + pos];
            int charWidth = this.metrics.getCharWidth(drawnChar);
            boolean groupable = this.metrics.hasUniformLineMetrics() ? charWidth == cellWidth : (charsWidth = this.metrics.getCharsWidth(drawnChars, charOffset + pos - group, group + 1)) == cellWidth * (group + 1);
            switch (Character.getDirectionality(drawnChar)) {
                case -1: 
                case 1: 
                case 2: 
                case 9: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    groupable = false;
                }
            }
            if (groupable) {
                ++group;
                continue;
            }
            if (group > 0) {
                this.drawShiftedChars(g15, drawnChars, charOffset + pos - group, group, positionX + (pos - group) * cellWidth, positionY);
                group = 0;
            }
            this.drawShiftedChars(g15, drawnChars, charOffset + pos, 1, positionX + pos * cellWidth + (cellWidth - charWidth) / 2, positionY);
        }
        if (group > 0) {
            this.drawShiftedChars(g15, drawnChars, charOffset + pos - group, group, positionX + (pos - group) * cellWidth, positionY);
        }
    }

    protected void drawShiftedChars(Graphics g15, char[] drawnChars, int charOffset, int length, int positionX, int positionY) {
        g15.drawChars(drawnChars, charOffset, length, positionX, positionY);
    }

    private int getRowPositionLength() {
        if (this.minRowPositionLength > 0 && this.minRowPositionLength == this.maxRowPositionLength) {
            return this.minRowPositionLength;
        }
        PositionCodeType positionCodeType = ((PositionCodeTypeCapable)((Object)this.codeArea)).getPositionCodeType();
        long dataSize = this.codeArea.getDataSize();
        if (dataSize == 0L) {
            return 1;
        }
        double natLog = Math.log(dataSize == Long.MAX_VALUE ? (double)dataSize : (double)(dataSize + 1L));
        int positionLength = (int)Math.ceil(natLog / positionCodeType.getBaseLog());
        if (this.minRowPositionLength > 0 && positionLength < this.minRowPositionLength) {
            positionLength = this.minRowPositionLength;
        }
        if (this.maxRowPositionLength > 0 && positionLength > this.maxRowPositionLength) {
            positionLength = this.maxRowPositionLength;
        }
        return positionLength == 0 ? 1 : positionLength;
    }

    @Nonnull
    public Rectangle getCursorPositionRect(long dataPosition, int codeOffset, CodeAreaSection section) {
        Rectangle rect = new Rectangle();
        this.updateRectToCursorPosition(rect, dataPosition, codeOffset, section);
        return rect;
    }

    protected void updateRectToCursorPosition(Rectangle rect, long dataPosition, int codeOffset, CodeAreaSection section) {
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        Point cursorPoint = this.getPositionPoint(dataPosition, codeOffset, section);
        if (cursorPoint == null) {
            rect.setBounds(0, 0, 0, 0);
        } else {
            DefaultCodeAreaCaret.CursorShape cursorShape = this.editOperation == EditOperation.INSERT ? DefaultCodeAreaCaret.CursorShape.INSERT : DefaultCodeAreaCaret.CursorShape.OVERWRITE;
            int cursorThickness = DefaultCodeAreaCaret.getCursorThickness(cursorShape, characterWidth, rowHeight);
            rect.setBounds(cursorPoint.x, cursorPoint.y, cursorThickness, rowHeight);
        }
    }

    private void renderBackgroundSequence(Graphics g15, int startOffset, int endOffset, int rowPositionX, int positionY) {
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceSize = characterWidth / 2;
        int rowHeight = this.metrics.getRowHeight();
        g15.fillRect(rowPositionX + this.layoutProfile.computePositionX(startOffset, characterWidth, halfSpaceSize), positionY, this.layoutProfile.computePositionX(endOffset - startOffset, characterWidth, halfSpaceSize), rowHeight);
    }

    @Override
    public void updateScrollBars() {
        int verticalScrollBarPolicy = CodeAreaSwingUtils.getVerticalScrollBarPolicy(this.scrolling.getVerticalScrollBarVisibility());
        if (this.scrollPanel.getVerticalScrollBarPolicy() != verticalScrollBarPolicy) {
            this.scrollPanel.setVerticalScrollBarPolicy(verticalScrollBarPolicy);
        }
        int horizontalScrollBarPolicy = CodeAreaSwingUtils.getHorizontalScrollBarPolicy(this.scrolling.getHorizontalScrollBarVisibility());
        if (this.scrollPanel.getHorizontalScrollBarPolicy() != horizontalScrollBarPolicy) {
            this.scrollPanel.setHorizontalScrollBarPolicy(horizontalScrollBarPolicy);
        }
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        this.recomputeScrollState();
        boolean revalidate = false;
        Rectangle scrollPanelRectangle = this.dimensions.getScrollPanelRectangle();
        Rectangle oldRect = this.scrollPanel.getBounds();
        if (!oldRect.equals(scrollPanelRectangle)) {
            this.scrollPanel.setBounds(scrollPanelRectangle);
            revalidate = true;
        }
        JViewport viewport = this.scrollPanel.getViewport();
        if (rowHeight > 0 && characterWidth > 0) {
            this.scrolling.computeViewDimension(this.viewDimension, viewport.getWidth(), viewport.getHeight(), this.layoutProfile, this.structure, characterWidth, rowHeight);
            if (this.dataView.getWidth() != this.viewDimension.getWidth() || this.dataView.getHeight() != this.viewDimension.getHeight()) {
                Dimension dataViewSize = new Dimension(this.viewDimension.getWidth(), this.viewDimension.getHeight());
                this.dataView.setPreferredSize(dataViewSize);
                this.dataView.setSize(dataViewSize);
                this.recomputeDimensions();
                scrollPanelRectangle = this.dimensions.getScrollPanelRectangle();
                if (!oldRect.equals(scrollPanelRectangle)) {
                    this.scrollPanel.setBounds(scrollPanelRectangle);
                }
                revalidate = true;
            }
            int verticalScrollValue = this.scrolling.getVerticalScrollValue(rowHeight, rowsPerDocument);
            int horizontalScrollValue = this.scrolling.getHorizontalScrollValue(characterWidth);
            this.scrollPanel.updateScrollBars(verticalScrollValue, horizontalScrollValue);
        }
        if (revalidate) {
            this.horizontalExtentChanged();
            this.verticalExtentChanged();
            this.codeArea.revalidate();
        }
    }

    @Override
    public void scrollPositionModified() {
        this.scrolling.clearLastVerticalScrollingValue();
        this.recomputeScrollState();
    }

    @Override
    public void scrollPositionChanged() {
        this.recomputeScrollState();
        this.updateScrollBars();
    }

    private void horizontalExtentChanged() {
        this.scrollPanel.horizontalExtentChanged();
    }

    private void verticalExtentChanged() {
        this.scrollPanel.verticalExtentChanged();
    }

    private void dataChanged() {
        this.validateCaret();
        this.validateSelection();
        this.recomputeLayout();
    }

    @Override
    public int getCharactersPerRow() {
        return this.structure.getHalfCharsPerRow();
    }

    @Override
    public int getBytesPerRow() {
        return this.structure.getBytesPerRow();
    }

    @Override
    @Nonnull
    public CodeAreaSection getActiveSection() {
        return ((CaretCapable)((Object)this.codeArea)).getActiveSection();
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.metrics.getMaxBytesPerChar();
    }

    @Override
    @Nonnull
    public byte[] getRowData() {
        return this.rowDataCache.rowData;
    }

    @Override
    public int getCodeLastCharPos() {
        return this.visibility.getCodeLastCharPos();
    }

    @Override
    public long getDataSize() {
        return this.structure.getDataSize();
    }

    @Override
    @Nonnull
    public BinaryData getContentData() {
        return this.codeArea.getContentData();
    }

    @Override
    @Nullable
    public CodeAreaSelection getSelectionHandler() {
        return ((SelectionCapable)((Object)this.codeArea)).getSelectionHandler();
    }

    public int getRowHeight() {
        return this.metrics.getRowHeight();
    }

    private int getHorizontalScrollBarSize() {
        JScrollBar horizontalScrollBar = this.scrollPanel.getHorizontalScrollBar();
        return horizontalScrollBar.isVisible() ? horizontalScrollBar.getHeight() : 0;
    }

    private int getVerticalScrollBarSize() {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        return verticalScrollBar.isVisible() ? verticalScrollBar.getWidth() : 0;
    }

    @Nonnull
    private CodeAreaSection getSection(CodeAreaCaretPosition caretPosition) {
        return caretPosition.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
    }

    protected static class CursorDataCache {
        Rectangle caretRect = new Rectangle();
        Rectangle mirrorCursorRect = new Rectangle();
        final Stroke dashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
        int cursorCharsLength;
        char[] cursorChars;
        int cursorDataLength;
        byte[] cursorData;

        protected CursorDataCache() {
        }
    }

    protected static class RowDataCache {
        char[] headerCodeData;
        char[] headerChars;
        char[] headerCharsShifted;
        char[] rowCodeData;
        byte[] rowData;
        char[] rowPositionCode;
        char[] rowCharacters;
        char[] rowCharactersShifted;

        protected RowDataCache() {
        }
    }
}

