/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.exbin.bined.basic.BasicCodeAreaScrolling;
import org.exbin.bined.basic.BasicCodeAreaStructure;
import org.exbin.bined.basic.ScrollBarVerticalScale;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.basic.BasicCodeAreaDimensions;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaScrollPane
extends JScrollPane {
    protected volatile boolean scrollingByUser = false;
    protected volatile boolean scrollingUpdate = false;
    protected final VerticalScrollBarModel verticalScrollBarModel = new VerticalScrollBarModel();
    protected final HorizontalScrollBarModel horizontalScrollBarModel = new HorizontalScrollBarModel();
    @Nonnull
    protected final BasicCodeAreaMetrics metrics;
    @Nonnull
    protected final BasicCodeAreaStructure structure;
    @Nonnull
    protected final BasicCodeAreaScrolling scrolling;
    @Nonnull
    protected final BasicCodeAreaDimensions dimensions;
    @Nonnull
    protected final CodeAreaSwingControl control;

    public DefaultCodeAreaScrollPane(CodeAreaSwingControl control, BasicCodeAreaMetrics metrics, BasicCodeAreaStructure structure, BasicCodeAreaDimensions dimensions, BasicCodeAreaScrolling scrolling) {
        this.control = control;
        this.metrics = metrics;
        this.structure = structure;
        this.dimensions = dimensions;
        this.scrolling = scrolling;
        this.init();
    }

    private void init() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setIgnoreRepaint(true);
        this.setOpaque(false);
        this.setInheritsPopupMenu(true);
        this.setViewportBorder(null);
        this.verticalScrollBar.setIgnoreRepaint(true);
        this.verticalScrollBar.addAdjustmentListener(new VerticalAdjustmentListener());
        this.verticalScrollBar.setModel(this.verticalScrollBarModel);
        this.verticalScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    DefaultCodeAreaScrollPane.this.scrollingByUser = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    DefaultCodeAreaScrollPane.this.scrollingByUser = false;
                }
            }
        });
        this.horizontalScrollBar.setIgnoreRepaint(true);
        this.horizontalScrollBar.addAdjustmentListener(new HorizontalAdjustmentListener());
        this.horizontalScrollBar.setModel(this.horizontalScrollBarModel);
        this.horizontalScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    DefaultCodeAreaScrollPane.this.scrollingByUser = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e15) {
                if (e15.getButton() == 1) {
                    DefaultCodeAreaScrollPane.this.scrollingByUser = false;
                }
            }
        });
    }

    @Override
    @Nonnull
    public JScrollBar createVerticalScrollBar() {
        return new JScrollPane.ScrollBar(1){

            @Override
            public void setValue(int value) {
                if (!DefaultCodeAreaScrollPane.this.scrollingUpdate && !DefaultCodeAreaScrollPane.this.scrollingByUser) {
                    DefaultCodeAreaScrollPane.this.scrollingByUser = true;
                    super.setValue(value);
                    DefaultCodeAreaScrollPane.this.scrollingByUser = false;
                } else {
                    super.setValue(value);
                }
            }
        };
    }

    @Override
    @Nonnull
    public JScrollBar createHorizontalScrollBar() {
        return new JScrollPane.ScrollBar(0){

            @Override
            public void setValue(int value) {
                if (!DefaultCodeAreaScrollPane.this.scrollingUpdate && !DefaultCodeAreaScrollPane.this.scrollingByUser) {
                    DefaultCodeAreaScrollPane.this.scrollingByUser = true;
                    super.setValue(value);
                    DefaultCodeAreaScrollPane.this.scrollingByUser = false;
                } else {
                    super.setValue(value);
                }
            }
        };
    }

    public void horizontalExtentChanged() {
        this.horizontalScrollBarModel.notifyChanged();
    }

    public void verticalExtentChanged() {
        this.verticalScrollBarModel.notifyChanged();
    }

    public void updateScrollBars(int verticalScrollValue, int horizontalScrollValue) {
        this.scrollingUpdate = true;
        this.verticalScrollBar.setValue(verticalScrollValue);
        this.horizontalScrollBar.setValue(horizontalScrollValue);
        this.scrollingUpdate = false;
    }

    protected class HorizontalAdjustmentListener
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(@Nullable AdjustmentEvent e15) {
            if (e15 == null || !DefaultCodeAreaScrollPane.this.scrollingByUser || DefaultCodeAreaScrollPane.this.scrollingUpdate) {
                return;
            }
            int scrollBarValue = DefaultCodeAreaScrollPane.this.horizontalScrollBar.getValue();
            DefaultCodeAreaScrollPane.this.scrolling.updateHorizontalScrollBarValue(scrollBarValue, DefaultCodeAreaScrollPane.this.metrics.getCharacterWidth());
            DefaultCodeAreaScrollPane.this.control.updateScrollPosition(DefaultCodeAreaScrollPane.this.scrolling.getScrollPosition());
        }
    }

    protected class VerticalAdjustmentListener
    implements AdjustmentListener {
        private boolean wasAdjusting = false;

        @Override
        public void adjustmentValueChanged(@Nullable AdjustmentEvent e15) {
            if (e15 == null || DefaultCodeAreaScrollPane.this.scrollingUpdate) {
                return;
            }
            if (!e15.getValueIsAdjusting()) {
                if (this.wasAdjusting) {
                    this.wasAdjusting = false;
                } else {
                    int lastValue = DefaultCodeAreaScrollPane.this.scrolling.getLastVerticalScrollingValue();
                    if (DefaultCodeAreaScrollPane.this.scrollingByUser && DefaultCodeAreaScrollPane.this.scrolling.getScrollBarVerticalScale() == ScrollBarVerticalScale.SCALED && lastValue != -1) {
                        if (e15.getValue() == lastValue - 1 || lastValue == 0 && e15.getValue() == 0) {
                            SwingUtilities.invokeLater(() -> {
                                DefaultCodeAreaScrollPane.this.scrolling.performScrolling(ScrollingDirection.UP, DefaultCodeAreaScrollPane.this.dimensions.getRowsPerPage(), DefaultCodeAreaScrollPane.this.structure.getRowsPerDocument());
                                DefaultCodeAreaScrollPane.this.control.updateScrollPosition(DefaultCodeAreaScrollPane.this.scrolling.getScrollPosition());
                            });
                            return;
                        }
                        int maxScroll = DefaultCodeAreaScrollPane.this.verticalScrollBarModel.getMaximum() - DefaultCodeAreaScrollPane.this.verticalScrollBarModel.getExtent();
                        if (e15.getValue() == lastValue + 1 || lastValue == maxScroll && e15.getValue() == maxScroll) {
                            SwingUtilities.invokeLater(() -> {
                                DefaultCodeAreaScrollPane.this.scrolling.performScrolling(ScrollingDirection.DOWN, DefaultCodeAreaScrollPane.this.dimensions.getRowsPerPage(), DefaultCodeAreaScrollPane.this.structure.getRowsPerDocument());
                                DefaultCodeAreaScrollPane.this.control.updateScrollPosition(DefaultCodeAreaScrollPane.this.scrolling.getScrollPosition());
                            });
                            return;
                        }
                    }
                }
            } else {
                this.wasAdjusting = true;
            }
            if (DefaultCodeAreaScrollPane.this.scrollingByUser) {
                int scrollBarValue = DefaultCodeAreaScrollPane.this.verticalScrollBar.getValue();
                int maxValue = DefaultCodeAreaScrollPane.this.scrolling.getMaximumScrollBarHeight() - DefaultCodeAreaScrollPane.this.verticalScrollBar.getVisibleAmount();
                long rowsPerDocumentToLastPage = DefaultCodeAreaScrollPane.this.structure.getRowsPerDocument() - (long)DefaultCodeAreaScrollPane.this.dimensions.getRowsPerRect();
                DefaultCodeAreaScrollPane.this.scrolling.updateVerticalScrollBarValue(scrollBarValue, DefaultCodeAreaScrollPane.this.metrics.getRowHeight(), maxValue, rowsPerDocumentToLastPage);
                DefaultCodeAreaScrollPane.this.control.updateScrollPosition(DefaultCodeAreaScrollPane.this.scrolling.getScrollPosition());
            }
        }
    }

    protected class HorizontalScrollBarModel
    extends DefaultBoundedRangeModel {
        @Override
        public int getExtent() {
            return super.getExtent() - DefaultCodeAreaScrollPane.this.scrolling.getHorizontalExtentDifference();
        }

        @Override
        public int getMaximum() {
            return super.getMaximum() - DefaultCodeAreaScrollPane.this.scrolling.getHorizontalExtentDifference();
        }

        public void notifyChanged() {
            this.fireStateChanged();
        }
    }

    protected class VerticalScrollBarModel
    extends DefaultBoundedRangeModel {
        private volatile int depth = 0;

        @Override
        public int getExtent() {
            return super.getExtent() - DefaultCodeAreaScrollPane.this.scrolling.getVerticalExtentDifference();
        }

        @Override
        public int getMaximum() {
            return super.getMaximum() - DefaultCodeAreaScrollPane.this.scrolling.getVerticalExtentDifference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
            super.setRangeProperties(newValue, newExtent, newMin, newMax, adjusting);
            if (!(DefaultCodeAreaScrollPane.this.scrollingUpdate || newValue != DefaultCodeAreaScrollPane.this.scrolling.getLastVerticalScrollingValue() || newValue > newMin && newValue < newMax - newExtent)) {
                ++this.depth;
                try {
                    if (this.depth < 5) {
                        this.fireStateChanged();
                    }
                }
                finally {
                    --this.depth;
                }
            }
        }

        @Override
        public void setValue(int n15) {
            DefaultCodeAreaScrollPane.this.scrolling.setLastVerticalScrollingValue(this.getValue());
            super.setValue(n15);
        }

        public void notifyChanged() {
            this.fireStateChanged();
        }
    }
}

