/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Font;
import java.awt.Graphics;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EmptyBinaryData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.ClipboardHandlingMode;
import org.exbin.bined.CodeAreaCaretListener;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditModeChangedListener;
import org.exbin.bined.EditOperation;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.ScrollingListener;
import org.exbin.bined.SelectionChangedListener;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicBackgroundPaintMode;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.HorizontalScrollUnit;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.VerticalScrollUnit;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.basic.AntialiasingMode;
import org.exbin.bined.swing.basic.DefaultCodeArea;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;
import org.exbin.bined.swing.basic.DefaultCodeAreaCommandHandler;
import org.exbin.bined.swing.basic.DefaultCodeAreaPainter;
import org.exbin.bined.swing.basic.color.BasicCodeAreaColorsProfile;
import org.exbin.bined.swing.basic.color.BasicColorsCapableCodeAreaPainter;

@ParametersAreNonnullByDefault
public class CodeArea
extends CodeAreaCore
implements DefaultCodeArea,
CodeAreaSwingControl {
    @Nonnull
    protected CodeAreaPainter painter;
    @Nonnull
    protected final DefaultCodeAreaCaret codeAreaCaret;
    @Nonnull
    protected final CodeAreaSelection selection = new CodeAreaSelection();
    @Nonnull
    protected final CodeAreaScrollPosition scrollPosition = new CodeAreaScrollPosition();
    @Nonnull
    protected Charset charset = Charset.forName("UTF-8");
    @Nonnull
    protected ClipboardHandlingMode clipboardHandlingMode = ClipboardHandlingMode.PROCESS;
    @Nonnull
    protected EditMode editMode = EditMode.EXPANDING;
    @Nonnull
    protected EditOperation editOperation = EditOperation.OVERWRITE;
    @Nonnull
    protected CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;
    @Nullable
    protected Font codeFont;
    @Nonnull
    protected BasicBackgroundPaintMode backgroundPaintMode = BasicBackgroundPaintMode.STRIPED;
    @Nonnull
    protected AntialiasingMode antialiasingMode = AntialiasingMode.AUTO;
    @Nonnull
    protected CodeType codeType = CodeType.HEXADECIMAL;
    @Nonnull
    protected CodeCharactersCase codeCharactersCase = CodeCharactersCase.UPPER;
    protected boolean showMirrorCursor = true;
    @Nonnull
    protected RowWrappingMode rowWrapping = RowWrappingMode.NO_WRAPPING;
    protected int minRowPositionLength = 0;
    protected int maxRowPositionLength = 0;
    protected int wrappingBytesGroupSize = 0;
    protected int maxBytesPerRow = 16;
    @Nonnull
    protected ScrollBarVisibility verticalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    protected VerticalScrollUnit verticalScrollUnit = VerticalScrollUnit.ROW;
    @Nonnull
    protected ScrollBarVisibility horizontalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    @Nonnull
    protected HorizontalScrollUnit horizontalScrollUnit = HorizontalScrollUnit.PIXEL;
    private final List<CodeAreaCaretListener> caretMovedListeners = new ArrayList<CodeAreaCaretListener>();
    private final List<ScrollingListener> scrollingListeners = new ArrayList<ScrollingListener>();
    private final List<SelectionChangedListener> selectionChangedListeners = new ArrayList<SelectionChangedListener>();
    private final List<EditModeChangedListener> editModeChangedListeners = new ArrayList<EditModeChangedListener>();

    public CodeArea() {
        this(DefaultCodeAreaCommandHandler.createDefaultCodeAreaCommandHandlerFactory());
    }

    public CodeArea(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        this(commandHandlerFactory, EmptyBinaryData.getInstance());
    }

    public CodeArea(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory, BinaryData contentData) {
        super(commandHandlerFactory, contentData);
        this.painter = new DefaultCodeAreaPainter(this);
        this.codeAreaCaret = new DefaultCodeAreaCaret(this::notifyCaretChanged);
        this.painter.attach();
        this.init();
    }

    private void init() {
        UIManager.addPropertyChangeListener(evt -> this.resetColors());
        this.codeAreaCaret.setSection(BasicCodeAreaSection.CODE_MATRIX);
    }

    @Nonnull
    public CodeAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(CodeAreaPainter painter) {
        CodeAreaUtils.requireNonNull(painter);
        this.painter.detach();
        this.painter = painter;
        painter.attach();
        this.reset();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g15) {
        this.painter.paintComponent(g15);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getBorder() == null) {
            super.setBorder(UIManager.getLookAndFeel().getDefaults().getBorder("TextAreaUI.border"));
        }
        if (this.painter != null) {
            this.painter.rebuildColors();
            this.painter.resetFont();
            this.painter.resetColors();
        }
    }

    @Override
    public void setBorder(@Nullable Border border) {
        super.setBorder(border);
        this.updateLayout();
    }

    @Override
    @Nonnull
    public DefaultCodeAreaCaret getCodeAreaCaret() {
        return this.codeAreaCaret;
    }

    @Override
    public boolean isShowMirrorCursor() {
        return this.showMirrorCursor;
    }

    @Override
    public void setShowMirrorCursor(boolean showMirrorCursor) {
        this.showMirrorCursor = showMirrorCursor;
        this.updateLayout();
    }

    @Override
    public int getMinRowPositionLength() {
        return this.minRowPositionLength;
    }

    @Override
    public void setMinRowPositionLength(int minRowPositionLength) {
        this.minRowPositionLength = minRowPositionLength;
        this.updateLayout();
    }

    @Override
    public int getMaxRowPositionLength() {
        return this.maxRowPositionLength;
    }

    @Override
    public void setMaxRowPositionLength(int maxRowPositionLength) {
        this.maxRowPositionLength = maxRowPositionLength;
        this.updateLayout();
    }

    public boolean isInitialized() {
        return this.painter.isInitialized();
    }

    @Override
    public long getDataPosition() {
        return this.codeAreaCaret.getDataPosition();
    }

    @Override
    public int getCodeOffset() {
        return this.codeAreaCaret.getCodeOffset();
    }

    @Override
    @Nonnull
    public CodeAreaSection getActiveSection() {
        return this.codeAreaCaret.getSection();
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition getActiveCaretPosition() {
        return this.codeAreaCaret.getCaretPosition();
    }

    @Override
    public void setActiveCaretPosition(CodeAreaCaretPosition caretPosition) {
        this.codeAreaCaret.setCaretPosition(caretPosition);
        this.notifyCaretMoved();
    }

    @Override
    public void setActiveCaretPosition(long dataPosition) {
        this.codeAreaCaret.setCaretPosition(dataPosition);
        this.notifyCaretMoved();
    }

    @Override
    public void setActiveCaretPosition(long dataPosition, int codeOffset) {
        this.codeAreaCaret.setCaretPosition(dataPosition, codeOffset);
        this.notifyCaretMoved();
    }

    @Override
    public int getMouseCursorShape(int positionX, int positionY) {
        return this.painter.getMouseCursorShape(positionX, positionY);
    }

    @Override
    @Nonnull
    public CodeCharactersCase getCodeCharactersCase() {
        return this.codeCharactersCase;
    }

    @Override
    public void setCodeCharactersCase(CodeCharactersCase codeCharactersCase) {
        this.codeCharactersCase = codeCharactersCase;
        this.updateLayout();
    }

    @Override
    public void resetColors() {
        this.painter.resetColors();
        this.repaint();
    }

    @Override
    @Nonnull
    public CodeAreaViewMode getViewMode() {
        return this.viewMode;
    }

    @Override
    public void setViewMode(CodeAreaViewMode viewMode) {
        if (viewMode != this.viewMode) {
            this.viewMode = viewMode;
            switch (viewMode) {
                case CODE_MATRIX: {
                    this.codeAreaCaret.setSection(BasicCodeAreaSection.CODE_MATRIX);
                    this.reset();
                    this.notifyCaretMoved();
                    break;
                }
                case TEXT_PREVIEW: {
                    this.codeAreaCaret.setSection(BasicCodeAreaSection.TEXT_PREVIEW);
                    this.reset();
                    this.notifyCaretMoved();
                    break;
                }
                default: {
                    this.reset();
                }
            }
            this.updateLayout();
        }
    }

    @Override
    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Override
    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
        this.validateCaret();
        this.updateLayout();
    }

    public void validateCaret() {
        boolean moved = false;
        if (this.codeAreaCaret.getDataPosition() > this.getDataSize()) {
            this.codeAreaCaret.setDataPosition(this.getDataSize());
            moved = true;
        }
        if (this.codeAreaCaret.getSection() == BasicCodeAreaSection.CODE_MATRIX && this.codeAreaCaret.getCodeOffset() >= this.codeType.getMaxDigitsForByte()) {
            this.codeAreaCaret.setCodeOffset(this.codeType.getMaxDigitsForByte() - 1);
            moved = true;
        }
        if (moved) {
            this.notifyCaretMoved();
        }
    }

    @Override
    public void revealCursor() {
        this.revealPosition(this.codeAreaCaret.getCaretPosition());
    }

    @Override
    public void revealPosition(CodeAreaCaretPosition caretPosition) {
        if (!this.isInitialized()) {
            return;
        }
        Optional<CodeAreaScrollPosition> revealScrollPosition = this.painter.computeRevealScrollPosition(caretPosition);
        revealScrollPosition.ifPresent(this::setScrollPosition);
    }

    public void revealPosition(long dataPosition, int dataOffset, CodeAreaSection section) {
        this.revealPosition(new DefaultCodeAreaCaretPosition(dataPosition, dataOffset, section));
    }

    @Override
    public void centerOnCursor() {
        this.centerOnPosition(this.codeAreaCaret.getCaretPosition());
    }

    @Override
    public void centerOnPosition(CodeAreaCaretPosition caretPosition) {
        if (!this.isInitialized()) {
            return;
        }
        Optional<CodeAreaScrollPosition> centerOnScrollPosition = this.painter.computeCenterOnScrollPosition(caretPosition);
        centerOnScrollPosition.ifPresent(this::setScrollPosition);
    }

    public void centerOnPosition(long dataPosition, int dataOffset, CodeAreaSection section) {
        this.centerOnPosition(new DefaultCodeAreaCaretPosition(dataPosition, dataOffset, section));
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition mousePositionToClosestCaretPosition(int positionX, int positionY, CaretOverlapMode overlapMode) {
        return this.painter.mousePositionToClosestCaretPosition(positionX, positionY, overlapMode);
    }

    @Override
    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction) {
        return this.painter.computeMovePosition(position, direction);
    }

    @Override
    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection scrollingShift) {
        return this.painter.computeScrolling(startPosition, scrollingShift);
    }

    public void updateScrollBars() {
        this.painter.updateScrollBars();
        this.repaint();
    }

    @Override
    @Nonnull
    public CodeAreaScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    @Override
    public void setScrollPosition(CodeAreaScrollPosition scrollPosition) {
        if (!scrollPosition.equals(this.scrollPosition)) {
            this.scrollPosition.setScrollPosition(scrollPosition);
            this.painter.scrollPositionModified();
            this.updateScrollBars();
            this.notifyScrolled();
        }
    }

    @Override
    public void updateScrollPosition(CodeAreaScrollPosition scrollPosition) {
        if (!scrollPosition.equals(this.scrollPosition)) {
            this.scrollPosition.setScrollPosition(scrollPosition);
            this.repaint();
            this.notifyScrolled();
        }
    }

    @Override
    @Nonnull
    public ScrollBarVisibility getVerticalScrollBarVisibility() {
        return this.verticalScrollBarVisibility;
    }

    @Override
    public void setVerticalScrollBarVisibility(ScrollBarVisibility verticalScrollBarVisibility) {
        this.verticalScrollBarVisibility = verticalScrollBarVisibility;
        this.resetPainter();
        this.updateScrollBars();
    }

    @Override
    @Nonnull
    public VerticalScrollUnit getVerticalScrollUnit() {
        return this.verticalScrollUnit;
    }

    @Override
    public void setVerticalScrollUnit(VerticalScrollUnit verticalScrollUnit) {
        this.verticalScrollUnit = verticalScrollUnit;
        long rowPosition = this.scrollPosition.getRowPosition();
        if (verticalScrollUnit == VerticalScrollUnit.ROW) {
            this.scrollPosition.setRowOffset(0);
        }
        this.resetPainter();
        this.scrollPosition.setRowPosition(rowPosition);
        this.updateScrollBars();
        this.notifyScrolled();
    }

    @Override
    @Nonnull
    public ScrollBarVisibility getHorizontalScrollBarVisibility() {
        return this.horizontalScrollBarVisibility;
    }

    @Override
    public void setHorizontalScrollBarVisibility(ScrollBarVisibility horizontalScrollBarVisibility) {
        this.horizontalScrollBarVisibility = horizontalScrollBarVisibility;
        this.resetPainter();
        this.updateScrollBars();
    }

    @Override
    @Nonnull
    public HorizontalScrollUnit getHorizontalScrollUnit() {
        return this.horizontalScrollUnit;
    }

    @Override
    public void setHorizontalScrollUnit(HorizontalScrollUnit horizontalScrollUnit) {
        this.horizontalScrollUnit = horizontalScrollUnit;
        int charPosition = this.scrollPosition.getCharPosition();
        if (horizontalScrollUnit == HorizontalScrollUnit.CHARACTER) {
            this.scrollPosition.setCharOffset(0);
        }
        this.resetPainter();
        this.scrollPosition.setCharPosition(charPosition);
        this.updateScrollBars();
        this.notifyScrolled();
    }

    @Override
    public void reset() {
        this.painter.reset();
    }

    @Override
    public void updateLayout() {
        this.painter.resetLayout();
        this.repaint();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void resetPainter() {
        this.painter.reset();
    }

    protected void notifyCaretChanged() {
        this.painter.resetCaret();
        this.repaint();
    }

    @Override
    public void notifyDataChanged() {
        super.notifyDataChanged();
        this.updateLayout();
    }

    @Override
    @Nonnull
    public AntialiasingMode getAntialiasingMode() {
        return this.antialiasingMode;
    }

    @Override
    public void setAntialiasingMode(AntialiasingMode antialiasingMode) {
        this.antialiasingMode = antialiasingMode;
        this.reset();
        this.repaint();
    }

    @Override
    @Nonnull
    public SelectionRange getSelection() {
        return this.selection.getRange();
    }

    @Override
    public void setSelection(SelectionRange selectionRange) {
        this.selection.setRange(CodeAreaUtils.requireNonNull(selectionRange));
        this.notifySelectionChanged();
        this.repaint();
    }

    @Override
    public void setSelection(long start, long end) {
        this.selection.setSelection(start, end);
        this.notifySelectionChanged();
        this.repaint();
    }

    @Override
    public void clearSelection() {
        this.selection.clearSelection();
        this.notifySelectionChanged();
        this.repaint();
    }

    @Override
    public boolean hasSelection() {
        return !this.selection.isEmpty();
    }

    @Override
    @Nonnull
    public CodeAreaSelection getSelectionHandler() {
        return this.selection;
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        CodeAreaUtils.requireNonNull(charset);
        this.charset = charset;
        this.reset();
        this.repaint();
    }

    @Override
    public boolean isEditable() {
        return this.editMode != EditMode.READ_ONLY;
    }

    @Override
    @Nonnull
    public EditMode getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(EditMode editMode) {
        boolean changed = editMode != this.editMode;
        this.editMode = editMode;
        if (changed) {
            this.editModeChangedListeners.forEach(listener -> listener.editModeChanged(editMode, this.getActiveOperation()));
            this.codeAreaCaret.resetBlink();
            this.notifyCaretChanged();
            this.repaint();
        }
    }

    @Override
    @Nonnull
    public EditOperation getActiveOperation() {
        switch (this.editMode) {
            case READ_ONLY: {
                return EditOperation.INSERT;
            }
            case INPLACE: {
                return EditOperation.OVERWRITE;
            }
            case CAPPED: 
            case EXPANDING: {
                return this.editOperation;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException(this.editMode);
    }

    @Override
    @Nonnull
    public EditOperation getEditOperation() {
        return this.editOperation;
    }

    @Override
    public void setEditOperation(EditOperation editOperation) {
        boolean changed;
        EditOperation previousOperation = this.getActiveOperation();
        this.editOperation = editOperation;
        EditOperation currentOperation = this.getActiveOperation();
        boolean bl4 = changed = previousOperation != currentOperation;
        if (changed) {
            this.editModeChangedListeners.forEach(listener -> listener.editModeChanged(this.editMode, currentOperation));
            this.codeAreaCaret.resetBlink();
            this.notifyCaretChanged();
            this.repaint();
        }
    }

    @Override
    @Nonnull
    public ClipboardHandlingMode getClipboardHandlingMode() {
        return this.clipboardHandlingMode;
    }

    @Override
    public void setClipboardHandlingMode(ClipboardHandlingMode clipboardHandlingMode) {
        this.clipboardHandlingMode = clipboardHandlingMode;
    }

    @Override
    @Nonnull
    public Font getCodeFont() {
        return this.codeFont == null ? super.getFont() : this.codeFont;
    }

    @Override
    public void setCodeFont(Font codeFont) {
        this.codeFont = codeFont;
        this.painter.resetFont();
        this.repaint();
    }

    @Override
    @Nonnull
    public BasicBackgroundPaintMode getBackgroundPaintMode() {
        return this.backgroundPaintMode;
    }

    @Override
    public void setBackgroundPaintMode(BasicBackgroundPaintMode backgroundPaintMode) {
        this.backgroundPaintMode = backgroundPaintMode;
        this.updateLayout();
    }

    @Override
    @Nonnull
    public RowWrappingMode getRowWrapping() {
        return this.rowWrapping;
    }

    @Override
    public void setRowWrapping(RowWrappingMode rowWrapping) {
        this.rowWrapping = rowWrapping;
        this.updateLayout();
    }

    @Override
    public int getWrappingBytesGroupSize() {
        return this.wrappingBytesGroupSize;
    }

    @Override
    public void setWrappingBytesGroupSize(int groupSize) {
        this.wrappingBytesGroupSize = groupSize;
        this.updateLayout();
    }

    @Override
    public int getMaxBytesPerRow() {
        return this.maxBytesPerRow;
    }

    @Override
    public void setMaxBytesPerRow(int maxBytesPerRow) {
        this.maxBytesPerRow = maxBytesPerRow;
        this.updateLayout();
    }

    @Override
    @Nonnull
    public Optional<BasicCodeAreaColorsProfile> getBasicColors() {
        if (this.painter instanceof BasicColorsCapableCodeAreaPainter) {
            return Optional.of(((BasicColorsCapableCodeAreaPainter)((Object)this.painter)).getBasicColors());
        }
        return Optional.empty();
    }

    @Override
    public void setBasicColors(BasicCodeAreaColorsProfile colorsProfile) {
        if (this.painter instanceof BasicColorsCapableCodeAreaPainter) {
            ((BasicColorsCapableCodeAreaPainter)((Object)this.painter)).setBasicColors(colorsProfile);
        }
    }

    protected void notifySelectionChanged() {
        this.selectionChangedListeners.forEach(SelectionChangedListener::selectionChanged);
    }

    protected void notifyCaretMoved() {
        this.caretMovedListeners.forEach(caretMovedListener -> caretMovedListener.caretMoved(this.codeAreaCaret.getCaretPosition()));
    }

    protected void notifyScrolled() {
        this.painter.resetLayout();
        this.scrollingListeners.forEach(ScrollingListener::scrolled);
    }

    @Override
    public void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.add(selectionChangedListener);
    }

    @Override
    public void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.remove(selectionChangedListener);
    }

    @Override
    public void addCaretMovedListener(CodeAreaCaretListener caretMovedListener) {
        this.caretMovedListeners.add(caretMovedListener);
    }

    @Override
    public void removeCaretMovedListener(CodeAreaCaretListener caretMovedListener) {
        this.caretMovedListeners.remove(caretMovedListener);
    }

    @Override
    public void addScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.add(scrollingListener);
    }

    @Override
    public void removeScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.remove(scrollingListener);
    }

    @Override
    public void addEditModeChangedListener(EditModeChangedListener editModeChangedListener) {
        this.editModeChangedListeners.add(editModeChangedListener);
    }

    @Override
    public void removeEditModeChangedListener(EditModeChangedListener editModeChangedListener) {
        this.editModeChangedListeners.remove(editModeChangedListener);
    }
}

