/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;

@ParametersAreNonnullByDefault
public class BasicCodeAreaDimensions {
    protected int scrollPanelX;
    protected int scrollPanelY;
    protected int scrollPanelWidth;
    protected int scrollPanelHeight;
    protected int verticalScrollBarSize;
    protected int horizontalScrollBarSize;
    protected int dataViewWidth;
    protected int dataViewHeight;
    protected int lastCharOffset;
    protected int lastRowOffset;
    protected int headerAreaHeight;
    protected int rowPositionAreaWidth;
    protected int rowsPerRect;
    protected int rowsPerPage;
    protected int charactersPerPage;
    protected int charactersPerRect;
    protected final Rectangle componentRectangle = new Rectangle();
    protected final Rectangle mainAreaRectangle = new Rectangle();
    protected final Rectangle headerAreaRectangle = new Rectangle();
    protected final Rectangle rowPositionAreaRectangle = new Rectangle();
    protected final Rectangle scrollPanelRectangle = new Rectangle();
    protected final Rectangle dataViewRectangle = new Rectangle();

    public void recomputeSizes(BasicCodeAreaMetrics metrics, int componentX, int componentY, int componentWidth, int componentHeight, int rowPositionLength, int verticalScrollBarSize, int horizontalScrollBarSize) {
        boolean availableHeight;
        this.componentRectangle.setBounds(componentX, componentY, componentWidth, componentHeight);
        this.verticalScrollBarSize = verticalScrollBarSize;
        this.horizontalScrollBarSize = horizontalScrollBarSize;
        this.rowPositionAreaWidth = metrics.getCharacterWidth() * (rowPositionLength + 1);
        this.headerAreaHeight = metrics.getFontHeight() + metrics.getFontHeight() / 4;
        this.scrollPanelX = componentX + this.rowPositionAreaWidth;
        this.scrollPanelY = componentY + this.headerAreaHeight;
        this.scrollPanelWidth = componentWidth - this.rowPositionAreaWidth;
        this.scrollPanelHeight = componentHeight - this.headerAreaHeight;
        this.dataViewWidth = this.scrollPanelWidth - verticalScrollBarSize;
        this.dataViewHeight = this.scrollPanelHeight - horizontalScrollBarSize;
        this.charactersPerRect = this.computeCharactersPerRectangle(metrics);
        this.charactersPerPage = this.computeCharactersPerPage(metrics);
        this.rowsPerRect = this.computeRowsPerRectangle(metrics);
        this.rowsPerPage = this.computeRowsPerPage(metrics);
        this.lastCharOffset = metrics.isInitialized() ? this.dataViewWidth % metrics.getCharacterWidth() : 0;
        this.lastRowOffset = metrics.isInitialized() ? this.dataViewHeight % metrics.getRowHeight() : 0;
        boolean availableWidth = this.rowPositionAreaWidth + verticalScrollBarSize <= componentWidth;
        boolean bl4 = availableHeight = this.scrollPanelY + horizontalScrollBarSize <= componentHeight;
        if (availableWidth && availableHeight) {
            this.mainAreaRectangle.setBounds(componentX + this.rowPositionAreaWidth, this.scrollPanelY, componentWidth - this.rowPositionAreaWidth - this.getVerticalScrollBarSize(), componentHeight - this.scrollPanelY - this.getHorizontalScrollBarSize());
        } else {
            this.mainAreaRectangle.setBounds(0, 0, 0, 0);
        }
        if (availableWidth) {
            this.headerAreaRectangle.setBounds(componentX + this.rowPositionAreaWidth, componentY, componentWidth - this.rowPositionAreaWidth - this.getVerticalScrollBarSize(), this.headerAreaHeight);
        } else {
            this.headerAreaRectangle.setBounds(0, 0, 0, 0);
        }
        if (availableHeight) {
            this.rowPositionAreaRectangle.setBounds(componentX, this.scrollPanelY, this.rowPositionAreaWidth, componentHeight - this.scrollPanelY - this.getHorizontalScrollBarSize());
        } else {
            this.rowPositionAreaRectangle.setBounds(0, 0, 0, 0);
        }
        this.scrollPanelRectangle.setBounds(this.scrollPanelX, this.scrollPanelY, this.scrollPanelWidth, this.scrollPanelHeight);
        this.dataViewRectangle.setBounds(this.scrollPanelX, this.scrollPanelY, Math.max(this.dataViewWidth, 0), Math.max(this.dataViewHeight, 0));
    }

    @Nonnull
    public BasicCodeAreaZone getPositionZone(int positionX, int positionY) {
        if (positionY <= this.scrollPanelY) {
            if (positionX < this.rowPositionAreaWidth) {
                return BasicCodeAreaZone.TOP_LEFT_CORNER;
            }
            return BasicCodeAreaZone.HEADER;
        }
        if (positionX < this.rowPositionAreaWidth) {
            if (positionY >= this.scrollPanelY + this.scrollPanelHeight) {
                return BasicCodeAreaZone.BOTTOM_LEFT_CORNER;
            }
            return BasicCodeAreaZone.ROW_POSITIONS;
        }
        if (positionX >= this.scrollPanelX + this.scrollPanelWidth && positionY < this.scrollPanelY + this.scrollPanelHeight) {
            return BasicCodeAreaZone.VERTICAL_SCROLLBAR;
        }
        if (positionY >= this.scrollPanelY + this.scrollPanelHeight) {
            if (positionX >= this.scrollPanelX + this.scrollPanelWidth) {
                return BasicCodeAreaZone.SCROLLBAR_CORNER;
            }
            return BasicCodeAreaZone.HORIZONTAL_SCROLLBAR;
        }
        return BasicCodeAreaZone.CODE_AREA;
    }

    protected int computeCharactersPerRectangle(BasicCodeAreaMetrics metrics) {
        int characterWidth = metrics.getCharacterWidth();
        return characterWidth == 0 ? 0 : (this.dataViewWidth + characterWidth - 1) / characterWidth;
    }

    protected int computeCharactersPerPage(BasicCodeAreaMetrics metrics) {
        int characterWidth = metrics.getCharacterWidth();
        return characterWidth == 0 ? 0 : this.dataViewWidth / characterWidth;
    }

    protected int computeRowsPerRectangle(BasicCodeAreaMetrics metrics) {
        int rowHeight = metrics.getRowHeight();
        return rowHeight == 0 ? 0 : (this.dataViewHeight + rowHeight - 1) / rowHeight;
    }

    protected int computeRowsPerPage(BasicCodeAreaMetrics metrics) {
        int rowHeight = metrics.getRowHeight();
        return rowHeight == 0 ? 0 : this.dataViewHeight / rowHeight;
    }

    public int getScrollPanelX() {
        return this.scrollPanelX;
    }

    public int getScrollPanelY() {
        return this.scrollPanelY;
    }

    public int getVerticalScrollBarSize() {
        return this.verticalScrollBarSize;
    }

    public int getHorizontalScrollBarSize() {
        return this.horizontalScrollBarSize;
    }

    public int getScrollPanelWidth() {
        return this.scrollPanelWidth;
    }

    public int getScrollPanelHeight() {
        return this.scrollPanelHeight;
    }

    public int getDataViewWidth() {
        return this.dataViewWidth;
    }

    public int getDataViewHeight() {
        return this.dataViewHeight;
    }

    public int getHeaderAreaHeight() {
        return this.headerAreaHeight;
    }

    public int getRowPositionAreaWidth() {
        return this.rowPositionAreaWidth;
    }

    public int getRowsPerRect() {
        return this.rowsPerRect;
    }

    public int getCharactersPerRect() {
        return this.charactersPerRect;
    }

    public int getCharactersPerPage() {
        return this.charactersPerPage;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public int getLastCharOffset() {
        return this.lastCharOffset;
    }

    public int getLastRowOffset() {
        return this.lastRowOffset;
    }

    @Nonnull
    public Rectangle getComponentRectangle() {
        return this.componentRectangle;
    }

    @Nonnull
    public Rectangle getMainAreaRectangle() {
        return this.mainAreaRectangle;
    }

    @Nonnull
    public Rectangle getScrollPanelRectangle() {
        return this.scrollPanelRectangle;
    }

    @Nonnull
    public Rectangle getDataViewRectangle() {
        return this.dataViewRectangle;
    }

    @Nonnull
    public Rectangle getHeaderAreaRectangle() {
        return this.headerAreaRectangle;
    }

    @Nonnull
    public Rectangle getRowPositionAreaRectangle() {
        return this.rowPositionAreaRectangle;
    }
}

