/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EmptyBinaryData;
import org.exbin.bined.CodeAreaControl;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaUI;

@ParametersAreNonnullByDefault
public abstract class CodeAreaCore
extends JTextComponent
implements CodeAreaControl,
Accessible {
    private static final String UI_CLASS_ID = "CodeAreaUI";
    @Nonnull
    protected BinaryData contentData;
    @Nonnull
    protected CodeAreaCommandHandler commandHandler;
    protected final List<DataChangedListener> dataChangedListeners = new ArrayList<DataChangedListener>();

    public CodeAreaCore(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        this(commandHandlerFactory, EmptyBinaryData.getInstance());
    }

    public CodeAreaCore(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory, BinaryData contentData) {
        this.contentData = contentData;
        this.commandHandler = this.createCommandHandler(CodeAreaUtils.requireNonNull(commandHandlerFactory));
        this.init();
    }

    private void init() {
        this.setName("CodeArea");
        this.setDocument(new SimulatedDocument());
        this.setCaret(new SimulatedCaret());
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.registerControlListeners();
    }

    @Nonnull
    private CodeAreaCommandHandler createCommandHandler(CodeAreaCommandHandler.CodeAreaCommandHandlerFactory commandHandlerFactory) {
        return commandHandlerFactory.createCommandHandler(this);
    }

    protected void registerControlListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nonnull ComponentEvent event) {
                CodeAreaCore.this.updateLayout();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(@Nonnull KeyEvent keyEvent) {
                CodeAreaCore.this.commandHandler.keyTyped(keyEvent);
            }

            @Override
            public void keyPressed(@Nonnull KeyEvent keyEvent) {
                CodeAreaCore.this.commandHandler.keyPressed(keyEvent);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@Nonnull FocusEvent e15) {
                CodeAreaCore.this.repaint();
            }

            @Override
            public void focusLost(@Nonnull FocusEvent e15) {
                CodeAreaCore.this.repaint();
            }
        });
    }

    @Nonnull
    public CodeAreaCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public void setCommandHandler(CodeAreaCommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    @Override
    public void copy() {
        this.commandHandler.copy();
    }

    @Override
    public void cut() {
        this.commandHandler.cut();
    }

    @Override
    public void paste() {
        this.commandHandler.paste();
    }

    @Override
    public void delete() {
        this.commandHandler.delete();
    }

    @Override
    public void selectAll() {
        this.commandHandler.selectAll();
    }

    @Override
    public void clearSelection() {
        this.commandHandler.clearSelection();
    }

    @Override
    public boolean canPaste() {
        return this.commandHandler.canPaste();
    }

    @Override
    public boolean hasSelection() {
        if (this instanceof SelectionCapable) {
            return ((SelectionCapable)((Object)this)).hasSelection();
        }
        return false;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    @Nonnull
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
        this.setUI(CodeAreaUI.createUI(this));
        this.invalidate();
    }

    @Override
    @Nonnull
    public BinaryData getContentData() {
        return this.contentData;
    }

    public void setContentData(@Nullable BinaryData contentData) {
        this.contentData = contentData == null ? EmptyBinaryData.getInstance() : contentData;
        this.notifyDataChanged();
        this.repaint();
    }

    @Override
    public long getDataSize() {
        return this.contentData.getDataSize();
    }

    @Override
    @Nonnull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleComponent();
        }
        return this.accessibleContext;
    }

    public void notifyDataChanged() {
        this.dataChangedListeners.forEach(DataChangedListener::dataChanged);
        Document document = this.getDocument();
        if (document instanceof SimulatedDocument) {
            ((SimulatedDocument)document).notifyDataChanged();
        }
    }

    public void addDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataChangedListeners.add(dataChangedListener);
    }

    public void removeDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataChangedListeners.remove(dataChangedListener);
    }

    public abstract void resetPainter();

    public abstract void updateLayout();

    @ParametersAreNonnullByDefault
    protected static class SimulatedCaret
    implements Caret {
        @Nullable
        private JTextComponent component;
        private final EventListenerList listenerList = new EventListenerList();
        private boolean visible = true;
        private boolean selectionVisible = false;
        private int rate;
        private int dot = 1;
        private Point magicCaretPosition = new Point();

        protected SimulatedCaret() {
        }

        @Override
        public void install(JTextComponent component) {
            this.component = component;
        }

        @Override
        public void deinstall(JTextComponent jtc) {
            this.component = null;
        }

        @Override
        public void paint(Graphics g15) {
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.listenerList.add(ChangeListener.class, listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.listenerList.remove(ChangeListener.class, listener);
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isSelectionVisible() {
            return this.selectionVisible;
        }

        @Override
        public void setSelectionVisible(boolean selectionVisible) {
            this.selectionVisible = selectionVisible;
        }

        @Override
        public void setMagicCaretPosition(Point magicCaretPosition) {
            this.magicCaretPosition = magicCaretPosition;
        }

        @Override
        @Nonnull
        public Point getMagicCaretPosition() {
            return this.magicCaretPosition;
        }

        @Override
        public void setBlinkRate(int rate) {
            this.rate = rate;
        }

        @Override
        public int getBlinkRate() {
            return this.rate;
        }

        @Override
        public int getDot() {
            return this.dot;
        }

        @Override
        public int getMark() {
            return 0;
        }

        @Override
        public void setDot(int dot) {
            this.dot = dot;
        }

        @Override
        public void moveDot(int dot) {
            this.dot = dot;
        }
    }

    @ParametersAreNonnullByDefault
    public class AccessibleComponent
    extends JComponent.AccessibleJComponent {
        public AccessibleComponent() {
            super(CodeAreaCore.this);
        }

        @Override
        @Nonnull
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        @Nonnull
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.MULTI_LINE);
            if (CodeAreaCore.this.isEditable()) {
                states.add(AccessibleState.EDITABLE);
            }
            return states;
        }
    }

    public static class SimulatedElement
    implements Element {
        private final Document document;
        private final AttributeSet attributeSet = new SimpleAttributeSet();

        public SimulatedElement(Document document) {
            this.document = document;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public String getName() {
            return "codeArea";
        }

        @Override
        public AttributeSet getAttributes() {
            return this.attributeSet;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return 2;
        }

        @Override
        public int getElementIndex(int offset) {
            return 0;
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public Element getElement(int index) {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    @ParametersAreNonnullByDefault
    protected static class SimulatedDocument
    implements Document {
        private final List<UndoableEditListener> undoableEditListeners = new ArrayList<UndoableEditListener>();
        private final List<DocumentListener> documentListeners = new ArrayList<DocumentListener>();
        private SimulatedElement rootElement = new SimulatedElement(this);

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            this.documentListeners.add(listener);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.documentListeners.remove(listener);
        }

        public void notifyDataChanged() {
            if (this.documentListeners.isEmpty()) {
                return;
            }
            DocumentEvent documentEvent = new DocumentEvent(){

                @Override
                public int getOffset() {
                    return 0;
                }

                @Override
                public int getLength() {
                    return 0;
                }

                @Override
                public Document getDocument() {
                    return this;
                }

                @Override
                @Nonnull
                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.CHANGE;
                }

                @Override
                public DocumentEvent.ElementChange getChange(final Element elem) {
                    return new DocumentEvent.ElementChange(){

                        @Override
                        public Element getElement() {
                            return elem;
                        }

                        @Override
                        public int getIndex() {
                            return 0;
                        }

                        @Override
                        public Element[] getChildrenRemoved() {
                            return new Element[0];
                        }

                        @Override
                        public Element[] getChildrenAdded() {
                            return new Element[0];
                        }
                    };
                }
            };
            this.documentListeners.forEach(t15 -> t15.changedUpdate(documentEvent));
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this.undoableEditListeners.add(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.undoableEditListeners.remove(listener);
        }

        @Override
        @Nullable
        public Object getProperty(Object key) {
            return null;
        }

        @Override
        public void putProperty(Object key, @Nullable Object value) {
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
        }

        @Override
        public void insertString(int i15, String string, AttributeSet as4) throws BadLocationException {
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            if (offset < 2) {
                if (length == 1) {
                    return " ";
                }
                if (offset == 0 && length == 2) {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public void getText(int offset, int length, Segment sgmnt) throws BadLocationException {
            if (offset < 2) {
                if (length == 1) {
                    sgmnt.array = new char[1];
                    sgmnt.array[0] = 32;
                    sgmnt.offset = 0;
                    sgmnt.count = 1;
                    return;
                }
                if (offset == 0 && length == 2) {
                    sgmnt.array = new char[2];
                    sgmnt.array[0] = 32;
                    sgmnt.array[1] = 32;
                    sgmnt.offset = 0;
                    sgmnt.count = 2;
                    return;
                }
            }
            sgmnt.array = new char[0];
            sgmnt.offset = 0;
            sgmnt.count = 0;
        }

        @Override
        @Nonnull
        public Position getStartPosition() {
            return () -> 0;
        }

        @Override
        @Nonnull
        public Position getEndPosition() {
            return () -> 0;
        }

        @Override
        @Nonnull
        public Position createPosition(int i15) throws BadLocationException {
            return () -> i15;
        }

        @Override
        public Element[] getRootElements() {
            Element[] result = new Element[]{this.rootElement};
            return result;
        }

        @Override
        public Element getDefaultRootElement() {
            return this.rootElement;
        }

        @Override
        public void render(Runnable r15) {
        }
    }
}

