/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.highlight.swing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.highlight.swing.SearchMatch;
import org.exbin.bined.highlight.swing.color.CodeAreaMatchColorType;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaPaintState;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;

@ParametersAreNonnullByDefault
public class SearchCodeAreaColorAssessor
implements CodeAreaColorAssessor {
    protected final CodeAreaColorAssessor parentAssessor;
    protected final List<SearchMatch> matches = new ArrayList<SearchMatch>();
    private int currentMatchIndex = -1;
    private int matchIndex = 0;
    private long matchPosition = -1L;
    @Nullable
    protected Color foundMatchesColor;
    @Nullable
    protected Color foundMatchesBackground;
    @Nullable
    protected Color currentMatchColor;
    @Nullable
    protected Color currentMatchBackground;
    protected int charactersPerRow = 1;

    public SearchCodeAreaColorAssessor(@Nullable CodeAreaColorAssessor parentAssessor) {
        this.parentAssessor = parentAssessor;
    }

    @Override
    public void startPaint(CodeAreaPaintState codeAreaPaintState) {
        this.matchIndex = 0;
        this.charactersPerRow = codeAreaPaintState.getCharactersPerRow();
        CodeAreaColorsProfile colorsProfile = codeAreaPaintState.getColorsProfile();
        this.foundMatchesColor = colorsProfile.getColor(CodeAreaMatchColorType.MATCH_COLOR);
        this.foundMatchesBackground = colorsProfile.getColor(CodeAreaMatchColorType.MATCH_BACKGROUND);
        if (this.foundMatchesBackground == null) {
            this.foundMatchesBackground = new Color(180, 255, 180);
        }
        this.currentMatchColor = colorsProfile.getColor(CodeAreaMatchColorType.CURRENT_MATCH_COLOR);
        this.currentMatchBackground = colorsProfile.getColor(CodeAreaMatchColorType.CURRENT_MATCH_BACKGROUND);
        if (this.currentMatchBackground == null) {
            this.currentMatchBackground = new Color(255, 210, 180);
        }
        if (this.parentAssessor != null) {
            this.parentAssessor.startPaint(codeAreaPaintState);
        }
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (!(this.currentMatchColor == null && this.foundMatchesColor == null || this.matches.isEmpty() || charOnRow >= this.charactersPerRow - 1)) {
            long dataPosition = rowDataPosition + (long)byteOnRow;
            if (this.currentMatchIndex >= 0) {
                SearchMatch currentMatch = this.matches.get(this.currentMatchIndex);
                if (this.currentMatchColor != null && dataPosition >= currentMatch.position && dataPosition < currentMatch.position + currentMatch.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (currentMatch.position + currentMatch.length - rowDataPosition) * (long)this.charactersPerRow - 1L)) {
                    return this.currentMatchColor;
                }
            }
            if (this.matchPosition < rowDataPosition) {
                this.matchIndex = 0;
            }
            for (int lineMatchIndex = this.matchIndex; lineMatchIndex < this.matches.size(); ++lineMatchIndex) {
                SearchMatch match = this.matches.get(lineMatchIndex);
                if (dataPosition >= match.position && dataPosition < match.position + match.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (match.position + match.length - rowDataPosition) * (long)this.charactersPerRow - 1L)) {
                    if (byteOnRow == 0) {
                        this.matchIndex = lineMatchIndex;
                        this.matchPosition = match.position;
                    }
                    if (this.foundMatchesColor == null) break;
                    return this.foundMatchesColor;
                }
                if (match.position > dataPosition) break;
                if (byteOnRow != 0) continue;
                this.matchIndex = lineMatchIndex;
                this.matchPosition = match.position;
            }
        }
        if (this.parentAssessor != null) {
            return this.parentAssessor.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (!this.matches.isEmpty() && charOnRow < this.charactersPerRow) {
            long dataPosition = rowDataPosition + (long)byteOnRow;
            if (this.currentMatchIndex >= 0) {
                SearchMatch currentMatch = this.matches.get(this.currentMatchIndex);
                if (dataPosition >= currentMatch.position && dataPosition < currentMatch.position + currentMatch.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (currentMatch.position + currentMatch.length - rowDataPosition) * (long)this.charactersPerRow - 1L)) {
                    return this.currentMatchBackground;
                }
            }
            if (this.matchPosition < rowDataPosition) {
                this.matchIndex = 0;
            }
            for (int lineMatchIndex = this.matchIndex; lineMatchIndex < this.matches.size(); ++lineMatchIndex) {
                SearchMatch match = this.matches.get(lineMatchIndex);
                if (dataPosition >= match.position && dataPosition < match.position + match.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (match.position + match.length - rowDataPosition) * (long)this.charactersPerRow - 1L)) {
                    if (byteOnRow == 0) {
                        this.matchIndex = lineMatchIndex;
                        this.matchPosition = match.position;
                    }
                    return this.foundMatchesBackground;
                }
                if (match.position > dataPosition) break;
                if (byteOnRow != 0) continue;
                this.matchIndex = lineMatchIndex;
                this.matchPosition = match.position;
            }
        }
        if (this.parentAssessor != null) {
            return this.parentAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nonnull
    public Optional<CodeAreaColorAssessor> getParentColorAssessor() {
        return Optional.ofNullable(this.parentAssessor);
    }

    @Nonnull
    public List<SearchMatch> getMatches() {
        return this.matches;
    }

    public void setMatches(List<SearchMatch> matches) {
        this.matches.clear();
        this.matches.addAll(matches);
        this.currentMatchIndex = -1;
    }

    public void clearMatches() {
        this.matches.clear();
        this.currentMatchIndex = -1;
    }

    @Nullable
    public SearchMatch getCurrentMatch() {
        if (this.currentMatchIndex >= 0) {
            return this.matches.get(this.currentMatchIndex);
        }
        return null;
    }

    public int getCurrentMatchIndex() {
        return this.currentMatchIndex;
    }

    public void setCurrentMatchIndex(int currentMatchIndex) {
        this.currentMatchIndex = currentMatchIndex;
    }
}

