/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SelectionRange {
    private final long start;
    private final long end;

    public SelectionRange() {
        this(0L, 0L);
    }

    public SelectionRange(@Nullable SelectionRange selectionRange) {
        if (selectionRange == null) {
            this.end = 0L;
            this.start = 0L;
        } else {
            this.start = selectionRange.start;
            this.end = selectionRange.end;
        }
    }

    public SelectionRange(long start, long end) {
        if (start < 0L) {
            throw new IllegalArgumentException("Selection with negative range start (" + start + ") is not allowed");
        }
        if (end < 0L) {
            throw new IllegalArgumentException("Selection with negative range end (" + end + ") is not allowed");
        }
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getFirst() {
        return Math.min(this.start, this.end);
    }

    public long getLast() {
        return this.start < this.end ? this.end - 1L : this.start - 1L;
    }

    public long getLength() {
        return this.start < this.end ? this.end - this.start : this.start - this.end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public boolean isInSelection(long position) {
        return this.start < this.end ? position >= this.start && position < this.end : position >= this.end && position < this.start;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionRange other = (SelectionRange)obj;
        if (this.start != other.start) {
            return false;
        }
        return this.end == other.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

