/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaCaretPosition
implements CodeAreaCaretPosition {
    private long dataPosition = 0L;
    private int codeOffset = 0;
    @Nullable
    private CodeAreaSection section = null;

    public DefaultCodeAreaCaretPosition() {
    }

    public DefaultCodeAreaCaretPosition(long dataPosition, int codeOffset, CodeAreaSection section) {
        this.dataPosition = dataPosition;
        this.codeOffset = codeOffset;
        this.section = section;
    }

    @Override
    public long getDataPosition() {
        return this.dataPosition;
    }

    public void setDataPosition(long dataPosition) {
        this.dataPosition = dataPosition;
    }

    @Override
    public int getCodeOffset() {
        return this.codeOffset;
    }

    public void setCodeOffset(int codeOffset) {
        this.codeOffset = codeOffset;
    }

    @Override
    @Nonnull
    public Optional<CodeAreaSection> getSection() {
        return Optional.ofNullable(this.section);
    }

    public void setSection(@Nullable CodeAreaSection section) {
        this.section = section;
    }

    public void setPosition(CodeAreaCaretPosition position) {
        this.dataPosition = position.getDataPosition();
        this.codeOffset = position.getCodeOffset();
        this.section = position.getSection().orElse(null);
    }

    @Override
    public void reset() {
        this.dataPosition = 0L;
        this.codeOffset = 0;
        this.section = null;
    }

    public int hashCode() {
        return Objects.hash(this.dataPosition, this.codeOffset, this.section);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultCodeAreaCaretPosition other = (DefaultCodeAreaCaretPosition)obj;
        return Objects.equals(this.dataPosition, other.dataPosition) && Objects.equals(this.codeOffset, other.codeOffset) && Objects.equals(this.section, other.section);
    }
}

