/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data.array;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.BinaryDataOutputStream;
import org.exbin.auxiliary.binary_data.DataOverflowException;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.OutOfBoundsException;
import org.exbin.auxiliary.binary_data.array.ByteArrayData;

@ParametersAreNonnullByDefault
public class ByteArrayEditableData
extends ByteArrayData
implements EditableBinaryData {
    public static final int BUFFER_SIZE = 1024;
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFFA;
    private static final String WRONG_INSERTION_POSITION_ERROR = "Data can be inserted only inside or at the end";
    private static final String WRONG_REPLACE_POSITION_ERROR = "Data can be replaced only inside or at the end";
    private static final String ARRAY_OVERFLOW_ERROR = "Maximum array size overflow";

    public ByteArrayEditableData() {
        this(null);
    }

    public ByteArrayEditableData(@Nullable byte[] data) {
        super(data);
    }

    @Override
    public void setDataSize(long size) {
        if (size < 0L) {
            throw new InvalidParameterException("Size cannot be negative");
        }
        if ((long)this.data.length != size) {
            if (size < (long)this.data.length) {
                this.data = Arrays.copyOfRange(this.data, 0, (int)size);
            } else {
                byte[] newData = new byte[(int)size];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }
    }

    @Override
    public void setByte(long position, byte value) {
        try {
            this.data[(int)position] = value;
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            throw new OutOfBoundsException(ex4);
        }
    }

    @Override
    public void insertUninitialized(long startFrom, long length) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException(WRONG_INSERTION_POSITION_ERROR);
        }
        if (length > (long)(0x7FFFFFFA - this.data.length)) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        if (length > 0L) {
            byte[] newData = new byte[(int)((long)this.data.length + length)];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, long length) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException(WRONG_INSERTION_POSITION_ERROR);
        }
        if (length > (long)(0x7FFFFFFA - this.data.length)) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        if (length > 0L) {
            byte[] newData = new byte[(int)((long)this.data.length + length)];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, byte[] insertedData) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException(WRONG_INSERTION_POSITION_ERROR);
        }
        if (insertedData.length > 0x7FFFFFFA - this.data.length) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        int length = insertedData.length;
        if (length > 0) {
            byte[] newData = new byte[this.data.length + length];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            try {
                System.arraycopy(insertedData, 0, newData, (int)startFrom, length);
            }
            catch (ArrayIndexOutOfBoundsException ex4) {
                throw new OutOfBoundsException(ex4);
            }
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + (long)length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, byte[] insertedData, int insertedDataOffset, int length) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException(WRONG_INSERTION_POSITION_ERROR);
        }
        if (length > 0x7FFFFFFA - this.data.length) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        if (length > 0) {
            byte[] newData = new byte[this.data.length + length];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            try {
                System.arraycopy(insertedData, insertedDataOffset, newData, (int)startFrom, length);
            }
            catch (ArrayIndexOutOfBoundsException ex4) {
                throw new OutOfBoundsException(ex4);
            }
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + (long)length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, BinaryData insertedData) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException(WRONG_INSERTION_POSITION_ERROR);
        }
        if (insertedData.getDataSize() > (long)(0x7FFFFFFA - this.data.length)) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        if (insertedData instanceof ByteArrayData) {
            this.insert(startFrom, ((ByteArrayData)insertedData).data);
        } else {
            this.insert(startFrom, insertedData, 0L, insertedData.getDataSize());
        }
    }

    @Override
    public void insert(long startFrom, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException(WRONG_INSERTION_POSITION_ERROR);
        }
        if (insertedDataLength > (long)(0x7FFFFFFA - this.data.length)) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        if (insertedData instanceof ByteArrayData) {
            if (insertedDataOffset > Integer.MAX_VALUE || insertedDataLength > Integer.MAX_VALUE) {
                throw new OutOfBoundsException("Out of range");
            }
            this.insert(startFrom, ((ByteArrayData)insertedData).data, (int)insertedDataOffset, (int)insertedDataLength);
        } else {
            long length = insertedDataLength;
            if (length > 0L) {
                byte[] newData = new byte[(int)((long)this.data.length + length)];
                System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
                int i15 = 0;
                while ((long)i15 < length) {
                    newData[(int)(startFrom + (long)i15)] = insertedData.getByte(insertedDataOffset + (long)i15);
                    ++i15;
                }
                System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + length), (int)((long)this.data.length - startFrom));
                this.data = newData;
            }
        }
    }

    @Override
    public long insert(long startFrom, InputStream inputStream, long dataSize) throws IOException {
        if (dataSize > (long)(0x7FFFFFFA - this.data.length)) {
            throw new DataOverflowException(ARRAY_OVERFLOW_ERROR);
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] newData;
            byte[] buffer = new byte[1024];
            if (dataSize > 0L) {
                int read;
                do {
                    int toRead;
                    if ((long)(toRead = buffer.length) > dataSize) {
                        toRead = (int)dataSize;
                    }
                    if ((read = inputStream.read(buffer, 0, toRead)) <= 0) continue;
                    output.write(buffer, 0, read);
                    dataSize -= (long)read;
                } while (read > 0 && dataSize > 0L);
            }
            if (startFrom + (long)(newData = output.toByteArray()).length > this.getDataSize()) {
                this.setDataSize(startFrom + (long)newData.length);
            }
            this.replace(startFrom, newData);
            long l15 = newData.length;
            return l15;
        }
    }

    @Override
    public void fillData(long startFrom, long length) {
        this.fillData(startFrom, length, (byte)0);
    }

    @Override
    public void fillData(long startFrom, long length, byte fill) {
        if (length > 0L) {
            try {
                Arrays.fill(this.data, (int)startFrom, (int)(startFrom + length), fill);
            }
            catch (ArrayIndexOutOfBoundsException ex4) {
                throw new OutOfBoundsException(ex4);
            }
        }
    }

    @Override
    public void replace(long targetPosition, BinaryData sourceData) {
        this.replace(targetPosition, sourceData, 0L, sourceData.getDataSize());
    }

    @Override
    public void replace(long targetPosition, BinaryData replacingData, long startFrom, long replacingLength) {
        if (targetPosition + replacingLength > this.getDataSize()) {
            throw new OutOfBoundsException(WRONG_REPLACE_POSITION_ERROR);
        }
        if (replacingData instanceof ByteArrayData) {
            this.replace(targetPosition, ((ByteArrayData)replacingData).data, (int)startFrom, (int)replacingLength);
        } else {
            while (replacingLength > 0L) {
                this.setByte(targetPosition, replacingData.getByte(startFrom));
                ++targetPosition;
                ++startFrom;
                --replacingLength;
            }
        }
    }

    @Override
    public void replace(long targetPosition, byte[] replacingData) {
        this.replace(targetPosition, replacingData, 0, replacingData.length);
    }

    @Override
    public void replace(long targetPosition, byte[] replacingData, int replacingDataOffset, int length) {
        if (targetPosition + (long)length > this.getDataSize()) {
            throw new OutOfBoundsException(WRONG_REPLACE_POSITION_ERROR);
        }
        try {
            System.arraycopy(replacingData, replacingDataOffset, this.data, (int)targetPosition, length);
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            throw new OutOfBoundsException(ex4);
        }
    }

    @Override
    public void remove(long startFrom, long length) {
        if (startFrom + length > (long)this.data.length) {
            throw new OutOfBoundsException("Cannot remove from " + startFrom + " with length " + length);
        }
        if (length > 0L) {
            byte[] newData = new byte[(int)((long)this.data.length - length)];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            System.arraycopy(this.data, (int)(startFrom + length), newData, (int)startFrom, (int)((long)this.data.length - startFrom - length));
            this.data = newData;
        }
    }

    @Override
    @Nonnull
    public ByteArrayEditableData copy() {
        byte[] copy = Arrays.copyOf(this.data, this.data.length);
        return new ByteArrayEditableData(copy);
    }

    @Override
    @Nonnull
    public ByteArrayEditableData copy(long startFrom, long length) {
        if (startFrom + length > (long)this.data.length) {
            throw new OutOfBoundsException("Attempt to copy outside of data");
        }
        byte[] copy = Arrays.copyOfRange(this.data, (int)startFrom, (int)(startFrom + length));
        return new ByteArrayEditableData(copy);
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public void loadFromStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int read;
            byte[] buffer = new byte[1024];
            do {
                if ((read = inputStream.read(buffer)) <= 0) continue;
                output.write(buffer, 0, read);
            } while (read > 0);
            this.data = output.toByteArray();
        }
    }

    @Override
    @Nonnull
    public OutputStream getDataOutputStream() {
        return new BinaryDataOutputStream(this);
    }
}

