/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import antlr.CharScanner;
import antlr.CommonAST;
import antlr.CommonToken;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import antlr.collections.ASTEnumeration;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ASTExpr;
import org.antlr.stringtemplate.language.ActionLexer;
import org.antlr.stringtemplate.language.ActionParser;
import org.antlr.stringtemplate.language.ConditionalExpr;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.FormalArgument;
import org.antlr.stringtemplate.language.NewlineRef;
import org.antlr.stringtemplate.language.StringTemplateAST;
import org.antlr.stringtemplate.language.TemplateParser;

public class StringTemplate {
    public static final String VERSION = "3.2.1";
    public static final int REGION_IMPLICIT = 1;
    public static final int REGION_EMBEDDED = 2;
    public static final int REGION_EXPLICIT = 3;
    public static final String ANONYMOUS_ST_NAME = "anonymous";
    static boolean lintMode = false;
    protected List referencedAttributes = null;
    protected String name = "anonymous";
    private static int templateCounter = 0;
    protected int templateID = StringTemplate.getNextTemplateCounter();
    protected StringTemplate enclosingInstance = null;
    protected Map argumentContext = null;
    protected StringTemplateAST argumentsAST = null;
    protected LinkedHashMap formalArguments = FormalArgument.UNKNOWN;
    protected int numberOfDefaultArgumentValues = 0;
    protected boolean passThroughAttributes = false;
    protected StringTemplateGroup nativeGroup;
    protected StringTemplateGroup group = defaultGroup;
    protected int groupFileLine;
    StringTemplateErrorListener listener = null;
    protected String pattern;
    protected Map attributes;
    protected Map attributeRenderers;
    protected List chunks;
    protected int regionDefType;
    protected boolean isRegion;
    protected Set regions;
    public static StringTemplateGroup defaultGroup = new StringTemplateGroup("defaultGroup", ".");

    private static synchronized int getNextTemplateCounter() {
        return ++templateCounter;
    }

    public static void resetTemplateCounter() {
        templateCounter = 0;
    }

    public StringTemplate() {
    }

    public StringTemplate(String template) {
        this(null, template);
    }

    public StringTemplate(String template, Class lexer) {
        this();
        this.setGroup(new StringTemplateGroup("defaultGroup", lexer));
        this.setTemplate(template);
    }

    public StringTemplate(StringTemplateGroup group, String template) {
        this();
        if (group != null) {
            this.setGroup(group);
        }
        this.setTemplate(template);
    }

    public StringTemplate(StringTemplateGroup group, String template, HashMap attributes) {
        this(group, template);
        this.attributes = attributes;
    }

    protected void dup(StringTemplate from, StringTemplate to4) {
        to4.attributeRenderers = from.attributeRenderers;
        to4.pattern = from.pattern;
        to4.chunks = from.chunks;
        to4.formalArguments = from.formalArguments;
        to4.numberOfDefaultArgumentValues = from.numberOfDefaultArgumentValues;
        to4.name = from.name;
        to4.group = from.group;
        to4.nativeGroup = from.nativeGroup;
        to4.listener = from.listener;
        to4.regions = from.regions;
        to4.isRegion = from.isRegion;
        to4.regionDefType = from.regionDefType;
    }

    public StringTemplate getInstanceOf() {
        StringTemplate t15 = null;
        t15 = this.nativeGroup != null ? this.nativeGroup.createStringTemplate() : this.group.createStringTemplate();
        this.dup(this, t15);
        return t15;
    }

    public StringTemplate getEnclosingInstance() {
        return this.enclosingInstance;
    }

    public StringTemplate getOutermostEnclosingInstance() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostEnclosingInstance();
        }
        return this;
    }

    public void setEnclosingInstance(StringTemplate enclosingInstance) {
        if (this == enclosingInstance) {
            throw new IllegalArgumentException("cannot embed template " + this.getName() + " in itself");
        }
        this.enclosingInstance = enclosingInstance;
    }

    public Map getArgumentContext() {
        return this.argumentContext;
    }

    public void setArgumentContext(Map ac5) {
        this.argumentContext = ac5;
    }

    public StringTemplateAST getArgumentsAST() {
        return this.argumentsAST;
    }

    public void setArgumentsAST(StringTemplateAST argumentsAST) {
        this.argumentsAST = argumentsAST;
    }

    public String getName() {
        return this.name;
    }

    public String getOutermostName() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostName();
        }
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public StringTemplateGroup getGroup() {
        return this.group;
    }

    public void setGroup(StringTemplateGroup group) {
        this.group = group;
    }

    public StringTemplateGroup getNativeGroup() {
        return this.nativeGroup;
    }

    public void setNativeGroup(StringTemplateGroup nativeGroup) {
        this.nativeGroup = nativeGroup;
    }

    public int getGroupFileLine() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getGroupFileLine();
        }
        return this.groupFileLine;
    }

    public void setGroupFileLine(int groupFileLine) {
        this.groupFileLine = groupFileLine;
    }

    public void setTemplate(String template) {
        this.pattern = template;
        this.breakTemplateIntoChunks();
    }

    public String getTemplate() {
        return this.pattern;
    }

    public void setErrorListener(StringTemplateErrorListener listener) {
        this.listener = listener;
    }

    public StringTemplateErrorListener getErrorListener() {
        if (this.listener == null) {
            return this.group.getErrorListener();
        }
        return this.listener;
    }

    public void reset() {
        this.attributes = new HashMap();
    }

    public void setPredefinedAttributes() {
        if (!StringTemplate.inLintMode()) {
            return;
        }
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null || name == null) {
            return;
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (value instanceof StringTemplate) {
            ((StringTemplate)value).setEnclosingInstance(this);
        } else {
            value = ASTExpr.convertArrayToList(value);
        }
        Object o15 = this.attributes.get(name);
        if (o15 == null) {
            this.rawSetAttribute(this.attributes, name, value);
            return;
        }
        STAttributeList v15 = null;
        if (o15.getClass() == STAttributeList.class) {
            v15 = (STAttributeList)o15;
        } else if (o15 instanceof List) {
            List listAttr = (List)o15;
            v15 = new STAttributeList(listAttr.size());
            v15.addAll(listAttr);
            this.rawSetAttribute(this.attributes, name, v15);
        } else {
            v15 = new STAttributeList();
            this.rawSetAttribute(this.attributes, name, v15);
            v15.add(o15);
        }
        if (value instanceof List) {
            if (v15 != value) {
                v15.addAll((List)value);
            }
        } else {
            v15.add(value);
        }
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, new Integer(value));
    }

    public void setAttribute(String aggrSpec, Object v15, Object v25) {
        this.setAttribute(aggrSpec, new Object[]{v15, v25});
    }

    public void setAttribute(String aggrSpec, Object v15, Object v25, Object v35) {
        this.setAttribute(aggrSpec, new Object[]{v15, v25, v35});
    }

    public void setAttribute(String aggrSpec, Object v15, Object v25, Object v35, Object v45) {
        this.setAttribute(aggrSpec, new Object[]{v15, v25, v35, v45});
    }

    public void setAttribute(String aggrSpec, Object v15, Object v25, Object v35, Object v45, Object v55) {
        this.setAttribute(aggrSpec, new Object[]{v15, v25, v35, v45, v55});
    }

    protected void setAttribute(String aggrSpec, Object[] values2) {
        ArrayList properties = new ArrayList();
        String aggrName = this.parseAggregateAttributeSpec(aggrSpec, properties);
        if (values2 == null || properties.size() == 0) {
            throw new IllegalArgumentException("missing properties or values for '" + aggrSpec + "'");
        }
        if (values2.length != properties.size()) {
            throw new IllegalArgumentException("number of properties in '" + aggrSpec + "' != number of values");
        }
        Aggregate aggr = new Aggregate();
        for (int i15 = 0; i15 < values2.length; ++i15) {
            Object value = values2[i15];
            if (value instanceof StringTemplate) {
                ((StringTemplate)value).setEnclosingInstance(this);
            } else {
                value = ASTExpr.convertArrayToList(value);
            }
            aggr.put((String)properties.get(i15), value);
        }
        this.setAttribute(aggrName, aggr);
    }

    protected String parseAggregateAttributeSpec(String aggrSpec, List properties) {
        int dot = aggrSpec.indexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + aggrSpec);
        }
        String aggrName = aggrSpec.substring(0, dot);
        String propString = aggrSpec.substring(dot + 1, aggrSpec.length());
        boolean error = true;
        StringTokenizer tokenizer = new StringTokenizer(propString, "{,}", true);
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ((token = token.trim()).equals("{")) {
                token = tokenizer.nextToken();
                token = token.trim();
                properties.add(token);
                token = tokenizer.nextToken();
                token = token.trim();
                while (token.equals(",")) {
                    token = tokenizer.nextToken();
                    token = token.trim();
                    properties.add(token);
                    token = tokenizer.nextToken();
                    token = token.trim();
                }
                if (token.equals("}")) {
                    error = false;
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + aggrSpec);
        }
        return aggrName;
    }

    protected void rawSetAttribute(Map attributes, String name, Object value) {
        if (this.formalArguments != FormalArgument.UNKNOWN && this.getFormalArgument(name) == null) {
            throw new NoSuchElementException("no such attribute: " + name + " in template context " + this.getEnclosingInstanceStackString());
        }
        if (value == null) {
            return;
        }
        attributes.put(name, value);
    }

    public void rawSetArgumentAttribute(StringTemplate embedded, Map attributes, String name, Object value) {
        if (embedded.formalArguments != FormalArgument.UNKNOWN && embedded.getFormalArgument(name) == null) {
            throw new NoSuchElementException("template " + embedded.getName() + " has no such attribute: " + name + " in template context " + this.getEnclosingInstanceStackString());
        }
        if (value == null) {
            return;
        }
        attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        Object v15 = this.get(this, name);
        if (v15 == null) {
            this.checkNullAttributeAgainstFormalArguments(this, name);
        }
        return v15;
    }

    public int write(StringTemplateWriter out) throws IOException {
        if (this.group.debugTemplateOutput) {
            this.group.emitTemplateStartDebugString(this, out);
        }
        int n15 = 0;
        boolean missing = true;
        this.setPredefinedAttributes();
        this.setDefaultArgumentValues();
        for (int i15 = 0; this.chunks != null && i15 < this.chunks.size(); ++i15) {
            Expr a15 = (Expr)this.chunks.get(i15);
            int chunkN = a15.write(this, out);
            if (chunkN <= 0 && i15 == 0 && i15 + 1 < this.chunks.size() && this.chunks.get(i15 + 1) instanceof NewlineRef) {
                ++i15;
                continue;
            }
            if (chunkN <= 0 && i15 - 1 >= 0 && this.chunks.get(i15 - 1) instanceof NewlineRef && i15 + 1 < this.chunks.size() && this.chunks.get(i15 + 1) instanceof NewlineRef) {
                ++i15;
            }
            if (chunkN == -1) continue;
            n15 += chunkN;
            missing = false;
        }
        if (this.group.debugTemplateOutput) {
            this.group.emitTemplateStopDebugString(this, out);
        }
        if (lintMode) {
            this.checkForTrouble();
        }
        if (missing && this.chunks != null && this.chunks.size() > 0) {
            return -1;
        }
        return n15;
    }

    public Object get(StringTemplate self, String attribute) {
        Map argContext;
        if (self == null) {
            return null;
        }
        if (lintMode) {
            self.trackAttributeReference(attribute);
        }
        Object o15 = null;
        if (self.attributes != null) {
            o15 = self.attributes.get(attribute);
        }
        if (o15 == null && (argContext = self.getArgumentContext()) != null) {
            o15 = argContext.get(attribute);
        }
        if (o15 == null && !self.passThroughAttributes && self.getFormalArgument(attribute) != null) {
            return null;
        }
        if (o15 == null && self.enclosingInstance != null) {
            Object valueFromEnclosing;
            o15 = valueFromEnclosing = this.get(self.enclosingInstance, attribute);
        } else if (o15 == null && self.enclosingInstance == null) {
            o15 = self.group.getMap(attribute);
        }
        return o15;
    }

    protected void breakTemplateIntoChunks() {
        if (this.pattern == null) {
            return;
        }
        try {
            Class lexerClass = this.group.getTemplateLexerClass();
            Constructor ctor = lexerClass.getConstructor(StringTemplate.class, Reader.class);
            CharScanner chunkStream = (CharScanner)ctor.newInstance(this, new StringReader(this.pattern));
            chunkStream.setTokenObjectClass("org.antlr.stringtemplate.language.ChunkToken");
            TemplateParser chunkifier = new TemplateParser(chunkStream);
            chunkifier.template(this);
        }
        catch (Exception e15) {
            String name = "<unknown>";
            String outerName = this.getOutermostName();
            if (this.getName() != null) {
                name = this.getName();
            }
            if (outerName != null && !name.equals(outerName)) {
                name = name + " nested in " + outerName;
            }
            this.error("problem parsing template '" + name + "'", e15);
        }
    }

    public ASTExpr parseAction(String action) {
        ActionLexer lexer = new ActionLexer(new StringReader(action.toString()));
        ActionParser parser = new ActionParser((TokenStream)lexer, this);
        parser.setASTNodeClass("org.antlr.stringtemplate.language.StringTemplateAST");
        lexer.setTokenObjectClass("org.antlr.stringtemplate.language.StringTemplateToken");
        ASTExpr a15 = null;
        try {
            Map options = parser.action();
            AST tree = parser.getAST();
            if (tree != null) {
                a15 = tree.getType() == 8 ? new ConditionalExpr(this, tree) : new ASTExpr(this, tree, options);
            }
        }
        catch (RecognitionException re5) {
            this.error("Can't parse chunk: " + action.toString(), re5);
        }
        catch (TokenStreamException tse) {
            this.error("Can't parse chunk: " + action.toString(), tse);
        }
        return a15;
    }

    public int getTemplateID() {
        return this.templateID;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public List getChunks() {
        return this.chunks;
    }

    public void addChunk(Expr e15) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(e15);
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public Map getFormalArguments() {
        return this.formalArguments;
    }

    public void setFormalArguments(LinkedHashMap args) {
        this.formalArguments = args;
    }

    public void setDefaultArgumentValues() {
        if (this.numberOfDefaultArgumentValues == 0) {
            return;
        }
        if (this.argumentContext == null) {
            this.argumentContext = new HashMap();
        }
        if (this.formalArguments != FormalArgument.UNKNOWN) {
            Set argNames = this.formalArguments.keySet();
            Iterator it = argNames.iterator();
            while (it.hasNext()) {
                ASTExpr e15;
                Object a15;
                Object existingValue;
                String argName = (String)it.next();
                FormalArgument arg = (FormalArgument)this.formalArguments.get(argName);
                if (arg.defaultValueST == null || (existingValue = this.getAttribute(argName)) != null) continue;
                Object defaultValue = arg.defaultValueST;
                int nchunks = arg.defaultValueST.chunks.size();
                if (nchunks == 1 && (a15 = arg.defaultValueST.chunks.get(0)) instanceof ASTExpr && (e15 = (ASTExpr)a15).getAST().getType() == 9) {
                    defaultValue = e15.evaluateExpression(this, e15.getAST());
                }
                this.argumentContext.put(argName, defaultValue);
            }
        }
    }

    public FormalArgument lookupFormalArgument(String name) {
        FormalArgument arg = this.getFormalArgument(name);
        if (arg == null && this.enclosingInstance != null) {
            arg = this.enclosingInstance.lookupFormalArgument(name);
        }
        return arg;
    }

    public FormalArgument getFormalArgument(String name) {
        return (FormalArgument)this.formalArguments.get(name);
    }

    public void defineEmptyFormalArgumentList() {
        this.setFormalArguments(new LinkedHashMap());
    }

    public void defineFormalArgument(String name) {
        this.defineFormalArgument(name, null);
    }

    public void defineFormalArguments(List names) {
        if (names == null) {
            return;
        }
        for (int i15 = 0; i15 < names.size(); ++i15) {
            String name = (String)names.get(i15);
            this.defineFormalArgument(name);
        }
    }

    public void defineFormalArgument(String name, StringTemplate defaultValue) {
        if (defaultValue != null) {
            ++this.numberOfDefaultArgumentValues;
        }
        FormalArgument a15 = new FormalArgument(name, defaultValue);
        if (this.formalArguments == FormalArgument.UNKNOWN) {
            this.formalArguments = new LinkedHashMap();
        }
        this.formalArguments.put(name, a15);
    }

    public void setPassThroughAttributes(boolean passThroughAttributes) {
        this.passThroughAttributes = passThroughAttributes;
    }

    public void setAttributeRenderers(Map renderers) {
        this.attributeRenderers = renderers;
    }

    public void registerRenderer(Class attributeClassType, AttributeRenderer renderer) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = new HashMap();
        }
        this.attributeRenderers.put(attributeClassType, renderer);
    }

    public AttributeRenderer getAttributeRenderer(Class attributeClassType) {
        AttributeRenderer renderer = null;
        if (this.attributeRenderers != null) {
            renderer = (AttributeRenderer)this.attributeRenderers.get(attributeClassType);
        }
        if (renderer != null) {
            return renderer;
        }
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getAttributeRenderer(attributeClassType);
        }
        return this.group.getAttributeRenderer(attributeClassType);
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void warning(String msg) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().warning(msg);
        } else {
            System.err.println("StringTemplate: warning: " + msg);
        }
    }

    public void error(String msg, Throwable e15) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().error(msg, e15);
        } else if (e15 != null) {
            System.err.println("StringTemplate: error: " + msg + ": " + e15.toString());
            if (e15 instanceof InvocationTargetException) {
                e15 = ((InvocationTargetException)e15).getTargetException();
            }
            e15.printStackTrace(System.err);
        } else {
            System.err.println("StringTemplate: error: " + msg);
        }
    }

    public static void setLintMode(boolean lint) {
        lintMode = lint;
    }

    public static boolean inLintMode() {
        return lintMode;
    }

    protected void trackAttributeReference(String name) {
        if (this.referencedAttributes == null) {
            this.referencedAttributes = new ArrayList();
        }
        this.referencedAttributes.add(name);
    }

    public static boolean isRecursiveEnclosingInstance(StringTemplate st4) {
        if (st4 == null) {
            return false;
        }
        StringTemplate p15 = st4.enclosingInstance;
        if (p15 == st4) {
            return true;
        }
        while (p15 != null) {
            if (p15 == st4) {
                return true;
            }
            p15 = p15.enclosingInstance;
        }
        return false;
    }

    public String getEnclosingInstanceStackTrace() {
        StringBuffer buf = new StringBuffer();
        HashSet<StringTemplate> seen = new HashSet<StringTemplate>();
        StringTemplate p15 = this;
        while (p15 != null) {
            if (seen.contains(p15)) {
                buf.append(p15.getTemplateDeclaratorString());
                buf.append(" (start of recursive cycle)");
                buf.append("\n");
                buf.append("...");
                break;
            }
            seen.add(p15);
            buf.append(p15.getTemplateDeclaratorString());
            if (p15.attributes != null) {
                buf.append(", attributes=[");
                int i15 = 0;
                Iterator iter = p15.attributes.keySet().iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    if (i15 > 0) {
                        buf.append(", ");
                    }
                    ++i15;
                    buf.append(attrName);
                    Object o15 = p15.attributes.get(attrName);
                    if (o15 instanceof StringTemplate) {
                        StringTemplate st4 = (StringTemplate)o15;
                        buf.append("=");
                        buf.append("<");
                        buf.append(st4.getName());
                        buf.append("()@");
                        buf.append(String.valueOf(st4.getTemplateID()));
                        buf.append(">");
                        continue;
                    }
                    if (!(o15 instanceof List)) continue;
                    buf.append("=List[..");
                    List list2 = (List)o15;
                    int n15 = 0;
                    for (int j15 = 0; j15 < list2.size(); ++j15) {
                        Object listValue = list2.get(j15);
                        if (!(listValue instanceof StringTemplate)) continue;
                        if (n15 > 0) {
                            buf.append(", ");
                        }
                        ++n15;
                        StringTemplate st5 = (StringTemplate)listValue;
                        buf.append("<");
                        buf.append(st5.getName());
                        buf.append("()@");
                        buf.append(String.valueOf(st5.getTemplateID()));
                        buf.append(">");
                    }
                    buf.append("..]");
                }
                buf.append("]");
            }
            if (p15.referencedAttributes != null) {
                buf.append(", references=");
                buf.append(p15.referencedAttributes);
            }
            buf.append(">\n");
            p15 = p15.enclosingInstance;
        }
        return buf.toString();
    }

    public String getTemplateDeclaratorString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(this.getName());
        buf.append("(");
        buf.append(this.formalArguments.keySet());
        buf.append(")@");
        buf.append(String.valueOf(this.getTemplateID()));
        buf.append(">");
        return buf.toString();
    }

    protected String getTemplateHeaderString(boolean showAttributes) {
        if (showAttributes) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getName());
            if (this.attributes != null) {
                buf.append(this.attributes.keySet());
            }
            return buf.toString();
        }
        return this.getName();
    }

    protected void checkNullAttributeAgainstFormalArguments(StringTemplate self, String attribute) {
        if (self.getFormalArguments() == FormalArgument.UNKNOWN) {
            if (self.enclosingInstance != null) {
                this.checkNullAttributeAgainstFormalArguments(self.enclosingInstance, attribute);
            }
            return;
        }
        FormalArgument formalArg = self.lookupFormalArgument(attribute);
        if (formalArg == null) {
            throw new NoSuchElementException("no such attribute: " + attribute + " in template context " + this.getEnclosingInstanceStackString());
        }
    }

    protected void checkForTrouble() {
        if (this.attributes == null) {
            return;
        }
        Set names = this.attributes.keySet();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.referencedAttributes == null || this.referencedAttributes.contains(name)) continue;
            this.warning(this.getName() + ": set but not used: " + name);
        }
    }

    public String getEnclosingInstanceStackString() {
        LinkedList<String> names = new LinkedList<String>();
        StringTemplate p15 = this;
        while (p15 != null) {
            String name = p15.getName();
            names.add(0, name + (p15.passThroughAttributes ? "(...)" : ""));
            p15 = p15.enclosingInstance;
        }
        return ((Object)names).toString().replaceAll(",", "");
    }

    public boolean isRegion() {
        return this.isRegion;
    }

    public void setIsRegion(boolean isRegion) {
        this.isRegion = isRegion;
    }

    public void addRegionName(String name) {
        if (this.regions == null) {
            this.regions = new HashSet();
        }
        this.regions.add(name);
    }

    public boolean containsRegionName(String name) {
        if (this.regions == null) {
            return false;
        }
        return this.regions.contains(name);
    }

    public int getRegionDefType() {
        return this.regionDefType;
    }

    public void setRegionDefType(int regionDefType) {
        this.regionDefType = regionDefType;
    }

    public String toDebugString() {
        StringBuffer buf = new StringBuffer();
        buf.append("template-" + this.getTemplateDeclaratorString() + ":");
        buf.append("chunks=");
        if (this.chunks != null) {
            buf.append(this.chunks.toString());
        }
        buf.append("attributes=[");
        if (this.attributes != null) {
            Set attrNames = this.attributes.keySet();
            int n15 = 0;
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                if (n15 > 0) {
                    buf.append(',');
                }
                String name = (String)iter.next();
                buf.append(name + "=");
                Object value = this.attributes.get(name);
                if (value instanceof StringTemplate) {
                    buf.append(((StringTemplate)value).toDebugString());
                } else {
                    buf.append(value);
                }
                ++n15;
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public String toStructureString() {
        return this.toStructureString(0);
    }

    public String toStructureString(int indent) {
        StringBuffer buf = new StringBuffer();
        for (int i15 = 1; i15 <= indent; ++i15) {
            buf.append("  ");
        }
        buf.append(this.getName());
        buf.append(this.attributes.keySet());
        buf.append(":\n");
        if (this.attributes != null) {
            Set attrNames = this.attributes.keySet();
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = this.attributes.get(name);
                if (value instanceof StringTemplate) {
                    buf.append(((StringTemplate)value).toStructureString(indent + 1));
                    continue;
                }
                if (value instanceof List) {
                    List alist = (List)value;
                    for (int i16 = 0; i16 < alist.size(); ++i16) {
                        Object o15 = alist.get(i16);
                        if (!(o15 instanceof StringTemplate)) continue;
                        buf.append(((StringTemplate)o15).toStructureString(indent + 1));
                    }
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map m15 = (Map)value;
                Collection mvalues = m15.values();
                Iterator iterator2 = mvalues.iterator();
                while (iterator2.hasNext()) {
                    Object o16 = iterator2.next();
                    if (!(o16 instanceof StringTemplate)) continue;
                    buf.append(((StringTemplate)o16).toStructureString(indent + 1));
                }
            }
        }
        return buf.toString();
    }

    public StringTemplate getDOTForDependencyGraph(boolean showAttributes) {
        String structure = "digraph StringTemplateDependencyGraph {\nnode [shape=$shape$, $if(width)$width=$width$,$endif$      $if(height)$height=$height$,$endif$ fontsize=$fontsize$];\n$edges:{e|\"$e.src$\" -> \"$e.trg$\"\n}$}\n";
        StringTemplate graphST = new StringTemplate(structure);
        HashMap edges = new HashMap();
        this.getDependencyGraph(edges, showAttributes);
        Set sourceNodes = edges.keySet();
        Iterator it = sourceNodes.iterator();
        while (it.hasNext()) {
            String src = (String)it.next();
            Set targetNodes = (Set)edges.get(src);
            Iterator it22 = targetNodes.iterator();
            while (it22.hasNext()) {
                String trg = (String)it22.next();
                graphST.setAttribute("edges.{src,trg}", src, trg);
            }
        }
        graphST.setAttribute("shape", "none");
        graphST.setAttribute("fontsize", "11");
        graphST.setAttribute("height", "0");
        return graphST;
    }

    public void getDependencyGraph(Map edges, boolean showAttributes) {
        String srcNode = this.getTemplateHeaderString(showAttributes);
        if (this.attributes != null) {
            Set attrNames = this.attributes.keySet();
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = this.attributes.get(name);
                if (value instanceof StringTemplate) {
                    String targetNode = ((StringTemplate)value).getTemplateHeaderString(showAttributes);
                    this.putToMultiValuedMap(edges, srcNode, targetNode);
                    ((StringTemplate)value).getDependencyGraph(edges, showAttributes);
                    continue;
                }
                if (value instanceof List) {
                    List alist = (List)value;
                    for (int i15 = 0; i15 < alist.size(); ++i15) {
                        Object o15 = alist.get(i15);
                        if (!(o15 instanceof StringTemplate)) continue;
                        String targetNode = ((StringTemplate)o15).getTemplateHeaderString(showAttributes);
                        this.putToMultiValuedMap(edges, srcNode, targetNode);
                        ((StringTemplate)o15).getDependencyGraph(edges, showAttributes);
                    }
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map m15 = (Map)value;
                Collection mvalues = m15.values();
                Iterator iterator2 = mvalues.iterator();
                while (iterator2.hasNext()) {
                    Object o16 = iterator2.next();
                    if (!(o16 instanceof StringTemplate)) continue;
                    String targetNode = ((StringTemplate)o16).getTemplateHeaderString(showAttributes);
                    this.putToMultiValuedMap(edges, srcNode, targetNode);
                    ((StringTemplate)o16).getDependencyGraph(edges, showAttributes);
                }
            }
        }
        for (int i16 = 0; this.chunks != null && i16 < this.chunks.size(); ++i16) {
            Expr expr = (Expr)this.chunks.get(i16);
            if (!(expr instanceof ASTExpr)) continue;
            ASTExpr e15 = (ASTExpr)expr;
            AST tree = e15.getAST();
            CommonAST includeAST = new CommonAST(new CommonToken(7, "include"));
            ASTEnumeration it = tree.findAllPartial(includeAST);
            while (it.hasMoreNodes()) {
                AST t15 = it.nextNode();
                String templateInclude = t15.getFirstChild().getText();
                System.out.println("found include " + templateInclude);
                this.putToMultiValuedMap(edges, srcNode, templateInclude);
                StringTemplateGroup group = this.getGroup();
                if (group == null) continue;
                StringTemplate st4 = group.getInstanceOf(templateInclude);
                st4.getDependencyGraph(edges, showAttributes);
            }
        }
    }

    protected void putToMultiValuedMap(Map map, Object key, Object value) {
        HashSet<Object> bag = (HashSet<Object>)map.get(key);
        if (bag == null) {
            bag = new HashSet<Object>();
            map.put(key, bag);
        }
        bag.add(value);
    }

    public void printDebugString() {
        System.out.println("template-" + this.getName() + ":");
        System.out.print("chunks=");
        System.out.println(this.chunks.toString());
        if (this.attributes == null) {
            return;
        }
        System.out.print("attributes=[");
        Set attrNames = this.attributes.keySet();
        int n15 = 0;
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String name;
            Object value;
            if (n15 > 0) {
                System.out.print(',');
            }
            if ((value = this.attributes.get(name = (String)iter.next())) instanceof StringTemplate) {
                System.out.print(name + "=");
                ((StringTemplate)value).printDebugString();
            } else if (value instanceof List) {
                ArrayList alist = (ArrayList)value;
                for (int i15 = 0; i15 < alist.size(); ++i15) {
                    Object o15 = alist.get(i15);
                    System.out.print(name + "[" + i15 + "] is " + o15.getClass().getName() + "=");
                    if (o15 instanceof StringTemplate) {
                        ((StringTemplate)o15).printDebugString();
                        continue;
                    }
                    System.out.println(o15);
                }
            } else {
                System.out.print(name + "=");
                System.out.println(value);
            }
            ++n15;
        }
        System.out.print("]\n");
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int lineWidth) {
        StringWriter out = new StringWriter();
        StringTemplateWriter wr4 = this.group.getStringTemplateWriter(out);
        wr4.setLineWidth(lineWidth);
        try {
            this.write(wr4);
        }
        catch (IOException io4) {
            this.error("Got IOException writing to writer " + wr4.getClass().getName());
        }
        wr4.setLineWidth(-1);
        return out.toString();
    }

    public static final class STAttributeList
    extends ArrayList {
        public STAttributeList(int size) {
            super(size);
        }

        public STAttributeList() {
        }
    }

    public static final class Aggregate {
        protected HashMap properties = new HashMap();

        protected void put(String propName, Object propValue) {
            this.properties.put(propName, propValue);
        }

        public Object get(String propName) {
            return this.properties.get(propName);
        }

        public String toString() {
            return this.properties.toString();
        }
    }
}

