/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X11) {
        int m15 = X11.length;
        if (m15 <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X11);
        double s25 = 0.0;
        for (int i15 = 0; i15 < m15; ++i15) {
            s25 += ((double)X11[i15] - xbar) * ((double)X11[i15] - xbar);
        }
        return Math.sqrt(s25 /= (double)(m15 - 1));
    }

    public static double avg(int[] X11) {
        double xbar = 0.0;
        int m15 = X11.length;
        if (m15 == 0) {
            return 0.0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            xbar += (double)X11[i15];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m15;
        }
        return 0.0;
    }

    public static int min(int[] X11) {
        int min = Integer.MAX_VALUE;
        int m15 = X11.length;
        if (m15 == 0) {
            return 0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            if (X11[i15] >= min) continue;
            min = X11[i15];
        }
        return min;
    }

    public static int max(int[] X11) {
        int max = Integer.MIN_VALUE;
        int m15 = X11.length;
        if (m15 == 0) {
            return 0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            if (X11[i15] <= max) continue;
            max = X11[i15];
        }
        return max;
    }

    public static double avg(List<Integer> X11) {
        double xbar = 0.0;
        int m15 = X11.size();
        if (m15 == 0) {
            return 0.0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            xbar += (double)X11.get(i15).intValue();
        }
        if (xbar >= 0.0) {
            return xbar / (double)m15;
        }
        return 0.0;
    }

    public static int min(List<Integer> X11) {
        int min = Integer.MAX_VALUE;
        int m15 = X11.size();
        if (m15 == 0) {
            return 0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            if (X11.get(i15) >= min) continue;
            min = X11.get(i15);
        }
        return min;
    }

    public static int max(List<Integer> X11) {
        int max = Integer.MIN_VALUE;
        int m15 = X11.size();
        if (m15 == 0) {
            return 0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            if (X11.get(i15) <= max) continue;
            max = X11.get(i15);
        }
        return max;
    }

    public static int sum(int[] X11) {
        int s15 = 0;
        int m15 = X11.length;
        if (m15 == 0) {
            return 0;
        }
        for (int i15 = 0; i15 < m15; ++i15) {
            s15 += X11[i15];
        }
        return s15;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f15 = new File(absoluteFilename);
        File parent = f15.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f15, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps4 = new PrintStream(bos);
        ps4.println(data);
        ps4.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

