/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;
    protected int range = -1;

    public void reset() {
        this.clear();
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public T remove() {
        T o15 = this.elementAt(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return o15;
    }

    public void add(T o15) {
        this.data.add(o15);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public int range() {
        return this.range;
    }

    public T head() {
        return this.elementAt(0);
    }

    public T elementAt(int i15) {
        int absIndex = this.p + i15;
        if (absIndex >= this.data.size()) {
            throw new NoSuchElementException("queue index " + absIndex + " > last index " + (this.data.size() - 1));
        }
        if (absIndex < 0) {
            throw new NoSuchElementException("queue index " + absIndex + " < 0");
        }
        if (absIndex > this.range) {
            this.range = absIndex;
        }
        return this.data.get(absIndex);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int n15 = this.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            buf.append(this.elementAt(i15));
            if (i15 + 1 >= n15) continue;
            buf.append(" ");
        }
        return buf.toString();
    }
}

