/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import net.fabricmc.mappingio.tree.AlphanumericComparator;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.jetbrains.annotations.Nullable;

public final class VisitOrder {
    private static final AlphanumericComparator ALPHANUM = new AlphanumericComparator(Locale.ROOT);
    private Comparator<MappingTreeView.ClassMappingView> classComparator;
    private Comparator<MappingTreeView.FieldMappingView> fieldComparator;
    private Comparator<MappingTreeView.MethodMappingView> methodComparator;
    private Comparator<MappingTreeView.MethodArgMappingView> methodArgComparator;
    private Comparator<MappingTreeView.MethodVarMappingView> methodVarComparator;
    private boolean methodsFirst;
    private boolean methodVarsFirst;

    private VisitOrder() {
    }

    public static VisitOrder createByInputOrder() {
        return new VisitOrder();
    }

    public static VisitOrder createByName() {
        return new VisitOrder().classesBySrcName().fieldsBySrcNameDesc().methodsBySrcNameDesc().methodArgsByLvIndex().methodVarsByLvIndex();
    }

    public VisitOrder classComparator(Comparator<MappingTreeView.ClassMappingView> comparator) {
        this.classComparator = comparator;
        return this;
    }

    public VisitOrder classesBySrcName() {
        return this.classComparator(VisitOrder.compareBySrcName());
    }

    public VisitOrder classesBySrcNameShortFirst() {
        return this.classComparator(VisitOrder.compareBySrcNameShortFirst());
    }

    public VisitOrder fieldComparator(Comparator<MappingTreeView.FieldMappingView> comparator) {
        this.fieldComparator = comparator;
        return this;
    }

    public VisitOrder fieldsBySrcNameDesc() {
        return this.fieldComparator(VisitOrder.compareBySrcNameDesc());
    }

    public VisitOrder methodComparator(Comparator<MappingTreeView.MethodMappingView> comparator) {
        this.methodComparator = comparator;
        return this;
    }

    public VisitOrder methodsBySrcNameDesc() {
        return this.methodComparator(VisitOrder.compareBySrcNameDesc());
    }

    public VisitOrder methodArgComparator(Comparator<MappingTreeView.MethodArgMappingView> comparator) {
        this.methodArgComparator = comparator;
        return this;
    }

    public VisitOrder methodArgsByPosition() {
        return this.methodArgComparator(Comparator.comparingInt(MappingTreeView.MethodArgMappingView::getArgPosition));
    }

    public VisitOrder methodArgsByLvIndex() {
        return this.methodArgComparator(Comparator.comparingInt(MappingTreeView.MethodArgMappingView::getLvIndex));
    }

    public VisitOrder methodVarComparator(Comparator<MappingTreeView.MethodVarMappingView> comparator) {
        this.methodVarComparator = comparator;
        return this;
    }

    public VisitOrder methodVarsByLvtRowIndex() {
        return this.methodVarComparator(Comparator.comparingInt(MappingTreeView.MethodVarMappingView::getLvIndex).thenComparingInt(MappingTreeView.MethodVarMappingView::getLvtRowIndex));
    }

    public VisitOrder methodVarsByLvIndex() {
        return this.methodVarComparator(Comparator.comparingInt(MappingTreeView.MethodVarMappingView::getLvIndex).thenComparingInt(MappingTreeView.MethodVarMappingView::getStartOpIdx).thenComparingInt(MappingTreeView.MethodVarMappingView::getEndOpIdx));
    }

    public VisitOrder methodsFirst(boolean methodsFirst) {
        this.methodsFirst = methodsFirst;
        return this;
    }

    public VisitOrder fieldsFirst() {
        return this.methodsFirst(false);
    }

    public VisitOrder methodsFirst() {
        return this.methodsFirst(true);
    }

    public VisitOrder methodVarsFirst(boolean varsFirst) {
        this.methodVarsFirst = varsFirst;
        return this;
    }

    public VisitOrder methodArgsFirst() {
        return this.methodVarsFirst(false);
    }

    public VisitOrder methodVarsFirst() {
        return this.methodVarsFirst(true);
    }

    public static <T extends MappingTreeView.ElementMappingView> Comparator<T> compareBySrcName() {
        return (a15, b15) -> {
            if (a15 instanceof MappingTreeView.ClassMappingView || b15 instanceof MappingTreeView.ClassMappingView) {
                return VisitOrder.compareNestaware(a15.getSrcName(), b15.getSrcName(), false);
            }
            return VisitOrder.compare(a15.getSrcName(), b15.getSrcName());
        };
    }

    public static <T extends MappingTreeView.MemberMappingView> Comparator<T> compareBySrcNameDesc() {
        return (a15, b15) -> {
            int cmp = VisitOrder.compare(a15.getSrcName(), b15.getSrcName());
            return cmp != 0 ? cmp : VisitOrder.compare(a15.getSrcDesc(), b15.getSrcDesc());
        };
    }

    public static <T extends MappingTreeView.ElementMappingView> Comparator<T> compareBySrcNameShortFirst() {
        return (a15, b15) -> {
            if (a15 instanceof MappingTreeView.ClassMappingView || b15 instanceof MappingTreeView.ClassMappingView) {
                return VisitOrder.compareNestaware(a15.getSrcName(), b15.getSrcName(), true);
            }
            return VisitOrder.compareShortFirst(a15.getSrcName(), b15.getSrcName());
        };
    }

    public static <T extends MappingTreeView.MemberMappingView> Comparator<T> compareBySrcNameDescShortFirst() {
        return (a15, b15) -> {
            int cmp = VisitOrder.compareShortFirst(a15.getSrcName(), b15.getSrcName());
            return cmp != 0 ? cmp : VisitOrder.compare(a15.getSrcDesc(), b15.getSrcDesc());
        };
    }

    public static int compare(@Nullable String a15, @Nullable String b15) {
        if (a15 == null || b15 == null) {
            return VisitOrder.compareNullLast(a15, b15);
        }
        return ALPHANUM.compare(a15, b15);
    }

    public static int compare(String a15, int startA, int endA, String b15, int startB, int endB) {
        return ALPHANUM.compare(a15.substring(startA, endA), b15.substring(startB, endB));
    }

    public static int compareShortFirst(@Nullable String a15, @Nullable String b15) {
        if (a15 == null || b15 == null) {
            return VisitOrder.compareNullLast(a15, b15);
        }
        int cmp = a15.length() - b15.length();
        return cmp != 0 ? cmp : ALPHANUM.compare(a15, b15);
    }

    public static int compareShortFirst(String a15, int startA, int endA, String b15, int startB, int endB) {
        int lenA = endA - startA;
        int ret = Integer.compare(lenA, endB - startB);
        if (ret != 0) {
            return ret;
        }
        return ALPHANUM.compare(a15.substring(startA, endA), b15.substring(startB, endB));
    }

    public static int compareNestaware(@Nullable String a15, @Nullable String b15) {
        return VisitOrder.compareNestaware(a15, b15, false);
    }

    public static int compareShortFirstNestaware(@Nullable String a15, @Nullable String b15) {
        return VisitOrder.compareNestaware(a15, b15, true);
    }

    private static int compareNestaware(@Nullable String a15, @Nullable String b15, boolean shortFirst) {
        int endA;
        if (a15 == null || b15 == null) {
            return VisitOrder.compareNullLast(a15, b15);
        }
        int pos = 0;
        do {
            int ret;
            endA = a15.indexOf(36, pos);
            int endB = b15.indexOf(36, pos);
            int positiveEndA = endA < 0 ? a15.length() : endA;
            int positiveEndB = endB < 0 ? b15.length() : endB;
            int n15 = ret = shortFirst ? VisitOrder.compareShortFirst(a15, pos, positiveEndA, b15, pos, positiveEndB) : VisitOrder.compare(a15, pos, positiveEndA, b15, pos, positiveEndB);
            if (ret != 0) {
                return ret;
            }
            if (endA < 0 == endB < 0) continue;
            return endA < 0 ? -1 : 1;
        } while ((pos = endA + 1) > 0);
        return 0;
    }

    public static int compareNullLast(@Nullable String a15, @Nullable String b15) {
        if (a15 == null) {
            if (b15 == null) {
                return 0;
            }
            return 1;
        }
        if (b15 == null) {
            return -1;
        }
        return ALPHANUM.compare(a15, b15);
    }

    public <T extends MappingTreeView.ClassMappingView> Collection<T> sortClasses(Collection<T> classes) {
        return VisitOrder.sort(classes, this.classComparator);
    }

    public <T extends MappingTreeView.FieldMappingView> Collection<T> sortFields(Collection<T> fields2) {
        return VisitOrder.sort(fields2, this.fieldComparator);
    }

    public <T extends MappingTreeView.MethodMappingView> Collection<T> sortMethods(Collection<T> methods2) {
        return VisitOrder.sort(methods2, this.methodComparator);
    }

    public <T extends MappingTreeView.MethodArgMappingView> Collection<T> sortMethodArgs(Collection<T> args) {
        return VisitOrder.sort(args, this.methodArgComparator);
    }

    public <T extends MappingTreeView.MethodVarMappingView> Collection<T> sortMethodVars(Collection<T> vars) {
        return VisitOrder.sort(vars, this.methodVarComparator);
    }

    private static <T> Collection<T> sort(Collection<T> inputs, Comparator<? super T> comparator) {
        if (comparator == null || inputs.size() < 2) {
            return inputs;
        }
        ArrayList<T> ret = new ArrayList<T>(inputs);
        ret.sort(comparator);
        return ret;
    }

    public boolean isMethodsFirst() {
        return this.methodsFirst;
    }

    public boolean isMethodVarsFirst() {
        return this.methodVarsFirst;
    }
}

