/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.srg;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;

public final class SrgFileReader {
    private SrgFileReader() {
    }

    public static void read(Reader reader, MappingVisitor visitor2) throws IOException {
        SrgFileReader.read(reader, "source", "target", visitor2);
    }

    public static void read(Reader reader, String sourceNs, String targetNs, MappingVisitor visitor2) throws IOException {
        SrgFileReader.read(new ColumnFileReader(reader, '\t', ' '), sourceNs, targetNs, visitor2);
    }

    private static void read(ColumnFileReader reader, String sourceNs, String targetNs, MappingVisitor visitor2) throws IOException {
        MappingVisitor parentVisitor;
        block29: {
            int markIdx;
            MappingFormat format = MappingFormat.SRG_FILE;
            Set<MappingFlag> flags = visitor2.getFlags();
            parentVisitor = null;
            boolean readerMarked = false;
            if (flags.contains((Object)MappingFlag.NEEDS_ELEMENT_UNIQUENESS)) {
                parentVisitor = visitor2;
                visitor2 = new MemoryMappingTree();
            } else if (flags.contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
                reader.mark();
                readerMarked = true;
            }
            while (true) {
                if (visitor2.visitHeader()) {
                    visitor2.visitNamespaces(sourceNs, Collections.singletonList(targetNs));
                }
                if (visitor2.visitContent()) {
                    String lastClassSrcName = null;
                    String lastClassDstName = null;
                    boolean classContentVisitPending = false;
                    do {
                        boolean classVisitRequired;
                        String dstDesc;
                        String dstName;
                        String srcDesc;
                        if (reader.nextCol("CL:")) {
                            String srcName = reader.nextCol();
                            if (srcName == null || srcName.isEmpty()) {
                                throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                            }
                            if (classContentVisitPending) {
                                visitor2.visitElementContent(MappedElementKind.CLASS);
                                classContentVisitPending = false;
                            }
                            lastClassSrcName = srcName;
                            if (!visitor2.visitClass(srcName)) continue;
                            String dstName2 = reader.nextCol();
                            if (dstName2 == null || dstName2.isEmpty()) {
                                throw new IOException("missing class-name-b in line " + reader.getLineNumber());
                            }
                            lastClassDstName = dstName2;
                            visitor2.visitDstName(MappedElementKind.CLASS, 0, dstName2);
                            classContentVisitPending = true;
                            continue;
                        }
                        boolean isMethod = reader.nextCol("MD:");
                        if (!isMethod && !reader.nextCol("FD:")) continue;
                        String src = reader.nextCol();
                        if (src == null) {
                            throw new IOException("missing class-/name-a in line " + reader.getLineNumber());
                        }
                        int srcSepPos = src.lastIndexOf(47);
                        if (srcSepPos <= 0 || srcSepPos == src.length() - 1) {
                            throw new IOException("invalid class-/name-a in line " + reader.getLineNumber());
                        }
                        String[] cols = new String[3];
                        for (int i15 = 0; i15 < 3; ++i15) {
                            cols[i15] = reader.nextCol();
                        }
                        if (!isMethod && cols[1] != null && cols[2] != null) {
                            format = MappingFormat.XSRG_FILE;
                        }
                        if (isMethod || format == MappingFormat.XSRG_FILE) {
                            srcDesc = cols[0];
                            if (srcDesc == null || srcDesc.isEmpty()) {
                                throw new IOException("missing desc-a in line " + reader.getLineNumber());
                            }
                            dstName = cols[1];
                            dstDesc = cols[2];
                            if (dstDesc == null || dstDesc.isEmpty()) {
                                throw new IOException("missing desc-b in line " + reader.getLineNumber());
                            }
                        } else {
                            srcDesc = null;
                            dstName = cols[0];
                            dstDesc = null;
                        }
                        if (dstName == null) {
                            throw new IOException("missing class-/name-b in line " + reader.getLineNumber());
                        }
                        int dstSepPos = dstName.lastIndexOf(47);
                        if (dstSepPos <= 0 || dstSepPos == dstName.length() - 1) {
                            throw new IOException("invalid class-/name-b in line " + reader.getLineNumber());
                        }
                        String srcOwner = src.substring(0, srcSepPos);
                        String dstOwner = dstName.substring(0, dstSepPos);
                        boolean bl4 = classVisitRequired = !srcOwner.equals(lastClassSrcName) || !dstOwner.equals(lastClassDstName);
                        if (classVisitRequired) {
                            if (classContentVisitPending) {
                                visitor2.visitElementContent(MappedElementKind.CLASS);
                                classContentVisitPending = false;
                            }
                            if (!visitor2.visitClass(srcOwner)) {
                                lastClassSrcName = srcOwner;
                                continue;
                            }
                            classContentVisitPending = true;
                        }
                        lastClassSrcName = srcOwner;
                        if (classVisitRequired) {
                            visitor2.visitDstName(MappedElementKind.CLASS, 0, dstOwner);
                            lastClassDstName = dstOwner;
                        }
                        if (classContentVisitPending) {
                            classContentVisitPending = false;
                            if (!visitor2.visitElementContent(MappedElementKind.CLASS)) continue;
                        }
                        String srcName = src.substring(srcSepPos + 1);
                        if ((!isMethod || !visitor2.visitMethod(srcName, srcDesc)) && (isMethod || !visitor2.visitField(srcName, srcDesc))) continue;
                        MappedElementKind kind2 = isMethod ? MappedElementKind.METHOD : MappedElementKind.FIELD;
                        visitor2.visitDstName(kind2, 0, dstName.substring(dstSepPos + 1));
                        visitor2.visitDstDesc(kind2, 0, dstDesc);
                        visitor2.visitElementContent(kind2);
                    } while (reader.nextLine(0));
                    if (classContentVisitPending) {
                        visitor2.visitElementContent(MappedElementKind.CLASS);
                    }
                }
                if (visitor2.visitEnd()) break block29;
                if (!readerMarked) {
                    throw new IllegalStateException("repeated visitation requested without NEEDS_MULTIPLE_PASSES");
                }
                markIdx = reader.reset();
                assert (markIdx == 1);
            }
        }
        if (parentVisitor != null) {
            ((MappingTree)((Object)visitor2)).accept(parentVisitor);
        }
    }
}

