/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.WasExperimental;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ExperimentalTime;
import kotlin.time.Instant;
import kotlin.time.InstantParseResult;
import kotlin.time.UnboundLocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0006\u001a\u0012\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082\u0080\u0004\u001a\u0012\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0082\u0080\u0004\u001a(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\u0088\u0004\u001a(\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\u0088\u0004\u001a\u0012\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0015H\u0080\u0080\u0004\u001a\u0016\u0010'\u001a\u00020\u0015*\u00020\u00152\u0006\u0010%\u001a\u00020\u0001H\u0082\u0080\u0004\u001a\u0016\u0010-\u001a\u00020\u0012*\u00020\u00102\u0006\u0010.\u001a\u00020\u0015H\u0082\u0080\u0004\" \u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0084\b\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0005\" \u0010\u0006\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0084\b\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\u0006\u0010\u0005\"\u000f\u0010\b\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\n\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u000b\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\f\u001a\u00020\tX\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0014\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u0016\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u001e\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\u001f\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010 \u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010!\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010\"\u001a\u00020\u0015X\u0080\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010#\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010$\u001a\u00020\u0015X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010(\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010*\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010+\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\"\u000f\u0010,\u001a\u00020)X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"isDistantPast", "", "Lkotlin/time/Instant;", "isDistantPast$annotations", "(Lkotlin/time/Instant;)V", "(Lkotlin/time/Instant;)Z", "isDistantFuture", "isDistantFuture$annotations", "DISTANT_PAST_SECONDS", "", "DISTANT_FUTURE_SECONDS", "MIN_SECOND", "MAX_SECOND", "parseIso", "Lkotlin/time/InstantParseResult;", "isoString", "", "formatIso", "", "instant", "DAYS_PER_CYCLE", "", "DAYS_0000_TO_1970", "safeAddOrElse", "a", "b", "action", "Lkotlin/Function0;", "", "safeMultiplyOrElse", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "HOURS_PER_DAY", "SECONDS_PER_DAY", "NANOS_PER_SECOND", "NANOS_PER_MILLI", "MILLIS_PER_SECOND", "isLeapYear", "year", "monthLength", "POWERS_OF_TEN", "", "asciiDigitPositionsInIsoStringAfterYear", "colonsInIsoOffsetString", "asciiDigitsInIsoOffsetString", "truncateForErrorMessage", "maxLength", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlin/time/InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Instant.kt\nkotlin/time/UnboundLocalDateTime\n*L\n1#1,871:1\n1#2:872\n491#3,28:873\n*S KotlinDebug\n*F\n+ 1 Instant.kt\nkotlin/time/InstantKt\n*L\n700#1:873,28\n*E\n"})
public final class InstantKt {
    private static final long DISTANT_PAST_SECONDS = -3217862419201L;
    private static final long DISTANT_FUTURE_SECONDS = 3093527980800L;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final int DAYS_0000_TO_1970 = 719528;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    public static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MILLIS_PER_SECOND = 1000;
    @NotNull
    private static final int[] POWERS_OF_TEN;
    @NotNull
    private static final int[] asciiDigitPositionsInIsoStringAfterYear;
    @NotNull
    private static final int[] colonsInIsoOffsetString;
    @NotNull
    private static final int[] asciiDigitsInIsoOffsetString;

    private static final boolean isDistantPast(Instant $this$isDistantPast) {
        Intrinsics.checkNotNullParameter($this$isDistantPast, "<this>");
        return $this$isDistantPast.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    @SinceKotlin(version="2.3")
    @WasExperimental(markerClass={ExperimentalTime.class})
    @InlineOnly
    public static /* synthetic */ void isDistantPast$annotations(Instant instant) {
    }

    private static final boolean isDistantFuture(Instant $this$isDistantFuture) {
        Intrinsics.checkNotNullParameter($this$isDistantFuture, "<this>");
        return $this$isDistantFuture.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @SinceKotlin(version="2.3")
    @WasExperimental(markerClass={ExperimentalTime.class})
    @InlineOnly
    public static /* synthetic */ void isDistantFuture$annotations(Instant instant) {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final InstantParseResult parseIso(CharSequence isoString) {
        void p15;
        void this_$iv;
        int n15;
        int nanosecond;
        int n16;
        int year;
        int n17;
        CharSequence s15 = isoString;
        int i15 = 0;
        if (s15.length() == 0) {
            return new InstantParseResult.Failure("An empty string is not a valid Instant", isoString);
        }
        char c15 = s15.charAt(i15);
        switch (c15) {
            case '+': 
            case '-': {
                ++i15;
                n17 = c15;
                break;
            }
            default: {
                n17 = 32;
            }
        }
        int yearSign = n17;
        int yearStart = i15;
        int absYear = 0;
        while (i15 < s15.length()) {
            char c16 = s15.charAt(i15);
            boolean bl4 = '0' <= c16 ? c16 < ':' : false;
            if (!bl4) break;
            absYear = absYear * 10 + (s15.charAt(i15) - 48);
            ++i15;
        }
        int yearStrLength = i15 - yearStart;
        if (yearStrLength > 10) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected at most 10 digits for the year number, got " + yearStrLength + " digits");
        }
        if (yearStrLength == 10 && Intrinsics.compare(s15.charAt(yearStart), 50) >= 0) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected at most 9 digits for the year number or year 1000000000, got " + yearStrLength + " digits");
        }
        if (yearStrLength < 4) {
            return InstantKt.parseIso$parseFailure(isoString, "The year number must be padded to 4 digits, got " + yearStrLength + " digits");
        }
        if (yearSign == 43 && yearStrLength == 4) {
            return InstantKt.parseIso$parseFailure(isoString, "The '+' sign at the start is only valid for year numbers longer than 4 digits");
        }
        if (yearSign == 32 && yearStrLength != 4) {
            return InstantKt.parseIso$parseFailure(isoString, "A '+' or '-' sign is required for year numbers longer than 4 digits");
        }
        int n18 = year = yearSign == 45 ? -absYear : absYear;
        if (s15.length() < i15 + 16) {
            return InstantKt.parseIso$parseFailure(isoString, "The input string is too short");
        }
        Object object = InstantKt.parseIso$expect(isoString, "'-'", i15, InstantKt::parseIso$lambda$0);
        if (object != null) {
            InstantParseResult.Failure it = object;
            return it;
        }
        object = InstantKt.parseIso$expect(isoString, "'-'", i15 + 3, InstantKt::parseIso$lambda$2);
        if (object != null) {
            InstantParseResult.Failure it = object;
            return it;
        }
        object = InstantKt.parseIso$expect(isoString, "'T' or 't'", i15 + 6, InstantKt::parseIso$lambda$4);
        if (object != null) {
            InstantParseResult.Failure it = object;
            return it;
        }
        object = InstantKt.parseIso$expect(isoString, "':'", i15 + 9, InstantKt::parseIso$lambda$6);
        if (object != null) {
            InstantParseResult.Failure it = object;
            return it;
        }
        object = InstantKt.parseIso$expect(isoString, "':'", i15 + 12, InstantKt::parseIso$lambda$8);
        if (object != null) {
            InstantParseResult.Failure it = object;
            return it;
        }
        for (Object j15 : (Object)asciiDigitPositionsInIsoStringAfterYear) {
            InstantParseResult.Failure failure = InstantKt.parseIso$expect(isoString, "an ASCII digit", i15 + j15, InstantKt::parseIso$lambda$10);
            if (failure == null) continue;
            InstantParseResult.Failure it = failure;
            return it;
        }
        int month = InstantKt.parseIso$twoDigitNumber(s15, i15 + 1);
        int day = InstantKt.parseIso$twoDigitNumber(s15, i15 + 4);
        int hour = InstantKt.parseIso$twoDigitNumber(s15, i15 + 7);
        int minute = InstantKt.parseIso$twoDigitNumber(s15, i15 + 10);
        int second = InstantKt.parseIso$twoDigitNumber(s15, i15 + 13);
        if (s15.charAt(i15 + 15) == '.') {
            int fractionStrLength;
            int fractionStart;
            int fraction = 0;
            for (i15 = fractionStart = i15 + 16; i15 < s15.length(); ++i15) {
                char c17 = s15.charAt(i15);
                boolean bl5 = '0' <= c17 ? c17 < ':' : false;
                if (!bl5) break;
                fraction = fraction * 10 + (s15.charAt(i15) - 48);
            }
            boolean bl6 = 1 <= (fractionStrLength = i15 - fractionStart) ? fractionStrLength < 10 : false;
            if (!bl6) return InstantKt.parseIso$parseFailure(isoString, "1..9 digits are supported for the fraction of the second, got " + fractionStrLength + " digits");
            n16 = fraction * POWERS_OF_TEN[9 - fractionStrLength];
        } else {
            i15 += 15;
            n16 = nanosecond = 0;
        }
        if (i15 >= s15.length()) {
            return InstantKt.parseIso$parseFailure(isoString, "The UTC offset at the end of the string is missing");
        }
        char sign22 = s15.charAt(i15);
        switch (sign22) {
            case 'Z': 
            case 'z': {
                if (s15.length() != i15 + 1) return InstantKt.parseIso$parseFailure(isoString, "Extra text after the instant at position " + (i15 + 1));
                n15 = 0;
                break;
            }
            case '+': 
            case '-': {
                int offsetSecond;
                int n19;
                int offsetStrLength = s15.length() - i15;
                if (offsetStrLength > 9) {
                    CharSequence charSequence = s15;
                    int n25 = charSequence.length();
                    return InstantKt.parseIso$parseFailure(isoString, "The UTC offset string \"" + InstantKt.truncateForErrorMessage(((Object)charSequence.subSequence(i15, n25)).toString(), 16) + "\" is too long");
                }
                if (offsetStrLength % 3 != 0) {
                    CharSequence charSequence = s15;
                    int n26 = charSequence.length();
                    return InstantKt.parseIso$parseFailure(isoString, "Invalid UTC offset string \"" + ((Object)charSequence.subSequence(i15, n26)).toString() + '\"');
                }
                for (int j16 : colonsInIsoOffsetString) {
                    if (i15 + j16 >= s15.length()) break;
                    if (s15.charAt(i15 + j16) == ':') continue;
                    return InstantKt.parseIso$parseFailure(isoString, "Expected ':' at index " + (i15 + j16) + ", got '" + s15.charAt(i15 + j16) + '\'');
                }
                for (int j16 : asciiDigitsInIsoOffsetString) {
                    if (i15 + j16 >= s15.length()) break;
                    n19 = s15.charAt(i15 + j16);
                    if (48 <= n19 ? n19 < 58 : false) continue;
                    return InstantKt.parseIso$parseFailure(isoString, "Expected an ASCII digit at index " + (i15 + j16) + ", got '" + s15.charAt(i15 + j16) + '\'');
                }
                int offsetHour = InstantKt.parseIso$twoDigitNumber(s15, i15 + 1);
                int offsetMinute = offsetStrLength > 3 ? InstantKt.parseIso$twoDigitNumber(s15, i15 + 4) : 0;
                int n27 = offsetSecond = offsetStrLength > 6 ? InstantKt.parseIso$twoDigitNumber(s15, i15 + 7) : 0;
                if (offsetMinute > 59) {
                    return InstantKt.parseIso$parseFailure(isoString, "Expected offset-minute-of-hour in 0..59, got " + offsetMinute);
                }
                if (offsetSecond > 59) {
                    return InstantKt.parseIso$parseFailure(isoString, "Expected offset-second-of-minute in 0..59, got " + offsetSecond);
                }
                if (offsetHour > 17 && (offsetHour != 18 || offsetMinute != 0 || offsetSecond != 0)) {
                    CharSequence j17 = s15;
                    n19 = j17.length();
                    return InstantKt.parseIso$parseFailure(isoString, "Expected an offset in -18:00..+18:00, got " + ((Object)j17.subSequence(i15, n19)).toString());
                }
                n15 = (offsetHour * 3600 + offsetMinute * 60 + offsetSecond) * (sign22 == '-' ? -1 : 1);
                break;
            }
            default: {
                return InstantKt.parseIso$parseFailure(isoString, "Expected the UTC offset at position " + i15 + ", got '" + sign22 + '\'');
            }
        }
        int offsetSeconds = n15;
        if (!(1 <= month ? month < 13 : false)) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected a month number in 1..12, got " + month);
        }
        if (!(1 <= day ? day <= InstantKt.monthLength(month, InstantKt.isLeapYear(year)) : false)) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected a valid day-of-month for month " + month + " of year " + year + ", got " + day);
        }
        if (hour > 23) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected hour in 0..23, got " + hour);
        }
        if (minute > 59) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected minute-of-hour in 0..59, got " + minute);
        }
        if (second > 59) {
            return InstantKt.parseIso$parseFailure(isoString, "Expected second-of-minute in 0..59, got " + second);
        }
        UnboundLocalDateTime sign22 = new UnboundLocalDateTime(year, month, day, hour, minute, second, nanosecond);
        int offsetSeconds$iv = offsetSeconds;
        boolean $i$f$toInstant = false;
        void $this$toInstant_u24lambda_u240$iv = this_$iv;
        boolean bl7 = false;
        void $this$toInstant_u24lambda_u240_u240$iv = $this$toInstant_u24lambda_u240$iv;
        boolean bl8 = false;
        long y$iv = $this$toInstant_u24lambda_u240_u240$iv.getYear();
        long total$iv = (long)365 * y$iv;
        total$iv = y$iv >= 0L ? (total$iv += (y$iv + (long)3) / (long)4 - (y$iv + (long)99) / (long)100 + (y$iv + (long)399) / (long)400) : (total$iv -= y$iv / (long)-4 - y$iv / (long)-100 + y$iv / (long)-400);
        total$iv += (long)((367 * $this$toInstant_u24lambda_u240_u240$iv.getMonth() - 362) / 12);
        total$iv += (long)($this$toInstant_u24lambda_u240_u240$iv.getDay() - 1);
        if ($this$toInstant_u24lambda_u240_u240$iv.getMonth() > 2) {
            total$iv += -1L;
            if (!InstantKt.isLeapYear($this$toInstant_u24lambda_u240_u240$iv.getYear())) {
                total$iv += -1L;
            }
        }
        long epochDays$iv = total$iv - (long)719528;
        int daySeconds$iv = $this$toInstant_u24lambda_u240$iv.getHour() * 3600 + $this$toInstant_u24lambda_u240$iv.getMinute() * 60 + $this$toInstant_u24lambda_u240$iv.getSecond();
        long epochSeconds$iv = epochDays$iv * (long)86400 + (long)daySeconds$iv - (long)offsetSeconds$iv;
        int n28 = this_$iv.getNanosecond();
        long p05 = epochSeconds$iv;
        return new InstantParseResult.Success(p05, (int)p15);
    }

    private static final String formatIso(Instant instant) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$formatIso_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl4 = false;
        UnboundLocalDateTime ldt = UnboundLocalDateTime.Companion.fromInstant(instant);
        int number = ldt.getYear();
        if (Math.abs(number) < 1000) {
            StringBuilder stringBuilder3;
            StringBuilder innerBuilder = new StringBuilder();
            if (number >= 0) {
                StringBuilder stringBuilder4 = innerBuilder.append(number + 10000).deleteCharAt(0);
                stringBuilder3 = stringBuilder4;
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "deleteCharAt(...)");
            } else {
                StringBuilder stringBuilder5 = innerBuilder.append(number - 10000).deleteCharAt(1);
                stringBuilder3 = stringBuilder5;
                Intrinsics.checkNotNullExpressionValue(stringBuilder5, "deleteCharAt(...)");
            }
            stringBuilder = $this$formatIso_u24lambda_u240.append((CharSequence)innerBuilder);
        } else {
            if (number >= 10000) {
                $this$formatIso_u24lambda_u240.append('+');
            }
            stringBuilder = $this$formatIso_u24lambda_u240.append(number);
        }
        $this$formatIso_u24lambda_u240.append('-');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getMonth());
        $this$formatIso_u24lambda_u240.append('-');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getDay());
        $this$formatIso_u24lambda_u240.append('T');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getHour());
        $this$formatIso_u24lambda_u240.append(':');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getMinute());
        $this$formatIso_u24lambda_u240.append(':');
        InstantKt.formatIso$lambda$0$appendTwoDigits($this$formatIso_u24lambda_u240, $this$formatIso_u24lambda_u240, ldt.getSecond());
        if (ldt.getNanosecond() != 0) {
            $this$formatIso_u24lambda_u240.append('.');
            int zerosToStrip = 0;
            while (ldt.getNanosecond() % POWERS_OF_TEN[zerosToStrip + 1] == 0) {
                ++zerosToStrip;
            }
            zerosToStrip -= zerosToStrip % 3;
            int numberToOutput = ldt.getNanosecond() / POWERS_OF_TEN[zerosToStrip];
            String string = String.valueOf(numberToOutput + POWERS_OF_TEN[9 - zerosToStrip]);
            int n15 = 1;
            Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
            String string2 = string.substring(n15);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            $this$formatIso_u24lambda_u240.append(string2);
        }
        $this$formatIso_u24lambda_u240.append('Z');
        return stringBuilder2.toString();
    }

    private static final long safeAddOrElse(long a15, long b15, Function0 action) {
        boolean $i$f$safeAddOrElse = false;
        long sum = a15 + b15;
        if ((a15 ^ sum) < 0L && (a15 ^ b15) >= 0L) {
            action.invoke();
            throw new KotlinNothingValueException();
        }
        return sum;
    }

    private static final long safeMultiplyOrElse(long a15, long b15, Function0 action) {
        boolean $i$f$safeMultiplyOrElse = false;
        if (b15 == 1L) {
            return a15;
        }
        if (a15 == 1L) {
            return b15;
        }
        if (a15 == 0L || b15 == 0L) {
            return 0L;
        }
        long total = a15 * b15;
        if (total / b15 != a15 || a15 == Long.MIN_VALUE && b15 == -1L || b15 == Long.MIN_VALUE && a15 == -1L) {
            action.invoke();
            throw new KotlinNothingValueException();
        }
        return total;
    }

    public static final boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static final int monthLength(int $this$monthLength, boolean isLeapYear) {
        int n15;
        switch ($this$monthLength) {
            case 2: {
                if (isLeapYear) {
                    n15 = 29;
                    break;
                }
                n15 = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n15 = 30;
                break;
            }
            default: {
                n15 = 31;
            }
        }
        return n15;
    }

    private static final String truncateForErrorMessage(CharSequence $this$truncateForErrorMessage, int maxLength) {
        return $this$truncateForErrorMessage.length() <= maxLength ? ((Object)$this$truncateForErrorMessage).toString() : ((Object)$this$truncateForErrorMessage.subSequence(0, maxLength)).toString() + "...";
    }

    private static final InstantParseResult.Failure parseIso$parseFailure(CharSequence $isoString, String error) {
        return new InstantParseResult.Failure(error + " when parsing an Instant from \"" + InstantKt.truncateForErrorMessage($isoString, 64) + '\"', $isoString);
    }

    private static final InstantParseResult.Failure parseIso$expect(CharSequence $isoString, String what, int where, Function1<? super Character, Boolean> predicate) {
        char c15 = $isoString.charAt(where);
        return predicate.invoke(Character.valueOf(c15)) != false ? null : InstantKt.parseIso$parseFailure($isoString, "Expected " + what + ", but got '" + c15 + "' at position " + where);
    }

    private static final boolean parseIso$lambda$0(char it) {
        return it == '-';
    }

    private static final boolean parseIso$lambda$2(char it) {
        return it == '-';
    }

    private static final boolean parseIso$lambda$4(char it) {
        return it == 'T' || it == 't';
    }

    private static final boolean parseIso$lambda$6(char it) {
        return it == ':';
    }

    private static final boolean parseIso$lambda$8(char it) {
        return it == ':';
    }

    private static final boolean parseIso$lambda$10(char it) {
        return '0' <= it ? it < ':' : false;
    }

    private static final int parseIso$twoDigitNumber(CharSequence s15, int index) {
        return (s15.charAt(index) - 48) * 10 + (s15.charAt(index + 1) - 48);
    }

    private static final void formatIso$lambda$0$appendTwoDigits(Appendable $this$formatIso_u24lambda_u240_u24appendTwoDigits, StringBuilder $this_buildString, int number) {
        if (number < 10) {
            $this$formatIso_u24lambda_u240_u24appendTwoDigits.append('0');
        }
        $this_buildString.append(number);
    }

    public static final /* synthetic */ String access$formatIso(Instant instant) {
        return InstantKt.formatIso(instant);
    }

    public static final /* synthetic */ InstantParseResult access$parseIso(CharSequence isoString) {
        return InstantKt.parseIso(isoString);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(CharSequence $receiver, int maxLength) {
        return InstantKt.truncateForErrorMessage($receiver, maxLength);
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POWERS_OF_TEN = nArray;
        nArray = new int[]{1, 2, 4, 5, 7, 8, 10, 11, 13, 14};
        asciiDigitPositionsInIsoStringAfterYear = nArray;
        nArray = new int[]{3, 6};
        colonsInIsoOffsetString = nArray;
        nArray = new int[]{1, 2, 4, 5, 7, 8};
        asciiDigitsInIsoOffsetString = nArray;
    }
}

